package com.dtyunxi.yundt.module.customer.biz.util;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.util.Date;

@Component
public class CustomerUtil {
    /**
     * 每毫秒生成号数量最大值
     */
    private static int maxPerMSECSize = 99999;


    @Autowired
    ICacheService cacheService;
    private static CustomerUtil customerUtil;
    private static final  String ACCOUNT_NO="ACCOUNTNO";
    private static final Integer STR_FORMAT_10 = 10;
    private static final Integer STR_FORMAT_100 = 100;
    private static final Integer STR_FORMAT_1000 = 1000;
    private static final Integer STR_FORMAT_10000 = 10000;
    @PostConstruct
    public void init() {
        customerUtil = this;
        customerUtil.cacheService=this.cacheService;
    }

    static public String generateTradeNo(String prefix){
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        String timeStr=String.valueOf(nowLong);
        Long result= customerUtil.cacheService.incr(ACCOUNT_NO);
        Long mod=result% maxPerMSECSize;
        String resultNo=""+mod;
        if(mod<STR_FORMAT_10){
            resultNo="0000"+mod;
        }
        else if(mod>=STR_FORMAT_10&&mod<STR_FORMAT_100){
            resultNo="000"+mod;
        }else if(mod>=STR_FORMAT_100 && mod < STR_FORMAT_1000){
            resultNo="00"+mod;
        }else if(mod>=STR_FORMAT_1000 && mod < STR_FORMAT_10000) {
            resultNo="0"+mod;
        }
        return prefix+timeStr+resultNo;
    }
}
