/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerGroupApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupModifyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupTreeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerGroupQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.ICustomerGroupService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerGroupServiceImpl
implements ICustomerGroupService {
    @Resource
    private IContext context;
    @Resource
    private ICustomerGroupApi customerGroupApi;
    @Resource
    private ICustomerGroupQueryApi customerGroupQueryApi;

    public Long add(CustomerGroupAddReqDto addReqDto) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        addReqDto.setInstanceId(instanceId);
        addReqDto.setTenantId(tenantId);
        RestResponse restResponse = this.customerGroupApi.add(addReqDto);
        return (Long)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    public void modify(CustomerGroupModifyReqDto modifyReqDto) {
        this.customerGroupApi.modify(modifyReqDto);
    }

    public void remove(Long id) {
        this.customerGroupApi.remove(id);
    }

    public CustomerGroupRespDto queryById(Long id) {
        RestResponse restResponse = this.customerGroupQueryApi.queryById(id);
        return (CustomerGroupRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    public PageInfo<CustomerGroupRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerGroupQueryReqDto searchReqDto = new CustomerGroupQueryReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerGroupQueryReqDto)JSONObject.parseObject((String)filter, CustomerGroupQueryReqDto.class);
        }
        searchReqDto.setInstanceId(this.context.instanceId());
        searchReqDto.setTenantId(this.context.tenantId());
        RestResponse restResponse = this.customerGroupQueryApi.queryByPage(searchReqDto, pageNum, pageSize);
        return (PageInfo)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    public List<CustomerGroupTreeRespDto> queryForTree() {
        return (List)RestResponseHelper.extractData((RestResponse)this.customerGroupQueryApi.queryForTree());
    }
}

