/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.biz.impl.user;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OrgSellerCustomerQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrgSellerCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IOrgSellerCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.IEmployeeCustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ParentAreCodeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.entity.NacosPropertiesOrgEntity;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAreaListExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerSearchExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeNumCountReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeNumCountRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeRegionRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerQueryV3Api;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerBlacklistQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeCustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmployeeRegionQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.user.api.IEmployeeExpandApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.entity.ImportBaseResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.RoleExpandReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.EmployeeExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.EmployeeExtRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleExpandRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.RoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserOrgizationRespDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeRoleQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrgInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IRoleQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserOrgExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.dtyunxi.yundt.cube.center.user.api.util.RestUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.request.EmployeeImportExtReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandQueryReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.user.EmployeeExpandReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.EmployeeExpandRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.EmpGovernTypeEnum;
import com.dtyunxi.yundt.module.customer.api.user.IEmployeeExpand2Service;
import com.dtyunxi.yundt.module.customer.api.vo.EmployeeExcelExtVo;
import com.dtyunxi.yundt.module.customer.api.vo.EmployeeExcelUpdateExtVo;
import com.dtyunxi.yundt.module.customer.biz.util.CommonUtil;
import com.dtyunxi.yundt.module.customer.biz.util.EasyPoiExportUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerAreaExtReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerExtReqDto;
import com.yx.tcbj.center.shop.api.dto.request.SellerExtQueryReqDto;
import com.yx.tcbj.center.shop.api.query.ISellerExpandQueryApi;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EmployeeExpand2ServiceImpl
implements IEmployeeExpand2Service {
    private static final Logger logger = LoggerFactory.getLogger(EmployeeExpand2ServiceImpl.class);
    @Resource
    private IEmployeeExpandApi employeeExpandApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private IEmployeeCustomerQueryApi employeeCustomerQueryApi;
    @Resource
    private IEmployeeCustomerApi employeeCustomerApi;
    @Resource
    private IEmployeeRegionQueryApi employeeRegionQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private IOrgSellerCustomerQueryApi orgSellerCustomerQueryApi;
    @Resource
    private NacosPropertiesOrgEntity nacosPropertiesOrgEntity;
    @Resource
    private ICustomerQueryV3Api customerQueryV3Api;
    @Resource
    private ISellerExpandQueryApi sellerExpandQueryApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IContext context;
    @Resource
    private IUserOrgExpandQueryApi userOrgExpandQueryApi;
    @Resource
    private IRoleQueryApi roleQueryApi;
    @Resource
    private IOrgInfoExtQueryApi orgInfoExtQueryApi;
    @Resource
    private IUserExtQueryApi userExtQueryApi;
    @Resource
    private IEmployeeRoleQueryApi employeeRoleQueryApi;
    @Resource
    private IEmployeeCustomerBlacklistQueryApi employeeCustomerBlacklistQueryApi;

    public Map<String, CustomerRespDto> getOrgCustomerMap(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return new HashMap<String, CustomerRespDto>();
        }
        RestResponse customerRest = this.employeeCustomerQueryApi.queryCustomerListByCodes(customerCodeList);
        if (customerRest == null || CollectionUtils.isEmpty((Collection)((Collection)customerRest.getData()))) {
            return new HashMap<String, CustomerRespDto>();
        }
        List customerList = (List)customerRest.getData();
        Map<String, CustomerRespDto> customerMap = customerList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        return customerMap;
    }

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    public Long tenantId() {
        Long tenantId = this.context.tenantId();
        logger.info("tenantId >>> {}", (Object)tenantId);
        if (tenantId == null) {
            tenantId = 1L;
        }
        return tenantId;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addEmployee(Long instanceId, EmployeeExpandReqDto employeeDto) {
        Integer type;
        logger.info("\u65b0\u589e\u4eba\u5458\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeDto));
        ArrayList<String> errorList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)employeeDto.getPhoneNum())) {
            errorList.add("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)employeeDto.getName())) {
            errorList.add("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orgId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        if (Objects.nonNull(employeeDto.getOrganizationId())) {
            orgId = employeeDto.getOrganizationId().toString();
            logger.info("\u8bf7\u6c42\u53c2\u6570\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        }
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        }
        if (StringUtils.isBlank((CharSequence)orgId)) {
            errorList.add("\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        }
        if (instanceId == null) {
            errorList.add("\u5b9e\u4f8bID[instanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!errorList.isEmpty()) {
            throw new BizException(String.join((CharSequence)"\uff1b", errorList));
        }
        Long tenantId = this.tenantId();
        employeeDto.setOrganizationId(Long.valueOf(StringUtils.isBlank((CharSequence)this.headerOrgId()) ? Long.parseLong(orgId) : Long.parseLong(this.headerOrgId())));
        if (YesOrNoEnum.isYes((Integer)employeeDto.getOrganizationStatus())) {
            if (employeeDto.getOrgId() == null) {
                throw new BizException("\u6240\u9009\u7ec4\u7ec7[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)employeeDto.getOrganizationCode())) {
                throw new BizException("\u6240\u9009\u7ec4\u7ec7\u4ee3\u7801[organizationCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            employeeDto.setOrganizationId(employeeDto.getOrganizationId());
        }
        if ((type = Integer.valueOf(Objects.isNull(employeeDto.getType()) ? 0 : employeeDto.getType())) == 1 && StringUtils.isNotEmpty((CharSequence)employeeDto.getCustomerCode())) {
            Map<String, CustomerRespDto> orgCustomerMap = this.getOrgCustomerMap(Collections.singletonList(employeeDto.getCustomerCode()));
            if (orgCustomerMap.isEmpty() || !orgCustomerMap.containsKey(employeeDto.getCustomerCode())) {
                throw new BizException("\u5ba2\u6237\u7f16\u53f7[" + employeeDto.getCustomerCode() + "]\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            CustomerRespDto customerRespDto = orgCustomerMap.get(employeeDto.getCustomerCode());
            employeeDto.setOrganizationId(customerRespDto.getMerchantId());
        }
        if (StringUtils.isNotEmpty((CharSequence)employeeDto.getName()) && StringUtils.isNotEmpty((CharSequence)employeeDto.getPhoneNum())) {
            this.checkNameAndPhoneNum(employeeDto);
        }
        employeeDto.setInstanceId(instanceId);
        employeeDto.setTenantId(tenantId);
        employeeDto.setType(type);
        Long employeeId = (Long)RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.addEmployee(instanceId, (EmployeeExtReqDto)employeeDto));
        employeeDto.setId(employeeId);
        this.bindEmployeeCustomer(employeeDto);
        return new RestResponse((Object)employeeId);
    }

    private void checkNameAndPhoneNum(EmployeeExpandReqDto employeeDto) {
        EmployeeExpandQueryReqDto extQueryReqDto = new EmployeeExpandQueryReqDto();
        extQueryReqDto.setName(employeeDto.getName());
        extQueryReqDto.setPhoneNum(employeeDto.getPhoneNum());
        extQueryReqDto.setOrganizationId(employeeDto.getOrganizationId());
        List employeeExtRespDtos = (List)this.employeeExpandQueryApi.queryEmployeeByPhoneNumOrg((EmployeeExtQueryReqDto)extQueryReqDto).getData();
        if (CollectionUtils.isNotEmpty((Collection)employeeExtRespDtos) && !Objects.isNull(((EmployeeExtRespDto)employeeExtRespDtos.get(0)).getId())) {
            String errorMsg = "\u59d3\u540d\u4e3a:" + employeeDto.getName() + "\u4e14\u624b\u673a\u53f7\u4e3a:" + employeeDto.getPhoneNum() + "\u7684\u5458\u5de5\u5df2\u7ecf\u5b58\u5728";
            throw new BizException(errorMsg);
        }
    }

    private String checkNameAndPhoneNumWithMessage(EmployeeExpandReqDto employeeDto) {
        EmployeeExpandQueryReqDto extQueryReqDto = new EmployeeExpandQueryReqDto();
        extQueryReqDto.setName(employeeDto.getName());
        extQueryReqDto.setPhoneNum(employeeDto.getPhoneNum());
        extQueryReqDto.setOrganizationId(employeeDto.getOrganizationId());
        List employeeExtRespDtos = (List)this.employeeExpandQueryApi.queryEmployeeByPhoneNumOrg((EmployeeExtQueryReqDto)extQueryReqDto).getData();
        if (CollectionUtils.isNotEmpty((Collection)employeeExtRespDtos) && !Objects.isNull(((EmployeeExtRespDto)employeeExtRespDtos.get(0)).getId())) {
            return "\u59d3\u540d\u4e3a:" + employeeDto.getName() + "\u4e14\u624b\u673a\u53f7\u4e3a:" + employeeDto.getPhoneNum() + "\u7684\u5458\u5de5\u5df2\u7ecf\u5b58\u5728";
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> modifyEmployee(Long instanceId, EmployeeExpandReqDto employeeDto) {
        logger.info("\u4fee\u6539\u4eba\u5458\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)employeeDto));
        ArrayList<String> errorList = new ArrayList<String>();
        if (employeeDto.getId() == null) {
            errorList.add("\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (instanceId == null) {
            errorList.add("\u5b9e\u4f8bID[instanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long tenantId = this.tenantId();
        String orgId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        if (Objects.nonNull(employeeDto.getOrganizationId())) {
            orgId = employeeDto.getOrganizationId().toString();
            logger.info("\u8bf7\u6c42\u53c2\u6570\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        }
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)orgId);
        }
        if (StringUtils.isBlank((CharSequence)orgId)) {
            errorList.add("\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        }
        if (YesOrNoEnum.isYes((Integer)employeeDto.getOrganizationStatus())) {
            if (employeeDto.getOrgId() == null) {
                errorList.add("\u6240\u9009\u7ec4\u7ec7[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)employeeDto.getOrganizationCode())) {
                errorList.add("\u6240\u9009\u7ec4\u7ec7\u4ee3\u7801[organizationCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!errorList.isEmpty()) {
            throw new BizException(String.join((CharSequence)"\uff1b", errorList));
        }
        Integer type = Objects.isNull(employeeDto.getType()) ? 0 : employeeDto.getType();
        if (type == 1 && StringUtils.isNotEmpty((CharSequence)employeeDto.getCustomerCode())) {
            Map<String, CustomerRespDto> orgCustomerMap = this.getOrgCustomerMap(Collections.singletonList(employeeDto.getCustomerCode()));
            if (orgCustomerMap.isEmpty() || !orgCustomerMap.containsKey(employeeDto.getCustomerCode())) {
                throw new BizException("\u5ba2\u6237\u7f16\u53f7[" + employeeDto.getCustomerCode() + "]\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            CustomerRespDto customerRespDto = orgCustomerMap.get(employeeDto.getCustomerCode());
            orgId = customerRespDto.getMerchantId().toString();
            employeeDto.setCustomerCode(employeeDto.getCustomerCode());
        }
        employeeDto.setOrganizationId(Long.valueOf(Long.parseLong(orgId)));
        employeeDto.setInstanceId(instanceId);
        employeeDto.setTenantId(tenantId);
        RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.modifyEmployee(instanceId, (EmployeeExtReqDto)employeeDto));
        this.bindEmployeeCustomer(employeeDto);
        return RestResponse.VOID;
    }

    public RestResponse<PageInfo<EmployeeExpandRespDto>> queryByPage(EmployeeExpandQueryReqDto reqDto) {
        List<EmployeeExpandRespDto> dtoList;
        List areaCodes;
        logger.info("\u8bf7\u6c42\u53c2\u6570\u7ec4\u7ec7ID\uff1a{}", (Object)reqDto.getOrganizationId());
        String organizationId = null;
        if (Objects.isNull(reqDto.getOrganizationId())) {
            organizationId = this.headerOrgId();
            logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        } else {
            organizationId = String.valueOf(reqDto.getOrganizationId());
        }
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        AssertUtil.assertNotNull((Object)reqDto.getInstanceId(), (String)"\u5b9e\u4f8bID[instanceId]\u4e0d\u80fd\u4e3a\u7a7a");
        Long orgId = StringUtils.isBlank((CharSequence)organizationId) ? null : Long.valueOf(Long.parseLong(organizationId));
        reqDto.setOrganizationId(orgId);
        Long tenantId = this.tenantId();
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList employeeIds = new ArrayList();
        if (Objects.nonNull(reqDto.getType()) && reqDto.getType() == 1 && Objects.nonNull(reqDto.getCustomerId())) {
            EmployeeCustomerQueryReqDto queryReqDto = new EmployeeCustomerQueryReqDto();
            queryReqDto.setCustomerId(reqDto.getCustomerId());
            List employeeCustomerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeCustomerQueryApi.queryEmployeeCustomerList(queryReqDto));
            employeeIds.addAll(employeeCustomerRespDtos.stream().map(EmployeeCustomerRespDto::getEmployeeId).distinct().collect(Collectors.toList()));
            reqDto.setCustomerIds(employeeCustomerRespDtos.stream().map(EmployeeCustomerRespDto::getCustomerId).collect(Collectors.toList()));
            List<CustomerRespDto> customerRespDtos = this.getCustomerRespDtos(reqDto);
            if (CollectionUtils.isEmpty(customerRespDtos) && CollectionUtils.isEmpty(employeeIds)) {
                return new RestResponse((Object)dtoPageInfo);
            }
            if (CollectionUtils.isNotEmpty(employeeIds)) {
                reqDto.setEmpCustomerCode(null);
            }
            List orgIdList = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
            reqDto.setOrganizationIdList(orgIdList);
            orgIdList.add(reqDto.getOrganizationId());
            reqDto.setOrganizationId(null);
        } else {
            List customerRespDtos = Optional.ofNullable(this.getCustomerRespDtos(reqDto)).orElse(new ArrayList());
            List orgIdList = customerRespDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
            orgIdList.add(reqDto.getOrganizationId());
            reqDto.setOrganizationIdList(orgIdList);
            reqDto.setOrganizationId(null);
        }
        List empCustDtos = null;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCustomerName()) || StringUtils.isNotBlank((CharSequence)reqDto.getCustomerCode())) {
            CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
            customerExtReqDto.setCode(reqDto.getCustomerCode());
            customerExtReqDto.setName(reqDto.getCustomerName());
            customerExtReqDto.setMerchantId(orgId);
            logger.info("\u5f00\u59cb\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u6839\u636e\u5ba2\u6237\u540d\u79f0\u3001\u5ba2\u6237\u7f16\u53f7\u67e5\u8be2)\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)customerExtReqDto));
            empCustDtos = (List)RestUtil.checkResponse((RestResponse)this.employeeCustomerQueryApi.queryEmployee(customerExtReqDto));
            logger.info("\u7ed3\u675f\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u6839\u636e\u5ba2\u6237\u540d\u79f0\u3001\u5ba2\u6237\u7f16\u53f7\u67e5\u8be2)\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)empCustDtos));
            if (CollectionUtils.isEmpty((Collection)empCustDtos)) {
                return new RestResponse((Object)dtoPageInfo);
            }
            List _ids = empCustDtos.stream().map(EmployeeCustomerRespDto::getEmployeeId).collect(Collectors.toList());
            employeeIds.addAll(_ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getCustomerAreaList()) && CollectionUtils.isNotEmpty(areaCodes = reqDto.getCustomerAreaList().stream().filter(Objects::nonNull).filter(o -> Objects.nonNull(o.getAreaCode())).map(CustomerAreaExtReqDto::getAreaCode).distinct().collect(Collectors.toList()))) {
            EmployeeRegionQueryReqDto regionQueryReqDto = new EmployeeRegionQueryReqDto();
            regionQueryReqDto.setInstanceId(reqDto.getInstanceId());
            regionQueryReqDto.setMerchantId(orgId);
            regionQueryReqDto.setRegionCodes(areaCodes);
            logger.info("\u5f00\u59cb\u5ba2\u6237\u533a\u57df\uff08\u5927B\u5ba2\u6237\u7ba1\u7406\u67e5\u8be2\uff09\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)regionQueryReqDto));
            dtoList = (List)RestUtil.checkResponse((RestResponse)this.employeeRegionQueryApi.queryEmployeeRegionByCodes(regionQueryReqDto));
            logger.info("\u7ed3\u675f\u5ba2\u6237\u533a\u57df\uff08\u5927B\u5ba2\u6237\u7ba1\u7406\u67e5\u8be2\uff09\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dtoList));
            if (CollectionUtils.isEmpty((Collection)dtoList)) {
                return new RestResponse((Object)dtoPageInfo);
            }
            List _ids = dtoList.stream().map(EmployeeRegionRespDto::getEmployeeId).collect(Collectors.toList());
            employeeIds.addAll(_ids);
        }
        if (CollectionUtils.isNotEmpty(employeeIds)) {
            reqDto.setIds(employeeIds);
        }
        PageInfo employeePage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.queryByPage((EmployeeExtQueryReqDto)reqDto));
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)employeePage, (String[])new String[]{"list", "navigatepageNums"});
        List employeePageList = employeePage.getList();
        dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)employeePageList, EmployeeExpandRespDto.class);
        AtomicLong newId = new AtomicLong(0L);
        dtoList.forEach(r -> r.setNewId(Long.valueOf(newId.getAndIncrement())));
        if (Objects.nonNull(reqDto.getType()) && reqDto.getType() == 1) {
            this.fillCustomInfo(dtoList, orgId);
        } else {
            this.fillCustomerAndRegionNum(dtoList, Long.valueOf(organizationId), reqDto.getInstanceId(), tenantId);
        }
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Nullable
    private List<CustomerRespDto> getCustomerRespDtos(EmployeeExpandQueryReqDto reqDto) {
        CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
        customerExtQuery.setMerchantId(reqDto.getOrganizationId());
        customerExtQuery.setIdList(reqDto.getCustomerIds());
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getEmpCustomerCode())) {
            customerExtQuery.setCode(reqDto.getEmpCustomerCode());
        }
        customerExtQuery.setCustomerNameLike(reqDto.getCustomerNameLike());
        customerExtQuery.setCustomerCodeLike(reqDto.getCustomerCodeLike());
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f(\u6839\u636e\u5ba2\u6237\u540d\u79f0\u6a21\u7cca\u67e5\u8be2)\uff0c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)customerExtQuery));
        return (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
    }

    public RestResponse<EmployeeExpandRespDto> queryById(EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotNull((Object)reqDto.getId(), (String)"\u4eba\u5458\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
        String organizationId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            organizationId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        }
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        ArrayList<EmployeeExpandRespDto> respDtos = new ArrayList<EmployeeExpandRespDto>(1);
        EmployeeExtRespDto employeeExtRespDto = (EmployeeExtRespDto)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.queryById(reqDto));
        if (Objects.nonNull(employeeExtRespDto) && Objects.nonNull(employeeExtRespDto.getId())) {
            EmployeeExpandRespDto expandRespDto = new EmployeeExpandRespDto();
            CubeBeanUtils.copyProperties((Object)expandRespDto, (Object)employeeExtRespDto, (String[])new String[0]);
            respDtos.add(expandRespDto);
        }
        if (CollectionUtils.isNotEmpty(respDtos)) {
            this.fillCustomInfo(respDtos, Long.valueOf(organizationId));
            this.fillOrganizationInfo(respDtos);
            return new RestResponse(respDtos.get(0));
        }
        return new RestResponse();
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updateStatus(Long instanceId, EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotEmpty((Collection)reqDto.getIds(), (String)"\u4eba\u5458\u4e3b\u952eID[\u5c5e\u6027\u540d\uff1aids]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)reqDto.getStatus(), (String)"\u72b6\u6001[\u5c5e\u6027\u540d\uff1astatus]\u4e0d\u80fd\u4e3a\u7a7a");
        String organizationId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            organizationId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        }
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        reqDto.setOrganizationId(Long.valueOf(organizationId));
        RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.upateStatus(instanceId, reqDto));
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> setSuperAdmin(Long instanceId, EmployeeExtReqDto reqDto) {
        AssertUtil.assertNotNull((Object)reqDto.getId(), (String)"\u4eba\u5458\u4e3b\u952eID[\u5c5e\u6027\u540d\uff1aid]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)reqDto.getSuperAdmin(), (String)"\u662f\u5426\u8d85\u7ea7\u7ba1\u7406\u5458[0-\u5426\uff0c1-\u662f]\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty((Collection)reqDto.getEmployeeRoleDtoList(), (String)"\u89d2\u8272\u4fe1\u606f[\u5c5e\u6027\u540d\uff1aemployeeRoleDtoList]\u4e0d\u80fd\u4e3a\u7a7a");
        String organizationId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            organizationId = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        }
        AssertUtil.assertNotBlank((String)organizationId, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        reqDto.setOrganizationId(Long.valueOf(organizationId));
        RestResponseHelper.extractData((RestResponse)this.employeeExpandApi.setSuperAdmin(instanceId, reqDto));
        return RestResponse.VOID;
    }

    public RestResponse<ImportBaseResponse> importExcelEmployee(EmployeeImportExtReqDto importReqDto) {
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        Long instanceId = importReqDto.getInstanceId();
        String orgIdStr = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        if (StringUtils.isBlank((CharSequence)orgIdStr)) {
            orgIdStr = this.nacosPropertiesOrgEntity.orgId();
            logger.info("nacos\u914d\u7f6e\u7684\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        }
        AssertUtil.assertNotBlank((String)orgIdStr, (String)"\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
        Long orgId = Long.valueOf(orgIdStr);
        ImportBaseResponse response = new ImportBaseResponse();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setKeyIndex(null);
        List<Object> importDataList = new ArrayList();
        boolean isModifyMode = !Objects.equals(importReqDto.getModule(), 0);
        try {
            ExcelImportResult result;
            if (Objects.equals(importReqDto.getModule(), 0)) {
                result = ExcelImportUtil.importExcelMore((InputStream)EasyPoiExportUtil.getInputStream(fileUrl), EmployeeExcelExtVo.class, (ImportParams)importParams);
                if (ObjectUtils.isNotEmpty((Object)result)) {
                    importDataList = result.getList();
                    importDataList = BeanPropertyNullUtil.getAllFieldNullList(importDataList);
                }
            } else {
                result = ExcelImportUtil.importExcelMore((InputStream)EasyPoiExportUtil.getInputStream(fileUrl), EmployeeExcelUpdateExtVo.class, (ImportParams)importParams);
                if (ObjectUtils.isNotEmpty((Object)result)) {
                    importDataList = result.getList().stream().map(r -> (EmployeeExcelExtVo)BeanUtil.copyProperties((Object)r, EmployeeExcelExtVo.class, (String[])new String[0])).collect(Collectors.toList());
                    importDataList = BeanPropertyNullUtil.getAllFieldNullList(importDataList);
                }
            }
            if (CollectionUtils.isEmpty(importDataList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        logger.info("\u5bfc\u5165\u4eba\u5458\u6570\u636e\u5f00\u59cb\u5904\u7406\uff0c\u603b\u8bb0\u5f55\u6570: {}, \u6a21\u5f0f: {}", (Object)importDataList.size(), (Object)(isModifyMode ? "\u4fee\u6539\u6a21\u5f0f" : "\u65b0\u589e\u6a21\u5f0f"));
        if (CollectionUtils.isEmpty(importDataList)) {
            response.setTotalNum(0);
            response.setSuccessNum(0);
            response.setErrorNum(0);
            return new RestResponse((Object)response);
        }
        importDataList.forEach(r -> r.setOrgId(orgId));
        response.setTotalNum(importDataList.size());
        HashSet<Integer> successfulImportRows = new HashSet<Integer>();
        List<EmployeeExcelExtVo> errorList = this.processImportEmployeeExcelExtVos(importDataList, orgId, isModifyMode, instanceId, successfulImportRows);
        int totalCount = response.getTotalNum();
        int successCount = successfulImportRows.size();
        int failureCount = totalCount - successCount;
        if (CollectionUtils.isNotEmpty(errorList)) {
            response.setErrorNum(errorList.size());
            String excelName = "\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, EmployeeExcelExtVo.class, null, excelName, "xls");
                response.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                logger.error("\u4eba\u5458\u5bfc\u5165\u5931\u8d25\u4fe1\u606f\u6587\u4ef6\u751f\u6210\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        response.setSuccessNum(successCount);
        response.setErrorNum(failureCount);
        logger.info("\u5bfc\u5165\u7ed3\u679c\u7edf\u8ba1: \u603b\u6761\u6570={}, \u6210\u529f\u6570={}, \u5931\u8d25\u6570={}", new Object[]{response.getTotalNum(), response.getSuccessNum(), response.getErrorNum()});
        return new RestResponse((Object)response);
    }

    public List<EmployeeExcelExtVo> processImportEmployeeExcelExtVos(List<EmployeeExcelExtVo> importDataList, Long orgId, boolean isModifyMode, Long instanceId, Set<Integer> successfulImportRows) {
        List existingEmployees;
        int rowIndex = 0;
        for (EmployeeExcelExtVo vo2 : importDataList) {
            vo2.setRowNum(rowIndex++);
        }
        Map<String, List<EmployeeExcelExtVo>> duplicateMap = importDataList.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getUserName()) && StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber())).collect(Collectors.groupingBy(vo -> vo.getUserName() + "_" + vo.getPhoneNumber()));
        duplicateMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).forEach(entry -> {
            List duplicates = (List)entry.getValue();
            logger.info("\u53d1\u73b0\u91cd\u590d\u7684\u59d3\u540d\u548c\u624b\u673a\u53f7, \u5c06\u88ab\u5408\u5e76\u5904\u7406: \u59d3\u540d={}, \u624b\u673a\u53f7={}, \u8bb0\u5f55\u6570={}", new Object[]{((EmployeeExcelExtVo)duplicates.get(0)).getUserName(), ((EmployeeExcelExtVo)duplicates.get(0)).getPhoneNumber(), duplicates.size()});
        });
        List employeeCodes = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getEmployeeCode())).map(EmployeeExcelExtVo::getEmployeeCode).distinct().collect(Collectors.toList());
        HashMap<String, EmployeeExtRespDto> existingEmployeeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(employeeCodes) && CollectionUtils.isNotEmpty((Collection)(existingEmployees = (List)RestResponseHelper.extractData((RestResponse)this.employeeRoleQueryApi.queryEmployeeByNos(employeeCodes))))) {
            existingEmployeeMap = existingEmployees.stream().collect(Collectors.toMap(EmployeeExtRespDto::getEmployeeNo, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList allRoleNames = new ArrayList();
        importDataList.forEach(data -> {
            if (StringUtils.isNotEmpty((CharSequence)data.getRoleName())) {
                String[] roleNames;
                for (String roleName : roleNames = data.getRoleName().split(";")) {
                    if (!StringUtils.isNotEmpty((CharSequence)roleName.trim())) continue;
                    allRoleNames.add(roleName.trim());
                }
            }
        });
        List<String> roleNameList = allRoleNames.stream().distinct().collect(Collectors.toList());
        Map<String, List<RoleExpandRespDto>> roleMap = this.getRoleMap(roleNameList, null);
        List<String> areaNameList = importDataList.stream().flatMap(employee -> Stream.of(employee.getSaleArea(), employee.getBigArea(), employee.getDistrict())).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = this.getCustomerAreaMap(areaNameList, orgId);
        List<String> accountList = importDataList.stream().filter(data -> StringUtils.isNotEmpty((CharSequence)data.getAccount())).map(EmployeeExcelExtVo::getAccount).distinct().collect(Collectors.toList());
        Map<String, List<UserOrgizationRespDto>> userOrgMap = this.getAccoutMap(accountList);
        ArrayList<String> customerCodes = new ArrayList<String>();
        importDataList.forEach(data -> {
            if (StringUtils.isNotBlank((CharSequence)data.getGovernCustomer())) {
                customerCodes.add(data.getGovernCustomer());
            }
            if (StringUtils.isNotBlank((CharSequence)data.getBlacklist())) {
                customerCodes.add(data.getBlacklist());
            }
        });
        HashMap<String, CustomerRespDto> customerMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customerCodes)) {
            customerMap = this.getOrgCustomerMap(customerCodes);
        }
        this.verifyData(importDataList, roleMap, customerAreasMap, customerMap, userOrgMap, existingEmployeeMap, isModifyMode);
        List<EmployeeExcelExtVo> validRecords = importDataList.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getErrorMsg())).collect(Collectors.toList());
        logger.info("\u5f00\u59cb\u5408\u5e76\u6570\u636e\uff0c\u603b\u8ba1{}\u6761\u6709\u6548\u8bb0\u5f55", (Object)validRecords.size());
        List<EmployeeExcelExtVo> employeeExcelVoList = this.mergeData(validRecords);
        logger.info("\u5408\u5e76\u540e\u5269\u4f59{}\u6761\u8bb0\u5f55", (Object)employeeExcelVoList.size());
        HashMap<EmployeeExcelExtVo, List<Object>> mergedToOriginalRowsMap = new HashMap<EmployeeExcelExtVo, List<Object>>();
        for (EmployeeExcelExtVo mergedVo : employeeExcelVoList) {
            String namePhoneKey = mergedVo.getUserName() + "_" + mergedVo.getPhoneNumber();
            List<EmployeeExcelExtVo> originalVos = duplicateMap.get(namePhoneKey);
            if (originalVos != null) {
                mergedToOriginalRowsMap.put(mergedVo, originalVos.stream().map(EmployeeExcelExtVo::getRowNum).collect(Collectors.toList()));
                continue;
            }
            mergedToOriginalRowsMap.put(mergedVo, Collections.singletonList(mergedVo.getRowNum()));
        }
        for (EmployeeExcelExtVo data2 : employeeExcelVoList) {
            try {
                Object rowNum2;
                EmployeeExtRespDto existingEmployee = null;
                if (StringUtils.isNotEmpty((CharSequence)data2.getEmployeeCode())) {
                    existingEmployee = (EmployeeExtRespDto)existingEmployeeMap.get(data2.getEmployeeCode());
                }
                if (isModifyMode && existingEmployee == null) {
                    logger.warn("\u4fee\u6539\u6a21\u5f0f\u4e0b\u627e\u4e0d\u5230\u5de5\u53f7\u4e3a[{}]\u7684\u5458\u5de5\uff0c\u65e0\u6cd5\u5904\u7406", (Object)data2.getEmployeeCode());
                    List failedRows = (List)mergedToOriginalRowsMap.get(data2);
                    if (failedRows == null) continue;
                    block5: for (Object rowNum2 : failedRows) {
                        for (EmployeeExcelExtVo employeeExcelExtVo : importDataList) {
                            if (employeeExcelExtVo.getRowNum() != rowNum2) continue;
                            if (!StringUtils.isEmpty((CharSequence)employeeExcelExtVo.getErrorMsg())) continue block5;
                            employeeExcelExtVo.setErrorMsg("\u4fee\u6539\u6a21\u5f0f\u4e0b\u627e\u4e0d\u5230\u5bf9\u5e94\u5de5\u53f7\uff0c\u65e0\u6cd5\u5904\u7406");
                            continue block5;
                        }
                    }
                    continue;
                }
                if (!isModifyMode && existingEmployee != null) {
                    logger.warn("\u65b0\u589e\u6a21\u5f0f\u4e0b\u5de5\u53f7\u4e3a[{}]\u7684\u5458\u5de5\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u5904\u7406", (Object)data2.getEmployeeCode());
                    List failedRows = (List)mergedToOriginalRowsMap.get(data2);
                    if (failedRows == null) continue;
                    block7: for (Object rowNum2 : failedRows) {
                        for (EmployeeExcelExtVo employeeExcelExtVo : importDataList) {
                            if (employeeExcelExtVo.getRowNum() != rowNum2) continue;
                            if (!StringUtils.isEmpty((CharSequence)employeeExcelExtVo.getErrorMsg())) continue block7;
                            employeeExcelExtVo.setErrorMsg("\u65b0\u589e\u6a21\u5f0f\u4e0b\u5de5\u53f7\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u5904\u7406");
                            continue block7;
                        }
                    }
                    continue;
                }
                boolean success = this.processEmployeeData(instanceId, data2, existingEmployee);
                if (success) {
                    List originalRows = (List)mergedToOriginalRowsMap.get(data2);
                    if (originalRows != null) {
                        successfulImportRows.addAll(originalRows);
                    }
                    logger.info("\u6210\u529f\u5904\u7406\u5458\u5de5: {}, \u884c\u53f7: {}", (Object)data2.getUserName(), mergedToOriginalRowsMap.get(data2));
                    continue;
                }
                logger.error("\u5904\u7406\u5458\u5de5\u5931\u8d25: {}, \u884c\u53f7: {}", (Object)data2.getUserName(), mergedToOriginalRowsMap.get(data2));
                List failedRows = (List)mergedToOriginalRowsMap.get(data2);
                if (failedRows == null) continue;
                rowNum2 = failedRows.iterator();
                block9: while (rowNum2.hasNext()) {
                    Integer rowNum3 = (Integer)rowNum2.next();
                    for (EmployeeExcelExtVo original2 : importDataList) {
                        if (original2.getRowNum() != rowNum3) continue;
                        if (!StringUtils.isEmpty((CharSequence)original2.getErrorMsg())) continue block9;
                        original2.setErrorMsg("\u5904\u7406\u5931\u8d25");
                        continue block9;
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u4eba\u5458\u5904\u7406\u6267\u884c\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                List failedRows = (List)mergedToOriginalRowsMap.get(data2);
                if (failedRows == null) continue;
                block11: for (Integer rowNum2 : failedRows) {
                    for (EmployeeExcelExtVo employeeExcelExtVo : importDataList) {
                        if (!Objects.equals(employeeExcelExtVo.getRowNum(), rowNum2)) continue;
                        employeeExcelExtVo.setErrorMsg(StringUtils.isEmpty((CharSequence)employeeExcelExtVo.getErrorMsg()) ? "\u6267\u884c\u5931\u8d25\uff01" + e.getMessage() : employeeExcelExtVo.getErrorMsg() + "\uff1b\u6267\u884c\u5931\u8d25\uff01" + e.getMessage());
                        continue block11;
                    }
                }
            }
        }
        List<EmployeeExcelExtVo> errorList = importDataList.stream().filter(vo -> !successfulImportRows.contains(vo.getRowNum())).collect(Collectors.toList());
        return errorList;
    }

    private List<EmployeeExcelExtVo> verifyData(List<EmployeeExcelExtVo> list, Map<String, List<RoleExpandRespDto>> roleMap, Map<String, List<CustomerAreaRespDto>> areasMap, Map<String, CustomerRespDto> customerMap, Map<String, List<UserOrgizationRespDto>> userOrgMap, Map<String, EmployeeExtRespDto> existingEmployeeMap, boolean isModifyMode) {
        HashMap<String, String> importBatchNamePhoneMap = new HashMap<String, String>();
        if (isModifyMode) {
            for (EmployeeExcelExtVo vo : list) {
                if (!StringUtils.isNotBlank((CharSequence)vo.getEmployeeCode()) || !StringUtils.isNotBlank((CharSequence)vo.getUserName()) || !StringUtils.isNotBlank((CharSequence)vo.getPhoneNumber())) continue;
                String namePhoneKey = vo.getUserName() + "_" + vo.getPhoneNumber();
                if (importBatchNamePhoneMap.containsKey(namePhoneKey)) {
                    String existingCode = (String)importBatchNamePhoneMap.get(namePhoneKey);
                    logger.warn("\u5bfc\u5165\u6279\u6b21\u4e2d\u53d1\u73b0\u91cd\u590d\u7684\u540d\u79f0+\u624b\u673a\u53f7\u7ec4\u5408: {}, \u5df2\u5b58\u5728\u4e8e\u5de5\u53f7: {}, \u5f53\u524d\u5de5\u53f7: {}", new Object[]{namePhoneKey, existingCode, vo.getEmployeeCode()});
                    continue;
                }
                importBatchNamePhoneMap.put(namePhoneKey, vo.getEmployeeCode());
            }
        }
        Long orgId = list.get(0).getOrgId();
        for (EmployeeExcelExtVo vo : list) {
            ArrayList<String> errorList = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)vo.getErrorMsg())) {
                errorList.add(vo.getErrorMsg());
            }
            if (isModifyMode) {
                if (StringUtils.isBlank((CharSequence)vo.getEmployeeCode())) {
                    errorList.add("\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getEmployeeCode())) {
                    if (existingEmployeeMap == null || !existingEmployeeMap.containsKey(vo.getEmployeeCode())) {
                        errorList.add("\u5de5\u53f7\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539");
                    } else if (StringUtils.isNotBlank((CharSequence)vo.getUserName()) && StringUtils.isNotBlank((CharSequence)vo.getPhoneNumber())) {
                        EmployeeExtRespDto currentEmployee;
                        String namePhoneKey = vo.getUserName() + "_" + vo.getPhoneNumber();
                        if (importBatchNamePhoneMap.containsKey(namePhoneKey) && !((String)importBatchNamePhoneMap.get(namePhoneKey)).equals(vo.getEmployeeCode())) {
                            errorList.add("\u5f53\u524d\u5bfc\u5165\u6279\u6b21\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u59d3\u540d\u548c\u624b\u673a\u53f7\u7684\u8bb0\u5f55\uff0c\u5de5\u53f7\u4e3a\uff1a" + (String)importBatchNamePhoneMap.get(namePhoneKey));
                        }
                        if ((currentEmployee = existingEmployeeMap.get(vo.getEmployeeCode())) != null) {
                            boolean isPhoneChanged;
                            boolean isNameChanged = !Objects.equals(currentEmployee.getName(), vo.getUserName());
                            boolean bl = isPhoneChanged = !Objects.equals(currentEmployee.getPhoneNum(), vo.getPhoneNumber());
                            if (isNameChanged || isPhoneChanged) {
                                EmployeeExpandReqDto employeeDto = new EmployeeExpandReqDto();
                                employeeDto.setName(vo.getUserName());
                                employeeDto.setPhoneNum(vo.getPhoneNumber());
                                employeeDto.setOrganizationId(orgId);
                                EmployeeExpandQueryReqDto extQueryReqDto = new EmployeeExpandQueryReqDto();
                                extQueryReqDto.setName(employeeDto.getName());
                                extQueryReqDto.setPhoneNum(employeeDto.getPhoneNum());
                                extQueryReqDto.setOrganizationId(employeeDto.getOrganizationId());
                                List employeeExtRespDtos = (List)this.employeeExpandQueryApi.queryEmployeeByPhoneNumOrg((EmployeeExtQueryReqDto)extQueryReqDto).getData();
                                if (CollectionUtils.isNotEmpty((Collection)employeeExtRespDtos)) {
                                    for (EmployeeExtRespDto existingEmp : employeeExtRespDtos) {
                                        if (existingEmp == null || existingEmp.getId() == null || Objects.equals(existingEmp.getId(), currentEmployee.getId())) continue;
                                        errorList.add("\u4fee\u6539\u540e\u7684\u59d3\u540d\u4e3a:" + vo.getUserName() + "\u4e14\u624b\u673a\u53f7\u4e3a:" + vo.getPhoneNumber() + "\u7684\u5458\u5de5\u5df2\u7ecf\u5b58\u5728\uff0c\u5458\u5de5\u7f16\u53f7\u4e3a:" + existingEmp.getEmployeeNo());
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!isModifyMode) {
                if (StringUtils.isBlank((CharSequence)vo.getAccount())) {
                    errorList.add("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)vo.getUserName())) {
                    errorList.add("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)vo.getPosition())) {
                    errorList.add("\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)vo.getEmployeeType())) {
                    errorList.add("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)vo.getPhoneNumber())) {
                    errorList.add("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)vo.getGovernType())) {
                    errorList.add("\u7ba1\u7406\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)vo.getRoleName())) {
                    errorList.add("\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtils.isEmpty((Object)vo.getStartDate())) {
                    errorList.add("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getAccount()) && (userOrgMap.isEmpty() || !userOrgMap.containsKey(vo.getAccount()))) {
                errorList.add("\u767b\u5f55\u8d26\u53f7\u9519\u8bef");
            }
            boolean canContinueUserCheck = false;
            if (!userOrgMap.isEmpty() && userOrgMap.containsKey(vo.getAccount())) {
                List<UserOrgizationRespDto> userOrgizationVos = userOrgMap.get(vo.getAccount());
                List userOrgList = userOrgizationVos.stream().filter(e -> orgId != null && orgId.compareTo(e.getOrgId()) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(userOrgList)) {
                    errorList.add("\u767b\u5f55\u8d26\u53f7\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                } else {
                    vo.setUserId(((UserOrgizationRespDto)userOrgList.get(0)).getUserId());
                    canContinueUserCheck = true;
                }
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getRoleName()})) {
                if (roleMap.isEmpty() || !roleMap.containsKey(vo.getRoleName())) {
                    errorList.add("\u89d2\u8272\u9519\u8bef");
                } else {
                    List<RoleExpandRespDto> roleExpandEos = roleMap.get(vo.getRoleName());
                    List orgRoleList = roleExpandEos.stream().filter(e -> Objects.nonNull(e.getBelongOrgId()) && orgId != null && Objects.equals(e.getBelongOrgId(), orgId) || e.getRoleType() == 1).collect(Collectors.toList());
                    logger.info("\u89d2\u8272\u7b5b\u9009:{},{}", (Object)JSONObject.toJSONString(orgRoleList), (Object)orgId);
                    if (CollectionUtils.isEmpty(orgRoleList)) {
                        errorList.add("\u89d2\u8272\u6240\u5c5e\u7ec4\u7ec7\u9519\u8bef");
                    } else {
                        EmployeeRoleReqDto employeeRoleReqDto = new EmployeeRoleReqDto();
                        employeeRoleReqDto.setRoleId(((RoleExpandRespDto)orgRoleList.get(0)).getId());
                        employeeRoleReqDto.setRoleCode(((RoleExpandRespDto)orgRoleList.get(0)).getCode());
                        vo.setRole(employeeRoleReqDto);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getEmployeeType()) && !"\u5185\u90e8".equals(vo.getEmployeeType()) && !"\u5916\u90e8".equals(vo.getEmployeeType())) {
                errorList.add("\u4eba\u5458\u7c7b\u578b\u53ea\u80fd\u4e3a'\u5185\u90e8'\u6216'\u5916\u90e8'");
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber()) && !CommonUtil.checkPhoneNum(vo.getPhoneNumber())) {
                errorList.add("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getGovernType())) {
                EmpGovernTypeEnum empGovernTypeEnum = EmpGovernTypeEnum.fromName((String)vo.getGovernType());
                if (ObjectUtils.isEmpty((Object)empGovernTypeEnum)) {
                    errorList.add("\u7ba1\u7406\u7c7b\u578b\u586b\u5199\u6709\u8bef");
                } else {
                    if ("\u5916\u90e8".equals(vo.getEmployeeType()) && !EmpGovernTypeEnum.CUS.getName().equals(empGovernTypeEnum.getName())) {
                        errorList.add("\u5916\u90e8\u4eba\u5458\u53ea\u80fd\u9009\u62e9\u7ba1\u7406\u5ba2\u6237\u7c7b\u578b");
                    }
                    if (StringUtils.isNotBlank((CharSequence)vo.getGovernCustomer()) && StringUtils.isNotBlank((CharSequence)vo.getBlacklist()) && vo.getGovernCustomer().equals(vo.getBlacklist())) {
                        errorList.add("\u540c\u4e00\u4e2a\u5ba2\u6237\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u7ba1\u7406\u9ed1\u540d\u5355\u548c\u7ba1\u7406\u5ba2\u6237");
                    }
                    if (canContinueUserCheck) {
                        switch (empGovernTypeEnum) {
                            case AREA: {
                                this.validateAreaManagement(vo, areasMap, errorList);
                                break;
                            }
                            case CUS: {
                                this.validateCustomerManagement(vo, customerMap, errorList);
                                break;
                            }
                            case BLA: {
                                this.validateBlacklistManagement(vo, customerMap, errorList);
                                break;
                            }
                            default: {
                                errorList.add("\u672a\u77e5\u7684\u7ba1\u7406\u7c7b\u578b");
                            }
                        }
                    }
                }
            }
            if (!isModifyMode && StringUtils.isNotEmpty((CharSequence)vo.getUserName()) && StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber())) {
                String namePhoneKey = vo.getUserName() + "_" + vo.getPhoneNumber();
                EmployeeExpandReqDto employeeDto = new EmployeeExpandReqDto();
                employeeDto.setName(vo.getUserName());
                employeeDto.setPhoneNum(vo.getPhoneNumber());
                employeeDto.setOrganizationId(orgId);
                String errorMsg = this.checkNameAndPhoneNumWithMessage(employeeDto);
                if (errorMsg != null) {
                    errorList.add(errorMsg);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getRoleName())) {
                this.processRoles(vo, roleMap, errorList);
            }
            if (errorList.isEmpty()) continue;
            vo.setErrorMsg(String.join((CharSequence)"\uff1b", errorList));
        }
        return list;
    }

    private void fillCustomInfo(List<EmployeeExpandRespDto> dtoList, Long merchantId) {
        List orgIdList = dtoList.stream().map(EmployeeExtRespDto::getOrganizationId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            CustomerSearchExtReqDto customerExtQuery = new CustomerSearchExtReqDto();
            customerExtQuery.setMerchantId(merchantId);
            customerExtQuery.setOrgInfoIds(orgIdList);
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(customerExtQuery));
            if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
                return;
            }
            Map customerMap = customerRespDtos.stream().collect(Collectors.toMap(dto -> merchantId + "_" + dto.getOrgInfoId(), Function.identity()));
            for (EmployeeExtRespDto employeeExtRespDto : dtoList) {
                String key = merchantId + "_" + employeeExtRespDto.getOrganizationId();
                if (customerMap.isEmpty() || !customerMap.containsKey(key)) continue;
                CustomerRespDto customerRespDto = (CustomerRespDto)customerMap.get(key);
                employeeExtRespDto.setCustomerName(customerRespDto.getName());
                employeeExtRespDto.setCustomerCode(customerRespDto.getCode());
            }
        }
    }

    private void fillCustomerCodeAndName(List<EmployeeExpandRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (EmployeeExtRespDto employeeExtRespDto : dtoList) {
            if (Objects.isNull(employeeExtRespDto.getId())) continue;
            CustomerExtReqDto customerExtReqDto = new CustomerExtReqDto();
            customerExtReqDto.setInstanceId(employeeExtRespDto.getInstanceId());
            customerExtReqDto.setOrgInfoId(employeeExtRespDto.getOrganizationId());
            customerExtReqDto.setEmployeeIds(Arrays.asList(employeeExtRespDto.getId()));
            customerExtReqDto.setType(employeeExtRespDto.getType());
            List customerRespDtos = (List)RestUtil.checkResponse((RestResponse)this.employeeCustomerQueryApi.queryEmployee(customerExtReqDto));
            if (!CollectionUtils.isNotEmpty((Collection)customerRespDtos)) continue;
            EmployeeCustomerRespDto customerRespDto = (EmployeeCustomerRespDto)customerRespDtos.get(0);
            employeeExtRespDto.setCustomerName(customerRespDto.getCustomerName());
            employeeExtRespDto.setCustomerCode(customerRespDto.getCustomerCode());
        }
    }

    private void fillCustomerAndRegionNum(List<EmployeeExpandRespDto> dtoList, Long orgId, Long instanceId, Long tenantId) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List employeeIds = dtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(employeeIds)) {
            return;
        }
        EmployeeNumCountReqDto reqDto = new EmployeeNumCountReqDto();
        reqDto.setEmployeeIds(employeeIds);
        reqDto.setOrgId(orgId);
        RestResponse response = this.employeeCustomerQueryApi.queryCountByEmployeeId(reqDto);
        if (Objects.nonNull(response) && "0".equals(response.getResultCode()) && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            List list = (List)response.getData();
            for (EmployeeExpandRespDto dto : dtoList) {
                for (EmployeeNumCountRespDto countNumDto : list) {
                    if (!Objects.nonNull(dto) || !Objects.nonNull(dto.getId()) || !Objects.nonNull(countNumDto) || !Objects.nonNull(countNumDto.getEmployeeId()) || dto.getId().longValue() != countNumDto.getEmployeeId().longValue()) continue;
                    dto.setCustomerNum(countNumDto.getCustomerNum());
                    dto.setRegionNum(countNumDto.getRegionNum());
                }
            }
        }
    }

    private void fillOrganizationInfo(List<EmployeeExpandRespDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List organizationIdList = dtoList.stream().map(EmployeeExtRespDto::getOrganizationId).collect(Collectors.toList());
        OrgSellerCustomerQueryReqDto queryReqDto = new OrgSellerCustomerQueryReqDto();
        queryReqDto.setPageNum(1);
        queryReqDto.setPageSize(organizationIdList.size());
        queryReqDto.setMerchantIdList(organizationIdList);
        RestResponse orgSellerCustomerRest = this.orgSellerCustomerQueryApi.orgSellerCustomerPage(queryReqDto);
        Map<Object, Object> orgSellerMap = new HashMap();
        if (orgSellerCustomerRest != null && CollectionUtils.isNotEmpty((Collection)((PageInfo)orgSellerCustomerRest.getData()).getList())) {
            List orgSellerList = ((PageInfo)orgSellerCustomerRest.getData()).getList();
            orgSellerMap = orgSellerList.stream().collect(Collectors.toMap(OrgSellerCustomerRespDto::getOrgId, Function.identity(), (k1, k2) -> k1));
        }
        for (EmployeeExpandRespDto respDto : dtoList) {
            if (orgSellerMap.isEmpty() || !orgSellerMap.containsKey(respDto.getOrganizationId())) continue;
            OrgSellerCustomerRespDto orgSellerCustomerRespDto = (OrgSellerCustomerRespDto)orgSellerMap.get(respDto.getOrganizationId());
            respDto.setOrganizationCode(orgSellerCustomerRespDto.getOrgCode());
            respDto.setOrganizationName(orgSellerCustomerRespDto.getOrgName());
            respDto.setSellerId(orgSellerCustomerRespDto.getSellerId());
            respDto.setSellerName(orgSellerCustomerRespDto.getSellerName());
            respDto.setSuperiorSellerName(orgSellerCustomerRespDto.getSuperiorSellerName());
            respDto.setDealerCode(orgSellerCustomerRespDto.getDealerCode());
        }
    }

    public void bindEmployeeCustomer(EmployeeExpandReqDto employeeDto) {
        logger.info("\u8fdb\u5165\u7ed1\u5b9a\u4eba\u5458\u5ba2\u6237");
        EmployeeCustomerAddReqDto bindCustomerDto = new EmployeeCustomerAddReqDto();
        bindCustomerDto.setEmployeeId(employeeDto.getId());
        bindCustomerDto.setUserId(employeeDto.getUserId());
        if (Objects.isNull(employeeDto.getUserId()) && StringUtils.isNotEmpty((CharSequence)employeeDto.getUserName())) {
            UserQueryReqDto userQueryReqDto = new UserQueryReqDto();
            userQueryReqDto.setUserNames(Collections.singletonList(employeeDto.getUserName()));
            List userRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.userExtQueryApi.queryUserByUserNames(userQueryReqDto));
            bindCustomerDto.setUserId(((UserRespDto)userRespDtos.get(0)).getId());
        }
        bindCustomerDto.setMerchantId(Optional.ofNullable(this.getHeaderOrgId()).orElse(employeeDto.getOrganizationId()));
        if (YesOrNoEnum.isYes((Integer)employeeDto.getOrganizationStatus())) {
            bindCustomerDto.setMerchantId(Optional.ofNullable(this.getHeaderOrgId()).orElse(employeeDto.getOrgId()));
        }
        bindCustomerDto.setRegionInfoList(employeeDto.getRegionInfoList());
        bindCustomerDto.setCustomerInfoList(employeeDto.getCustomerInfoList());
        if (CollectionUtils.isEmpty((Collection)bindCustomerDto.getCustomerInfoList()) && StringUtils.isNotEmpty((CharSequence)employeeDto.getCustomerCode())) {
            EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
            employeeCustomerReqDto.setEmployeeId(employeeDto.getId());
            employeeCustomerReqDto.setMerchantId(this.getHeaderOrgId());
            employeeCustomerReqDto.setUserId(employeeDto.getUserId());
            employeeCustomerReqDto.setStartTime(new Date());
            CustomerSearchExtReqDto searchReqDto = new CustomerSearchExtReqDto();
            searchReqDto.setCode(employeeDto.getCustomerCode());
            searchReqDto.setPageNum(Integer.valueOf(1));
            searchReqDto.setPageSize(Integer.valueOf(1));
            List customerRespDtos = (List)RestUtil.checkResponse((RestResponse)this.customerQueryV3Api.queryCustomerByExtDtoList(searchReqDto));
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                employeeCustomerReqDto.setCustomerId(((CustomerRespDto)customerRespDtos.get(0)).getId());
                bindCustomerDto.setCustomerInfoList((List)Lists.newArrayList((Object[])new EmployeeCustomerReqDto[]{employeeCustomerReqDto}));
            }
        }
        bindCustomerDto.setCustomerBlackList(employeeDto.getCustomerBlackList());
        this.employeeCustomerApi.saveEmployeeBindInfo(bindCustomerDto);
        logger.info("\u8fdb\u5165\u7ed1\u5b9a\u4eba\u5458\u5ba2\u6237\u7ed3\u675f");
    }

    public Long getHeaderOrgId() {
        String organizationId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isEmpty((CharSequence)organizationId)) {
            return null;
        }
        return Long.parseLong(organizationId);
    }

    public RestResponse<PageInfo<EmployeeExpandRespDto>> queryPageByOrg(Long organizationId, Integer pageNum, Integer pageSize) {
        EmployeeExpandQueryReqDto queryReqDto = new EmployeeExpandQueryReqDto();
        queryReqDto.setPageNum(pageNum);
        queryReqDto.setPageSize(pageSize);
        queryReqDto.setOrganizationId(organizationId);
        return this.queryByPage(queryReqDto);
    }

    public RestResponse<List<Long>> getEmployeeOrgIdByUserId(Long userId) {
        return this.employeeExpandQueryApi.getEmployeeOrgIdByUserId(userId);
    }

    public RestResponse<List<EmployeeExtRespDto>> queryByRole(Long roleId, Long instanceId) {
        String organizationId = this.headerOrgId();
        logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        ServiceContext.getContext().set("yes.req.cus.b2b.organizationId", (Object)organizationId);
        MDC.put((String)"yes.req.cus.b2b.organizationId", (String)organizationId);
        return this.employeeExpandQueryApi.queryByRole(roleId, instanceId, organizationId);
    }

    public RestResponse<List<OrganizationDto>> getOrgInfoByUserId(Long userId) {
        List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getOrgInfoByUserId(userId));
        if (CollectionUtils.isEmpty((Collection)organizationDtos)) {
            return new RestResponse();
        }
        List orgIdList = organizationDtos.stream().map(OrganizationDto::getId).collect(Collectors.toList());
        SellerExtQueryReqDto sellerExtQueryReqDto = new SellerExtQueryReqDto();
        sellerExtQueryReqDto.setOrgIdList(orgIdList);
        List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerExpandQueryApi.queryBatchSellerList(sellerExtQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)sellerRespDtos)) {
            return new RestResponse((Object)organizationDtos);
        }
        Map sellerOrgMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, Function.identity(), (k1, k2) -> k1));
        for (OrganizationDto organizationDto : organizationDtos) {
            if (sellerOrgMap.isEmpty() || !sellerOrgMap.containsKey(organizationDto.getId())) continue;
            SellerRespDto sellerRespDto = (SellerRespDto)sellerOrgMap.get(organizationDto.getId());
            organizationDto.setName(sellerRespDto.getName());
        }
        return new RestResponse((Object)organizationDtos);
    }

    public Map<String, List<RoleExpandRespDto>> getRoleMap(List<String> roleNameList, Long orgId) {
        if (CollectionUtils.isEmpty(roleNameList)) {
            return new HashMap<String, List<RoleExpandRespDto>>();
        }
        Map<String, List<RoleExpandRespDto>> roleMap = new HashMap<String, List<RoleExpandRespDto>>(roleNameList.size() * 4 / 3 + 2);
        RoleExpandReqDto roleExpandReqDto = new RoleExpandReqDto();
        roleExpandReqDto.setOrgId(orgId);
        roleExpandReqDto.setRoleNameList(roleNameList);
        List roleExpandRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.roleQueryApi.getRoleByNameList(roleExpandReqDto));
        if (CollectionUtils.isEmpty((Collection)roleExpandRespDtos)) {
            return roleMap;
        }
        roleMap = roleExpandRespDtos.stream().collect(Collectors.groupingBy(RoleRespDto::getName));
        return roleMap;
    }

    public Map<String, List<UserOrgizationRespDto>> getAccoutMap(List<String> accountList) {
        if (CollectionUtils.isEmpty(accountList)) {
            return new HashMap<String, List<UserOrgizationRespDto>>();
        }
        Map<String, List<UserOrgizationRespDto>> userOrgMap = new HashMap<String, List<UserOrgizationRespDto>>(accountList.size() * 4 / 3 + 2);
        List userOrgInfoList = (List)RestResponseHelper.extractData((RestResponse)this.userOrgExpandQueryApi.queryUserOrgByUserName(accountList));
        if (CollectionUtils.isEmpty((Collection)userOrgInfoList)) {
            return userOrgMap;
        }
        userOrgMap = userOrgInfoList.stream().collect(Collectors.groupingBy(UserOrgizationRespDto::getUserName));
        return userOrgMap;
    }

    public Map<String, List<CustomerAreaRespDto>> getCustomerAreaMap(List<String> governAreaList, Long orgId) {
        Map<String, List<CustomerAreaRespDto>> customerAreasMap = new HashMap<String, List<CustomerAreaRespDto>>(governAreaList.size() * 4 / 3 + 2);
        if (CollectionUtils.isEmpty(governAreaList)) {
            return customerAreasMap;
        }
        CustomerAreaListExtReqDto areaListReqDto = new CustomerAreaListExtReqDto();
        areaListReqDto.setNameList(governAreaList);
        areaListReqDto.setOrgInfoId(orgId);
        RestResponse areaRest = this.employeeRegionQueryApi.queryCustomerAreaByNames(areaListReqDto);
        if (null == areaRest || CollectionUtils.isEmpty((Collection)((Collection)areaRest.getData()))) {
            return customerAreasMap;
        }
        List customerAreaList = (List)areaRest.getData();
        List areaCodes = customerAreaList.stream().map(CustomerAreaRespDto::getCode).distinct().collect(Collectors.toList());
        HashSet allAreaCodes = new HashSet();
        try {
            RestResponse subCodesResp = this.employeeRegionQueryApi.querySubCustomerAreaByCodes(areaCodes);
            if (subCodesResp != null && CollectionUtils.isNotEmpty((Collection)((Collection)subCodesResp.getData()))) {
                List allSubCodes = (List)subCodesResp.getData();
                RestResponse subCodesResp1 = this.employeeRegionQueryApi.querySubCustomerAreaByCodes((List)subCodesResp.getData());
                allAreaCodes.addAll(areaCodes);
                allAreaCodes.addAll(allSubCodes);
                allAreaCodes.addAll((Collection)subCodesResp1.getData());
                ParentAreCodeReqDto parentReqDto = new ParentAreCodeReqDto();
                parentReqDto.setCodes(new ArrayList(allAreaCodes));
                RestResponse parentCodesResp = this.customerAreaQueryApi.queryAllParentCode(parentReqDto);
                if (parentCodesResp != null && CollectionUtils.isNotEmpty((Collection)((Collection)parentCodesResp.getData()))) {
                    allAreaCodes.addAll((Collection)parentCodesResp.getData());
                    RestResponse completeAreasResp = this.employeeRegionQueryApi.queryCustomerAreaByCodes(new ArrayList(allAreaCodes));
                    if (completeAreasResp != null && CollectionUtils.isNotEmpty((Collection)((Collection)completeAreasResp.getData()))) {
                        customerAreaList = (List)completeAreasResp.getData();
                    }
                }
            } else {
                ParentAreCodeReqDto parentReqDto = new ParentAreCodeReqDto();
                parentReqDto.setCodes(new ArrayList(areaCodes));
                RestResponse parentCodesResp = this.customerAreaQueryApi.queryAllParentCode(parentReqDto);
                if (parentCodesResp != null && CollectionUtils.isNotEmpty((Collection)((Collection)parentCodesResp.getData()))) {
                    allAreaCodes.addAll((Collection)parentCodesResp.getData());
                    parentReqDto.setCodes(new ArrayList((Collection)parentCodesResp.getData()));
                    RestResponse parentCodesResp2 = this.customerAreaQueryApi.queryAllParentCode(parentReqDto);
                    allAreaCodes.addAll((Collection)parentCodesResp2.getData());
                    RestResponse completeAreasResp = this.employeeRegionQueryApi.queryCustomerAreaByCodes(new ArrayList(allAreaCodes));
                    if (completeAreasResp != null && CollectionUtils.isNotEmpty((Collection)((Collection)completeAreasResp.getData()))) {
                        customerAreaList = (List)completeAreasResp.getData();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u533a\u57df\u5c42\u7ea7\u5173\u7cfb\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
        }
        logger.info("\u533a\u57df\u83b7\u53d6:{}", (Object)JSONObject.toJSONString(customerAreasMap));
        customerAreasMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getName));
        Map<String, List<CustomerAreaRespDto>> areaCodeMap = customerAreaList.stream().collect(Collectors.groupingBy(CustomerAreaRespDto::getCode));
        for (Map.Entry<String, List<CustomerAreaRespDto>> entry : areaCodeMap.entrySet()) {
            String areaName;
            List<CustomerAreaRespDto> areas = entry.getValue();
            if (areas.isEmpty() || customerAreasMap.containsKey(areaName = areas.get(0).getName())) continue;
            customerAreasMap.put(areaName, areas);
        }
        logger.info("\u5df2\u83b7\u53d6\u533a\u57df\u4fe1\u606f\u603b\u6570: {}, \u5305\u542b\u9500\u552e\u533a\u57df\u3001\u5927\u533a\u548c\u533a\u57df", (Object)customerAreaList.size());
        return customerAreasMap;
    }

    public Map<String, Long> getEmployeeMap(List<Long> userIdList, List<Long> orgIdList) {
        Map<String, Long> employeeInfoMap = new HashMap<String, Long>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return employeeInfoMap;
        }
        EmployeeExtQueryReqDto dto = new EmployeeExtQueryReqDto();
        dto.setOrganizationIdList(orgIdList);
        dto.setUserIds(userIdList);
        List employeeList = (List)RestResponseHelper.extractData((RestResponse)this.employeeExpandQueryApi.getEmployeeByUserOrgList(dto));
        if (CollectionUtils.isNotEmpty((Collection)employeeList)) {
            employeeInfoMap = employeeList.stream().collect(Collectors.toMap(ee -> ee.getOrganizationId() + "_" + ee.getUserId() + "_" + ee.getPhoneNum(), BaseRespDto::getId, (o, o1) -> o));
        }
        return employeeInfoMap;
    }

    public Map<String, OrganizationDto> getOrgByNameMap(List<String> nameList) {
        if (CollectionUtils.isEmpty(nameList)) {
            return new HashMap<String, OrganizationDto>();
        }
        List dtoList = (List)RestResponseHelper.extractData((RestResponse)this.orgInfoExtQueryApi.getOrgByNameList(nameList));
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return new HashMap<String, OrganizationDto>();
        }
        Map<String, OrganizationDto> organizationEoMap = dtoList.stream().collect(Collectors.toMap(OrganizationDto::getName, Function.identity(), (k1, k2) -> k1));
        return organizationEoMap;
    }

    public List<EmployeeExcelExtVo> setErrorsMsg(List<EmployeeExcelExtVo> list, String account, String errorMsg) {
        list.forEach(vo -> {
            if (StringUtils.isBlank((CharSequence)vo.getErrorMsg()) && vo.getAccount().equals(account)) {
                vo.setErrorMsg(errorMsg);
            } else if (vo.getAccount().equals(account)) {
                vo.setErrorMsg(vo.getErrorMsg() + "\uff1b" + errorMsg);
            }
        });
        return list;
    }

    private EmployeeExtRespDto checkExistingEmployee(String employeeCode, String userName, String phoneNumber, Long orgId) {
        if (StringUtils.isNotEmpty((CharSequence)employeeCode)) {
            ArrayList<String> codes = new ArrayList<String>();
            codes.add(employeeCode);
            List existingEmployees = (List)RestResponseHelper.extractData((RestResponse)this.employeeRoleQueryApi.queryEmployeeByNos(codes));
            if (CollectionUtils.isNotEmpty((Collection)existingEmployees)) {
                return (EmployeeExtRespDto)existingEmployees.get(0);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)userName) && StringUtils.isNotEmpty((CharSequence)phoneNumber)) {
            EmployeeExpandReqDto expandReqDto = new EmployeeExpandReqDto();
            expandReqDto.setName(userName);
            expandReqDto.setPhoneNum(phoneNumber);
            expandReqDto.setOrganizationId(orgId);
            this.checkNameAndPhoneNum(expandReqDto);
        }
        return null;
    }

    private boolean processEmployeeData(Long instanceId, EmployeeExcelExtVo data, EmployeeExtRespDto existingEmployee) {
        try {
            boolean isModifyMode;
            EmployeeExpandReqDto employeeExtReqDto = new EmployeeExpandReqDto();
            employeeExtReqDto.setOrganizationId(data.getOrgId());
            employeeExtReqDto.setOrgId(data.getOrgId());
            employeeExtReqDto.setName(data.getUserName());
            employeeExtReqDto.setPosition(data.getPosition());
            employeeExtReqDto.setPersonType("\u5185\u90e8".equals(data.getEmployeeType()) ? "Internal" : "External");
            employeeExtReqDto.setPhoneNum(data.getPhoneNumber());
            employeeExtReqDto.setEmployeeRoleDtoList(data.getRoleList());
            employeeExtReqDto.setUserId(data.getUserId());
            employeeExtReqDto.setStartTime(new Date());
            employeeExtReqDto.setCustomerInfoList(data.getCustomerInfoList());
            employeeExtReqDto.setCustomerBlackList(data.getCustomerBlackList());
            employeeExtReqDto.setRegionInfoList(data.getAreaList());
            employeeExtReqDto.setOrganizationStatus(YesOrNoEnum.NO.getStatus());
            employeeExtReqDto.setStatus(Integer.valueOf(1));
            if (StringUtils.isNotEmpty((CharSequence)data.getEmployeeCode())) {
                employeeExtReqDto.setEmployeeNo(data.getEmployeeCode());
            }
            boolean bl = isModifyMode = StringUtils.isNotBlank((CharSequence)data.getEmployeeCode()) && existingEmployee != null;
            if (isModifyMode) {
                EmployeeRegionQueryReqDto queryReqDto;
                instanceId = existingEmployee.getInstanceId();
                employeeExtReqDto.setId(existingEmployee.getId());
                if (StringUtils.isBlank((CharSequence)employeeExtReqDto.getName())) {
                    employeeExtReqDto.setName(existingEmployee.getName());
                }
                if (StringUtils.isBlank((CharSequence)employeeExtReqDto.getPhoneNum())) {
                    employeeExtReqDto.setPhoneNum(existingEmployee.getPhoneNum());
                }
                if (StringUtils.isBlank((CharSequence)employeeExtReqDto.getPosition())) {
                    employeeExtReqDto.setPosition(existingEmployee.getPosition());
                }
                if (!data.getGovernTypes().contains(EmpGovernTypeEnum.AREA.getName())) {
                    queryReqDto = new EmployeeRegionQueryReqDto();
                    queryReqDto.setEmployeeId(existingEmployee.getId());
                    queryReqDto.setMerchantId(existingEmployee.getOrganizationId());
                    List employeeRegionRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeRegionQueryApi.queryEmployeeRegionList(queryReqDto));
                    employeeExtReqDto.setRegionInfoList(employeeRegionRespDtos.stream().map(r -> (EmployeeRegionReqDto)BeanUtil.copyProperties((Object)r, EmployeeRegionReqDto.class, (String[])new String[0])).collect(Collectors.toList()));
                }
                if (!data.getGovernTypes().contains(EmpGovernTypeEnum.BLA.getName())) {
                    queryReqDto = new EmployeeCustomerBlacklistQueryReqDto();
                    queryReqDto.setEmployeeId(existingEmployee.getId());
                    queryReqDto.setMerchantId(existingEmployee.getOrganizationId());
                    List customerBlacklistRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeCustomerBlacklistQueryApi.queryEmployeeCustomerBlackList((EmployeeCustomerBlacklistQueryReqDto)queryReqDto));
                    employeeExtReqDto.setCustomerBlackList(customerBlacklistRespDtos.stream().map(r -> (EmployeeCustomerBlacklistReqDto)BeanUtil.copyProperties((Object)r, EmployeeCustomerBlacklistReqDto.class, (String[])new String[0])).collect(Collectors.toList()));
                }
                if (!data.getGovernTypes().contains(EmpGovernTypeEnum.CUS.getName())) {
                    queryReqDto = new EmployeeCustomerQueryReqDto();
                    queryReqDto.setEmployeeId(existingEmployee.getId());
                    List employeeCustomerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.employeeCustomerQueryApi.queryEmployeeCustomerList((EmployeeCustomerQueryReqDto)queryReqDto));
                    employeeExtReqDto.setCustomerInfoList(employeeCustomerRespDtos.stream().map(r -> (EmployeeCustomerReqDto)BeanUtil.copyProperties((Object)r, EmployeeCustomerReqDto.class, (String[])new String[0])).collect(Collectors.toList()));
                }
                logger.info("\u4fee\u6539\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                this.modifyEmployee(instanceId, employeeExtReqDto);
            } else {
                if (existingEmployee != null) {
                    logger.warn("\u5de5\u53f7\u4e3a[{}]\u7684\u5458\u5de5\u5df2\u5b58\u5728\uff0c\u4f46\u5f53\u524d\u4e3a\u65b0\u589e\u6a21\u5f0f\uff0c\u8df3\u8fc7\u5904\u7406", (Object)data.getEmployeeCode());
                    return false;
                }
                logger.info("\u65b0\u589e\u4eba\u5458\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)employeeExtReqDto));
                this.addEmployee(instanceId, employeeExtReqDto);
            }
            logger.info("\u4eba\u5458\u5904\u7406\u6210\u529f: {}", (Object)data.getAccount());
            return true;
        }
        catch (Exception e) {
            logger.error("\u4eba\u5458\u5904\u7406\u6267\u884c\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            data.setErrorMsg(e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateAreaManagement(EmployeeExcelExtVo vo, Map<String, List<CustomerAreaRespDto>> areasMap, List<String> errorList) {
        String saleAreaCode;
        List<Object> saleAreaList;
        boolean hasSaleArea = StringUtils.isNotBlank((CharSequence)vo.getSaleArea());
        boolean hasBigArea = StringUtils.isNotBlank((CharSequence)vo.getBigArea());
        boolean hasDistrict = StringUtils.isNotBlank((CharSequence)vo.getDistrict());
        if (!(hasSaleArea || hasBigArea || hasDistrict)) {
            errorList.add("\u9500\u552e\u533a\u57df\u3001\u5927\u533a\u3001\u533a\u57df\u81f3\u5c11\u586b\u5199\u4e00\u9879");
            return;
        }
        ArrayList<EmployeeRegionReqDto> areaList = new ArrayList<EmployeeRegionReqDto>();
        if (hasSaleArea && !hasBigArea && !hasDistrict) {
            saleAreaList = areasMap.get(vo.getSaleArea());
            if (CollectionUtils.isEmpty(saleAreaList)) {
                errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
                return;
            }
            if (CollectionUtils.isEmpty(saleAreaList = saleAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList()))) {
                errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
                return;
            }
            saleAreaCode = ((CustomerAreaRespDto)saleAreaList.get(0)).getCode();
            logger.info("\u7ed1\u5b9a\u9500\u552e\u533a\u57df: {}", (Object)vo.getSaleArea());
            for (Map.Entry entry : areasMap.entrySet()) {
                for (Object area : (List)entry.getValue()) {
                    if (!saleAreaCode.equals(area.getParentCode()) || !Objects.equals(area.getOrgInfoId(), vo.getOrgId())) continue;
                    logger.info("\u7ed1\u5b9a\u5927\u533a: {}", (Object)area.getName());
                    String string = area.getCode();
                    for (Map.Entry<String, List<CustomerAreaRespDto>> subEntry : areasMap.entrySet()) {
                        for (CustomerAreaRespDto subArea : subEntry.getValue()) {
                            if (!string.equals(subArea.getParentCode()) || !Objects.equals(subArea.getOrgInfoId(), vo.getOrgId())) continue;
                            EmployeeRegionReqDto districtDto = new EmployeeRegionReqDto();
                            districtDto.setRegionCode(subArea.getCode());
                            districtDto.setStartTime(vo.getStartDate());
                            districtDto.setEndTime(vo.getEndDate());
                            areaList.add(districtDto);
                            logger.info("\u7ed1\u5b9a\u533a\u57df: {}", (Object)subArea.getName());
                        }
                    }
                }
            }
        } else if (hasSaleArea && hasBigArea && !hasDistrict) {
            saleAreaList = areasMap.get(vo.getSaleArea());
            if (CollectionUtils.isEmpty(saleAreaList)) {
                errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
                return;
            }
            if (CollectionUtils.isEmpty(saleAreaList = saleAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList()))) {
                errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
                return;
            }
            List<Object> bigAreaList = areasMap.get(vo.getBigArea());
            if (CollectionUtils.isEmpty(bigAreaList)) {
                errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
                return;
            }
            if (CollectionUtils.isEmpty(bigAreaList = bigAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList()))) {
                errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
                return;
            }
            String saleAreaCode2 = ((CustomerAreaRespDto)saleAreaList.get(0)).getCode();
            CustomerAreaRespDto customerAreaRespDto = (CustomerAreaRespDto)bigAreaList.get(0);
            if (!customerAreaRespDto.getParentCode().equals(saleAreaCode2)) {
                errorList.add("\u9500\u552e\u533a\u57df\u4e0b\u4e0d\u5b58\u5728\u8be5\u5927\u533a");
                return;
            }
            logger.info("\u7ed1\u5b9a\u9500\u552e\u533a\u57df: {}", (Object)vo.getSaleArea());
            String bigAreaCode = customerAreaRespDto.getCode();
            logger.info("\u7ed1\u5b9a\u5927\u533a: {}", (Object)vo.getBigArea());
            for (Map.Entry entry : areasMap.entrySet()) {
                for (CustomerAreaRespDto area : (List)entry.getValue()) {
                    if (!bigAreaCode.equals(area.getParentCode()) || !Objects.equals(area.getOrgInfoId(), vo.getOrgId())) continue;
                    EmployeeRegionReqDto districtDto = new EmployeeRegionReqDto();
                    districtDto.setRegionCode(area.getCode());
                    districtDto.setStartTime(vo.getStartDate());
                    districtDto.setEndTime(vo.getEndDate());
                    areaList.add(districtDto);
                    logger.info("\u7ed1\u5b9a\u533a\u57df: {}", (Object)area.getName());
                }
            }
        } else if (!hasSaleArea && hasBigArea && !hasDistrict) {
            List<Object> bigAreaList = areasMap.get(vo.getBigArea());
            if (CollectionUtils.isEmpty(bigAreaList)) {
                errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
                return;
            }
            if (CollectionUtils.isEmpty(bigAreaList = bigAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList()))) {
                errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
                return;
            }
            String bigAreaCode = ((CustomerAreaRespDto)bigAreaList.get(0)).getCode();
            String parentCode = ((CustomerAreaRespDto)bigAreaList.get(0)).getParentCode();
            Object var11_13 = null;
            for (Map.Entry<String, List<CustomerAreaRespDto>> entry : areasMap.entrySet()) {
                void var11_14;
                for (CustomerAreaRespDto area : entry.getValue()) {
                    if (!parentCode.equals(area.getCode())) continue;
                    CustomerAreaRespDto customerAreaRespDto = area;
                    vo.setSaleArea(area.getName());
                    logger.info("\u7ed1\u5b9a\u9500\u552e\u533a\u57df: {}", (Object)area.getName());
                    break;
                }
                if (var11_14 == null) continue;
                break;
            }
            for (Map.Entry<String, List<CustomerAreaRespDto>> entry : areasMap.entrySet()) {
                for (CustomerAreaRespDto area : entry.getValue()) {
                    if (!bigAreaCode.equals(area.getParentCode()) || !Objects.equals(area.getOrgInfoId(), vo.getOrgId())) continue;
                    EmployeeRegionReqDto districtDto = new EmployeeRegionReqDto();
                    districtDto.setRegionCode(area.getCode());
                    districtDto.setStartTime(vo.getStartDate());
                    districtDto.setEndTime(vo.getEndDate());
                    areaList.add(districtDto);
                    logger.info("\u7ed1\u5b9a\u533a\u57df: {}", (Object)area.getName());
                }
            }
        } else if (!hasSaleArea && !hasBigArea && hasDistrict) {
            List<Object> districtList = areasMap.get(vo.getDistrict());
            if (CollectionUtils.isEmpty(districtList)) {
                errorList.add("\u627e\u4e0d\u5230\u533a\u57df");
                return;
            }
            if (CollectionUtils.isEmpty(districtList = districtList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList()))) {
                errorList.add("\u627e\u4e0d\u5230\u533a\u57df");
                return;
            }
            String districtCode = ((CustomerAreaRespDto)districtList.get(0)).getCode();
            String bigAreaCode = ((CustomerAreaRespDto)districtList.get(0)).getParentCode();
            Object var11_16 = null;
            for (Map.Entry<String, List<CustomerAreaRespDto>> entry : areasMap.entrySet()) {
                void var11_17;
                block11: for (CustomerAreaRespDto area : entry.getValue()) {
                    if (!bigAreaCode.equals(area.getCode())) continue;
                    CustomerAreaRespDto customerAreaRespDto = area;
                    vo.setBigArea(area.getName());
                    logger.info("\u7ed1\u5b9a\u5927\u533a: {}", (Object)area.getName());
                    String saleAreaCode3 = area.getParentCode();
                    for (Map.Entry<String, List<CustomerAreaRespDto>> entry2 : areasMap.entrySet()) {
                        for (CustomerAreaRespDto area2 : entry2.getValue()) {
                            if (!saleAreaCode3.equals(area2.getCode())) continue;
                            vo.setSaleArea(area2.getName());
                            logger.info("\u7ed1\u5b9a\u9500\u552e\u533a\u57df: {}", (Object)area2.getName());
                            break;
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)vo.getSaleArea())) continue;
                        break block11;
                    }
                }
                if (var11_17 == null) continue;
                break;
            }
            EmployeeRegionReqDto districtDto = new EmployeeRegionReqDto();
            districtDto.setRegionCode(districtCode);
            districtDto.setStartTime(vo.getStartDate());
            districtDto.setEndTime(vo.getEndDate());
            areaList.add(districtDto);
            logger.info("\u7ed1\u5b9a\u533a\u57df: {}", (Object)vo.getDistrict());
        } else if (hasSaleArea && hasBigArea && hasDistrict) {
            this.validateCompleteAreaHierarchy(vo, areasMap, errorList);
            if (!(errorList.contains("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df") || errorList.contains("\u627e\u4e0d\u5230\u5927\u533a") || errorList.contains("\u627e\u4e0d\u5230\u533a\u57df") || errorList.contains("\u9500\u552e\u533a\u57df\u4e0b\u4e0d\u5b58\u5728\u8be5\u5927\u533a") || errorList.contains("\u5927\u533a\u4e0b\u4e0d\u5b58\u5728\u8be5\u533a\u57df"))) {
                saleAreaList = areasMap.get(vo.getSaleArea());
                saleAreaList = saleAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList());
                saleAreaCode = ((CustomerAreaRespDto)saleAreaList.get(0)).getCode();
                logger.info("\u7ed1\u5b9a\u9500\u552e\u533a\u57df: {}", (Object)vo.getSaleArea());
                List<CustomerAreaRespDto> bigAreaList = areasMap.get(vo.getBigArea());
                logger.info("\u7ed1\u5b9a\u5927\u533a: {}", (Object)vo.getBigArea());
                List<CustomerAreaRespDto> list = areasMap.get(vo.getDistrict());
                List list2 = list.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList());
                String districtCode = ((CustomerAreaRespDto)list2.get(0)).getCode();
                EmployeeRegionReqDto districtDto = new EmployeeRegionReqDto();
                districtDto.setRegionCode(districtCode);
                districtDto.setStartTime(vo.getStartDate());
                districtDto.setEndTime(vo.getEndDate());
                areaList.add(districtDto);
                logger.info("\u7ed1\u5b9a\u533a\u57df: {}", (Object)vo.getDistrict());
            }
        }
        if (!(errorList.contains("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df") || errorList.contains("\u627e\u4e0d\u5230\u5927\u533a") || errorList.contains("\u627e\u4e0d\u5230\u533a\u57df") || errorList.contains("\u9500\u552e\u533a\u57df\u4e0b\u4e0d\u5b58\u5728\u8be5\u5927\u533a") || errorList.contains("\u5927\u533a\u4e0b\u4e0d\u5b58\u5728\u8be5\u533a\u57df"))) {
            ArrayList<String> addedCodes = new ArrayList<String>();
            ArrayList<EmployeeRegionReqDto> uniqueList = new ArrayList<EmployeeRegionReqDto>();
            for (EmployeeRegionReqDto employeeRegionReqDto : areaList) {
                if (addedCodes.contains(employeeRegionReqDto.getRegionCode())) continue;
                addedCodes.add(employeeRegionReqDto.getRegionCode());
                uniqueList.add(employeeRegionReqDto);
            }
            vo.setAreaList(uniqueList);
            logger.info("\u6700\u7ec8\u7ed1\u5b9a\u533a\u57df\u6570\u91cf: {}", (Object)uniqueList.size());
        }
    }

    private void validateCompleteAreaHierarchy(EmployeeExcelExtVo vo, Map<String, List<CustomerAreaRespDto>> areasMap, List<String> errorList) {
        List<Object> saleAreaList = areasMap.get(vo.getSaleArea());
        if (CollectionUtils.isEmpty(saleAreaList)) {
            errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
            return;
        }
        if (CollectionUtils.isEmpty(saleAreaList = saleAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList()))) {
            errorList.add("\u627e\u4e0d\u5230\u9500\u552e\u533a\u57df");
            return;
        }
        List<Object> bigAreaList = areasMap.get(vo.getBigArea());
        if (CollectionUtils.isEmpty(bigAreaList)) {
            errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
            return;
        }
        if (CollectionUtils.isEmpty(bigAreaList = bigAreaList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList()))) {
            errorList.add("\u627e\u4e0d\u5230\u5927\u533a");
            return;
        }
        if (!((CustomerAreaRespDto)bigAreaList.get(0)).getParentCode().equals(((CustomerAreaRespDto)saleAreaList.get(0)).getCode())) {
            errorList.add("\u9500\u552e\u533a\u57df\u4e0b\u4e0d\u5b58\u5728\u8be5\u5927\u533a");
            return;
        }
        List<Object> districtList = areasMap.get(vo.getDistrict());
        if (CollectionUtils.isEmpty(districtList)) {
            errorList.add("\u627e\u4e0d\u5230\u533a\u57df");
            return;
        }
        if (CollectionUtils.isEmpty(districtList = districtList.stream().filter(e -> Objects.equals(e.getOrgInfoId(), vo.getOrgId())).collect(Collectors.toList()))) {
            errorList.add("\u627e\u4e0d\u5230\u533a\u57df");
            return;
        }
        if (!((CustomerAreaRespDto)districtList.get(0)).getParentCode().equals(((CustomerAreaRespDto)bigAreaList.get(0)).getCode())) {
            errorList.add("\u5927\u533a\u4e0b\u4e0d\u5b58\u5728\u8be5\u533a\u57df");
            return;
        }
        EmployeeRegionReqDto employeeRegionReqDto = new EmployeeRegionReqDto();
        employeeRegionReqDto.setRegionCode(((CustomerAreaRespDto)districtList.get(0)).getCode());
        employeeRegionReqDto.setStartTime(vo.getStartDate());
        employeeRegionReqDto.setEndTime(vo.getEndDate());
        vo.setArea(employeeRegionReqDto);
    }

    private void validateCustomerManagement(EmployeeExcelExtVo vo, Map<String, CustomerRespDto> customerMap, List<String> errorList) {
        if (StringUtils.isBlank((CharSequence)vo.getGovernCustomer())) {
            errorList.add("\u7ba1\u7406\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        CustomerRespDto customerRespDto = customerMap.get(vo.getGovernCustomer());
        if (Objects.isNull(customerRespDto)) {
            errorList.add("\u7ba1\u7406\u5ba2\u6237\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u9519\u8bef");
            return;
        }
        EmployeeCustomerReqDto employeeCustomerReqDto = new EmployeeCustomerReqDto();
        employeeCustomerReqDto.setCustomerId(customerRespDto.getId());
        employeeCustomerReqDto.setStartTime(vo.getStartDate());
        vo.setCustomerDto(employeeCustomerReqDto);
        ArrayList<EmployeeCustomerReqDto> customerInfoList = new ArrayList<EmployeeCustomerReqDto>();
        customerInfoList.add(employeeCustomerReqDto);
        vo.setCustomerInfoList(customerInfoList);
    }

    private void validateBlacklistManagement(EmployeeExcelExtVo vo, Map<String, CustomerRespDto> customerMap, List<String> errorList) {
        if ("\u5916\u90e8".equals(vo.getEmployeeType())) {
            errorList.add("\u5916\u90e8\u4eba\u5458\u4e0d\u80fd\u9009\u62e9\u7ba1\u7406\u9ed1\u540d\u5355\u7c7b\u578b");
            return;
        }
        if (StringUtils.isBlank((CharSequence)vo.getBlacklist())) {
            errorList.add("\u7ba1\u7406\u9ed1\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        CustomerRespDto customerBlackRespDto = customerMap.get(vo.getBlacklist());
        if (Objects.isNull(customerBlackRespDto)) {
            errorList.add("\u7ba1\u7406\u9ed1\u540d\u5355\uff08\u5ba2\u6237\u7f16\u53f7\uff09\u9519\u8bef");
            return;
        }
        EmployeeCustomerBlacklistReqDto customerBlacklistReqDto = new EmployeeCustomerBlacklistReqDto();
        customerBlacklistReqDto.setCustomerId(customerBlackRespDto.getId());
        customerBlacklistReqDto.setStartTime(vo.getStartDate());
        vo.setCustomerBlackDto(customerBlacklistReqDto);
        ArrayList<EmployeeCustomerBlacklistReqDto> blackList = new ArrayList<EmployeeCustomerBlacklistReqDto>();
        blackList.add(customerBlacklistReqDto);
        vo.setCustomerBlackList(blackList);
    }

    private void processRoles(EmployeeExcelExtVo vo, Map<String, List<RoleExpandRespDto>> roleMap, List<String> errorList) {
        String[] roleNames = vo.getRoleName().split(";");
        ArrayList<EmployeeRoleReqDto> roleList = new ArrayList<EmployeeRoleReqDto>();
        for (String roleName : roleNames) {
            if (!StringUtils.isNotEmpty((CharSequence)(roleName = roleName.trim()))) continue;
            if (roleMap.containsKey(roleName)) {
                List<RoleExpandRespDto> roleExpands = roleMap.get(roleName);
                if (!CollectionUtils.isNotEmpty(roleExpands)) continue;
                EmployeeRoleReqDto roleReqDto = new EmployeeRoleReqDto();
                roleReqDto.setRoleId(roleExpands.get(0).getId());
                roleReqDto.setRoleCode(roleExpands.get(0).getCode());
                roleList.add(roleReqDto);
                continue;
            }
            errorList.add("\u89d2\u8272\uff1a" + roleName + " \u4e0d\u5b58\u5728");
        }
        if (CollectionUtils.isNotEmpty(roleList)) {
            vo.setRoleList(roleList);
        }
    }

    public List<EmployeeExcelExtVo> mergeData(List<EmployeeExcelExtVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        Map<String, List<EmployeeExcelExtVo>> namePhoneMap = list.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getEmployeeCode()) || StringUtils.isNotEmpty((CharSequence)vo.getUserName()) && StringUtils.isNotEmpty((CharSequence)vo.getPhoneNumber())).collect(Collectors.groupingBy(vo -> vo.getEmployeeCode() + "_" + vo.getUserName() + "_" + vo.getPhoneNumber()));
        ArrayList<EmployeeExcelExtVo> mergedList = new ArrayList<EmployeeExcelExtVo>();
        for (Map.Entry<String, List<EmployeeExcelExtVo>> entry : namePhoneMap.entrySet()) {
            List<EmployeeExcelExtVo> duplicates = entry.getValue();
            if (duplicates.size() == 1) {
                mergedList.add(duplicates.get(0));
                continue;
            }
            logger.info("\u5408\u5e76\u76f8\u540c\u59d3\u540d\u548c\u624b\u673a\u53f7\u7684\u8bb0\u5f55: {}, \u8bb0\u5f55\u6570: {}", (Object)entry.getKey(), (Object)duplicates.size());
            EmployeeExcelExtVo mergedVo = new EmployeeExcelExtVo();
            EmployeeExcelExtVo firstVo = duplicates.get(0);
            mergedVo.setUserName(firstVo.getUserName());
            mergedVo.setPhoneNumber(firstVo.getPhoneNumber());
            mergedVo.setAreaList(duplicates.stream().filter(r -> CollectionUtils.isNotEmpty(r.getAreaList())).flatMap(r -> r.getAreaList().stream()).collect(Collectors.toList()));
            mergedVo.setCustomerBlackList(duplicates.stream().filter(r -> CollectionUtils.isNotEmpty(r.getCustomerBlackList())).flatMap(r -> r.getCustomerBlackList().stream()).collect(Collectors.toList()));
            mergedVo.setCustomerInfoList(duplicates.stream().filter(r -> CollectionUtils.isNotEmpty(r.getCustomerInfoList())).flatMap(r -> r.getCustomerInfoList().stream()).collect(Collectors.toList()));
            String employeeCode = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getEmployeeCode())).map(EmployeeExcelExtVo::getEmployeeCode).findFirst().orElse(null);
            mergedVo.setEmployeeCode(employeeCode);
            String account = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getAccount())).map(EmployeeExcelExtVo::getAccount).findFirst().orElse(null);
            mergedVo.setAccount(account);
            String position = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getPosition())).map(EmployeeExcelExtVo::getPosition).findFirst().orElse(null);
            mergedVo.setPosition(position);
            Long userId = duplicates.stream().filter(vo -> vo.getUserId() != null).map(EmployeeExcelExtVo::getUserId).findFirst().orElse(null);
            mergedVo.setUserId(userId);
            Long orgId = duplicates.stream().filter(vo -> vo.getOrgId() != null).map(EmployeeExcelExtVo::getOrgId).findFirst().orElse(null);
            mergedVo.setOrgId(orgId);
            String employeeType = duplicates.stream().filter(vo -> "\u5185\u90e8".equals(vo.getEmployeeType())).map(EmployeeExcelExtVo::getEmployeeType).findFirst().orElse(duplicates.get(0).getEmployeeType());
            mergedVo.setEmployeeType(employeeType);
            String governType = duplicates.stream().filter(vo -> EmpGovernTypeEnum.AREA.getName().equals(vo.getGovernType())).map(EmployeeExcelExtVo::getGovernType).findFirst().orElse(duplicates.stream().filter(vo -> EmpGovernTypeEnum.BLA.getName().equals(vo.getGovernType())).map(EmployeeExcelExtVo::getGovernType).findFirst().orElse(duplicates.stream().filter(vo -> EmpGovernTypeEnum.CUS.getName().equals(vo.getGovernType())).map(EmployeeExcelExtVo::getGovernType).findFirst().orElse(null)));
            mergedVo.setGovernType(governType);
            mergedVo.setGovernTypes(duplicates.stream().map(EmployeeExcelExtVo::getGovernType).distinct().collect(Collectors.toList()));
            HashSet<EmployeeRoleReqDto> roleSet = new HashSet<EmployeeRoleReqDto>();
            for (EmployeeExcelExtVo vo2 : duplicates) {
                if (!CollectionUtils.isNotEmpty(vo2.getRoleList())) continue;
                roleSet.addAll(vo2.getRoleList());
            }
            mergedVo.setRoleList(new ArrayList<EmployeeRoleReqDto>(roleSet));
            Date startDate = duplicates.stream().filter(vo -> vo.getStartDate() != null).map(EmployeeExcelExtVo::getStartDate).max(Date::compareTo).orElse(null);
            mergedVo.setStartDate(startDate);
            Date endDate = duplicates.stream().filter(vo -> vo.getEndDate() != null).map(EmployeeExcelExtVo::getEndDate).max(Date::compareTo).orElse(null);
            mergedVo.setEndDate(endDate);
            String saleArea = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getSaleArea())).map(EmployeeExcelExtVo::getSaleArea).findFirst().orElse(null);
            mergedVo.setSaleArea(saleArea);
            String bigArea = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getBigArea())).map(EmployeeExcelExtVo::getBigArea).findFirst().orElse(null);
            mergedVo.setBigArea(bigArea);
            String district = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getDistrict())).map(EmployeeExcelExtVo::getDistrict).findFirst().orElse(null);
            mergedVo.setDistrict(district);
            String governCustomer = duplicates.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getGovernCustomer())).map(EmployeeExcelExtVo::getGovernCustomer).findFirst().orElse(null);
            mergedVo.setGovernCustomer(governCustomer);
            mergedList.add(mergedVo);
        }
        return mergedList;
    }
}

