package com.dtyunxi.yundt.module.customer.biz.service;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 药店数据模块
 * @author lius5
 */
public interface IStoreService {

    /**
     * 药店数据修改
     * @param reqDto
     */
    RestResponse<Void> saveOrUpdateStore(StoreReqDto reqDto);

    /**
     * 根据导入Excel处理数据
     * @param file
     */
    RestResponse<Void> saveOrUpdateStoreByExcel(MultipartFile file);

    @Async
    void processParentStoreInfo(StoreReqDto reqDto);

    /**
     * 药店状态有更改时，同步转换后的状态到小b(小b需为启用、注销状态)
     *
     * 该方法写在service是为了使Async注解生效。异步提升效率
     */
    void syncStoreState2Customer(StoreReqDto reqDto);

    void syncStoreState2CustomerBatch(List<StoreReqDto> reqDtos);

}
