/**
 * @(#)Captcha.java 1.0 2019年7月15日
 *
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 验证码
 * 
 * @author wu.sheng
 * @time 2019年7月15日 上午11:37:18
 */
@ApiModel(value = "Captcha", description = "验证码")
public class Captcha {

	/**
	 * 类型 1 短信 2 邮箱 3图形验证码")
	 */
	@ApiModelProperty(name = "type", value = "类型 1 短信 2 邮箱3图形验证码")
	private Integer type;
	
	/**
	 * 发送实体 如 手机：1364089665887
	 */
	@ApiModelProperty(name = "target", value = "发送实体 如 手机：1364089665887")
	private String target;
	
	/**
	 * 验证码唯一标识
	 */
	@ApiModelProperty(name = "captchaId", value = "验证码唯一标识")
	private String captchaId;
	
	/**
	 * 图形验证码base64字符串
	 */
	@ApiModelProperty(name = "image", value = "图形验证码base64字符串")
	private String image;

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	public String getCaptchaId() {
		return captchaId;
	}

	public void setCaptchaId(String captchaId) {
		this.captchaId = captchaId;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

}
