package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.IOrgRoleApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.ChooseOrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.OrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.tcbj.OrgRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrgRoleQueryApi;
import com.dtyunxi.yundt.module.customer.api.dto.response.user.OrgRoleExtRespDto;
import com.dtyunxi.yundt.module.customer.api.user.IOrgRoleService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author jiejun
 * @Description 组织角色管理
 * @since 1.0.0
 */
@Api(tags = {"用户组件：组织角色管理"})
@RestController
@RequestMapping("/v2/ext/orgUser")
public class OrgUser2Rest {

    @Resource
    private IOrgRoleService orgRoleService;


    /**
     * 创建组织角色
     * @param orgRoleReqDto 请求对象
     * @return 请求结果
     */
    @PostMapping("/create")
    @ApiOperation(value = "创建组织角色", notes = "创建组织角色")
    public RestResponse<Long> create(@RequestBody OrgRoleReqDto orgRoleReqDto) {
        return orgRoleService.create(orgRoleReqDto);
    }

    /**
     * 修改组织角色
     * @param orgRoleReqDto 请求对象
     */
    @PostMapping("/update")
    @ApiOperation(value = "修改组织角色", notes = "修改组织角色")
    public RestResponse<Void> update(@RequestBody OrgRoleReqDto orgRoleReqDto) {
        return orgRoleService.update(orgRoleReqDto);
    }

    /**
     * 删除组织角色
     * @param id 删除ID
     */
    @GetMapping("/delete")
    @ApiOperation(value = "删除组织角色", notes = "删除组织角色")
    public RestResponse<Void> delete(@RequestParam("id") Long id) {
        return orgRoleService.delete(id);
    }

    /**
     * 查询组织角色详情
     * @param id 请求ID
     * @return 请求结果
     */
    @PostMapping("/queryOne")
    @ApiOperation(value = "查询组织角色详情", notes = "查询组织角色详情")
    public RestResponse<OrgRoleExtRespDto> queryDetail(@RequestParam("id") Long id) {
        return orgRoleService.queryDetail(id);
    }

    /**
     * 查询选择绑定组织角色分页列表
     * @param reqDto 参数对象
     * @return 请求结果
     */
    @PostMapping("/queryChoosePage")
    @ApiOperation(value = "查询选择绑定组织角色分页列表", notes = "查询选择绑定组织角色分页列表")
    public RestResponse<PageInfo<RoleDto>> queryChoosePage(@RequestBody ChooseOrgRoleReqDto reqDto) {
        return orgRoleService.queryChoosePage(reqDto);
    }

    /**
     * 获取系统应用列表
     * @return 请求结果
     */
    @GetMapping("/queryAppInstanceList")
    @ApiOperation(value = "获取系统应用列表", notes = "获取系统应用列表")
    public RestResponse<List<AppInstanceDto>> queryAppInstanceList() {
        return orgRoleService.queryAppInstanceList();
    }
}
