package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.customer.api.IFileService;
import com.dtyunxi.yundt.module.customer.api.dto.request.UploadFileReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 客户信息
 * @author xuhuaqiang
 * @version 1.0.0
 * @description
 * @date 2020/9/29 18:06
 */
@Api(tags = {"客商组件：OSS服务"})
@RestController
@RequestMapping("/v1/file")
public class FileRest {

    private static final Logger logger = LoggerFactory.getLogger(FileRest.class);

    @Resource
    private IFileService fileService;


    /**
     * 上传文件
     *
     * @param reqDto
     * @return
     */
    @PostMapping(value = "/upload", produces = "application/json")
    @ApiOperation(value = "上传文件", notes = "上传文件")
    RestResponse<String> uploadFile(@RequestBody UploadFileReqDto reqDto){
        return new RestResponse<>(fileService.uploadFile(reqDto));
    }


}
