/**
 * @(#)ILogin.java 1.0 2019年7月12日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.user.IAuthentication;
import com.dtyunxi.yundt.module.customer.api.dto.request.ModifyPasswordReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.request.ResetPasswordReqDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.TenantGuideRespDto;
import com.dtyunxi.yundt.module.customer.bo.LoginInfo;
import com.dtyunxi.yundt.module.customer.bo.TokenInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * 登录服务
 *
 * @author wu.sheng
 * @time 2019年7月12日 上午10:09:23
 */
@Api(tags = {"用户组件：认证服务"})
@RestController
@RequestMapping("/v1/user")
public class AuthenticationRest {

    @Resource
    private IContext context;

    @Resource
    private IAuthentication authenticationImpl;

    @PostMapping("/token")
    @ApiOperation(value = "用户登录", notes = "登陆方式loginType：(0,手机号/用户名/邮箱 + 密码), (1,用户名+密码),(2,手机+密码),(3,手机+验证码),(4," +
            "邮箱+密码),(5,身份证+加密码),(6,用户名+加密码+验证码)")
    @ApiImplicitParam(paramType = "body", name = "loginInfo", dataType = "LoginInfo", required = true, value = "用户登录")
    RestResponse<TokenInfo> login(@Valid @RequestBody LoginInfo loginInfo) {
        return new RestResponse<>(authenticationImpl.login(loginInfo));
    }

    @PostMapping("/new/token")
    @ApiOperation(value = "用户登录", notes = "登陆方式loginType：(0,手机号/用户名/邮箱 + 密码), (1,用户名+密码),(2,手机+密码),(3,手机+验证码),(4," +
            "邮箱+密码),(5,身份证+加密码),(6,用户名+加密码+验证码)")
    @ApiImplicitParam(paramType = "body", name = "loginInfo", dataType = "LoginInfo", required = true, value = "用户登录")
    RestResponse<TokenInfo> newLogin(@Valid @RequestBody LoginInfo loginInfo) {
        return new RestResponse<>(authenticationImpl.newLogin(loginInfo));
    }

    @DeleteMapping("/logout/token")
    @ApiOperation(value = "注销")
    RestResponse<Void> logout() {
        authenticationImpl.logout(context.userId());
        return RestResponse.VOID;
    }

    @ApiOperation(value = "根据（用户名+原密码）修改密码")
    @ApiImplicitParam(paramType = "body", name = "modifyPasswordReqDto", dataType = "ModifyPasswordReqDto", required
            = true, value = "修改密码参数")
    @PutMapping("/password")
    RestResponse<Void> modifyPassword(@Valid @RequestBody ModifyPasswordReqDto modifyPasswordReqDto) {
        authenticationImpl.modifyPassword(modifyPasswordReqDto.getUserName(), modifyPasswordReqDto.getPassword(),
                modifyPasswordReqDto.getNewPassword());
        return RestResponse.VOID;
    }

    @ApiOperation(value = "根据(手机/邮箱+验证码)重置密码")
    @ApiImplicitParam(paramType = "body", name = "resetPasswordReqDto", dataType = "ResetPasswordReqDto", required =
            true, value = "修改密码参数")
    @PutMapping("/password/reset")
    RestResponse<Void> resetPassword(@Valid @RequestBody ResetPasswordReqDto resetPasswordReqDto) {
        authenticationImpl.resetPassword(resetPasswordReqDto);
        return RestResponse.VOID;
    }

    @ApiOperation(value = "根据用户id重置密码")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "path", name = "userId", dataType = "Long", required = true, value = "用户id"),
            @ApiImplicitParam(paramType = "query", name = "newPassword", dataType = "String", required = true, value
                    = "新密码")
    })
    @PutMapping("/{userId}/password/reset")
    RestResponse<Void> resetPassword(@PathVariable("userId") Long userId,
                                     @RequestParam("newPassword") String newPassword) {
        authenticationImpl.resetPassword(userId, newPassword);
        return RestResponse.VOID;
    }


    @ApiOperation(value = "手机号码绑定")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "path", name = "userId", dataType = "Long", required = true, value = "用户id"),
            @ApiImplicitParam(paramType = "query", name = "phone", dataType = "String", required = true, value = "手机号码")
    })
    @PutMapping("/{userId}/phone/bind")
    RestResponse<Void> bindPhone(@PathVariable("userId") Long userId, @RequestParam("phone") String phone) {
        authenticationImpl.bindPhone(userId, phone);
        return RestResponse.VOID;
    }

    @ApiOperation(value = "手机号码解绑")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "path", name = "userId", dataType = "Long", required = true, value = "用户id"),
            @ApiImplicitParam(paramType = "query", name = "phone", dataType = "String", required = true, value = "手机号码")
    })
    @PutMapping("/{userId}/phone/unbind")
    RestResponse<Void> unbindPhone(@PathVariable("userId") Long userId, @RequestParam("phone") String phone) {
        authenticationImpl.unbindPhone(userId, phone);
        return RestResponse.VOID;
    }
    @GetMapping("/tenant/guide")
    @ApiOperation(value = "租户指引")
    RestResponse<TenantGuideRespDto> tenantGuide() {
        return new RestResponse<>(authenticationImpl.tenantGuide(context.tenantId()));
    }

}
