package com.dtyunxi.yundt.module.customer.rest;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerDataApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportSaveReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.biz.mq.process.CustomerInfoImportProcessor;
import com.dtyunxi.yundt.module.customer.biz.mq.process.SupplierInfoImportProcessor;
import com.dtyunxi.yundt.module.customer.biz.mq.producer.CustomerImportProducer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 客商中心导入
 *
 * @author sumo on 2020/10/14 0014
 */
@Api(tags = {"客商组件：客商中心导入相关服务"})
@RestController
@RequestMapping("/v1/customer/data")
public class ICustomerDataRest {

    private static final Logger logger = LoggerFactory.getLogger(ICustomerDataRest.class);
    @Resource
    ICustomerDataApi customerDataApi;
    @Resource
    CustomerInfoImportProcessor customerInfoImportProcessor;
    @Resource
    SupplierInfoImportProcessor supplierInfoImportProcessor;
    @Resource
    CustomerImportProducer customerImportProducer;
    @Resource
    private IContext context;

    //todo:sumo 登录密码要处理好
    @PostMapping(value = "customer-import")
    @ApiOperation(value = "保存批量导入接口")
    public RestResponse<Void> customerImport(@RequestBody CustomerImportSaveReqDto customerImportSaveReqDto) {
        customerImportSaveReqDto.setOperator(context.userName());
        RestResponse<Long> longRestResponse = customerDataApi.saveCustomerInfoImport(customerImportSaveReqDto);
        Long aLong = RestResponseHelper.extractData(longRestResponse);
        logger.info("保存成功,开始通知1 = [" + customerImportSaveReqDto.toString() + "]instanceId:" + customerImportSaveReqDto.getInstanceId());
        customerImportSaveReqDto.setId(aLong);
        customerImportSaveReqDto.setInstanceId(null != ServiceContext.getContext().getRequestInstanceId() ? ServiceContext.getContext().getRequestInstanceId() : customerImportSaveReqDto.getInstanceId());
        customerImportSaveReqDto.setTenantId(null != ServiceContext.getContext().getRequestTenantId() ? ServiceContext.getContext().getRequestTenantId() : customerImportSaveReqDto.getTenantId());
        logger.info("保存成功,开始通知2 = [" + customerImportSaveReqDto.toString() + "]instanceId:" + customerImportSaveReqDto.getInstanceId());
        customerImportProducer.sendCustomerImportMq(customerImportSaveReqDto);
        return new RestResponse<>();
    }


    @PostMapping(value = "/test")
    @ApiOperation(value = "测试针对上传文档的处理逻辑,可参考以下导入数据", notes =
            "{\n" +
                    "  \"createPerson\": \"ssssss\",\n" +
                    "  \"extFields\": {},\n" +
                    "  \"extension\": \"string\",\n" +
                    "  \"fileName\": \"供应商导入表模v1.0.0\",\n" +
                    "  \"importType\": 1,\n" +
                    "  \"instanceId\": 1,\n" +
                    "  \"tenantId\": 1,\n" +
                    "  \"operator\": \"sumo\",\n" +
                    "  \"id\": 1255590515967578139,\n" +
            "  \"updatePerson\": \"string\",\n" +
            "  \"url\": \"https://yunxi-isales.oss-cn-shenzhen.aliyuncs.com/客户导入表模v1.0.2 - 真实数据.xlsx\"\n" +
            "}")
    public RestResponse<MessageResponse> test(@RequestBody CustomerImportSaveReqDto customerImportSaveReqDto) {
        customerImportSaveReqDto.setInstanceId(null != ServiceContext.getContext().getRequestInstanceId() ? ServiceContext.getContext().getRequestInstanceId() : customerImportSaveReqDto.getInstanceId());
        customerImportSaveReqDto.setTenantId(null != ServiceContext.getContext().getRequestTenantId() ? ServiceContext.getContext().getRequestTenantId() : customerImportSaveReqDto.getTenantId());
        if (ImportTypeEnum.fromCode(customerImportSaveReqDto.getImportType()) == ImportTypeEnum.CUSTOMER) {
            customerInfoImportProcessor.process(customerImportSaveReqDto);

        } else if (ImportTypeEnum.fromCode(customerImportSaveReqDto.getImportType()) == ImportTypeEnum.SUPPLIER) {
            supplierInfoImportProcessor.process(customerImportSaveReqDto);

        }
        return new RestResponse<MessageResponse>();
    }

}
