/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.inventory.biz.apiimpl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ExportTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.response.BaseImportRespDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ExportService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IWarehouseSupplyRelApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.BizImportRespDto;
import com.dtyunxi.yundt.cube.center.inventory.vo.DeliveryConfigVo;
import com.dtyunxi.yundt.module.inventory.biz.service.IWarehouseSupplyDetailExtService;
import com.dtyunxi.yundt.module.inventory.biz.util.BeanPropertyNullUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IWarehouseSupplyDetailExtServiceImpl
implements IWarehouseSupplyDetailExtService {
    private static final Logger log = LoggerFactory.getLogger(IWarehouseSupplyDetailExtServiceImpl.class);
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IWarehouseSupplyRelApi warehouseSupplyRelApi;
    @Resource
    private ExportService exportService;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public BizImportRespDto importCusetomerSupplyDetail(MultipartFile file) {
        BizImportRespDto bizImportDataReqDto = new BizImportRespDto();
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), DeliveryConfigVo.class, (ImportParams)importParams);
            List allFieldNullList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
            bizImportDataReqDto.setObjects(allFieldNullList);
        }
        catch (Exception var7) {
            Exception var6 = var7;
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        if (bizImportDataReqDto.getObjects().size() > 300) {
            throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7300\u6761");
        }
        bizImportDataReqDto.setOrgId(orgId);
        log.info("\u5bfc\u5165\u5ba2\u6237\u4f9b\u8d27\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)bizImportDataReqDto));
        RestResponse bizImportRespDtoRestResponse = this.warehouseSupplyRelApi.importWarehouseSupplyRel(bizImportDataReqDto);
        log.info("\u5bfc\u5165\u5ba2\u6237\u4f9b\u8d27\u660e\u7ec6\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)bizImportRespDtoRestResponse));
        return (BizImportRespDto)bizImportRespDtoRestResponse.getData();
    }

    @Override
    public Void importSplitWarehouse(MultipartFile file) {
        Long recordId = this.exportService.init(file.getOriginalFilename(), ExportTypeEnum.SPLIT_WAREHOUSE_CONFIG);
        log.info("\u4e0a\u4f20\u6587\u4ef6\u8def\u5f84: {}", (Object)file.getOriginalFilename());
        byte[] fileContent = null;
        try {
            fileContent = file.getBytes();
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25", (Throwable)e);
            return null;
        }
        byte[] finalFileContent = fileContent;
        log.info("finalFileContent: {}", (Object)finalFileContent);
        Long orgId = (Long)this.customerExtQueryApi.queryCurrentUserOrgId().getData();
        log.info("orgId={}", (Object)orgId);
        ((IWarehouseSupplyDetailExtService)this.applicationContext.getBean(IWarehouseSupplyDetailExtService.class)).importSplitWarehouseByExcelAsyn(finalFileContent, file.getOriginalFilename(), recordId, orgId);
        return null;
    }

    @Override
    public void importSplitWarehouseByExcelAsyn(byte[] fileContent, String originalFilename, Long recordId, Long orgId) {
        boolean isSuccess = false;
        BaseImportRespDto result = new BaseImportRespDto();
        try {
            result = this.importSplitWarehouseByExcelAsyn0(fileContent, originalFilename, orgId);
            log.info("importSplitWarehouseByExcelAsyn0 \u5bfc\u5165\u5206\u4ed3\u914d\u7f6e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)result));
            isSuccess = true;
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5bfc\u5165\u53d1\u8d27\u914d\u7f6e \u5931\u8d25 \u4efb\u52a1id:" + recordId);
            e.printStackTrace();
            this.exportService.fail(recordId, String.format("\u6587\u4ef6\u540d\uff1a%s , \u4efb\u52a1id\uff1a%s , \u5931\u8d25\u539f\u56e0\uff1a%s", originalFilename, recordId, e));
        }
        if (isSuccess) {
            this.exportService.success(recordId, result.getErrorFile(), String.format("\u603b\u8ba4\u8bc1\uff1a%s\u6761\uff0c\u6210\u529f\uff1a%s\u6761\uff0c\u5931\u8d25\uff1a%s\u6761", result.getNum(), result.getSuccessNum(), result.getFailNum()));
        }
    }

    public BaseImportRespDto importSplitWarehouseByExcelAsyn0(byte[] fileContent, String originalFilename, Long orgId) {
        BizImportRespDto<DeliveryConfigVo> bizImportDataReqDto;
        try {
            bizImportDataReqDto = this.getExcelData(fileContent, orgId);
        }
        catch (Exception e) {
            throw new com.dtyunxi.exceptions.BizException("\u89e3\u6790excel\u5f02\u5e38" + e);
        }
        if (bizImportDataReqDto.getObjects() == null || bizImportDataReqDto.getObjects().isEmpty()) {
            throw new com.dtyunxi.exceptions.BizException("\u89e3\u6790excel\u5931\u8d25 \u89e3\u6790\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (bizImportDataReqDto.getObjects().size() > 1000) {
            throw new com.dtyunxi.exceptions.BizException("\u89e3\u6790excel\u5931\u8d25 \u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u6761");
        }
        log.info("\u5bfc\u5165\u5ba2\u6237\u4f9b\u8d27\u660e\u7ec6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(bizImportDataReqDto));
        com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.BaseImportRespDto bizImportRespDtoRestResponse = (com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.BaseImportRespDto)this.warehouseSupplyRelApi.importSplitWarehouse(bizImportDataReqDto).getData();
        log.info("\u5bfc\u5165\u5ba2\u6237\u4f9b\u8d27\u660e\u7ec6\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)bizImportRespDtoRestResponse));
        String errorFile = null;
        if (CollectionUtils.isNotEmpty((Collection)bizImportRespDtoRestResponse.getErrorList())) {
            try {
                String fileName = ExportTypeEnum.SPLIT_WAREHOUSE_CONFIG.getName();
                if (StringUtils.isNotEmpty((CharSequence)originalFilename)) {
                    fileName = originalFilename.substring(0, originalFilename.lastIndexOf("."));
                }
                ArrayList excelTempDtos = new ArrayList(bizImportRespDtoRestResponse.getErrorList());
                errorFile = EasyPoiExportUtil.getExportUrl(excelTempDtos, DeliveryConfigVo.class, null, (String)("cube/" + fileName + "-\u5206\u4ed3\u914d\u7f6e\u5bfc\u5165\u5931\u8d25\u6587\u4ef6-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss")), (String)"xls");
                log.info("\u5bfc\u5165\u5206\u4ed3\u914d\u7f6e\u5931\u8d25\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)errorFile);
            }
            catch (Exception e) {
                throw new com.dtyunxi.exceptions.BizException("\u5904\u7406\u660e\u7ec6excel\u751f\u6210\u5931\u8d25\uff1a" + e);
            }
        }
        return BaseImportRespDto.builder().num(bizImportRespDtoRestResponse.getNum()).successNum(bizImportRespDtoRestResponse.getSuccessNum()).failNum(bizImportRespDtoRestResponse.getFailNum()).errorFile(errorFile).build();
    }

    private BizImportRespDto<DeliveryConfigVo> getExcelData(byte[] fileContent, Long orgId) {
        BizImportRespDto bizImportDataReqDto = new BizImportRespDto();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent);){
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)inputStream, DeliveryConfigVo.class, (ImportParams)importParams);
            log.info("ExcelImportResult: {}", (Object)JSONObject.toJSONString((Object)result.getList()));
            List allFieldNullList = BeanPropertyNullUtil.getAllFieldNullList(result.getList());
            bizImportDataReqDto.setObjects(allFieldNullList);
        }
        catch (Exception var7) {
            Exception var6 = var7;
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        bizImportDataReqDto.setOrgId(orgId);
        return bizImportDataReqDto;
    }
}

