/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IDirectoryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirItemRelativeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirTreeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectorySortUpdateDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.RootDirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirIndexRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.util.ConvertUtil;
import com.dtyunxi.yundt.module.item.api.ICategory;
import com.dtyunxi.yundt.module.item.biz.service.IItemCommonService;
import com.dtyunxi.yundt.module.item.bo.Category;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryImpl
implements ICategory {
    private static final Logger logger = LoggerFactory.getLogger(CategoryImpl.class);
    @Autowired
    private IDirectoryApi directoryApi;
    @Autowired
    private IDirectoryQueryApi directoryQueryApi;
    @Autowired
    private IItemApi itemApi;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Autowired
    private IContext context;
    @Resource
    private IItemCommonService itemCommonService;
    public final Integer SHOW_DISABLE = 1;

    public Long create(Category category) {
        if (StringUtils.isBlank((CharSequence)category.getName())) {
            throw new BusinessRuntimeException("\u76ee\u5f55\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (category.getParentId() == null) {
            category.setParentId(Long.valueOf(0L));
        }
        if (StringUtils.isBlank((CharSequence)category.getCode())) {
            category.setCode(this.buildCode());
        }
        this.judgeRepeat(category);
        JSONObject json = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)category.getAttrs())) {
            json.put("desc", (Object)category.getAttrs());
        }
        json.put("imgUrl", (Object)category.getImageUrl());
        category.setAttrs(json.toJSONString());
        Long dirId = null;
        if (category.getParentId() == 0L) {
            RootDirectoryReqDto rootDto = new RootDirectoryReqDto();
            CubeBeanUtils.copyProperties((Object)rootDto, (Object)category, (String[])new String[0]);
            Long userId = this.context.userId();
            rootDto.setOwnerId(userId);
            rootDto.setTenantId(this.context.tenantId());
            rootDto.setInstanceId(this.context.instanceId());
            dirId = (Long)RestResponseHelper.extractData((RestResponse)this.directoryApi.addRootDirectory(rootDto));
        } else {
            Long parentId = category.getParentId();
            switch (category.getDirUsage()) {
                case "back": {
                    Integer backDirMaxLevel = this.itemCommonService.getDirMaxLevel("backDirMaxLevel");
                    this.validDirLevelNum(backDirMaxLevel, parentId);
                    break;
                }
                case "front": {
                    Integer frontDirMaxLevel = this.itemCommonService.getDirMaxLevel("frontDirMaxLevel");
                    this.validDirLevelNum(frontDirMaxLevel, parentId);
                    break;
                }
                case "shop": {
                    Integer shopDirMaxLevel = this.itemCommonService.getDirMaxLevel("shopDirMaxLevel");
                    this.validDirLevelNum(shopDirMaxLevel, parentId);
                    break;
                }
            }
            DirectoryReqDto directoryReqDto = new DirectoryReqDto();
            CubeBeanUtils.copyProperties((Object)directoryReqDto, (Object)category, (String[])new String[0]);
            directoryReqDto.setTenantId(this.context.tenantId());
            directoryReqDto.setInstanceId(this.context.instanceId());
            dirId = (Long)RestResponseHelper.extractData((RestResponse)this.directoryApi.addDirectory(directoryReqDto));
        }
        return dirId;
    }

    private void validDirLevelNum(int levelNum, Long parentId) {
        boolean flag = true;
        for (int i = 0; i < levelNum; ++i) {
            String reqParam = "{\"id\":" + parentId + "}";
            List dirRespDtos = (List)this.directoryQueryApi.queryDirectoryItem(reqParam).getData();
            if (!CollectionUtils.isNotEmpty((Collection)dirRespDtos) || (parentId = ((DirectoryItemRespDto)dirRespDtos.get(0)).getParentId()) != 0L) continue;
            flag = false;
            break;
        }
        if (flag) {
            throw new BizException("\u65b0\u589e\u5931\u8d25\uff0c\u76ee\u5f55\u5c42\u7ea7\u4e0d\u80fd\u8d85\u8fc7" + levelNum + "\u7ea7");
        }
    }

    public void judgeRepeat(Category category) {
        block13: {
            String filters;
            block11: {
                List data;
                block12: {
                    filters = "";
                    if (!Objects.equals(category.getParentId(), 0L)) break block11;
                    RootDirectoryReqDto query = new RootDirectoryReqDto();
                    query.setName(category.getName());
                    query.setDirUsage(category.getDirUsage());
                    query.setInstanceId(this.context.instanceId());
                    query.setTenantId(this.context.tenantId());
                    query.setShopId(category.getShopId());
                    filters = JSONObject.toJSONString((Object)query);
                    data = (List)this.directoryQueryApi.queryDirTreeDetail(filters).getData();
                    if (CollectionUtils.isNotEmpty((Collection)data)) {
                        Iterator it = data.iterator();
                        while (it.hasNext()) {
                            TreeDto treeDto = (TreeDto)it.next();
                            if (Objects.equals(((DirIndexRespDto)treeDto.getNode()).getName(), category.getName())) continue;
                            it.remove();
                        }
                    }
                    if (category.getId() != null) break block12;
                    if (CollectionUtils.isNotEmpty((Collection)data)) {
                        throw new BizException("\u8be5\u76ee\u5f55\u540d\u79f0\u5df2\u5b58\u5728");
                    }
                    break block13;
                }
                if (!CollectionUtils.isNotEmpty((Collection)data)) break block13;
                for (TreeDto dto2 : data) {
                    if (!Objects.equals(((DirIndexRespDto)dto2.getNode()).getName(), category.getName()) || ((DirIndexRespDto)dto2.getNode()).getId().equals(category.getId())) continue;
                    throw new BizException("\u8be5\u76ee\u5f55\u540d\u79f0\u5df2\u5b58\u5728");
                }
                break block13;
            }
            DirectoryReqDto dto = new DirectoryReqDto();
            dto.setName(category.getName());
            dto.setInstanceId(this.context.instanceId());
            dto.setTenantId(this.context.tenantId());
            dto.setParentId(category.getParentId());
            filters = JSONObject.toJSONString((Object)dto);
            List list = (List)this.directoryQueryApi.queryDirectoryItem(filters).getData();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    DirectoryItemRespDto respDto = (DirectoryItemRespDto)it.next();
                    if (Objects.equals(respDto.getName(), category.getName())) continue;
                    it.remove();
                }
            }
            if (category.getId() == null) {
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    throw new BizException("\u8be5\u76ee\u5f55\u540d\u79f0\u5df2\u5b58\u5728");
                }
            } else if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (DirectoryItemRespDto dto2 : list) {
                    if (!Objects.equals(dto2.getName(), category.getName()) || dto2.getId().equals(category.getId())) continue;
                    throw new BizException("\u8be5\u76ee\u5f55\u540d\u79f0\u5df2\u5b58\u5728");
                }
            }
        }
    }

    private String buildCode() {
        return "D" + System.currentTimeMillis();
    }

    public void modify(Category category) {
        if (category.getId() == null) {
            throw new BusinessRuntimeException("\u53c2\u6570\u5f02\u5e38,\u76ee\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.judgeRepeat(category);
        JSONObject json = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)category.getAttrs())) {
            json.put("desc", (Object)category.getAttrs());
        }
        json.put("imgUrl", (Object)category.getImageUrl());
        category.setAttrs(json.toJSONString());
        try {
            DirectoryReqDto directoryReqDto = new DirectoryReqDto();
            CubeBeanUtils.copyProperties((Object)directoryReqDto, (Object)category, (String[])new String[0]);
            directoryReqDto.setOwnerId(this.context.userId());
            directoryReqDto.setTenantId(this.context.tenantId());
            directoryReqDto.setInstanceId(this.context.instanceId());
            this.directoryApi.modifyDirectory(directoryReqDto).getData();
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u76ee\u5f55\u5931\u8d25");
            throw new BusinessRuntimeException("\u4fee\u6539\u76ee\u5f55\u5931\u8d25");
        }
    }

    public RestResponse<Void> remove(Long categoryId) {
        ArrayList list = Lists.newArrayList();
        this.getChild(list, Lists.newArrayList((Object[])new Long[]{categoryId}));
        List<Long> dirIds = list.stream().map(DirectoryItemRespDto::getId).collect(Collectors.toList());
        dirIds.add(categoryId);
        if (this.existItem(dirIds)) {
            throw new BizException("\u8be5\u7c7b\u76ee\u4e0b\u5b58\u5728\u4e0a\u67b6\u7684\u5546\u54c1\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        for (Long dirId : dirIds) {
            RestResponse restResponse = this.directoryApi.removeDirectory(dirId);
            if ("0".equals(restResponse.getResultCode())) continue;
            return restResponse;
        }
        return new RestResponse();
    }

    private void getChild(List<DirectoryItemRespDto> list, List<Long> dirIds) {
        if (CollectionUtils.isEmpty(dirIds)) {
            return;
        }
        for (Long dirId : dirIds) {
            DirectoryReqDto query = new DirectoryReqDto();
            query.setParentId(dirId);
            List childList = (List)this.directoryQueryApi.queryDirectoryItem(JSONObject.toJSONString((Object)query)).getData();
            if (!CollectionUtils.isNotEmpty((Collection)childList)) continue;
            list.addAll(childList);
            dirIds = childList.stream().map(DirectoryItemRespDto::getId).collect(Collectors.toList());
            this.getChild(list, dirIds);
        }
    }

    private boolean existItem(List<Long> dirIds) {
        DirItemRelativeReqDto relativeReqDto = new DirItemRelativeReqDto();
        relativeReqDto.setDirIds(dirIds);
        List dirItems = (List)this.itemQueryApi.queryItemDirRelative(JSON.toJSONString((Object)relativeReqDto)).getData();
        return CollectionUtils.isNotEmpty((Collection)dirItems);
    }

    public List<Category> queryTree(String dirUsage) {
        RootDirectoryReqDto rootDirectoryReqDto = new RootDirectoryReqDto();
        rootDirectoryReqDto.setDirUsage(dirUsage);
        rootDirectoryReqDto.setInstanceId(this.context.instanceId());
        rootDirectoryReqDto.setTenantId(this.context.tenantId());
        String filter = ObjectHelper.bean2Json((Object)rootDirectoryReqDto);
        List treeList = (List)this.directoryQueryApi.queryDirectoryTreeByFilter(filter).getData();
        if (CollectionUtils.isEmpty((Collection)treeList)) {
            return null;
        }
        ArrayList dirList = Lists.newArrayList();
        this.tree2List(dirList, treeList);
        List<Category> categoryList = dirList.stream().map(dirDto -> (Category)ConvertUtil.convert((Object)dirDto, Category.class)).collect(Collectors.toList());
        return this.toTree(categoryList);
    }

    public Map<String, Object> queryList(RootDirectoryReqDto rootDirectoryReqDto, Integer showDisable) {
        List result;
        HashMap resultMap = Maps.newHashMap();
        if ("front".equals(rootDirectoryReqDto.getDirUsage())) {
            DirTreeReqDto dirTreeReqDto = new DirTreeReqDto();
            dirTreeReqDto.setInstanceId(this.context.instanceId());
            dirTreeReqDto.setTenantId(this.context.tenantId());
            dirTreeReqDto.setDirUsage(rootDirectoryReqDto.getDirUsage());
            result = (List)this.directoryQueryApi.queryDirTree(dirTreeReqDto).getData();
        } else {
            rootDirectoryReqDto.setInstanceId(this.context.instanceId());
            rootDirectoryReqDto.setTenantId(this.context.tenantId());
            String filters = JSONObject.toJSONString((Object)rootDirectoryReqDto);
            result = (List)this.directoryQueryApi.queryDirectoryTreeByFilter(filters).getData();
        }
        if (null == result) {
            resultMap.put("dirUsage", rootDirectoryReqDto.getDirUsage());
            resultMap.put("tree", null);
            return resultMap;
        }
        if (!this.SHOW_DISABLE.equals(showDisable)) {
            this.filterDisable(result);
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            this.setLevel(result);
        }
        resultMap.put("dirUsage", rootDirectoryReqDto.getDirUsage());
        resultMap.put("tree", result);
        return resultMap;
    }

    void filterDisable(List<TreeDto<DirectoryItemRespDto>> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return;
        }
        Iterator<TreeDto<DirectoryItemRespDto>> iterator = sourceList.iterator();
        while (iterator.hasNext()) {
            TreeDto<DirectoryItemRespDto> itemRespDto = iterator.next();
            if (itemRespDto.getNode() == null || ((DirectoryItemRespDto)itemRespDto.getNode()).getStatus() == null || !((DirectoryItemRespDto)itemRespDto.getNode()).getStatus().equals(StatusEnum.DISABLED.getStatus())) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty(sourceList)) {
            return;
        }
        for (TreeDto<DirectoryItemRespDto> dirTreeDto : sourceList) {
            this.filterDisable(dirTreeDto.getChildren());
        }
    }

    public void setLevel(List<TreeDto<DirectoryItemRespDto>> sourceList) {
        for (TreeDto<DirectoryItemRespDto> dirTreeDto : sourceList) {
            int i = 1;
            ((DirectoryItemRespDto)dirTreeDto.getNode()).setExtension(String.valueOf(i));
            if (dirTreeDto.getChildren() == null) continue;
            for (TreeDto childTreeDto : dirTreeDto.getChildren()) {
                i = 2;
                ((DirectoryItemRespDto)childTreeDto.getNode()).setExtension(String.valueOf(i));
                if (childTreeDto.getChildren() == null) continue;
                i = 3;
                for (TreeDto grandTreeDto : childTreeDto.getChildren()) {
                    ((DirectoryItemRespDto)grandTreeDto.getNode()).setExtension(String.valueOf(i));
                }
            }
        }
    }

    private void tree2List(List<DirectoryItemRespDto> dirList, List<TreeDto<DirectoryItemRespDto>> treeList) {
        for (TreeDto<DirectoryItemRespDto> treeDto : treeList) {
            dirList.add((DirectoryItemRespDto)treeDto.getNode());
            if (null == treeDto.getChildren()) continue;
            this.tree2List(dirList, treeDto.getChildren());
        }
    }

    private List<Category> toTree(List<Category> categoryList) {
        ArrayList treeList = Lists.newArrayList();
        for (Category tree : categoryList) {
            if (!tree.getParentId().equals(0L)) continue;
            treeList.add(tree);
        }
        for (Category tree : categoryList) {
            this.toTreeChildren(treeList, tree);
        }
        return treeList;
    }

    private void toTreeChildren(List<Category> treeList, Category tree) {
        for (Category node : treeList) {
            if (tree.getParentId().equals(node.getId())) {
                if (node.getChildren() == null) {
                    node.setChildren((List)Lists.newArrayList());
                }
                node.getChildren().add(tree);
            }
            if (node.getChildren() == null) continue;
            this.toTreeChildren(node.getChildren(), tree);
        }
    }

    public Category getById(Long categoryId) {
        Category category = null;
        DirectoryItemRespDto directoryItemRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(categoryId).getData();
        if (null != directoryItemRespDto) {
            category = (Category)ConvertUtil.convert((Object)directoryItemRespDto, Category.class);
            if (category.getParentId() == 0L) {
                category.setParentName("\u6839\u5143\u7d20");
            } else {
                directoryItemRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(category.getParentId()).getData();
                if (directoryItemRespDto != null) {
                    category.setParentName(directoryItemRespDto.getName());
                }
            }
        }
        return category;
    }

    public List<Long> selectBackNameById(Long categoryId) {
        return this.directoryQueryApi.selectBackNameById(categoryId);
    }

    public void sortDirectory(Long categoryId, String sortType) {
        DirectorySortUpdateDto directorySortUpdateDto = new DirectorySortUpdateDto();
        directorySortUpdateDto.setSortType(sortType);
        directorySortUpdateDto.setTenantId(this.context.tenantId());
        directorySortUpdateDto.setInstanceId(this.context.instanceId());
        this.directoryApi.compatSortDirectory(categoryId, directorySortUpdateDto);
    }

    public Map<Long, String> getDirParent(Long dirId) {
        DirectoryItemRespDto directoryRespDto;
        Long reqParam = dirId;
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        Long parentId = -1L;
        while (parentId != null && parentId != 0L && (parentId = (directoryRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(reqParam).getData()).getParentId()) != 0L) {
            resultMap.put(directoryRespDto.getId(), directoryRespDto.getName());
            reqParam = parentId;
        }
        return resultMap;
    }

    public List<Long> getDirListParent(Long dirId) {
        ArrayList<Long> dirIdList = new ArrayList<Long>();
        Map<Long, String> dirMap = this.getDirParent(dirId);
        for (Map.Entry<Long, String> entry : dirMap.entrySet()) {
            dirIdList.add(entry.getKey());
        }
        Collections.reverse(dirIdList);
        return dirIdList;
    }

    public Map<String, Object> getFront(RootDirectoryReqDto rootDirectoryReqDto, Integer showDisable, Long id) {
        HashMap resultMap = Maps.newHashMap();
        rootDirectoryReqDto.setInstanceId(this.context.instanceId());
        rootDirectoryReqDto.setTenantId(this.context.tenantId());
        String filters = JSONObject.toJSONString((Object)rootDirectoryReqDto);
        List result = (List)this.directoryQueryApi.queryDirectoryTreeById(id, rootDirectoryReqDto.getDirUsage(), rootDirectoryReqDto.getShopId()).getData();
        if (null == result) {
            resultMap.put("dirUsage", rootDirectoryReqDto.getDirUsage());
            resultMap.put("tree", null);
            return resultMap;
        }
        if (!this.SHOW_DISABLE.equals(showDisable)) {
            this.filterDisable(result);
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            this.setLevel(result);
        }
        resultMap.put("dirUsage", rootDirectoryReqDto.getDirUsage());
        resultMap.put("tree", result);
        return resultMap;
    }
}

