/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.interceptor;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.LoggerFactory;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={RequestInterceptor.class})
@Configuration
public class ApiRequestInterceptor
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ApiRequestInterceptor.class);

    public void apply(RequestTemplate requestTemplate) {
        String sceneCode = ServiceContext.getContext().getAttachment("sceneCode");
        if (StringUtils.isNotEmpty((CharSequence)sceneCode)) {
            try {
                String param = URLEncoder.encode(sceneCode, "UTF-8");
                requestTemplate.header("sceneCode", new String[]{param});
                logger.info("set header param:{}, value:true", (Object)sceneCode);
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("\u8bbe\u7f6e\u8bf7\u6c42\u5934\u65f6\u8f6c\u6362\u4e2d\u6587\u5f02\u5e38\uff1a{}", (Object)sceneCode);
            }
        }
    }
}

