/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.handler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemChangeApplyApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemChangeApplyStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ChangeApplyAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.AuditResultRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.item.api.IItem;
import com.dtyunxi.yundt.module.item.api.IItemService;
import com.dtyunxi.yundt.module.item.api.enums.ItemEventCodeEnum;
import com.dtyunxi.yundt.module.item.api.enums.ItemLibTypeEnum;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import com.dtyunxi.yundt.module.item.biz.extension.itempublishchannel.IItemPublishChannel;
import com.dtyunxi.yundt.module.item.biz.service.IItemCommonService;
import com.dtyunxi.yundt.module.item.biz.service.IItemValidateRule;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="modifyHandler")
public class ModifyHandler
implements IServiceHandler,
IItemValidateRule {
    private static final Logger logger = LoggerFactory.getLogger(ModifyHandler.class);
    @Resource
    private IContext context;
    @Resource
    private IItemChangeApplyApi iItemChangeApplyApi;
    @Resource
    private IItemCommonService itemCommonService;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItem iItem;
    @Resource
    private IItemService itemService;

    public Object handle(ServiceEvent<?> serviceEvent) {
        IItemPublishChannel iItemPublishChannel;
        logger.info("======>\u4fee\u6539\u5546\u54c1");
        ItemChangeApplyDto itemChangeApplyDto = (ItemChangeApplyDto)serviceEvent.getData();
        Long itemId = (long)itemChangeApplyDto.getItemId();
        boolean attended = this.isAttended(itemId);
        if (attended) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.NOT_MODIFY);
        }
        RestResponse itemDetailRespDtoRestResponse = this.itemQueryApi.queryItemDetail(Long.valueOf(itemChangeApplyDto.getItemId()), "sku", null);
        ItemDetailRespDto oldItemDetail = (ItemDetailRespDto)RestResponseHelper.extractData((RestResponse)itemDetailRespDtoRestResponse);
        if (ItemStatus.ITEM_ONSHELF.getStatus().equals(oldItemDetail.getItem().getStatus())) {
            ServiceEvent offshelfEvent = new ServiceEvent(ItemEventCodeEnum.OFF_SHELF.getCode(), ItemEventCodeEnum.OFF_SHELF.getName(), (Object)String.valueOf(oldItemDetail.getItem().getId()));
            this.itemService.doService(offshelfEvent);
        }
        if (Objects.isNull(itemChangeApplyDto)) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.INVALID_PARAM);
        }
        if (null == (iItemPublishChannel = this.itemCommonService.getItemPublishChannel(JSON.parseObject((String)itemChangeApplyDto.getAttrs()).getString("publishChannel")))) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.INVALID_ITEM_PUBLISH_CHANNEL);
        }
        Long instanceId = oldItemDetail.getItem().getInstanceId();
        Long tenantId = oldItemDetail.getItem().getTenantId();
        Long userId = oldItemDetail.getItem().getOwnerId();
        Long sellerId = oldItemDetail.getItem().getSellerId();
        ItemChangeApplyReqDto itemChangeApplyReqDto = new ItemChangeApplyReqDto();
        CubeBeanUtils.copyProperties((Object)itemChangeApplyReqDto, (Object)itemChangeApplyDto, (String[])new String[0]);
        itemChangeApplyReqDto.setItemId(itemChangeApplyDto.getItemId());
        itemChangeApplyReqDto.setType(itemChangeApplyDto.getType());
        itemChangeApplyReqDto.setInstanceId(instanceId);
        itemChangeApplyReqDto.setTenantId(tenantId);
        itemChangeApplyReqDto.setSellerId(sellerId);
        itemChangeApplyReqDto.setOwnerId(userId);
        itemChangeApplyReqDto.setStatus(ItemChangeApplyStatus.DRAFT.getStatus());
        if (ItemLibTypeEnum.VIRTUAL_ITEM.getType().equals(itemChangeApplyReqDto.getType())) {
            itemChangeApplyDto.setVirtual(Boolean.valueOf(true));
        } else {
            itemChangeApplyDto.setVirtual(Boolean.valueOf(false));
        }
        itemChangeApplyReqDto.setItemChangeApplyDto(itemChangeApplyDto);
        RestResponse addResponse = this.iItemChangeApplyApi.add(itemChangeApplyReqDto);
        Long applyId = (Long)RestResponseHelper.extractData((RestResponse)addResponse);
        RestResponse commitResponse = this.iItemChangeApplyApi.commit(applyId);
        RestResponseHelper.extractData((RestResponse)commitResponse);
        ChangeApplyAuditReqDto changeApplyAuditReqDto = new ChangeApplyAuditReqDto();
        changeApplyAuditReqDto.setChangeApplyId(applyId);
        changeApplyAuditReqDto.setStatus(ItemChangeApplyStatus.AUDIT_SUCCESS.getStatus());
        changeApplyAuditReqDto.setTenantId(this.context.tenantId());
        changeApplyAuditReqDto.setInstanceId(this.context.instanceId());
        RestResponse auditResponse = this.iItemChangeApplyApi.audit(changeApplyAuditReqDto);
        AuditResultRespDto auditResultRespDto = (AuditResultRespDto)RestResponseHelper.extractData((RestResponse)auditResponse);
        ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)this.itemQueryApi.queryItemDetail(Long.valueOf(auditResultRespDto.getItemId()), "sku", null).getData();
        this.iItem.modifyItemVirStorage(auditResultRespDto.getItemId(), oldItemDetail, itemDetailRespDto);
        if (ItemStatus.ITEM_ONSHELF.getStatus().equals(oldItemDetail.getItem().getStatus())) {
            ServiceEvent onShelfEvent = new ServiceEvent(ItemEventCodeEnum.ON_SHELF.getCode(), ItemEventCodeEnum.ON_SHELF.getName(), (Object)String.valueOf(auditResultRespDto.getItemId()));
            this.itemService.doService(onShelfEvent);
        }
        return null;
    }
}

