/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.IBrandApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.util.ConvertUtil;
import com.dtyunxi.yundt.module.item.api.IBrand;
import com.dtyunxi.yundt.module.item.bo.Brand;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrandImpl
implements IBrand {
    @Autowired
    private IContext context;
    @Autowired
    private IBrandApi brandApi;
    @Autowired
    private IBrandQueryApi brandQueryApi;

    public Long create(Brand brand) {
        TagReqDto.BrandReqDto brandReqDto = (TagReqDto.BrandReqDto)ConvertUtil.convert((Object)brand, TagReqDto.BrandReqDto.class);
        if (StringUtils.isBlank((CharSequence)brand.getCode())) {
            String code = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
            brandReqDto.setCode(code);
        }
        if (brandReqDto.getStatus() == null) {
            brandReqDto.setStatus(StatusEnum.ENABLED.getStatus());
        }
        brandReqDto.setTenantId(this.context.tenantId());
        brandReqDto.setInstanceId(this.context.instanceId());
        RestResponse restResponse = this.brandApi.addBrand(brandReqDto);
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        return (Long)restResponse.getData();
    }

    public Long modify(Brand brand) {
        TagReqDto.BrandReqDto brandReqDto = (TagReqDto.BrandReqDto)ConvertUtil.convert((Object)brand, TagReqDto.BrandReqDto.class);
        BrandRespDto dto = (BrandRespDto)this.brandQueryApi.queryById(brandReqDto.getId()).getData();
        if (dto == null) {
            throw new BizException("\u4fee\u6539\u7684\u54c1\u724c\u4e0d\u5b58\u5728");
        }
        brandReqDto.setCode(dto.getCode());
        brandReqDto.setTenantId(this.context.tenantId());
        brandReqDto.setInstanceId(this.context.instanceId());
        RestResponseHelper.checkOrThrow((RestResponse)this.brandApi.modifyBrand(brandReqDto));
        return brandReqDto.getId();
    }

    public RestResponse<Void> remove(String brandIds) {
        return this.brandApi.removeById(brandIds);
    }

    public PageInfo<Brand> query(Brand brand, Integer pageNum, Integer pageSize) {
        JSONObject filter = JSONObject.parseObject((String)JSON.toJSONString((Object)brand));
        filter.put("tenantId", (Object)this.context.tenantId());
        filter.put("instanceId", (Object)this.context.instanceId());
        ArrayList brandList = new ArrayList();
        PageInfo pageInfo = (PageInfo)this.brandQueryApi.queryByPage(filter.toJSONString(), pageNum, pageSize).getData();
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            CubeBeanUtils.copyCollection(brandList, (Collection)pageInfo.getList(), Brand.class);
            pageInfo.setList(brandList);
        }
        return pageInfo;
    }

    public Brand getById(Long brandId) {
        RestResponse restResponse = this.brandQueryApi.queryById(brandId);
        if (!"0".equals(restResponse.getResultCode())) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        Brand brand = (Brand)ConvertUtil.convert((Object)restResponse.getData(), Brand.class);
        return brand;
    }

    public List<Brand> getList() {
        ArrayList<Brand> brandList = new ArrayList<Brand>();
        JSONObject filter = new JSONObject();
        filter.put("tenantId", (Object)this.context.tenantId());
        filter.put("instanceId", (Object)this.context.instanceId());
        filter.put("status", (Object)1);
        PageInfo pageInfo = (PageInfo)this.brandQueryApi.queryByPage(filter.toJSONString(), Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (pageInfo != null && pageInfo.getTotal() > 0L) {
            int count = (int)(pageInfo.getTotal() / 100L + 1L);
            for (int pageNum = 1; pageNum <= count; ++pageNum) {
                PageInfo page = (PageInfo)this.brandQueryApi.queryByPage(filter.toJSONString(), Integer.valueOf(pageNum), Integer.valueOf(100)).getData();
                if (page == null || !CollectionUtils.isNotEmpty((Collection)page.getList())) continue;
                Brand brand = null;
                for (BrandRespDto brandDto : page.getList()) {
                    brand = new Brand();
                    CubeBeanUtils.copyProperties((Object)brand, (Object)brandDto, (String[])new String[0]);
                    brandList.add(brand);
                }
            }
        }
        return brandList;
    }
}

