/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl;

import com.dtyunxi.cube.framework.services.IServiceHandler;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.yundt.module.item.api.IItemService;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import com.dtyunxi.yundt.module.item.biz.handler.OffShelfHandler;
import com.dtyunxi.yundt.module.item.biz.handler.OnShelfHandler;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IItemServiceImpl
implements IItemService {
    private static final Logger logger = LoggerFactory.getLogger(IItemServiceImpl.class);
    @Resource
    private Map<String, IServiceHandler> serviceHandlerMap;
    @Resource
    private OnShelfHandler onShelfHandler;
    @Resource
    private OffShelfHandler offShelfHandler;

    public Object doService(ServiceEvent<?> serviceEvent) {
        Object handleResult = null;
        IServiceHandler handler = this.serviceHandlerMap.get(serviceEvent.getName());
        if (null == handler) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.EVENT_NOT_HAVE_HANDLER);
        }
        handleResult = handler.handle(serviceEvent);
        return handleResult;
    }

    public void onShelf(ServiceEvent<?> serviceEvent) {
        this.onShelfHandler.handle(serviceEvent);
    }

    public void offShelf(ServiceEvent<?> serviceEvent) {
        this.offShelfHandler.handle(serviceEvent);
    }

    public Object preHandle(ServiceEvent<?> serviceEvent, Object ... objects) {
        return null;
    }

    public Object postHandle(ServiceEvent<?> serviceEvent, Object ... objects) {
        return null;
    }
}

