/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemChangeApplyApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemChangeApplyStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ChangeApplyAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemModifyStatusReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPublishReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.AuditResultRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemChangeApplyQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemVersionQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.constant.UserConstant;
import com.dtyunxi.yundt.module.item.api.IItemService;
import com.dtyunxi.yundt.module.item.api.IProduct;
import com.dtyunxi.yundt.module.item.api.dto.ProductInfoDto;
import com.dtyunxi.yundt.module.item.api.dto.request.ProductQueryDto;
import com.dtyunxi.yundt.module.item.api.enums.ItemEventCodeEnum;
import com.dtyunxi.yundt.module.item.api.enums.ItemLibTypeEnum;
import com.dtyunxi.yundt.module.item.biz.service.IItemCommonService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductImpl
implements IProduct {
    private static final Logger logger = LoggerFactory.getLogger(ProductImpl.class);
    @Autowired
    private IContext context;
    @Autowired
    private IItemApi itemApi;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Autowired
    private IItemCommonService commonService;
    @Autowired
    private IItemChangeApplyApi itemChangeApplyApi;
    @Autowired
    private IDirectoryQueryApi directoryQueryApi;
    @Autowired
    private IBrandQueryApi brandQueryApi;
    @Resource
    private IItemChangeApplyQueryApi itemChangeApplyQueryApi;
    @Resource
    private IItemVersionQueryApi itemVersionQueryApi;
    @Resource
    private IItemService itemService;

    private ItemChangeApplyReqDto getChangeApply(ProductInfoDto productInfoDto, boolean isModify) {
        Long sellerId = null;
        Integer roleType = this.commonService.getRoleType();
        if (UserConstant.MERCHANT.equals(roleType)) {
            sellerId = this.commonService.getSellerId();
        }
        ItemChangeApplyDto itemChangeApplyDto = new ItemChangeApplyDto();
        CubeBeanUtils.copyProperties((Object)itemChangeApplyDto, (Object)productInfoDto, (String[])new String[0]);
        itemChangeApplyDto.setInstanceId(this.context.instanceId());
        itemChangeApplyDto.setTenantId(this.context.tenantId());
        Long userId = this.context.userId();
        itemChangeApplyDto.setOwnerId(userId);
        if (isModify) {
            itemChangeApplyDto.setItemId(productInfoDto.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)productInfoDto.getImgUrlList())) {
            List collect = productInfoDto.getImgUrlList().stream().map(url -> {
                ItemMediasReqDto itemMediasReqDto = new ItemMediasReqDto();
                itemMediasReqDto.setFileType(Integer.valueOf(2));
                itemMediasReqDto.setPath1(url);
                return itemMediasReqDto;
            }).collect(Collectors.toList());
            itemChangeApplyDto.setMedias(collect);
        }
        JSONObject attrs = new JSONObject();
        attrs.put("propList", (Object)productInfoDto.getPropList());
        attrs.put("backDirList", (Object)productInfoDto.getBackDirList());
        itemChangeApplyDto.setAttrs(attrs.toJSONString());
        itemChangeApplyDto.setDisplayName(productInfoDto.getItemName());
        itemChangeApplyDto.setInstanceId(this.context.instanceId());
        itemChangeApplyDto.setTenantId(this.context.tenantId());
        itemChangeApplyDto.setSellerId(sellerId);
        itemChangeApplyDto.setType(ItemLibTypeEnum.PRODUCT.getType());
        itemChangeApplyDto.setItemId(productInfoDto.getId());
        itemChangeApplyDto.setDirId((Long)productInfoDto.getBackDirList().get(productInfoDto.getBackDirList().size() - 1));
        ItemChangeApplyReqDto itemChangeApplyReqDto = new ItemChangeApplyReqDto();
        CubeBeanUtils.copyProperties((Object)itemChangeApplyReqDto, (Object)productInfoDto, (String[])new String[0]);
        itemChangeApplyReqDto.setItemChangeApplyDto(itemChangeApplyDto);
        itemChangeApplyReqDto.setOwnerId(userId);
        itemChangeApplyReqDto.setInstanceId(this.context.instanceId());
        itemChangeApplyReqDto.setTenantId(this.context.tenantId());
        itemChangeApplyReqDto.setSellerId(sellerId);
        itemChangeApplyReqDto.setType(ItemLibTypeEnum.PRODUCT.getType());
        itemChangeApplyReqDto.setStatus(ItemChangeApplyStatus.DRAFT.getStatus());
        itemChangeApplyReqDto.setDirId((Long)productInfoDto.getBackDirList().get(productInfoDto.getBackDirList().size() - 1));
        return itemChangeApplyReqDto;
    }

    private AuditResultRespDto autoAuditSuccess(Long id, ItemChangeApplyReqDto changeApply) {
        ChangeApplyAuditReqDto changeApplyAuditReqDto = new ChangeApplyAuditReqDto();
        changeApplyAuditReqDto.setChangeApplyId(id);
        changeApplyAuditReqDto.setItemCode(changeApply.getItemCode());
        changeApplyAuditReqDto.setAuditDesc("\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        changeApplyAuditReqDto.setInstanceId(this.context.instanceId());
        changeApplyAuditReqDto.setTenantId(this.context.tenantId());
        changeApplyAuditReqDto.setAuditPerson(this.context.userId());
        changeApplyAuditReqDto.setStatus(ItemChangeApplyStatus.AUDIT_SUCCESS.getStatus());
        RestResponse audit = this.itemChangeApplyApi.audit(changeApplyAuditReqDto);
        AuditResultRespDto auditResultRespDto = (AuditResultRespDto)RestResponseHelper.extractData((RestResponse)audit);
        return auditResultRespDto;
    }

    public Long create(ProductInfoDto productInfoDto) {
        ItemChangeApplyReqDto changeApply = this.getChangeApply(productInfoDto, false);
        RestResponse restResponse = this.itemChangeApplyApi.add(changeApply);
        Long id = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        RestResponse commit = this.itemChangeApplyApi.commit(id);
        RestResponseHelper.checkOrThrow((RestResponse)commit);
        AuditResultRespDto auditResultRespDto = this.autoAuditSuccess(id, changeApply);
        return auditResultRespDto.getItemId();
    }

    public Long modify(ProductInfoDto productInfoDto) {
        ItemChangeApplyReqDto changeApply = this.getChangeApply(productInfoDto, true);
        RestResponse restResponse = this.itemChangeApplyApi.add(changeApply);
        Long id = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        RestResponse commit = this.itemChangeApplyApi.commit(id);
        RestResponseHelper.checkOrThrow((RestResponse)commit);
        AuditResultRespDto auditResultRespDto = this.autoAuditSuccess(id, changeApply);
        Boolean modifyItem = true;
        if (modifyItem.booleanValue()) {
            this.batchModifyItem(productInfoDto);
        }
        return auditResultRespDto.getItemId();
    }

    public void publish(String ids) {
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] split;
            for (String id : split = ids.split(",")) {
                ItemPublishReqDto itemPubishReqDto = new ItemPublishReqDto();
                itemPubishReqDto.setItemId(Long.valueOf(id));
                this.itemApi.publish(itemPubishReqDto);
            }
        }
    }

    public void updateStatus(String ids, Integer status) {
        ItemModifyStatusReqDto itemModifyStatusReqDto = new ItemModifyStatusReqDto();
        ArrayList<Long> idList = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] split;
            for (String id : split = ids.split(",")) {
                idList.add(Long.valueOf(id));
            }
        }
        itemModifyStatusReqDto.setIds(idList);
        itemModifyStatusReqDto.setStatus(status);
        this.itemApi.batchModifyItemStatus(itemModifyStatusReqDto);
    }

    public ProductInfoDto getDetail(Long id) {
        String queryField = "attributes,medias,sku";
        ProductInfoDto productInfoDto = new ProductInfoDto();
        RestResponse itemDetailRespDtoRestResponse = this.itemQueryApi.queryItemDetail(id, queryField, null);
        ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)RestResponseHelper.extractData((RestResponse)itemDetailRespDtoRestResponse);
        if (itemDetailRespDto != null && itemDetailRespDto.getItem() != null) {
            ItemRespDto item = itemDetailRespDto.getItem();
            BeanUtils.copyProperties((Object)item, (Object)productInfoDto);
            productInfoDto.setItemName(item.getName());
            if (item.getBrandId() != null) {
                RestResponse brandRespDtoRestResponse = this.brandQueryApi.queryById(item.getBrandId());
                BrandRespDto brandRespDto = (BrandRespDto)RestResponseHelper.extractData((RestResponse)brandRespDtoRestResponse);
                productInfoDto.setBrand(brandRespDto.getName());
            }
            if (CollectionUtils.isNotEmpty((Collection)itemDetailRespDto.getItemAttributesList())) {
                ItemAttributesRespDto itemAttributesRespDto = (ItemAttributesRespDto)itemDetailRespDto.getItemAttributesList().get(0);
                String attrs = itemAttributesRespDto.getAttrs();
                if (StringUtils.isNotBlank((CharSequence)attrs)) {
                    String dirId;
                    DirectoryItemRespDto dirRespDto;
                    JSONObject attrJson = JSONObject.parseObject((String)attrs);
                    List dirList = (List)attrJson.get((Object)"backDirList");
                    if (CollectionUtils.isNotEmpty((Collection)dirList) && (dirRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(Long.valueOf(dirId = String.valueOf(dirList.get(dirList.size() - 1)))).getData()) != null) {
                        productInfoDto.setDir(dirRespDto.getName());
                    }
                    productInfoDto.setDetail(item.getDetail());
                    productInfoDto.setPropList((List)attrJson.get((Object)"propList"));
                    productInfoDto.setBackDirList((List)attrJson.get((Object)"backDirList"));
                }
                if (CollectionUtils.isNotEmpty((Collection)itemDetailRespDto.getItemMediasList())) {
                    List collect = itemDetailRespDto.getItemMediasList().stream().map(ItemMediasRespDto::getPath1).collect(Collectors.toList());
                    productInfoDto.setImgUrlList(collect);
                }
            }
            List itemSkuList = itemDetailRespDto.getItemSkuList();
            try {
                this.setPrice(itemSkuList);
            }
            catch (Exception e) {
                logger.error("\u8bbe\u7f6e\u4ef7\u683c\u51fa\u9519\uff01e:{}", (Object)e.getMessage(), (Object)e);
            }
            productInfoDto.setItemSkuList(itemSkuList);
            productInfoDto.setSaleChannels(itemDetailRespDto.getSaleChannels());
        }
        return productInfoDto;
    }

    private void setPrice(List<ItemSkuRespDto> itemSkuList) {
    }

    public PageInfo<ProductInfoDto> pageQuery(ProductQueryDto productQueryDto, Integer pageNum, Integer pageSize) {
        logger.info("\u67e5\u8be2\u5546\u54c1\u5e93\u5217\u8868\uff0c\u5165\u53c2productQueryDto\uff1a{}", (Object)JSON.toJSONString((Object)productQueryDto));
        PageInfo productInfoDtoPageInfo = new PageInfo();
        ItemReqDto itemReqDto = new ItemReqDto();
        BeanUtils.copyProperties((Object)productQueryDto, (Object)itemReqDto);
        itemReqDto.setType(ItemLibTypeEnum.PRODUCT.getType());
        itemReqDto.setName(productQueryDto.getItemName());
        itemReqDto.setInstanceId(this.context.instanceId());
        itemReqDto.setTenantId(this.context.tenantId());
        RestResponse pageInfoRestResponse = this.itemQueryApi.queryByPage(JSON.toJSONString((Object)itemReqDto), pageNum, pageSize);
        PageInfo itemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        BeanUtils.copyProperties((Object)itemRespDtoPageInfo, (Object)productInfoDtoPageInfo);
        if (CollectionUtils.isNotEmpty((Collection)itemRespDtoPageInfo.getList())) {
            List collect = itemRespDtoPageInfo.getList().stream().map(itemRespDto -> {
                ProductInfoDto detail = this.getDetail(itemRespDto.getId());
                return detail;
            }).collect(Collectors.toList());
            productInfoDtoPageInfo.setList(collect);
        }
        return productInfoDtoPageInfo;
    }

    public Map<String, Long> getStatusCount(ProductQueryDto productQueryDto) {
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        resultMap.put("DRAFT", 0L);
        resultMap.put("PUBLISH", 0L);
        resultMap.put("RECYCLE", 0L);
        return resultMap;
    }

    private Long count(ItemReqDto itemReqDto) {
        String filter = JSON.toJSONString((Object)itemReqDto);
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null != pageInfo) {
            return pageInfo.getTotal();
        }
        return 0L;
    }

    public void batchModifyItem(ProductInfoDto productInfoDto) {
        List<ItemRespDto> items = this.queryItemBySpuid(productInfoDto.getId());
        items.forEach(itemRespDto -> {
            try {
                ItemChangeApplyDto itemChangeApplyDto = (ItemChangeApplyDto)this.itemVersionQueryApi.queryItemSnapshotByItemId(itemRespDto.getId()).getData();
                itemChangeApplyDto.setBrief(productInfoDto.getDetail());
                if (CollectionUtils.isNotEmpty((Collection)productInfoDto.getImgUrlList())) {
                    List collect = productInfoDto.getImgUrlList().stream().map(url -> {
                        ItemMediasReqDto itemMediasReqDto = new ItemMediasReqDto();
                        itemMediasReqDto.setFileType(Integer.valueOf(2));
                        itemMediasReqDto.setPath1(url);
                        return itemMediasReqDto;
                    }).collect(Collectors.toList());
                    itemChangeApplyDto.setMedias(collect);
                }
                ServiceEvent modifyItemEvent = new ServiceEvent(ItemEventCodeEnum.MODIFY.getCode(), ItemEventCodeEnum.MODIFY.getName(), (Object)itemChangeApplyDto);
                this.itemService.doService(modifyItemEvent);
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0\u5546\u54c1\u56fe\u7247\u3001\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            }
        });
    }

    private List<ItemRespDto> queryItemBySpuid(Long supid) {
        ArrayList list = Lists.newArrayList();
        ItemReqDto itemReqDto = new ItemReqDto();
        itemReqDto.setSpuid(supid);
        PageInfo itemPage = (PageInfo)this.itemQueryApi.queryByPage(JSONObject.toJSONString((Object)itemReqDto), Integer.valueOf(1), Integer.valueOf(100)).getData();
        if (null != itemPage && CollectionUtils.isNotEmpty((Collection)itemPage.getList())) {
            list.addAll(itemPage.getList());
        }
        for (int i = 2; i <= itemPage.getPages(); ++i) {
            itemPage = (PageInfo)this.itemQueryApi.queryByPage(JSONObject.toJSONString((Object)itemReqDto), Integer.valueOf(i), Integer.valueOf(100)).getData();
            if (null == itemPage || !CollectionUtils.isNotEmpty((Collection)itemPage.getList())) continue;
            list.addAll(itemPage.getList());
        }
        return list;
    }
}

