/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemStorageApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemStorageQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.item.biz.service.IItemStorageService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemStorageServiceImpl
implements IItemStorageService {
    @Resource
    private IContext context;
    @Resource
    private IItemStorageApi itemStorageApi;
    @Resource
    private IItemStorageQueryApi itemStorageQueryApi;

    @Override
    public void reset(Long shopId, Long skuId, Long quantity) {
        Long storage = this.queryStorage(shopId, skuId);
        ItemStorageReqDto storageReqDto = new ItemStorageReqDto();
        storageReqDto.setInstanceId(this.context.instanceId());
        storageReqDto.setTenantId(this.context.tenantId());
        storageReqDto.setSkuId(skuId);
        storageReqDto.setShopId(shopId);
        if (storage > 0L) {
            storageReqDto.setBalance(Long.valueOf(-storage.longValue()));
            RestResponse restResponse = this.itemStorageApi.operatingItemStorage(storageReqDto);
        }
        storageReqDto.setBalance(quantity);
        this.itemStorageApi.operatingItemStorage(storageReqDto);
    }

    @Override
    public Long queryStorage(Long shopId, Long skuId) {
        ItemStorageQueryReqDto queryReqDto = new ItemStorageQueryReqDto();
        queryReqDto.setSkuIds((List)Lists.newArrayList((Object[])new Long[]{skuId}));
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setShopId(shopId);
        List storageList = (List)this.itemStorageQueryApi.queryItemStorage(JSON.toJSONString((Object)queryReqDto)).getData();
        if (CollectionUtils.isEmpty((Collection)storageList)) {
            return 0L;
        }
        return ((ItemStorageQueryRespDto)storageList.get(0)).getAvaNum();
    }
}

