/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.IPropApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.PropInputTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameCreateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropNameRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IPropQueryApi;
import com.dtyunxi.yundt.module.item.api.IProperty;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PropertyImpl
implements IProperty {
    @Autowired
    private IPropApi propApi;
    @Autowired
    private IPropQueryApi propQueryApi;

    public Long add(PropNameReqDto propNameReqDto) {
        if (StringUtils.isBlank((CharSequence)propNameReqDto.getName())) {
            throw new BizException("\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer inputType = propNameReqDto.getInputType();
        if (inputType != null && PropInputTypeEnum.SELECT.getCode() == inputType.intValue() && CollectionUtils.isEmpty((Collection)propNameReqDto.getPropValueList())) {
            throw new BizException("\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inputType != null && PropInputTypeEnum.INPUT.getCode() == propNameReqDto.getInputType().intValue() && propNameReqDto.getCharSizeLimit() == null) {
            throw new BizException("\u5b57\u7b26\u6570\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (propNameReqDto.getRequired() == null) {
            throw new BizException("\u662f\u5426\u5fc5\u586b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.queryPropByPropName(propNameReqDto.getName()).booleanValue()) {
            throw new BizException("\u5c5e\u6027\u540d\u79f0\u3010" + propNameReqDto.getName() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        PropNameCreateReqDto propNameCreateReqDto = new PropNameCreateReqDto();
        BeanUtils.copyProperties((Object)propNameReqDto, (Object)propNameCreateReqDto);
        if (propNameCreateReqDto.getInputType() == null) {
            propNameCreateReqDto.setInputType(Integer.valueOf(PropInputTypeEnum.INPUT.getCode()));
        }
        if (StringUtils.isBlank((CharSequence)propNameCreateReqDto.getCode())) {
            propNameCreateReqDto.setCode(DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        }
        return (Long)RestResponseHelper.extractData((RestResponse)this.propApi.addProp(propNameCreateReqDto));
    }

    public PageInfo<PropNameRespDto> queryByPage(PropNameReqDto propNameReqDto, Integer pageNum, Integer pageSize) {
        RestResponse restResponse = this.propQueryApi.queryPropNameByPage(propNameReqDto, pageNum, pageSize);
        PageInfo propNameRespDtoPageInfo = (PageInfo)restResponse.getData();
        if (propNameRespDtoPageInfo == null) {
            throw new BizException(restResponse.getResultMsg());
        }
        return propNameRespDtoPageInfo;
    }

    public PropNameRespDto getPropById(Long id) {
        RestResponse restResponse = this.propQueryApi.queryPropNameById(id);
        PropNameRespDto propNameRespDto = (PropNameRespDto)restResponse.getData();
        if (propNameRespDto == null) {
            throw new BizException(restResponse.getResultMsg());
        }
        return propNameRespDto;
    }

    public RestResponse<Void> delete(Long id) {
        return this.propApi.removeProp(id);
    }

    public String batchDelete(PropNameReqDto propNameReqDto) {
        if (CollectionUtils.isNotEmpty((Collection)propNameReqDto.getPropValueList())) {
            for (String id : propNameReqDto.getPropValueList()) {
                this.propApi.removeProp(Long.valueOf(id));
            }
        }
        return null;
    }

    public void update(PropNameReqDto propNameReqDto) {
        PropNameRespDto respDto = (PropNameRespDto)RestResponseHelper.extractData((RestResponse)this.propQueryApi.queryPropNameById(propNameReqDto.getId()));
        if (respDto == null) {
            throw new BizException("\u4fee\u6539\u7684\u5c5e\u6027\u4e0d\u5b58\u5728");
        }
        Integer inputType = propNameReqDto.getInputType();
        if (inputType == null || inputType.intValue() != respDto.getInputType().intValue()) {
            throw new BizException("\u7f16\u8f91\u65b9\u5f0f\u4e0d\u53ef\u4fee\u6539");
        }
        if (!propNameReqDto.getName().equals(respDto.getName()) && this.queryPropByPropName(propNameReqDto.getName()).booleanValue()) {
            throw new BizException("\u5c5e\u6027\u540d\u79f0\u3010" + propNameReqDto.getName() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        if (StringUtils.isBlank((CharSequence)propNameReqDto.getCode())) {
            propNameReqDto.setCode(DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        }
        this.propApi.modifyProp(propNameReqDto);
    }

    public Boolean queryPropByPropName(String name) {
        PropNameReqDto propNameReqDto = new PropNameReqDto();
        propNameReqDto.setName(name);
        PageInfo propNameRespDtoPageInfo = (PageInfo)this.propQueryApi.queryPropNameByPage(propNameReqDto, Integer.valueOf(1), Integer.valueOf(10)).getData();
        if (propNameRespDtoPageInfo != null && CollectionUtils.isNotEmpty((Collection)propNameRespDtoPageInfo.getList()) && propNameRespDtoPageInfo.getList().size() > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

