/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.impl;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DistributionSetRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.dto.response.CommanderComsCfgRespDto;
import com.dtyunxi.yundt.imkt.cube.bundle.commander.center.member.api.query.ICommanderComsCfgQueryApi;
import com.dtyunxi.yundt.module.item.api.IDistributionSetService;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DistributionSetServiceImpl
implements IDistributionSetService {
    private static final Logger logger = LoggerFactory.getLogger(DistributionSetServiceImpl.class);
    @Resource
    private ICommanderComsCfgQueryApi commanderComsCfgQueryApi;
    private Long DEFAULT_ID = 1259460810394469377L;

    public DistributionSetRespDto getDefault() {
        RestResponse restResponse = this.commanderComsCfgQueryApi.queryById(this.DEFAULT_ID);
        CommanderComsCfgRespDto cfgRespDto = (CommanderComsCfgRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        DistributionSetRespDto defaultSet = new DistributionSetRespDto();
        if (null != cfgRespDto) {
            if (cfgRespDto.getComsCalType() == 2) {
                defaultSet.setFirstLevelAmount(BigDecimal.valueOf(cfgRespDto.getDirectComs() / 100.0));
                defaultSet.setSecondLevelAmount(BigDecimal.valueOf(cfgRespDto.getIndirectComs() / 100.0));
                defaultSet.setFirstLevelPoint(BigDecimal.valueOf(cfgRespDto.getDirectPoints() / 100.0));
                defaultSet.setSecondLevelPoint(BigDecimal.valueOf(cfgRespDto.getIndirectPoints() / 100.0));
            } else if (cfgRespDto.getComsCalType() == 1) {
                defaultSet.setFirstLevelAmount(BigDecimal.valueOf(cfgRespDto.getDirectComs() * 100.0));
                defaultSet.setSecondLevelAmount(BigDecimal.valueOf(cfgRespDto.getIndirectComs() * 100.0));
                defaultSet.setFirstLevelPoint(BigDecimal.valueOf(cfgRespDto.getDirectPoints() * 100.0));
                defaultSet.setSecondLevelPoint(BigDecimal.valueOf(cfgRespDto.getIndirectPoints() * 100.0));
            }
            defaultSet.setSetType(Integer.valueOf(0));
            defaultSet.setValueType(cfgRespDto.getComsCalType());
        } else {
            logger.info("\u5206\u9500\u9ed8\u8ba4\u914d\u7f6e\u672a\u914d\u7f6e");
            defaultSet.setSetType(Integer.valueOf(0));
            defaultSet.setFirstLevelAmount(BigDecimal.ZERO);
            defaultSet.setFirstLevelPoint(BigDecimal.ZERO);
            defaultSet.setSecondLevelAmount(BigDecimal.ZERO);
            defaultSet.setSecondLevelPoint(BigDecimal.ZERO);
            defaultSet.setValueType(Integer.valueOf(2));
        }
        return defaultSet;
    }
}

