/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.rest;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemAuditReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.module.item.api.IItem;
import com.dtyunxi.yundt.module.item.api.IItemService;
import com.dtyunxi.yundt.module.item.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.item.api.dto.request.ItemOffShelfReqDto;
import com.dtyunxi.yundt.module.item.api.dto.request.ItemOnShelfReqDto;
import com.dtyunxi.yundt.module.item.api.enums.ItemEventCodeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ec4\u4ef6\uff1a\u5546\u54c1\u7ba1\u7406\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/item"})
public class ItemServiceRest {
    @Resource
    private IItemService itemService;
    @Resource
    private IItem item;

    @ApiOperation(value="\u65b0\u589e\u5546\u54c1", notes="\u65b0\u589e\u5546\u54c1\uff0c\u72b6\u6001\u4e3a\uff080\uff0c\u5f85\u53d1\u5e03\uff09")
    @ApiImplicitParam(name="changApply", paramType="body", dataType="ItemChangeApplyDetailDto", required=true, value="\u5546\u54c1\u4fe1\u606f")
    @PostMapping(value={""})
    @Deprecated
    RestResponse<Void> create(@Valid @RequestBody ItemChangeApplyDetailDto changApply) {
        this.checkItemParam(changApply);
        this.setSingleSku(changApply);
        this.setItemChangeApplyAttr(changApply);
        ServiceEvent serviceEvent = new ServiceEvent(ItemEventCodeEnum.CREATE.getCode(), ItemEventCodeEnum.CREATE.getName(), (Object)changApply);
        this.itemService.doService(serviceEvent);
        return new RestResponse();
    }

    @ApiOperation(value="\u53d1\u5e03\u5546\u54c1", notes="\u63d0\u4ea4\u5ba1\u6838\u7533\u8bf7")
    @ApiImplicitParam(name="id", paramType="path", dataType="Long", required=true, value="\u5546\u54c1ID")
    @PostMapping(value={"/{id}/submit"})
    RestResponse<Void> submit(@PathVariable(value="id") Long id) {
        ServiceEvent serviceEvent = new ServiceEvent(ItemEventCodeEnum.PUBLISH.getCode(), ItemEventCodeEnum.PUBLISH.getName(), (Object)id);
        this.itemService.doService(serviceEvent);
        return new RestResponse();
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u54c1", notes="\u4fee\u6539\u5546\u54c1\u7248\u672c,\u5546\u54c1\u72b6\u6001\u53d8\u4e3a\uff080\uff0c\u5f85\u53d1\u5e03\uff09")
    @ApiImplicitParam(name="itemChangeApplyDetailDto", paramType="body", dataType="ItemChangeApplyDetailDto", required=true, value="\u5546\u54c1\u4fe1\u606f")
    @PutMapping(value={""})
    @Deprecated
    RestResponse<Void> modify(@Valid @RequestBody ItemChangeApplyDetailDto itemChangeApplyDetailDto) {
        this.checkItemParam(itemChangeApplyDetailDto);
        this.setSingleSku(itemChangeApplyDetailDto);
        this.setItemChangeApplyAttr(itemChangeApplyDetailDto);
        ServiceEvent serviceEvent = new ServiceEvent(ItemEventCodeEnum.MODIFY.getCode(), ItemEventCodeEnum.MODIFY.getName(), (Object)itemChangeApplyDetailDto);
        this.itemService.doService(serviceEvent);
        return new RestResponse();
    }

    @ApiOperation(value="\u5ba1\u6838\u5546\u54c1", notes="\u5ba1\u6838\u5546\u54c1\uff0c\u5ba1\u6838\u901a\u8fc7\u5546\u54c1\u72b6\u6001\u53d8\u4e3a\uff084\uff0c\u5df2\u53d1\u5e03\uff09\uff0c\u5ba1\u6838\u4e0d\u901a\u8fc7\u72b6\u6001\u53d8\u4e3a\uff080\uff0c\u5f85\u53d1\u5e03\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", paramType="path", dataType="Long", required=true, value="\u5546\u54c1id"), @ApiImplicitParam(name="itemAuditReqDto", paramType="body", dataType="ItemAuditReqDto", required=true, value="\u5ba1\u6838\u4fe1\u606f")})
    @PutMapping(value={"/{id}/audit"})
    RestResponse<Void> audit(@PathVariable(value="id") Long id, @Valid @RequestBody ItemAuditReqDto itemAuditReqDto) {
        ServiceEvent serviceEvent = new ServiceEvent(ItemEventCodeEnum.AUDIT.getCode(), ItemEventCodeEnum.AUDIT.getName(), (Object)itemAuditReqDto);
        this.itemService.doService(serviceEvent);
        return new RestResponse();
    }

    @ApiOperation(value="\u5220\u9664\u5546\u54c1")
    @ApiImplicitParam(name="id", paramType="path", dataType="Long", required=true, value="\u5546\u54c1\u7248\u672cID")
    @DeleteMapping(value={"/{id}"})
    RestResponse<Void> removeItem(@PathVariable(value="id") Long id) {
        ServiceEvent serviceEvent = new ServiceEvent(ItemEventCodeEnum.REMOVE.getCode(), ItemEventCodeEnum.REMOVE.getName(), (Object)id);
        this.itemService.doService(serviceEvent);
        return new RestResponse();
    }

    @ApiOperation(value="\u5220\u9664\u5e97\u94fa\u5546\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="shopId", paramType="path", dataType="Long", required=true, value="\u5e97\u94faID"), @ApiImplicitParam(name="id", paramType="path", dataType="Long", required=true, value="\u5546\u54c1ID")})
    @DeleteMapping(value={"/{shopId}/{id}"})
    RestResponse<Void> removeShopItem(@PathVariable(value="shopId") Long shopId, @PathVariable(value="id") Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("shopId", shopId);
        paramMap.put("id", id);
        ServiceEvent serviceEvent = new ServiceEvent(ItemEventCodeEnum.REMOVESHOP.getCode(), ItemEventCodeEnum.REMOVESHOP.getName(), paramMap);
        this.itemService.doService(serviceEvent);
        return new RestResponse();
    }

    @ApiOperation(value="\u6279\u91cf\u4e0a\u67b6\u5546\u54c1", notes="\u5546\u54c1\u6279\u91cf\u4e0a\u67b6")
    @PutMapping(value={"/onSale"})
    RestResponse<Void> onShelf(@Valid @RequestBody List<ItemOnShelfReqDto> itemOnShelfReqDtos) {
        ServiceEvent serviceEvent = new ServiceEvent(ItemEventCodeEnum.ON_SHELF.getCode(), ItemEventCodeEnum.ON_SHELF.getName(), itemOnShelfReqDtos);
        this.itemService.onShelf(serviceEvent);
        return new RestResponse();
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u7aef\u6279\u91cf\u4e0a\u67b6\u5546\u54c1", notes="\u5c0f\u7a0b\u5e8f\u5546\u54c1\u6279\u91cf\u4e0a\u67b6")
    @PutMapping(value={"/onSaleApp"})
    RestResponse<Void> onAppShelf(@Valid @RequestBody List<ItemOnShelfReqDto> itemOnShelfReqDtos) {
        this.item.getApp(itemOnShelfReqDtos);
        return new RestResponse();
    }

    @ApiOperation(value="\u6279\u91cf\u4e0b\u67b6\u5546\u54c1", notes="\u5546\u54c1\u6279\u91cf\u4e0b\u67b6")
    @PutMapping(value={"/offSale"})
    RestResponse<Void> offShelf(@RequestBody List<ItemOffShelfReqDto> itemOffShelfReqDtos) {
        ServiceEvent serviceEvent = new ServiceEvent(ItemEventCodeEnum.OFF_SHELF.getCode(), ItemEventCodeEnum.OFF_SHELF.getName(), itemOffShelfReqDtos);
        this.itemService.offShelf(serviceEvent);
        return new RestResponse();
    }

    private void setSingleSku(ItemChangeApplyDetailDto itemChangeApplyDetailDto) {
        if (itemChangeApplyDetailDto.getSkus().size() == 1) {
            ItemBundleReqDto sku = (ItemBundleReqDto)itemChangeApplyDetailDto.getSkus().get(0);
            sku.setBarCode(itemChangeApplyDetailDto.getItemBarCode());
            if (StringUtils.isEmpty((String)sku.getAttr())) {
                sku.setAttr("");
            }
        }
    }

    private void setItemChangeApplyAttr(ItemChangeApplyDetailDto itemChangeApplyDetailDto) {
        JSONObject attrsJson = JSONObject.parseObject((String)itemChangeApplyDetailDto.getAttrs());
        if (null == attrsJson) {
            attrsJson = new JSONObject();
        }
        attrsJson.put("sellPoint", (Object)itemChangeApplyDetailDto.getSellPoint());
        attrsJson.put("itemBarCode", (Object)itemChangeApplyDetailDto.getItemBarCode());
        attrsJson.put("frontDirList", (Object)itemChangeApplyDetailDto.getFrontDirList());
        attrsJson.put("shopDirs", (Object)itemChangeApplyDetailDto.getShopDirs());
        attrsJson.put("publishChannel", (Object)itemChangeApplyDetailDto.getPublishChannel());
        attrsJson.put("shippingTemplateId", (Object)itemChangeApplyDetailDto.getShippingTemplateId());
        attrsJson.put("uniformFreight", (Object)itemChangeApplyDetailDto.getUniformFreight());
        attrsJson.put("propList", (Object)itemChangeApplyDetailDto.getPropList());
        attrsJson.put("backDirList", (Object)itemChangeApplyDetailDto.getBackDirList());
        itemChangeApplyDetailDto.setAttrs(attrsJson.toString());
    }

    private void checkItemParam(ItemChangeApplyDetailDto item) {
        BigDecimal maxFreight = BigDecimal.valueOf(9.999999999E7);
        BigDecimal maxPrice = BigDecimal.valueOf(9.999999999E7);
        BigDecimal markingOutPrice = BigDecimal.ZERO;
        Long maxStock = 99999999L;
        String msg = null;
        if (StringUtils.length((String)item.getItemName()) > 200) {
            msg = "\u5546\u54c1\u540d\u79f0[1-200]\u5b57\u7b26";
        }
        if (StringUtils.length((String)item.getSellPoint()) > 200) {
            msg = "\u5546\u54c1\u5356\u70b9[1-200]\u5b57\u7b26";
        }
        if (StringUtils.length((String)item.getItemCode()) > 32) {
            msg = "\u5546\u54c1\u7f16\u7801[1-32]\u5b57\u7b26";
        }
        if (StringUtils.length((String)item.getItemBarCode()) > 32) {
            msg = "\u5546\u54c1\u6761\u7801[1-32]\u5b57\u7b26";
        }
        if (CollectionUtils.isEmpty((Collection)item.getFrontDirList())) {
            msg = "\u524d\u53f0\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)item.getBackDirList())) {
            msg = "\u540e\u53f0\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null != item.getUniformFreight() && item.getUniformFreight().compareTo(maxFreight) == 1) {
            msg = "\u8fd0\u8d39\u8303\u56f4[0-99999999.99]";
        }
        if (StringUtils.isNotBlank((String)item.getBrief()) && item.getBrief().length() > 4000) {
            msg = "\u5546\u54c1\u4ecb\u7ecd[0-4000]\u5b57\u7b26";
        }
        if (CollectionUtils.isEmpty((Collection)item.getSkus())) {
            msg = "\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a";
        } else {
            for (ItemBundleReqDto sku : item.getSkus()) {
                if (StringUtils.isBlank((String)sku.getCode())) {
                    sku.setCode(null);
                } else if (StringUtils.length((String)sku.getCode()) > 32) {
                    msg = "\u89c4\u683c\u7f16\u7801[1-32]\u5b57\u7b26";
                }
                if (StringUtils.length((String)sku.getBarCode()) > 32) {
                    msg = "\u89c4\u683c\u6761\u7801[1-32]\u5b57\u7b26";
                }
                if (CollectionUtils.isEmpty((Collection)sku.getPrices())) {
                    msg = "\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a";
                    continue;
                }
                markingOutPrice = sku.getPrices().stream().filter(e -> "\u5212\u7ebf\u4ef7".equals(e.getName())).findFirst().orElse(new ItemPriceReqDto()).getPrice();
                if (markingOutPrice == null) {
                    throw new BizException("\u5212\u7ebf\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (ItemPriceReqDto price : sku.getPrices()) {
                    if (price.getPrice() == null || price.getPrice().compareTo(maxPrice) > 0) {
                        msg = "\u4ef7\u683c\u8303\u56f4[0-99999999.99]";
                    }
                    if ("\u5212\u7ebf\u4ef7".equals(price.getName()) || price.getPrice().compareTo(markingOutPrice) <= 0) continue;
                    msg = "\u552e\u4ef7\u4e0d\u80fd\u5927\u4e8e\u5212\u7ebf\u4ef7";
                }
            }
        }
        if (StringUtils.isNotBlank((String)msg)) {
            throw new BizException(msg);
        }
    }
}

