/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.rest;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.IManagementBlockApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ManagementBlockReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ManagementBlockSaveReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMgmtBlockRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ManagementBlockRespDto;
import com.dtyunxi.yundt.module.item.api.IManagementBlockService;
import com.dtyunxi.yundt.module.item.api.dto.response.customer.CustomerListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ec4\u4ef6\uff1a\u7ecf\u8425\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/management-block"})
public class IManagementBlockRest {
    private static final Logger logger = LoggerFactory.getLogger(IManagementBlockRest.class);
    @Resource
    private IManagementBlockService iManagementBlockService;
    @Resource
    private IManagementBlockApi iManagementBlockApi;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;

    @ApiOperation(value="\u7ecf\u8425\u5c4f\u853d\u5546\u54c1\u5206\u9875\u5217\u8868", notes="\u7ecf\u8425\u5c4f\u853d\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", paramType="query", dataType="Int", defaultValue="1", required=true), @ApiImplicitParam(name="pageSize", paramType="query", dataType="Int", defaultValue="10", required=true)})
    @GetMapping(value={"/page"})
    RestResponse<PageInfo<ManagementBlockRespDto>> list(ManagementBlockReqDto itemListQueryReqDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        logger.info("\u7ecf\u8425\u5c4f\u853d\u5546\u54c1\u5206\u9875\u5217\u8868\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)itemListQueryReqDto));
        return new RestResponse((Object)this.iManagementBlockService.pageManagementBlock(itemListQueryReqDto, pageNum, pageSize));
    }

    @GetMapping(value={"/area-group/tree"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u533a\u57df\u5206\u7ec4\u6811", notes="\u67e5\u8be2\u533a\u57df\u5206\u7ec4\u6811")
    RestResponse<List<AreaGroupTreeRespDto>> queryAreaGroupForTree() {
        List respDtoList = (List)this.areaGroupQueryApi.queryForTree().getData();
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            Iterator it = respDtoList.iterator();
            while (it.hasNext()) {
                AreaGroupTreeRespDto respDto = (AreaGroupTreeRespDto)it.next();
                if (!"0".equals(respDto.getCode())) continue;
                it.remove();
            }
        }
        return new RestResponse((Object)respDtoList);
    }

    @GetMapping(value={"/customer-type/all-simple"}, produces={"application/json"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5ba2\u6237\u7c7b\u578b", notes="\u67e5\u8be2\u6240\u6709\u5ba2\u6237\u7c7b\u578b,\u8fd4\u56de\u7684\u6570\u636e\u8f83\u4e3a\u7b80\u5355,\u5355\u8868\u67e5\u8be2")
    RestResponse<List<CustomerTypeRespDto>> queryAllSimpleCustomerType() {
        return this.customerTypeQueryApi.queryAllSimpleCustomerType(null);
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237ID\u67e5\u770b\u5ba2\u6237id\u4e0e\u540d\u79f0\u96c6\u5408", notes="\u6839\u636e\u5ba2\u6237ID\u67e5\u770b\u5ba2\u6237id\u4e0e\u540d\u79f0\u96c6\u5408")
    @ApiImplicitParam(name="ids", value="\u4f8b\u5982:1,2,3", required=true)
    @GetMapping(value={"/customer/list/ids"}, produces={"application/json"})
    RestResponse<List<CustomerNameSimpleRespDto>> queryCustomerListByIds(@RequestParam(value="ids") List<Long> ids) {
        return this.customerQueryApi.queryListByIds(ids);
    }

    @GetMapping(value={"/customer/page"}, produces={"application/json"})
    @ApiOperation(value="\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2", notes="\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="filter", value="\u8fc7\u6ee4\u6761\u4ef6, tenantId, instanceId\u901a\u8fc7filter\u4f20\u9012", dataType="string", paramType="query"), @ApiImplicitParam(name="pageNum", value="\u8d77\u59cb\u9875", dataType="int", paramType="query", required=true), @ApiImplicitParam(name="pageSize", value="\u6bcf\u4e00\u9875\u7684\u8bb0\u5f55\u6570", dataType="int", paramType="query", required=true)})
    RestResponse<PageInfo<CustomerListRespDto>> queryCustomerByPage(@RequestParam(name="filter", required=false) String filter, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.iManagementBlockService.queryCustomerByPage(filter, pageNum, pageSize));
    }

    @GetMapping(value={"/{itemId}"})
    @ApiOperation(value="\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1\u7ecf\u8425\u5c4f\u853d\u4fe1\u606f", notes="\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1\u7ecf\u8425\u5c4f\u853d\u4fe1\u606f(\u5546\u54c1\u8be6\u60c5\u7528)", response=ItemMgmtBlockRespDto.class)
    RestResponse<List<ItemMgmtBlockRespDto>> queryItemMgmtBlockList(@PathVariable(value="itemId") Long itemId) {
        return new RestResponse((Object)this.iManagementBlockService.queryItemMgmtBlockList(itemId));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u6307\u5b9asku\u7ecf\u8425\u5c4f\u853d", notes="\u5c4f\u853d\u6307\u5b9asku\u7ecf\u8425\u8303\u56f4,\u7ecf\u8425\u533a\u57df,\u5ba2\u6237\u7c7b\u578b\u7b49")
    RestResponse<Void> addOrModifyManagementBlock(@RequestBody @Valid ManagementBlockSaveReqDto itemStatReqDto) {
        return this.iManagementBlockApi.addOrModifyManagementBlock(itemStatReqDto);
    }

    @GetMapping(value={"/cancel"})
    @ApiOperation(value="\u53d6\u6d88\u7ecf\u8425\u5c4f\u853d", notes="\u53d6\u6d88\u7ecf\u8425\u5c4f\u853d,\u7ecf\u8425\u533a\u57df,\u5ba2\u6237\u7c7b\u578b\u7b49")
    RestResponse<Void> cancelManagementBlock(@RequestParam(value="skuIds") List<Long> skuIds) {
        return this.iManagementBlockApi.cancelManagementBlock(skuIds);
    }
}

