/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.rest;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.RootDirectoryReqDto;
import com.dtyunxi.yundt.module.item.api.ICategory;
import com.dtyunxi.yundt.module.item.biz.impl.ItemModuleHelper;
import com.dtyunxi.yundt.module.item.bo.Category;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ec4\u4ef6\uff1a\u7c7b\u76ee\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/item/category"})
public class CategoryRest {
    @Resource
    private ICategory categoryImpl;
    @Autowired
    private ItemModuleHelper itemModuleHelper;

    @ApiOperation(value="\u65b0\u589e\u7c7b\u76ee")
    @ApiImplicitParam(name="category", paramType="body", dataType="Category", required=true, value="\u7c7b\u76ee\u4fe1\u606f")
    @PostMapping(value={""})
    RestResponse<Long> create(@Valid @RequestBody Category category) {
        return new RestResponse((Object)this.categoryImpl.create(category));
    }

    @ApiOperation(value="\u4fee\u6539\u7c7b\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", paramType="path", dataType="Long", required=true, value="\u7c7b\u76eeid"), @ApiImplicitParam(name="category", paramType="body", dataType="Category", required=true, value="\u7c7b\u76ee\u4fe1\u606f")})
    @PutMapping(value={"/{categoryId}"})
    RestResponse<Void> modify(@PathVariable(value="categoryId") Long categoryId, @Valid @RequestBody Category category) {
        category.setId(categoryId);
        this.categoryImpl.modify(category);
        return new RestResponse();
    }

    @ApiOperation(value="\u5220\u9664\u7c7b\u76ee")
    @ApiImplicitParam(name="categoryId", paramType="path", dataType="Long", required=true, value="\u7c7b\u76eeid")
    @DeleteMapping(value={"/{categoryId}"})
    RestResponse<Void> remove(@PathVariable(value="categoryId") Long categoryId) {
        return this.categoryImpl.remove(categoryId);
    }

    @ApiOperation(value="\u7c7b\u76ee\u6392\u5e8f", notes="\u7c7b\u76ee\u5728\u540c\u7ea7\u4e0b\u8fdb\u884cBOTTOM\u7f6e\u5e95\uff0cINCR\u5347\u5e8f\uff0cDECR\u964d\u5e8f\uff0cTOP\u7f6e\u9876\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryId", paramType="path", dataType="Long", required=true, value="\u7c7b\u76eeid"), @ApiImplicitParam(name="sortType", paramType="path", dataType="String", required=true, value="\u6392\u5e8f\u7c7b\u578b\uff1aBOTTOM\u7f6e\u5e95\uff0cINCR\u5347\u5e8f\uff0cDECR\u964d\u5e8f\uff0cTOP\u7f6e\u9876")})
    @PutMapping(value={"/{categoryId}/sort/{sortType}"})
    RestResponse<Void> modify(@PathVariable(value="categoryId") Long categoryId, @PathVariable(value="sortType") String sortType) {
        this.categoryImpl.sortDirectory(categoryId, sortType);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u76ee\u7c7b\u578b\u67e5\u8be2\u7c7b\u76ee\u6811", notes="dirUsage:back \u540e\u53f0\u7c7b\u76ee,front \u524d\u53f0\u7c7b\u76ee,shop \u5e97\u94fa\u7c7b\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dirUsage", paramType="path", dataType="String", required=true, value="\u7c7b\u76ee\u7c7b\u578b\uff1aback \u540e\u53f0\u7c7b\u76ee,front \u524d\u53f0\u7c7b\u76ee,shop \u5e97\u94fa\u7c7b\u76ee"), @ApiImplicitParam(name="shopId", paramType="query", dataType="Long", value="\u5e97\u94faid\uff0c\u5f53\u67e5\u5e97\u94fa\u7c7b\u76ee\u65f6\u5e97\u94faid\u6216\u57ce\u5e02\u7ad9\u9700\u4f20\u4e00\u4e2a\uff0c\u4f18\u5148\u6309\u5e97\u94faid\u67e5"), @ApiImplicitParam(name="cityStation", paramType="query", dataType="String", value="\u57ce\u5e02\u7ad9\u540d\u79f0\uff0c\u5f53\u67e5\u5e97\u94fa\u7c7b\u76ee\u65f6\u5e97\u94faid\u6216\u57ce\u5e02\u7ad9\u9700\u4f20\u4e00\u4e2a"), @ApiImplicitParam(name="showDisable", paramType="query", dataType="Integer", value="\u662f\u5426\u663e\u793a\u7981\u7528\u7c7b\u76ee:1\u663e\u793a 0\u4e0d\u663e\u793a \u9ed8\u8ba4\u4e0d\u663e\u793a")})
    @GetMapping(value={"/{dirUsage}/tree"})
    RestResponse<Map<String, Object>> queryCategoryTree(@PathVariable(value="dirUsage") String dirUsage, @RequestParam(value="shopId", required=false) Long shopId, @RequestParam(value="cityStation", required=false) String cityStation, @RequestParam(value="showDisable", required=false) Integer showDisable, @RequestParam(value="name", required=false) String name) {
        if ("shop".equals(dirUsage) && shopId == null) {
            if (StringUtils.isBlank((String)cityStation)) {
                throw new BizException("\u5f53\u67e5\u5e97\u94fa\u7c7b\u76ee\u65f6\uff0c\u5e97\u94faid\u6216\u57ce\u5e02\u7ad9\u540d\u79f0\u81f3\u5c11\u9700\u4f20\u4e00\u4e2a");
            }
            shopId = this.itemModuleHelper.getByShopName(cityStation);
        }
        RootDirectoryReqDto rootDirectoryReqDto = new RootDirectoryReqDto();
        rootDirectoryReqDto.setDirUsage(dirUsage);
        rootDirectoryReqDto.setShopId(shopId);
        rootDirectoryReqDto.setName(name);
        return new RestResponse((Object)this.categoryImpl.queryList(rootDirectoryReqDto, showDisable));
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u76eeid\u67e5\u8be2\u7c7b\u76ee")
    @ApiImplicitParam(name="categoryId", paramType="path", dataType="Long", required=true, value="\u7c7b\u76eeid")
    @GetMapping(value={"/{categoryId}"})
    RestResponse<Category> getById(@PathVariable(value="categoryId") Long categoryId) {
        Category category = this.categoryImpl.getById(categoryId);
        List names = this.categoryImpl.selectBackNameById(categoryId);
        category.setBackNames(names);
        return new RestResponse((Object)category);
    }

    @GetMapping(value={"/getParentById"})
    public RestResponse getDirParent(@RequestParam(value="dirId") Long dirId) {
        return new RestResponse((Object)this.categoryImpl.getDirParent(dirId));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="dirUsage", paramType="path", dataType="String", required=true, value="\u7c7b\u76ee\u7c7b\u578b\uff1aback \u540e\u53f0\u7c7b\u76ee,front \u524d\u53f0\u7c7b\u76ee,shop \u5e97\u94fa\u7c7b\u76ee"), @ApiImplicitParam(name="shopId", paramType="query", dataType="Long", value="\u5e97\u94faid\uff0c\u5f53\u67e5\u5e97\u94fa\u7c7b\u76ee\u65f6\u5e97\u94faid\u6216\u57ce\u5e02\u7ad9\u9700\u4f20\u4e00\u4e2a\uff0c\u4f18\u5148\u6309\u5e97\u94faid\u67e5"), @ApiImplicitParam(name="cityStation", paramType="query", dataType="String", value="\u57ce\u5e02\u7ad9\u540d\u79f0\uff0c\u5f53\u67e5\u5e97\u94fa\u7c7b\u76ee\u65f6\u5e97\u94faid\u6216\u57ce\u5e02\u7ad9\u9700\u4f20\u4e00\u4e2a"), @ApiImplicitParam(name="showDisable", paramType="query", dataType="Integer", value="\u662f\u5426\u663e\u793a\u7981\u7528\u7c7b\u76ee:1\u663e\u793a 0\u4e0d\u663e\u793a \u9ed8\u8ba4\u4e0d\u663e\u793a")})
    @GetMapping(value={"/{dirUsage}/byId/{id}"})
    @ApiOperation(value="\u6839\u636e\u540e\u53f0\u7c7b\u76ee\u67e5\u8be2\u524d\u53f0\u7c7b\u76ee")
    public RestResponse<Map<String, Object>> getFront(@PathVariable(value="dirUsage") String dirUsage, @PathVariable(value="id") Long id, @RequestParam(value="shopId", required=false) Long shopId, @RequestParam(value="cityStation", required=false) String cityStation, @RequestParam(value="showDisable", required=false) Integer showDisable) {
        if ("shop".equals(dirUsage) && shopId == null) {
            if (StringUtils.isBlank((String)cityStation)) {
                throw new BizException("\u5f53\u67e5\u5e97\u94fa\u7c7b\u76ee\u65f6\uff0c\u5e97\u94faid\u6216\u57ce\u5e02\u7ad9\u540d\u79f0\u81f3\u5c11\u9700\u4f20\u4e00\u4e2a");
            }
            shopId = this.itemModuleHelper.getByShopName(cityStation);
        }
        RootDirectoryReqDto rootDirectoryReqDto = new RootDirectoryReqDto();
        rootDirectoryReqDto.setDirUsage(dirUsage);
        rootDirectoryReqDto.setShopId(shopId);
        return new RestResponse((Object)this.categoryImpl.getFront(rootDirectoryReqDto, showDisable, id));
    }
}

