/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.rest;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IItemInfoApi;
import com.dtyunxi.tcbj.api.dto.request.QueryItemByBrandAndOrgReqDto;
import com.dtyunxi.tcbj.api.dto.response.QueryItemByBrandAndOrgRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.module.item.api.IItemLibService;
import com.dtyunxi.yundt.module.item.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.item.api.dto.ItemSkuBundleDto;
import com.dtyunxi.yundt.module.item.api.dto.request.ItemOffShelfReqDto;
import com.dtyunxi.yundt.module.item.api.dto.request.ItemOnShelfReqDto;
import com.dtyunxi.yundt.module.item.api.dto.request.SkuShelfReqDto;
import com.dtyunxi.yundt.module.item.rest.ItemServiceRest;
import com.yx.tcbj.center.api.ItemBrandAuthApi;
import com.yx.tcbj.center.api.dto.request.ItemBrandAuthAddReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ec4\u4ef6\uff1a\u5546\u54c1\u7ba1\u7406\u670d\u52a1 \u540e\u53f0\u7ef4\u62a4\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v2/item"})
public class ItemServiceRestV2 {
    private static final Logger log = LogManager.getLogger(ItemServiceRestV2.class);
    @Resource
    private ItemServiceRest itemServiceRest;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemInfoApi itemInfoApi;
    @Resource
    private ItemBrandAuthApi itemBrandAuthApi;
    @Autowired
    private IItemLibService itemLibService;

    @PostMapping(value={"/offShelfByBrand"}, produces={"application/json"})
    @ApiOperation(value="\u6279\u91cf\u4e0b\u67b6\u5546\u54c1by\u54c1\u724ccode+\u54c1\u724c\u65b9orgId")
    RestResponse<String> offShelfByBrand(@RequestBody QueryItemByBrandAndOrgReqDto reqDto) {
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0b\u67b6\u5546\u54c1,\u8bf7\u6c42\u53c2\u6570 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        List queryItemByBrandAndOrgRespDto = (List)this.itemInfoApi.queryItemByBrandAndOrg(reqDto).getData();
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0b\u67b6\u5546\u54c1,\u67e5\u8be2\u54c1\u724c\u65b9\u4e0b\u9762\u5bf9\u5e94\u54c1\u724c\u7684\u5546\u54c1\u4fe1\u606f queryItemByBrandAndOrgRespDto={}", (Object)JSONObject.toJSONString((Object)queryItemByBrandAndOrgRespDto));
        List<ItemOffShelfReqDto> itemOffShelfReqDtos = this.convertOffShelfParam(queryItemByBrandAndOrgRespDto);
        if (itemOffShelfReqDtos.isEmpty()) {
            return new RestResponse((Object)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u4e0b\u67b6");
        }
        log.info("\u5f00\u59cb\u8c03\u7528\u4e0b\u67b6\u5546\u54c1 sum={}, itemOffShelfReqDtosParam={}", (Object)itemOffShelfReqDtos.size(), (Object)JSONObject.toJSONString(itemOffShelfReqDtos));
        int index = 0;
        for (ItemOffShelfReqDto itemOffShelfReqDto : itemOffShelfReqDtos) {
            ArrayList<ItemOffShelfReqDto> itemOffShelfReqDtosParam = new ArrayList<ItemOffShelfReqDto>();
            itemOffShelfReqDtosParam.add(itemOffShelfReqDto);
            log.info("\u5355\u6761\u5546\u54c1\u4e0b\u67b6 index={},sum={}, itemOffShelfReqDtosParam={}", (Object)index, (Object)itemOffShelfReqDtos.size(), (Object)JSONObject.toJSONString(itemOffShelfReqDtosParam));
            try {
                this.itemServiceRest.offShelf(itemOffShelfReqDtosParam);
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u4e0b\u67b6\u5f02\u5e38", (Throwable)e);
            }
            log.info("\u5355\u6761\u5546\u54c1\u4e0b\u67b6\u7ed3\u675f index={}, sum={}", (Object)index, (Object)itemOffShelfReqDtos.size());
            ++index;
        }
        log.info("\u7ed3\u675f\u8c03\u7528\u4e0b\u67b6\u5546\u54c1 sum={}, itemOffShelfReqDtosParam={}", (Object)itemOffShelfReqDtos.size(), (Object)JSONObject.toJSONString(itemOffShelfReqDtos));
        return new RestResponse();
    }

    private List<ItemOffShelfReqDto> convertOffShelfParam(List<QueryItemByBrandAndOrgRespDto> queryItemByBrandAndOrgRespDto) {
        ArrayList<ItemOffShelfReqDto> itemOffShelfReqDtos = new ArrayList<ItemOffShelfReqDto>();
        for (QueryItemByBrandAndOrgRespDto itemByBrandAndOrgRespDto : queryItemByBrandAndOrgRespDto) {
            ItemOffShelfReqDto itemOffShelfReqDto = new ItemOffShelfReqDto();
            BeanUtil.copyProperties((Object)itemByBrandAndOrgRespDto, (Object)itemOffShelfReqDto, (String[])new String[0]);
            itemOffShelfReqDtos.add(itemOffShelfReqDto);
        }
        return itemOffShelfReqDtos;
    }

    @ApiOperation(value="\u6279\u91cf\u4e0a\u67b6\u5546\u54c1by\u54c1\u724ccode+\u54c1\u724c\u65b9orgId")
    @PutMapping(value={"/onSaleByBrand"})
    RestResponse<String> onShelfByBrand(@RequestBody QueryItemByBrandAndOrgReqDto reqDto) {
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0a\u67b6\u5546\u54c1,\u8bf7\u6c42\u53c2\u6570 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        List queryItemByBrandAndOrgRespDto = (List)this.itemInfoApi.queryItemByBrandAndOrg(reqDto).getData();
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0a\u67b6\u5546\u54c1,\u67e5\u8be2\u54c1\u724c\u65b9\u4e0b\u9762\u5bf9\u5e94\u54c1\u724c\u7684\u5546\u54c1\u4fe1\u606f queryItemByBrandAndOrgRespDto={}", (Object)JSONObject.toJSONString((Object)queryItemByBrandAndOrgRespDto));
        Map onShelfShopMap = queryItemByBrandAndOrgRespDto.stream().collect(Collectors.groupingBy(QueryItemByBrandAndOrgRespDto::getShopId, Collectors.mapping(QueryItemByBrandAndOrgRespDto::getItemId, Collectors.toList())));
        if (onShelfShopMap.isEmpty()) {
            return new RestResponse((Object)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u4e0a\u67b6");
        }
        int sum = queryItemByBrandAndOrgRespDto.size();
        int[] index = new int[]{0};
        log.info("\u4e0a\u67b6\u5546\u54c1\u8c03\u7528\u5f00\u59cb sum={}, onShelfShopMap={}", (Object)sum, (Object)JSONObject.toJSONString(onShelfShopMap));
        onShelfShopMap.forEach((key, value) -> {
            Long shopId = Long.valueOf(key);
            for (Long itemId : value) {
                ItemOnShelfReqDto itemOnShelfReqDto = this.buildItemOnShelfReqDto(shopId, itemId, this.itemLibService.getItemLibDetail(itemId));
                ArrayList<ItemOnShelfReqDto> itemOnShelfReqDtos = new ArrayList<ItemOnShelfReqDto>();
                itemOnShelfReqDtos.add(itemOnShelfReqDto);
                log.info("\u5f00\u59cb\u8c03\u7528\u4e0a\u67b6\u5546\u54c1 index={}, sum={}, shopId={}, itemOnShelfReqDtos={}", (Object)index[0], (Object)sum, (Object)(shopId + ""), (Object)JSONObject.toJSONString(itemOnShelfReqDtos));
                try {
                    this.itemServiceRest.onShelf(itemOnShelfReqDtos);
                }
                catch (Exception e) {
                    log.error("\u5546\u54c1\u4e0a\u67b6\u5f02\u5e38", (Throwable)e);
                }
                log.info("\u7ed3\u675f\u8c03\u7528\u4e0a\u67b6\u5546\u54c1 index={}, sum={}", (Object)index[0], (Object)sum);
                index[0] = index[0] + 1;
            }
        });
        log.info("\u4e0a\u67b6\u5546\u54c1\u8c03\u7528\u7ed3\u675f sum={}, onShelfShopMap={}", (Object)sum, (Object)JSONObject.toJSONString(onShelfShopMap));
        return new RestResponse();
    }

    private ItemOnShelfReqDto buildItemOnShelfReqDto(Long shopId, Long itemId, ItemChangeApplyDetailDto itemLibDetail) {
        ItemOnShelfReqDto onShelfReqDto = new ItemOnShelfReqDto();
        SkuShelfReqDto skuShelfReqDto = new SkuShelfReqDto();
        if (CollectionUtils.isNotEmpty((Collection)itemLibDetail.getSkuList())) {
            ItemSkuBundleDto skuBundleDto = (ItemSkuBundleDto)itemLibDetail.getSkuList().get(0);
            log.info("sku\u4fe1\u606f\uff1a{} \n   \u5546\u54c1id: {}", (Object)JSONObject.toJSONString((Object)skuBundleDto), (Object)itemId);
            skuShelfReqDto.setSkuId(skuBundleDto.getId());
            skuShelfReqDto.setStorage(Long.valueOf(1L));
            skuShelfReqDto.setItemId(itemId);
            if (CollectionUtils.isNotEmpty((Collection)skuBundleDto.getPrices())) {
                skuShelfReqDto.setPrice(((ItemPriceReqDto)skuBundleDto.getPrices().get(0)).getPrice());
            } else {
                skuShelfReqDto.setPrice(BigDecimal.valueOf(0.01));
            }
        }
        onShelfReqDto.setLimitMin(Integer.valueOf(1));
        onShelfReqDto.setLimitMinMode(Integer.valueOf(1));
        onShelfReqDto.setMultipleStatus(Integer.valueOf(0));
        onShelfReqDto.setRefresh(Boolean.valueOf(true));
        onShelfReqDto.setShopId(shopId);
        onShelfReqDto.setStockDisplay(Integer.valueOf(1));
        onShelfReqDto.setSkus((List)Lists.newArrayList((Object[])new SkuShelfReqDto[]{skuShelfReqDto}));
        log.info("=======================\u300b \u5546\u54c1\u4e0a\u67b6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)skuShelfReqDto));
        return onShelfReqDto;
    }

    @PostMapping(value={"/offShelfByBrandWithConfig"}, produces={"application/json"})
    @ApiOperation(value="\u6279\u91cf\u4e0b\u67b6\u5546\u54c1by\u54c1\u724ccode+\u54c1\u724c\u65b9orgId \u5e76\u4e14\u6dfb\u52a0\u5230\u7981\u552e\u914d\u7f6e\u8868")
    RestResponse<Void> offShelfByBrandWithConfig(@RequestBody ItemBrandAuthAddReqDto reqDto) {
        log.info("\u6309\u54c1\u724c\u6279\u91cf\u4e0b\u67b6\u5546\u54c1\u5e76\u6dfb\u52a0\u914d\u7f6e,\u8bf7\u6c42\u53c2\u6570 reqDto={}", (Object)JSONObject.toJSONString((Object)reqDto));
        ItemBrandAuthAddReqDto itemBrandAuthAddReqDto = ItemBrandAuthAddReqDto.builder().authType(reqDto.getAuthType()).saleControlType("1").ppfOrgId(reqDto.getPpfOrgId()).brandId(reqDto.getBrandId()).shopId(reqDto.getShopId()).itemId(reqDto.getItemId()).build();
        log.info("1 \u8c03\u7528\u7981\u552e\u914d\u7f6e\u65b0\u589e\u63a5\u53e3 itemBrandAuthAddReqDto={}", (Object)itemBrandAuthAddReqDto);
        this.itemBrandAuthApi.add(itemBrandAuthAddReqDto).getData();
        QueryItemByBrandAndOrgReqDto queryItemByBrandAndOrgReqDto = QueryItemByBrandAndOrgReqDto.builder().ppfOrgId(reqDto.getPpfOrgId()).brandId(reqDto.getBrandId()).shopId(reqDto.getShopId()).itemId(reqDto.getItemId()).build();
        log.info("2 \u8c03\u7528\u5546\u54c1\u6279\u91cf\u4e0b\u67b6 queryItemByBrandAndOrgReqDto={}", (Object)queryItemByBrandAndOrgReqDto);
        this.offShelfByBrand(queryItemByBrandAndOrgReqDto);
        return new RestResponse();
    }
}

