/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.rest;

import com.dtyunxi.cube.framework.services.ServiceEvent;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemModifyStatusReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.omnichannel.IItemOmniChannelApi;
import com.dtyunxi.yundt.module.item.api.IItemService;
import com.dtyunxi.yundt.module.item.api.IProduct;
import com.dtyunxi.yundt.module.item.api.dto.ProductInfoDto;
import com.dtyunxi.yundt.module.item.api.dto.request.ProductQueryDto;
import com.dtyunxi.yundt.module.item.api.enums.ItemEventCodeEnum;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u7ec4\u4ef6\uff1a\u4ea7\u54c1\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/item/product"})
@Deprecated
public class ProductRest {
    @Autowired
    private IProduct product;
    @Autowired
    private IItemService itemService;
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Autowired
    private IItemApi iItemApi;
    @Resource
    private IItemOmniChannelApi itemOmniChannelApi;

    @ApiOperation(value="\u65b0\u589e\u4ea7\u54c1", notes="\u65b0\u589e\u4ea7\u54c1\uff0c\u72b6\u6001\u4e3a\uff080\uff0c\u5f85\u53d1\u5e03\uff09")
    @ApiImplicitParam(dataType="ProductInfoDto", paramType="body", name="productInfoDto", required=true, value="\u4ea7\u54c1\u4fe1\u606f")
    @PostMapping(value={""})
    public RestResponse<Long> create(@RequestBody ProductInfoDto productInfoDto) {
        this.product.create(productInfoDto);
        return new RestResponse();
    }

    @ApiOperation(value="\u4fee\u6539\u4ea7\u54c1\u4fe1\u606f")
    @ApiImplicitParam(dataType="ProductInfoDto", paramType="body", name="productInfoDto", required=true, value="\u4ea7\u54c1\u4fe1\u606f")
    @PutMapping(value={""})
    public RestResponse<Long> modify(@RequestBody ProductInfoDto productInfoDto) {
        this.product.modify(productInfoDto);
        return new RestResponse();
    }

    @ApiOperation(value="\u53d1\u5e03\u4ea7\u54c1,\u652f\u6301\u6279\u91cf\u64cd\u4f5c", notes="\uff08\u6279\u91cf\uff09\u53d1\u5e03\u4ea7\u54c1,\u591a\u4e2a\u53c2\u6570\u7528\u9017\u53f7\u9694\u5f00\uff0c\u5982\u201c111,112\u201d ")
    @ApiImplicitParam(dataType="String", paramType="query", name="ids", required=true, value="\u4ea7\u54c1id")
    @PutMapping(value={"/publish"})
    public RestResponse<Void> publish(@NotBlank @RequestParam(value="ids") String ids) {
        this.product.publish(ids);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u653e\u5165\u4ea7\u54c1\u56de\u6536\u7ad9,\u652f\u6301\u6279\u91cf\u64cd\u4f5c", notes="(\u6279\u91cf)\u653e\u5165\u56de\u6536\u7ad9,\u591a\u4e2a\u53c2\u6570\u7528\u9017\u53f7\u9694\u5f00\uff0c\u5982\u201c111,112\u201d ")
    @ApiImplicitParam(dataType="String", paramType="query", name="ids", required=true, value="\u4ea7\u54c1id")
    @PutMapping(value={"/recycle"})
    public RestResponse<Void> recycle(@RequestParam(value="ids") String ids) {
        this.product.updateStatus(ids, ItemStatus.PRODUCT_DISABLE.getStatus());
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u4ece\u56de\u6536\u7ad9\u6062\u590d\u4ea7\u54c1")
    @ApiImplicitParam(dataType="String", paramType="query", name="id", required=true, value="\u4ea7\u54c1id")
    @PutMapping(value={"/recover"})
    public RestResponse<Void> recover(@RequestParam(value="id") String id) {
        List itemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemIds(id));
        if (CollectionUtils.isEmpty((Collection)itemRespDtoList)) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.ITEM_NOT_EXIST);
        }
        ItemModifyStatusReqDto itemModifyStatusReqDto = new ItemModifyStatusReqDto();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(Long.valueOf(id));
        itemModifyStatusReqDto.setIds(ids);
        itemModifyStatusReqDto.setStatus(ItemStatus.PRODUCT_WAIT_PUBLISHED.getStatus());
        this.iItemApi.batchModifyItemStatus(itemModifyStatusReqDto);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u5220\u9664\u4ea7\u54c1")
    @ApiImplicitParam(dataType="Long", paramType="path", name="id", required=true, value="\u4ea7\u54c1id")
    @DeleteMapping(value={"/{id}"})
    public RestResponse<Void> delete(@PathVariable(value="id") Long id) {
        ServiceEvent serviceEvent = new ServiceEvent(ItemEventCodeEnum.REMOVE.getCode(), ItemEventCodeEnum.REMOVE.getName(), (Object)id);
        this.itemService.doService(serviceEvent);
        return RestResponse.VOID;
    }

    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u8be6\u60c5")
    @ApiImplicitParam(dataType="Long", paramType="path", name="id", required=true, value="\u4ea7\u54c1id")
    @GetMapping(value={"/{id}"})
    public RestResponse<ProductInfoDto> getDetail(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.product.getDetail(id));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5e93\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(dataType="Int", paramType="query", name="pageNum", required=true, value="\u5f53\u524d\u9875"), @ApiImplicitParam(dataType="Int", paramType="query", name="pageSize", required=true, value="\u9875\u9762\u5927\u5c0f")})
    @GetMapping(value={"/page"})
    public RestResponse<PageInfo<ProductInfoDto>> pageQuery(ProductQueryDto productQueryDto, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return new RestResponse((Object)this.product.pageQuery(productQueryDto, pageNum, pageSize));
    }

    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u7684\u72b6\u6001\u7edf\u8ba1\u4fe1\u606f", notes="DRAFT \u5f85\u53d1\u5e03\uff1b PUBLISH \u5df2\u53d1\u5e03\uff1b RECYCLE \u56de\u6536\u7ad9")
    @GetMapping(value={"/status/count"})
    public RestResponse<Map<String, Long>> queryStatusCount(ProductQueryDto productQueryDto) {
        return new RestResponse((Object)this.product.getStatusCount(productQueryDto));
    }

    @PostMapping(value={"/updateAvailableOffline/{skuId}/{ifAvailableOffline}"})
    @ApiOperation(value="\u66f4\u65b0\u662f\u5426\u7ebf\u4e0b\u53ef\u552e", notes="\u66f4\u65b0\u662f\u5426\u7ebf\u4e0b\u53ef\u552e")
    public RestResponse<Void> updateAvailableOffline(@PathVariable(value="skuId") Long skuId, @PathVariable(value="ifAvailableOffline") Integer ifAvailableOffline) {
        return this.itemOmniChannelApi.updateAvailableOffline(skuId, ifAvailableOffline);
    }
}

