/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBizTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.PropInputTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemRelationSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRelationSkuRespDto;
import com.dtyunxi.yundt.module.item.api.IItem;
import com.dtyunxi.yundt.module.item.api.IItemLibService;
import com.dtyunxi.yundt.module.item.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.item.api.dto.ItemListInfo;
import com.dtyunxi.yundt.module.item.api.dto.request.ItemListQueryReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u5e93\u7ec4\u4ef6\uff1a\u5546\u54c1\u5e93\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/itemlib"})
public class ItemLibRest {
    private static final Logger logger = LoggerFactory.getLogger(ItemLibRest.class);
    @Autowired
    private IItemLibService itemLibService;
    @Resource
    private IItem item;

    @ApiOperation(value="\u5546\u54c1\u5e93\u8be6\u60c5", notes="\u5546\u54c1\u5e93\u8be6\u60c5")
    @ApiImplicitParam(name="itemId", paramType="path", dataType="Long", value="\u5546\u54c1id", required=true)
    @GetMapping(value={"/detail/{itemId}"})
    RestResponse<ItemChangeApplyDetailDto> detail(@PathVariable(value="itemId") Long itemId) {
        return new RestResponse((Object)this.itemLibService.getItemLibDetail(itemId));
    }

    @ApiOperation(value="\u65b0\u589e\u5546\u54c1\u5e93", notes="\u65b0\u589e\u5546\u54c1\u5e93")
    @PostMapping(value={"create"})
    RestResponse<Void> create(@Valid @RequestBody ItemChangeApplyDetailDto changApply) {
        logger.info("\u521b\u5efa\u5546\u54c1\u5e93\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)changApply));
        this.initData(changApply);
        this.itemLibService.createItemLib(changApply);
        return new RestResponse();
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u54c1", notes="\u4fee\u6539\u5546\u54c1\u7248\u672c,\u5546\u54c1\u72b6\u6001\u53d8\u4e3a\uff080\uff0c\u5f85\u53d1\u5e03\uff09")
    @PutMapping(value={"create"})
    RestResponse<Void> update(@Valid @RequestBody ItemChangeApplyDetailDto changApply) {
        logger.info("\u4fee\u6539\u5546\u54c1\u5e93\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)changApply));
        this.initData(changApply);
        this.itemLibService.updateItemLib(changApply);
        return new RestResponse();
    }

    @ApiOperation(value="\u5546\u54c1\u5e93\u5217\u8868", notes="\u5546\u54c1\u5e93\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", paramType="query", dataType="Int", defaultValue="1", required=true), @ApiImplicitParam(name="pageSize", paramType="query", dataType="Int", defaultValue="10", required=true)})
    @GetMapping(value={"/list"})
    RestResponse<ItemListInfo> list(ItemListQueryReqDto itemListQueryReqDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        logger.info("\u5546\u54c1\u5e93\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)itemListQueryReqDto));
        itemListQueryReqDto.setBizType(ItemBizTypeEnum.ITEM_LIB.getType());
        return new RestResponse((Object)this.item.query(itemListQueryReqDto, pageNum, pageSize));
    }

    @PostMapping(value={"relation/page"})
    @ApiOperation(value="\u5546\u54c1\u5173\u7cfbsku\u7684\u4fe1\u606f\u67e5\u8be2", notes="\u5546\u54c1\u5173\u7cfbsku\u7684\u4fe1\u606f\u67e5\u8be2")
    RestResponse<PageInfo<ItemRelationSkuRespDto>> queryItemRelationSku(@RequestBody ItemRelationSkuReqDto itemRelationSkuReqDto, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        return new RestResponse((Object)this.itemLibService.queryItemRelationSku(itemRelationSkuReqDto, pageNum, pageSize));
    }

    @GetMapping(value={"/getDefalutPrice"})
    @ApiOperation(value="\u83b7\u53d6\u52a0\u4ef7\u5206\u9500\u9ed8\u8ba4\u7684\u767e\u5206\u6bd4\u503c", notes="\u83b7\u53d6\u52a0\u4ef7\u5206\u9500\u9ed8\u8ba4\u7684\u767e\u5206\u6bd4\u503c")
    RestResponse<String> getDefalutPrice() {
        return new RestResponse((Object)this.itemLibService.getDefalutPrice());
    }

    private void initData(ItemChangeApplyDetailDto changApply) {
        this.checkItemParam(changApply);
        this.setSingleSku(changApply);
        this.setItemChangeApplyAttr(changApply);
    }

    private void setSingleSku(ItemChangeApplyDetailDto itemChangeApplyDetailDto) {
        if (itemChangeApplyDetailDto.getSkus().size() == 1) {
            ItemBundleReqDto sku = (ItemBundleReqDto)itemChangeApplyDetailDto.getSkus().get(0);
            sku.setBarCode(itemChangeApplyDetailDto.getItemBarCode());
            if (StringUtils.isEmpty((String)sku.getAttr())) {
                sku.setAttr("");
            }
        }
    }

    private void setItemChangeApplyAttr(ItemChangeApplyDetailDto itemChangeApplyDetailDto) {
        JSONObject attrsJson = JSONObject.parseObject((String)itemChangeApplyDetailDto.getAttrs());
        if (null == attrsJson) {
            attrsJson = new JSONObject();
        }
        attrsJson.put("sellPoint", (Object)itemChangeApplyDetailDto.getSellPoint());
        attrsJson.put("itemBarCode", (Object)itemChangeApplyDetailDto.getItemBarCode());
        attrsJson.put("propList", (Object)itemChangeApplyDetailDto.getPropList());
        attrsJson.put("backDirList", (Object)itemChangeApplyDetailDto.getBackDirList());
        itemChangeApplyDetailDto.setAttrs(attrsJson.toString());
    }

    private void checkItemParam(ItemChangeApplyDetailDto item) {
        BigDecimal maxFreight = BigDecimal.valueOf(9.999999999E7);
        BigDecimal maxPrice = BigDecimal.valueOf(9.999999999E7);
        String msg = null;
        if (StringUtils.length((String)item.getItemName()) > 200) {
            msg = "\u5546\u54c1\u540d\u79f0[1-200]\u5b57\u7b26.";
        }
        if (StringUtils.length((String)item.getSellPoint()) > 200) {
            msg = "\u5546\u54c1\u5356\u70b9[1-200]\u5b57\u7b26.";
        }
        if (StringUtils.length((String)item.getItemCode()) > 32) {
            msg = "\u5546\u54c1\u7f16\u7801[1-32]\u5b57\u7b26.";
        }
        if (StringUtils.length((String)item.getItemBarCode()) > 32) {
            msg = "\u5546\u54c1\u6761\u7801[1-32]\u5b57\u7b26.";
        }
        if (CollectionUtils.isEmpty((Collection)item.getBackDirList())) {
            msg = "\u540e\u53f0\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a.";
        }
        if (null != item.getUniformFreight() && item.getUniformFreight().compareTo(maxFreight) == 1) {
            msg = "\u8fd0\u8d39\u8303\u56f4[0-99999999.99].";
        }
        if (StringUtils.isNotBlank((String)item.getBrief()) && item.getBrief().length() > 4000) {
            msg = "\u5546\u54c1\u4ecb\u7ecd[0-4000]\u5b57\u7b26.";
        }
        if (CollectionUtils.isEmpty((Collection)item.getSkus())) {
            msg = "\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a.";
        } else {
            for (ItemBundleReqDto sku : item.getSkus()) {
                if (StringUtils.isBlank((String)sku.getCode())) {
                    sku.setCode(null);
                } else if (StringUtils.length((String)sku.getCode()) > 32) {
                    msg = "\u89c4\u683c\u7f16\u7801[1-32]\u5b57\u7b26.";
                }
                if (StringUtils.length((String)sku.getBarCode()) > 32) {
                    msg = "\u89c4\u683c\u6761\u7801[1-32]\u5b57\u7b26.";
                }
                if (CollectionUtils.isEmpty((Collection)sku.getPrices())) {
                    msg = "\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a.";
                    continue;
                }
                BigDecimal retailPrice = null;
                BigDecimal oriPrice = null;
                for (ItemPriceReqDto price : sku.getPrices()) {
                    if (StringUtils.isEmpty((String)price.getPriceType())) {
                        throw new BizException("\u4ef7\u683c\u7c7b\u578bpriceType\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (null == price.getPrice()) {
                        throw new BizException("\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if ("RETAIL_PRICE".equals(price.getPriceType())) {
                        retailPrice = price.getPrice();
                    } else if ("PRICE".equals(price.getPriceType())) {
                        oriPrice = price.getPrice();
                    } else {
                        throw new BizException("\u4ef7\u683c\u7c7b\u578b\u4e0d\u6b63\u786e\uff01");
                    }
                    if (null == price.getPrice() || price.getPrice().compareTo(maxPrice) > 0) {
                        msg = "\u4ef7\u683c\u8303\u56f4[0-99999999.99].";
                    }
                    if (null == retailPrice || null == oriPrice || oriPrice.compareTo(retailPrice) >= 0) continue;
                    throw new BizException("\u96f6\u552e\u4ef7\u4e0d\u80fd\u5927\u4e8e\u5b9a\u4ef7\uff01");
                }
            }
        }
        List itemPropGroupDtoList = item.getPropGroupDtoList();
        if (CollectionUtils.isNotEmpty((Collection)itemPropGroupDtoList)) {
            itemPropGroupDtoList.forEach(itemPropGroupDto -> {
                List itemPropNameDtoList = itemPropGroupDto.getPropNameDtoList();
                if (CollectionUtils.isNotEmpty((Collection)itemPropNameDtoList)) {
                    itemPropNameDtoList.forEach(itemPropNameDto -> {
                        Integer inputType = itemPropNameDto.getInputType();
                        String inputValue = itemPropNameDto.getInputValue();
                        List choose = itemPropNameDto.getChoose();
                        Integer required = itemPropNameDto.getRequired();
                        Integer charSizeLimit = itemPropNameDto.getCharSizeLimit();
                        if (inputType != null && required != null && 1 == required) {
                            if (inputType.intValue() == PropInputTypeEnum.INPUT.getCode() && StringUtils.isBlank((String)inputValue)) {
                                throw new BizException(String.format("\u5c5e\u6027[%s]\u4e3a\u5fc5\u586b, \u4e0d\u80fd\u4e3a\u7a7a", itemPropNameDto.getName()));
                            }
                            if (inputType.intValue() == PropInputTypeEnum.SELECT.getCode() && CollectionUtils.isEmpty((Collection)choose)) {
                                throw new BizException(String.format("\u5c5e\u6027[%s]\u4e3a\u5fc5\u9009, \u4e0d\u80fd\u4e3a\u7a7a", itemPropNameDto.getName()));
                            }
                        }
                        if (inputType != null && PropInputTypeEnum.INPUT.getCode() == inputType.intValue() && StringUtils.isNotBlank((String)inputValue) && charSizeLimit != null && charSizeLimit > 0 && inputValue.length() > charSizeLimit) {
                            throw new BizException(String.format("\u5c5e\u6027[%s]\u7684\u503c\u6700\u5927\u957f\u5ea6\u4e3a[%s]", itemPropNameDto.getName(), charSizeLimit));
                        }
                    });
                }
            });
        }
        if (StringUtils.isNotBlank((String)msg)) {
            throw new BizException(msg);
        }
    }
}

