/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.scheduleds;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.control.api.dto.constant.AmountStatusEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.IsMonthSettleEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.TradeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemAmountOptVo;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlItemAmountRuleService;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlItemAmountRuleDas;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlItemAmountRuleEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component(value="dealMonthSettleScheduled")
@Scope(value="prototype")
public class DealMonthSettleScheduled
extends SingleTupleScheduleEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DealMonthSettleScheduled.class);
    @Resource
    private TrControlItemAmountRuleDas trControlItemAmountRuleDas;
    @Resource
    private ITrControlItemAmountRuleService itemAmountRuleService;
    @Resource
    private ITrControlItemAmountRuleService controlItemAmountRuleService;
    private static final Integer PAGESIZE = 20000;

    public void dealLastMonthSettle(String dateString) {
        Integer pageNo = 1;
        Date date = null;
        date = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dateString}) ? DateUtil.parseDate((String)dateString, (String)"yyyy-MM-dd") : new Date();
        String nowMonth = DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)date);
        String lastMonth = DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)DateUtil.addMonths((Date)date, (int)-1));
        LOGGER.info("\u3010\u5f00\u59cb\u6267\u884c\u8ba2\u8d27\u989d\u5ea6\u6708\u7ed3\u5904\u7406\u3011\u8ba2\u8d27\u989d\u5ea6\u6708\u7ed3\u5904\u7406\u65f6\u95f4\u65f6\u95f4\u70b9\uff1a{}", (Object)JSON.toJSONString(Arrays.asList(nowMonth, lastMonth)));
        ArrayList resultList = Lists.newArrayList();
        Boolean result = true;
        while (result.booleanValue()) {
            result = this.batchItemAmountRule(resultList, nowMonth, lastMonth, pageNo, PAGESIZE);
            Integer n = pageNo;
            Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean batchItemAmountRule(List<TrControlItemAmountRuleEo> resultList, String nowMonth, String lastMonth, Integer pageNo, Integer pageSize) {
        LOGGER.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u6708\u7ed3\u5904\u7406\u3011\u9057\u6f0f\u5355\u6b21\u989d\u5ea6\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(resultList));
        List<TrControlItemAmountRuleEo> trControlItemAmountRuleEos = this.itemAmountRuleService.queryTrControlItemAmountRuleListOrderByCustomerCode(Arrays.asList(nowMonth, lastMonth), (pageNo - 1) * pageSize, pageSize);
        if (ObjectUtils.isEmpty(trControlItemAmountRuleEos)) {
            Map<String, List<TrControlItemAmountRuleEo>> collect = resultList.stream().collect(Collectors.groupingBy(c -> c.getOrgId() + c.getCustomerCode()));
            collect.forEach((k, v) -> this.settleMonthData((List<TrControlItemAmountRuleEo>)v, nowMonth, lastMonth));
            return false;
        }
        trControlItemAmountRuleEos.addAll(resultList);
        resultList.clear();
        Map<String, List<TrControlItemAmountRuleEo>> collect = trControlItemAmountRuleEos.stream().collect(Collectors.groupingBy(c -> c.getOrgId() + c.getCustomerCode()));
        collect.forEach((k, v) -> {
            if (v.size() < 2) {
                resultList.addAll((Collection<TrControlItemAmountRuleEo>)v);
                return;
            }
            this.settleMonthData((List<TrControlItemAmountRuleEo>)v, nowMonth, lastMonth);
        });
        return true;
    }

    public void settleMonthData(List<TrControlItemAmountRuleEo> itemAmountRuleEos, String nowMonth, String lastMonth) {
        TrControlItemAmountRuleEo itemAmountRuleEoLast;
        Map<Date, List<TrControlItemAmountRuleEo>> collectMap = itemAmountRuleEos.stream().collect(Collectors.groupingBy(TrControlItemAmountRuleEo::getAmountTime));
        List<TrControlItemAmountRuleEo> controlItemAmountRuleEoNowList = collectMap.getOrDefault(DateUtil.parseDate((String)nowMonth, (String)DatePattern.DATE_PATTERN.getPattern()), Lists.newArrayList());
        List<TrControlItemAmountRuleEo> controlItemAmountRuleEoLastList = collectMap.getOrDefault(DateUtil.parseDate((String)lastMonth, (String)DatePattern.DATE_PATTERN.getPattern()), Lists.newArrayList());
        TrControlItemAmountRuleEo itemAmountRuleEoNow = ObjectUtils.isEmpty(controlItemAmountRuleEoNowList) ? null : (TrControlItemAmountRuleEo)controlItemAmountRuleEoNowList.stream().findFirst().get();
        TrControlItemAmountRuleEo trControlItemAmountRuleEo = itemAmountRuleEoLast = ObjectUtils.isEmpty(controlItemAmountRuleEoLastList) ? null : (TrControlItemAmountRuleEo)controlItemAmountRuleEoLastList.stream().findFirst().get();
        if (!ObjectUtils.isEmpty(itemAmountRuleEoLast)) {
            itemAmountRuleEoLast.setStatus(AmountStatusEnum.USED.getType());
            int lastResult = this.trControlItemAmountRuleDas.update((BaseEo)itemAmountRuleEoLast);
            if (lastResult < 0) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5b9a\u65f6\u4efb\u52a1\u3011\u5904\u7406\u5931\u6548\u8ba2\u8d27\u989d\u5ea6\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)itemAmountRuleEoLast));
            }
        }
        if (!ObjectUtils.isEmpty((Object)itemAmountRuleEoNow)) {
            itemAmountRuleEoNow.setStatus(AmountStatusEnum.USING.getType());
            int nowResult = this.trControlItemAmountRuleDas.update((BaseEo)itemAmountRuleEoNow);
            if (nowResult < 0) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5b9a\u65f6\u4efb\u52a1\u3011\u5904\u7406\u5f53\u6708\u8ba2\u8d27\u989d\u5ea6\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)itemAmountRuleEoNow));
            }
        }
        if (itemAmountRuleEos.size() < 2 && ObjectUtils.isEmpty((Object)itemAmountRuleEoLast)) {
            return;
        }
        if (itemAmountRuleEos.size() < 2 && !ObjectUtils.isEmpty((Object)itemAmountRuleEoLast) && IsMonthSettleEnum.SETTLE_FALSE.getType().equals(itemAmountRuleEoLast.getIsMonthSettle()) && itemAmountRuleEoLast.getSurplusAmount().compareTo(BigDecimal.ZERO) == 1) {
            TrControlItemAmountRuleEo itemAmountRuleEo = new TrControlItemAmountRuleEo(itemAmountRuleEoLast.getCustomerCode(), itemAmountRuleEoLast.getCustomerName(), DateUtil.parseDate((String)nowMonth, (String)"yyyy-MM-dd"), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, IsMonthSettleEnum.SETTLE_FALSE.getType(), AmountStatusEnum.USING.getType(), itemAmountRuleEoLast.getOrgId());
            int result = this.trControlItemAmountRuleDas.insert((BaseEo)itemAmountRuleEo);
            if (result < 0) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5b9a\u65f6\u4efb\u52a1\u3011\u5904\u7406\u8f6c\u6708\u7ed3\uff0c\u9ed8\u8ba4\u63d2\u5165\u5f53\u524d\u6708\u4efd\u8ba2\u8d27\u989d\u5ea6\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)itemAmountRuleEo));
            }
            itemAmountRuleEoNow = itemAmountRuleEo;
        }
        if (IsMonthSettleEnum.SETTLE_FALSE.getType().equals(itemAmountRuleEoLast.getIsMonthSettle()) && itemAmountRuleEoLast.getSurplusAmount().compareTo(BigDecimal.ZERO) == 1) {
            ItemAmountOptVo itemAmountOptVo = new ItemAmountOptVo();
            itemAmountOptVo.setCustomerCode(itemAmountRuleEoLast.getCustomerCode());
            itemAmountOptVo.setCustomerName(itemAmountRuleEoLast.getCustomerName());
            itemAmountOptVo.setId(itemAmountRuleEoNow.getId());
            itemAmountOptVo.setAmount(itemAmountRuleEoLast.getSurplusAmount());
            itemAmountOptVo.setTypeEnum(TradeTypeEnum.AMOUNT_MONTH_SETTLE);
            itemAmountOptVo.setOrgId(itemAmountRuleEoLast.getOrgId());
            itemAmountOptVo.setAmountTime(itemAmountRuleEoNow.getAmountTime());
            this.itemAmountRuleService.handleAmount(itemAmountOptVo);
        }
    }

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        String content = taskMsg.getContent();
        LOGGER.info("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u8c03\u5ea6\u4efb\u52a1\u3011\u8c03\u5ea6\u4f20\u9012\u53c2\u6570\uff1a{}", (Object)content);
        this.dealLastMonthSettle(content);
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

