/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.scheduleds;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountGrantIsReturnEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountGrantStatus;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountWayEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlGiftResultReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftGrantRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftGrantRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.biz.scheduleds.DisabledGiftScheduled;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftGrantRecordService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftResultService;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftGrantRecordEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="giftGrantScheduled")
@Scope(value="prototype")
public class GiftGrantScheduled
extends SingleTupleScheduleEvent {
    private final Logger logger = LoggerFactory.getLogger(DisabledGiftScheduled.class);
    @Resource
    private ITrControlGiftGrantRecordService controlGiftGrantRecordService;
    @Resource
    private ITrControlGiftResultService controlGiftResultService;

    public void disabledGiftAmountScheduled(String grantId) {
        Date date = new Date();
        this.logger.info("\u3010\u4efb\u52a1\u8c03\u5ea6\u3011\u5f00\u59cb\u5904\u7406\u5373\u5c06\u53d1\u653e\u7684\u9884\u652f\u989d\u5ea6 {}", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)date));
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{grantId})) {
            TrControlGiftGrantRecordRespDto giftGrantRecordRespDto = this.controlGiftGrantRecordService.queryById(Long.valueOf(grantId));
            if (giftGrantRecordRespDto.getGrantTime().compareTo(date) == -1 && giftGrantRecordRespDto.getStatus().equals(GiftAmountGrantStatus.PENDING_SEND.getType())) {
                TrControlGiftGrantRecordEo controlGiftGrantRecordEo = new TrControlGiftGrantRecordEo();
                DtoHelper.dto2Eo((BaseVo)giftGrantRecordRespDto, (BaseEo)controlGiftGrantRecordEo);
                this.grantGiftAmountAndRecord(controlGiftGrantRecordEo);
            }
        } else {
            List<TrControlGiftGrantRecordEo> controlGiftGrantRecordAndPendingSend = this.controlGiftGrantRecordService.getControlGiftGrantRecordAndPendingSend(date, GiftAmountGrantStatus.PENDING_SEND.getType());
            AssertUtils.notEmpty(controlGiftGrantRecordAndPendingSend, (String)"\u5f53\u524d\u65f6\u95f4\u70b9\u4e0d\u5b58\u5728\u5f85\u53d1\u653e\u6570\u636e");
            controlGiftGrantRecordAndPendingSend.forEach(c -> this.grantGiftAmountAndRecord((TrControlGiftGrantRecordEo)c));
        }
    }

    public void grantGiftAmountAndRecord(TrControlGiftGrantRecordEo giftGrantRecordEo) {
        giftGrantRecordEo.setStatus(GiftAmountGrantIsReturnEnum.NEED.getType().equals(giftGrantRecordEo.getIsReturn()) ? GiftAmountGrantStatus.PENDING_RETURN.getType() : GiftAmountGrantStatus.NOT_NEED.getType());
        BizControlGiftResultReqDto bizControlGiftResultReqDto = new BizControlGiftResultReqDto(giftGrantRecordEo.getRuleId(), giftGrantRecordEo.getCustomerCode(), giftGrantRecordEo.getCustomerName(), giftGrantRecordEo.getOrgId(), giftGrantRecordEo.getAdvanceAmount(), giftGrantRecordEo.getAmountType(), giftGrantRecordEo.getGrantNo(), GiftAmountWayEnum.WAY_08.getType(), null);
        this.controlGiftResultService.modifyBillData(bizControlGiftResultReqDto);
        TrControlGiftGrantRecordReqDto controlGiftGrantRecordReqDto = new TrControlGiftGrantRecordReqDto();
        DtoHelper.eo2Dto((BaseEo)giftGrantRecordEo, (BaseVo)controlGiftGrantRecordReqDto);
        this.controlGiftGrantRecordService.modifyTrControlGiftGrantRecord(controlGiftGrantRecordReqDto);
    }

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        this.disabledGiftAmountScheduled(taskMsg.getContent());
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

