/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CountOrderItemNumReqDto;
import com.dtyunxi.tcbj.api.dto.response.CountorderItemNumRespDto;
import com.dtyunxi.tcbj.api.query.IControlReportQueryApi;
import com.dtyunxi.tcbj.center.control.api.dto.constant.CalculateTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleRangeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlItemReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlItemAreaReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlItemCustomerReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlBaseReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.base.ControlItemBaseReq;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizChangeRuleResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemAreaExtRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemLimitContentRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemOrderRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlToCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.SelectTimeRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemAreaService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemCustomerService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemOrderService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlItemAreaDas;
import com.dtyunxi.tcbj.center.control.dao.das.ControlItemCustomerDas;
import com.dtyunxi.tcbj.center.control.dao.das.ControlItemRuleDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlItemAreaEo;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlItemCustomerEo;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlItemRuleEo;
import com.dtyunxi.tcbj.center.control.dao.mapper.ControlItemAreaMapper;
import com.dtyunxi.tcbj.center.control.dao.mapper.ControlItemCustomerMapper;
import com.dtyunxi.tcbj.center.control.dao.mapper.ControlItemRuleMapper;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ControlItemServiceImpl
implements IControlItemService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlItemRuleDas controlItemRuleDas;
    @Resource
    private IControlItemCustomerService customerService;
    @Resource
    private ControlItemCustomerDas controlItemCustomerDas;
    @Resource
    private ControlItemCustomerMapper controlItemCustomerMapper;
    @Resource
    private ControlItemAreaMapper controlItemAreaMapper;
    @Resource
    private ControlItemAreaDas controlItemAreaDas;
    @Resource
    private IControlItemAreaService areaService;
    @Resource
    private IControlReportQueryApi controlReportQueryApi;
    @Resource
    private ControlItemRuleMapper controlItemRuleMapper;
    @Resource
    private IControlItemService controlItemService;
    @Resource
    private IControlItemOrderService controlItemOrderService;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto> addControlItem(BizControlItemReqDto addReqDto) {
        BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto> resultRespDto = new BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto>();
        if (RuleEnableEnum.ENABLE.getValue().equals(addReqDto.getEnable()) && !(resultRespDto = this.verifyRule(addReqDto)).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_NOEXIT.getValue())) {
            return resultRespDto;
        }
        ControlItemRuleEo controlItemRuleEo = new ControlItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlItemRuleEo);
        this.controlItemRuleDas.insert((BaseEo)controlItemRuleEo);
        Long ruleId = controlItemRuleEo.getId();
        if (ruleId == null) {
            this.logger.error("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u6dfb\u52a0\u7ba1\u63a7\u89c4\u5219\u5931\u8d25\uff0c\u63d0\u4ea4\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
        String requestId = ServiceContext.getContext().getRequestId();
        ExecutorUtils.execute(() -> {
            MDC.put((String)"yes.req.requestId", (String)requestId);
            this.logger.info("\u5f02\u6b65\u5904\u7406\u5173\u8054\u5173\u7cfb");
            this.handleAddRel(addReqDto, controlItemRuleEo, ruleId);
        });
        return resultRespDto;
    }

    private void handleAddRel(BizControlItemReqDto addReqDto, ControlItemRuleEo controlItemRuleEo, Long ruleId) {
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getCustomerList())) {
            this.logger.info("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6307\u5b9a\u5ba2\u6237,\u5ba2\u6237\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)addReqDto.getCustomerList());
            addReqDto.getCustomerList().stream().forEach(customer -> {
                customer.setRuleId(ruleId);
                customer.setCalculateType(addReqDto.getCalculateType());
                customer.setEnable(addReqDto.getEnable());
                customer.setId(Long.valueOf(IdGenrator.getDistributedId()));
            });
            this.customerService.addOrderCustomers(addReqDto.getCustomerList());
            if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(controlItemRuleEo.getCalculateType())) {
                List customerList = addReqDto.getCustomerList();
                ArrayList customerEoLis = Lists.newArrayList();
                DtoHelper.dtoList2EoList((Collection)customerList, (Collection)customerEoLis, ControlItemCustomerEo.class);
                ArrayList controlItemBaseReqs = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)controlItemBaseReqs, (Collection)customerEoLis, ControlItemBaseReq.class);
                this.countItemNum(true, controlItemBaseReqs);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getAreaList())) {
            this.logger.info("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6309\u5ba2\u6237\u533a\u57df,\u533a\u57df\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)addReqDto.getAreaList());
            ArrayList areaList = Lists.newArrayList();
            addReqDto.getAreaList().forEach(areaItem -> areaItem.getAreaCodeList().forEach(areaCode -> {
                ControlItemAreaReqDto controlItemAreaReqDto = new ControlItemAreaReqDto();
                CubeBeanUtils.copyProperties((Object)controlItemAreaReqDto, (Object)areaItem, (String[])new String[0]);
                if (areaCode.equals(areaItem.getAreaCode())) {
                    controlItemAreaReqDto.setAreaEnable(RuleEnableEnum.ENABLE.getValue());
                } else {
                    controlItemAreaReqDto.setAreaEnable(RuleEnableEnum.STOP.getValue());
                    controlItemAreaReqDto.setItemAreaPid(areaItem.getAreaCode());
                }
                controlItemAreaReqDto.setSharePurchaseRestriction(addReqDto.getSharePurchaseRestriction());
                controlItemAreaReqDto.setRuleId(ruleId);
                controlItemAreaReqDto.setCalculateType(addReqDto.getCalculateType());
                controlItemAreaReqDto.setEnable(addReqDto.getEnable());
                controlItemAreaReqDto.setAreaCode(areaCode);
                controlItemAreaReqDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
                controlItemAreaReqDto.setPurchasedCount(Integer.valueOf(0));
                areaList.add(controlItemAreaReqDto);
            }));
            this.areaService.addControlAreaList(areaList);
            if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(controlItemRuleEo.getCalculateType())) {
                ArrayList itemAreaEos = Lists.newArrayList();
                DtoHelper.dtoList2EoList((Collection)areaList, (Collection)itemAreaEos, ControlItemAreaEo.class);
                List collect1 = itemAreaEos.stream().filter(c -> c.getAreaEnable().equals(RuleEnableEnum.ENABLE.getValue())).collect(Collectors.toList());
                ArrayList controlItemBaseReqs = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)controlItemBaseReqs, collect1, ControlItemBaseReq.class);
                this.countItemNum(false, controlItemBaseReqs);
            }
        }
    }

    private BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto> verifyRule(BizControlItemReqDto addReqDto) {
        ArrayList list;
        BizChangeRuleResultRespDto resultRespDto = new BizChangeRuleResultRespDto();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getCustomerList())) {
            Map<String, List<ControlItemCustomerReqDto>> newCustomerItemMap = addReqDto.getCustomerList().stream().collect(Collectors.groupingBy(dto -> dto.getCustomerId() + "_" + dto.getItemId()));
            ArrayList newCustomerItemList = Lists.newArrayList();
            for (List<ControlItemCustomerReqDto> list2 : newCustomerItemMap.values()) {
                if (list2.size() <= 1) continue;
                list = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)list, list2, ControlItemCustomerRespDto.class);
                newCustomerItemList.addAll(list);
            }
            if (CollectionUtils.isNotEmpty((Collection)newCustomerItemList)) {
                resultRespDto.setCustomerList((List)newCustomerItemList);
                resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_NEW_EXIT.getValue());
                return resultRespDto;
            }
            this.logger.info("[\u51b2\u7a81\u6821\u9a8c]\uff0c\u6307\u5b9a\u5ba2\u6237");
            List<ControlItemCustomerRespDto> verifyCustomerRespDtos = this.customerService.verifyRuleForCustomer(addReqDto);
            this.logger.info("[\u51b2\u7a81\u6821\u9a8c]\uff0c\u6307\u5b9a\u5ba2\u6237\uff1a{}", (Object)JacksonUtil.toJson((Object)verifyCustomerRespDtos));
            if (CollectionUtils.isNotEmpty((Collection)verifyCustomerRespDtos)) {
                resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                resultRespDto.setCustomerList((List)verifyCustomerRespDtos);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getAreaList())) {
            Map<String, List<ControlItemAreaReqDto>> newAreaItemMap = addReqDto.getAreaList().stream().collect(Collectors.groupingBy(dto -> dto.getAreaCode() + "_" + dto.getItemId()));
            ArrayList newAreaItemList = Lists.newArrayList();
            for (List<ControlItemAreaReqDto> list3 : newAreaItemMap.values()) {
                if (list3.size() <= 1) continue;
                list = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)list, list3, ControlItemAreaRespDto.class);
                newAreaItemList.addAll(list);
            }
            if (CollectionUtils.isNotEmpty((Collection)newAreaItemList)) {
                resultRespDto.setAreaList((List)newAreaItemList);
                resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_NEW_EXIT.getValue());
                return resultRespDto;
            }
            List<ControlItemAreaRespDto> verifyAreaRespDtos = this.areaService.verifyRuleForArea(addReqDto, addReqDto.getId());
            if (CollectionUtils.isNotEmpty(verifyAreaRespDtos)) {
                this.logger.error("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u89c4\u5219\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u7684\u5ba2\u6237\u533a\u57df\uff0c\u91cd\u590d\u7684\u5ba2\u6237\u533a\u57df\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(verifyAreaRespDtos));
                List list4 = verifyAreaRespDtos.stream().map(ControlItemAreaRespDto::getRuleId).distinct().collect(Collectors.toList());
                ControlItemRuleEo queryEo = new ControlItemRuleEo();
                if (!ObjectUtils.isEmpty((Object)addReqDto.getId())) {
                    list4.remove(addReqDto.getId());
                }
                queryEo.setOrgId(addReqDto.getOrgId());
                queryEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", list4)}));
                ArrayList orderRuleList = ObjectUtils.isEmpty(list4) ? Lists.newArrayList() : this.controlItemRuleDas.select((BaseEo)queryEo);
                List itemRuleEos = Optional.ofNullable(orderRuleList).orElseGet(Collections::emptyList).stream().filter(rule -> rule.getControlEndDate().compareTo(addReqDto.getControlStartDate()) >= 0).collect(Collectors.toList());
                ArrayList conflictItemRuleList = Lists.newArrayList();
                DtoHelper.eoList2DtoList(itemRuleEos, (Collection)conflictItemRuleList, ControlItemRespDto.class);
                this.logger.error("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u76f8\u4e92\u51b2\u7a81\u7684\u5355\u54c1\u7ba1\u63a7\u89c4\u5219\u6709\uff1a{}", (Object)JSON.toJSONString((Object)conflictItemRuleList));
                if (CollectionUtils.isNotEmpty(itemRuleEos)) {
                    resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                    List conflictRuleIdList = itemRuleEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    List conflictAreaList = verifyAreaRespDtos.stream().filter(verifyArea -> conflictRuleIdList.contains(verifyArea.getRuleId())).collect(Collectors.toList());
                    resultRespDto.setConflictRuleList((List)conflictItemRuleList);
                    resultRespDto.setAreaList(conflictAreaList);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getAreaList())) {
            Map<Long, List<ControlItemAreaReqDto>> areaItemMap = addReqDto.getAreaList().stream().collect(Collectors.groupingBy(dto -> dto.getItemId()));
            for (List<ControlItemAreaReqDto> dtoList : areaItemMap.values()) {
                Map<String, List<ControlItemAreaReqDto>> map = dtoList.stream().collect(Collectors.groupingBy(dto -> dto.getAreaCode()));
                if (dtoList.size() <= 1) continue;
                for (ControlItemAreaReqDto areaReqDto : dtoList) {
                    String code = areaReqDto.getAreaCode();
                    List areaCodes = dtoList.stream().map(ControlItemAreaReqDto::getAreaCode).filter(areaCode -> !code.equals(areaCode)).collect(Collectors.toList());
                    CustomerAreaListReqDto reqDto = new CustomerAreaListReqDto();
                    reqDto.setOrgInfoId(addReqDto.getOrgId());
                    reqDto.setCode(code);
                    List subCodes = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.querySubCodeAll(reqDto));
                    for (String areaCode2 : areaCodes) {
                        if (!subCodes.contains(areaCode2)) continue;
                        throw new BizException(ControlExceptionCode.ENABLE_UNALLOW.getCode(), "\u5546\u54c1" + areaReqDto.getItemName() + "\u6240\u5c5e\u533a\u57df\u91cd\u53e0" + map.get(areaCode2).get(0).getAreaName() + "\u4e3a" + areaReqDto.getAreaName() + "\u7684\u5b50\u533a\u57df");
                    }
                }
            }
        }
        return resultRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto> modifyControlItem(BizControlItemReqDto modifyReqDto) {
        this.logger.info("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u4fee\u6539\u5355\u54c1\u7ba1\u63a7\u89c4\u5219");
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"\u5355\u54c1\u7ba1\u63a7\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto> resultRespDto = new BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto>();
        ControlItemRuleEo originConItemEo = (ControlItemRuleEo)this.controlItemRuleDas.selectByPrimaryKey(modifyReqDto.getId());
        AssertUtils.notNull((Object)originConItemEo.getId(), (String)"\u539f\u5355\u54c1\u7ba1\u63a7\u89c4\u5219\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        if (RuleEnableEnum.ENABLE.getValue().equals(originConItemEo.getEnable())) {
            this.modifyEnableStatusControlItem(modifyReqDto, originConItemEo);
            return resultRespDto;
        }
        if (RuleEnableEnum.STOP.getValue().equals(originConItemEo.getEnable())) {
            throw ControlExceptionCode.FOBBIN_MDOIFY_STOP_STATUS.getException();
        }
        if (RuleEnableEnum.ENABLE.getValue().equals(modifyReqDto.getEnable()) && !(resultRespDto = this.verifyRule(modifyReqDto)).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_NOEXIT.getValue())) {
            return resultRespDto;
        }
        ControlItemRuleEo updateItemRuleEo = new ControlItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)updateItemRuleEo);
        this.controlItemRuleDas.updateSelective((BaseEo)updateItemRuleEo);
        Long ruleId = modifyReqDto.getId();
        String requestId = ServiceContext.getContext().getRequestId();
        ExecutorUtils.execute(() -> {
            MDC.put((String)"yes.req.requestId", (String)requestId);
            this.logger.info("\u5f02\u6b65\u5904\u7406\u5173\u8054\u5173\u7cfb");
            this.handleModifyRel(modifyReqDto, updateItemRuleEo, ruleId);
        });
        return resultRespDto;
    }

    private void handleModifyRel(BizControlItemReqDto modifyReqDto, ControlItemRuleEo updateItemRuleEo, Long ruleId) {
        this.customerService.removeCustomerByRuleId(ruleId);
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getCustomerList())) {
            this.logger.info("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u4fee\u6539\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6307\u5b9a\u5ba2\u6237,\u5ba2\u6237\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", JSON.toJSON((Object)modifyReqDto.getCustomerList()));
            modifyReqDto.getCustomerList().stream().forEach(customer -> {
                customer.setRuleId(ruleId);
                customer.setEnable(modifyReqDto.getEnable());
                customer.setCalculateType(modifyReqDto.getCalculateType());
                customer.setId(Long.valueOf(IdGenrator.getDistributedId()));
            });
            this.customerService.addOrderCustomers(modifyReqDto.getCustomerList());
            if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(updateItemRuleEo.getCalculateType())) {
                List customerList = modifyReqDto.getCustomerList();
                ArrayList customerEoLis = Lists.newArrayList();
                DtoHelper.dtoList2EoList((Collection)customerList, (Collection)customerEoLis, ControlItemCustomerEo.class);
                ArrayList controlItemBaseReqs = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)controlItemBaseReqs, (Collection)customerEoLis, ControlItemBaseReq.class);
                this.countItemNum(true, controlItemBaseReqs);
            }
        }
        this.areaService.removeControlAreaByRuleId(ruleId);
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getAreaList())) {
            this.logger.info("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6309\u5ba2\u6237\u533a\u57df,\u533a\u57df\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)modifyReqDto.getAreaList());
            ArrayList areaList = Lists.newArrayList();
            modifyReqDto.getAreaList().forEach(areaItem -> areaItem.getAreaCodeList().forEach(areaCode -> {
                ControlItemAreaReqDto controlItemAreaReqDto = new ControlItemAreaReqDto();
                CubeBeanUtils.copyProperties((Object)controlItemAreaReqDto, (Object)areaItem, (String[])new String[0]);
                if (areaCode.equals(areaItem.getAreaCode())) {
                    controlItemAreaReqDto.setAreaEnable(RuleEnableEnum.ENABLE.getValue());
                } else {
                    controlItemAreaReqDto.setAreaEnable(RuleEnableEnum.STOP.getValue());
                }
                controlItemAreaReqDto.setId(null);
                controlItemAreaReqDto.setSharePurchaseRestriction(modifyReqDto.getSharePurchaseRestriction());
                controlItemAreaReqDto.setRuleId(ruleId);
                controlItemAreaReqDto.setCalculateType(modifyReqDto.getCalculateType());
                controlItemAreaReqDto.setEnable(modifyReqDto.getEnable());
                controlItemAreaReqDto.setAreaCode(areaCode);
                controlItemAreaReqDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
                controlItemAreaReqDto.setPurchasedCount(Integer.valueOf(0));
                areaList.add(controlItemAreaReqDto);
            }));
            this.areaService.addControlAreaList(areaList);
            if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(updateItemRuleEo.getCalculateType())) {
                ArrayList itemAreaEos = Lists.newArrayList();
                DtoHelper.dtoList2EoList((Collection)areaList, (Collection)itemAreaEos, ControlItemAreaEo.class);
                List collect1 = itemAreaEos.stream().filter(c -> c.getAreaEnable().equals(RuleEnableEnum.ENABLE.getValue())).collect(Collectors.toList());
                ArrayList controlItemBaseReqs = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)controlItemBaseReqs, collect1, ControlItemBaseReq.class);
                this.countItemNum(false, controlItemBaseReqs);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void modifyEnableStatusControlItem(BizControlItemReqDto modifyReqDto, ControlItemRuleEo originConItemEo) {
        ControlItemRuleEo ruleEo = new ControlItemRuleEo();
        AssertUtils.notBlank((String)modifyReqDto.getRuleName(), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyReqDto.getControlEndDate(), (String)"\u53d7\u63a7\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyReqDto.getControlType(), (String)"\u7ba1\u63a7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        String orginStartDateStr = DateUtil.getDateFormat((Date)originConItemEo.getControlStartDate(), (String)"yyyy-MM-dd");
        String modifyStartDateStr = DateUtil.getDateFormat((Date)modifyReqDto.getControlStartDate(), (String)"yyyy-MM-dd");
        AssertUtils.isTrue((modifyReqDto.getControlEndDate().compareTo(new Date()) > 0 ? 1 : 0) != 0, (String)"\u53d7\u63a7\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65e5\u671f");
        AssertUtils.isTrue((boolean)orginStartDateStr.equals(modifyStartDateStr), (String)("\u53d7\u63a7\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4fee\u6539\uff0c\u9700\u4e3a\u539f\u5148\u7684\u65e5\u671f\u3010" + orginStartDateStr + "\u3011"));
        ruleEo.setId(modifyReqDto.getId());
        ruleEo.setRuleName(modifyReqDto.getRuleName());
        ruleEo.setControlEndDate(modifyReqDto.getControlEndDate());
        ruleEo.setControlType(modifyReqDto.getControlType());
        this.controlItemRuleDas.updateSelective((BaseEo)ruleEo);
        if (RuleRangeTypeEnum.CUSTOMER.getType().equals(originConItemEo.getRuleRangeType())) {
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getCustomerList())) {
                this.logger.info("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u542f\u7528\u72b6\u6001\u4e0b\u4fee\u6539\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6307\u5b9a\u5ba2\u6237,\u5ba2\u6237\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", JSON.toJSON((Object)modifyReqDto.getCustomerList()));
                ArrayList customerEoLis = Lists.newArrayList();
                modifyReqDto.getCustomerList().stream().forEach(customer -> {
                    ControlItemCustomerEo upEo = new ControlItemCustomerEo();
                    if (CalculateTypeEnum.PURCHASE_LIMITS.getType().equals(originConItemEo.getCalculateType())) {
                        AssertUtils.notNull((Object)customer.getLimitCount(), (String)"\u9650\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        upEo.setLimitCount(customer.getLimitCount());
                    } else if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(originConItemEo.getCalculateType())) {
                        AssertUtils.notNull((Object)customer.getLimitContent(), (String)"\u53d7\u63a7\u5546\u54c1\u9650\u8d2d\u6570\u91cf\u5185\u5bb9\u5185\u5bb9\u4e0d\u80fd");
                        upEo.setLimitContent(customer.getLimitContent());
                    }
                    AssertUtils.notNull((Object)customer.getId(), (String)"\u53d7\u63a7\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                    upEo.setId(customer.getId());
                    this.controlItemCustomerDas.updateSelective((BaseEo)upEo);
                    if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(originConItemEo.getCalculateType())) {
                        upEo = (ControlItemCustomerEo)this.controlItemCustomerDas.selectByPrimaryKey(customer.getId());
                        customerEoLis.add(upEo);
                    }
                });
                if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(originConItemEo.getCalculateType())) {
                    ArrayList controlItemBaseReqs = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)controlItemBaseReqs, (Collection)customerEoLis, ControlItemBaseReq.class);
                    this.countItemNum(true, controlItemBaseReqs);
                }
            }
        } else if (RuleRangeTypeEnum.AREA.getType().equals(originConItemEo.getRuleRangeType())) {
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getAreaList())) {
                this.logger.info("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6309\u5ba2\u6237\u533a\u57df,\u533a\u57df\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)modifyReqDto.getAreaList());
                ArrayList itemAreaEos = Lists.newArrayList();
                modifyReqDto.getAreaList().forEach(areaItem -> {
                    ControlItemAreaEo areaUpEo = new ControlItemAreaEo();
                    if (CalculateTypeEnum.PURCHASE_LIMITS.getType().equals(originConItemEo.getCalculateType())) {
                        AssertUtils.notNull((Object)areaItem.getLimitCount(), (String)"\u9650\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                        areaUpEo.setLimitCount(areaItem.getLimitCount());
                    } else if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(originConItemEo.getCalculateType())) {
                        AssertUtils.notNull((Object)areaItem.getLimitContent(), (String)"\u53d7\u63a7\u5546\u54c1\u9650\u8d2d\u6570\u91cf\u5185\u5bb9\u5185\u5bb9\u4e0d\u80fd");
                        areaUpEo.setLimitContent(areaItem.getLimitContent());
                    }
                    AssertUtils.notNull((Object)areaItem.getId(), (String)"\u53d7\u63a7\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                    areaUpEo.setId(areaItem.getId());
                    this.controlItemAreaDas.updateSelective((BaseEo)areaUpEo);
                    if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(originConItemEo.getCalculateType())) {
                        areaUpEo = (ControlItemAreaEo)this.controlItemAreaDas.selectByPrimaryKey(areaItem.getId());
                        itemAreaEos.add(areaUpEo);
                    }
                });
                if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(originConItemEo.getCalculateType())) {
                    List collect1 = itemAreaEos.stream().filter(c -> c.getAreaEnable().equals(RuleEnableEnum.ENABLE.getValue())).collect(Collectors.toList());
                    ArrayList controlItemBaseReqs = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)controlItemBaseReqs, collect1, ControlItemBaseReq.class);
                    this.countItemNum(false, controlItemBaseReqs);
                }
            }
            ControlItemAreaEo searchControlItemAreaEo = new ControlItemAreaEo();
            searchControlItemAreaEo.setRuleId(originConItemEo.getId());
            List controlItemAreaEos = this.controlItemAreaDas.select((BaseEo)searchControlItemAreaEo);
            if (CollectionUtils.isNotEmpty((Collection)controlItemAreaEos)) {
                controlItemAreaEos.forEach(e -> {
                    ControlItemCustomerEo update = new ControlItemCustomerEo();
                    update.setLimitCount(e.getLimitCount());
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)new LambdaUpdateChainWrapper((BaseMapper)this.controlItemCustomerMapper).eq(ControlItemCustomerEo::getRuleId, (Object)e.getRuleId())).eq(ControlItemCustomerEo::getAreaCode, (Object)e.getAreaCode())).eq(ControlItemCustomerEo::getItemId, (Object)e.getItemId())).update((Object)update);
                });
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlItemRuleDas.logicDeleteById(Long.valueOf(id));
            this.areaService.removeControlAreaByRuleId(Long.valueOf(id));
            this.customerService.removeCustomerByRuleId(Long.valueOf(id));
        }
    }

    @Override
    public ControlItemRespDto queryById(Long id) {
        AssertUtils.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ControlItemRuleEo controlItemRuleEo = (ControlItemRuleEo)this.controlItemRuleDas.selectByPrimaryKey(id);
        if (ObjectUtils.isEmpty((Object)controlItemRuleEo)) {
            return null;
        }
        ControlItemRespDto controlItemRespDto = new ControlItemRespDto();
        DtoHelper.eo2Dto((BaseEo)controlItemRuleEo, (BaseVo)controlItemRespDto);
        if (controlItemRespDto.getRuleRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType())) {
            controlItemRespDto.setCustomerList(this.customerService.queryByRuleId(controlItemRespDto.getId()));
        }
        if (controlItemRespDto.getRuleRangeType().equals(RuleRangeTypeEnum.AREA.getType())) {
            List<ControlItemAreaRespDto> controlItemAreaRespDtoList1 = this.areaService.queryByRuleId(controlItemRespDto.getId());
            List<ControlItemAreaRespDto> controlItemAreaRespDtoList = controlItemAreaRespDtoList1.stream().filter(c -> c.getAreaEnable().equals(RuleEnableEnum.ENABLE.getValue())).collect(Collectors.toList());
            Map<String, List<ControlItemAreaRespDto>> collect = controlItemAreaRespDtoList1.stream().collect(Collectors.groupingBy(c -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{c.getItemAreaPid()}) ? c.getItemAreaPid() + c.getItemCode() : ""));
            controlItemAreaRespDtoList.forEach(c -> {
                List areaCodeList = ((List)Optional.ofNullable(collect.get(c.getAreaCode() + c.getItemCode())).orElse(Lists.newArrayList())).stream().map(k -> k.getAreaCode()).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(areaCodeList)) {
                    CustomerAreaListReqDto areaListReqDto = new CustomerAreaListReqDto();
                    areaListReqDto.setCode(c.getAreaCode());
                    List data = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.querySubCodeAll(areaListReqDto));
                    areaCodeList.addAll(data);
                }
                if (!areaCodeList.contains(c.getAreaCode())) {
                    areaCodeList.add(c.getAreaCode());
                }
                c.setAreaCodeList(areaCodeList);
                if (controlItemRespDto.getSharePurchaseRestriction() == 1) {
                    List dtoList = this.controlItemCustomerDas.queryCustomerItem(areaCodeList, c.getItemId());
                    Integer purchasedCount = dtoList.stream().mapToInt(ControlItemAreaRespDto::getPurchasedCount).sum();
                    c.setPurchasedCount(purchasedCount);
                }
            });
            controlItemRespDto.setAreaList(controlItemAreaRespDtoList);
        }
        return controlItemRespDto;
    }

    @Override
    public PageInfo<ControlItemRespDto> queryByPage(String filter, Long orgId, Integer pageNum, Integer pageSize) {
        BizControlItemReqDto controlItemReqDto = (BizControlItemReqDto)JSON.parseObject((String)filter, BizControlItemReqDto.class);
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)controlItemReqDto)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlItemReqDto.getItemKeyword()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlItemReqDto.getCustomerKeyword()})) {
                List controlItemCustomerAndRuleId = this.controlItemCustomerMapper.getControlItemCustomerByItemOrCustomerAndRuleId(controlItemReqDto.getItemKeyword(), controlItemReqDto.getItemKeyword(), controlItemReqDto.getCustomerKeyword(), controlItemReqDto.getCustomerKeyword());
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlItemReqDto.getCustomerKeyword()})) {
                    List controlItemAreaAndRuleId = this.controlItemAreaMapper.getControlItemAreaAndRuleId(controlItemReqDto.getItemKeyword(), controlItemReqDto.getItemKeyword());
                    controlItemCustomerAndRuleId.addAll(controlItemAreaAndRuleId);
                }
                if (ObjectUtils.isEmpty((Object)controlItemCustomerAndRuleId)) {
                    dtoPageInfo.setPageNum(pageNum.intValue());
                    dtoPageInfo.setPageSize(pageSize.intValue());
                    return dtoPageInfo;
                }
                sqlFilterList.add(SqlFilter.in((String)"id", (Object)controlItemCustomerAndRuleId));
            }
            if (controlItemReqDto.getEnable() != null) {
                RuleEnableEnum enableEnum = RuleEnableEnum.enumOf((Integer)controlItemReqDto.getEnable());
                sqlFilterList.add(SqlFilter.eq((String)"enable", (Object)enableEnum.getValue()));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlItemReqDto.getRuleName()})) {
                sqlFilterList.add(SqlFilter.like((String)"rule_name", (Object)controlItemReqDto.getRuleName()));
            }
        }
        this.logger.info("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u3010\u5206\u9875\u67e5\u8be2\u5355\u54c1\u7ba1\u63a7\u89c4\u5219\u5217\u8868\u3011\u67e5\u8be2\u7684\u6761\u4ef6\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sqlFilterList));
        ControlItemRuleEo controlItemRuleEo = new ControlItemRuleEo();
        controlItemRuleEo.setOrgId(orgId);
        controlItemRuleEo.setSqlFilters((List)sqlFilterList);
        controlItemRuleEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.controlItemRuleDas.selectPage((BaseEo)controlItemRuleEo, pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    public BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto> setEnable(Long ruleId, Integer enableStatus, Long orgId) {
        AssertUtils.notNull((Object)ruleId, (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RuleEnableEnum enableEnum = RuleEnableEnum.enumOf((Integer)enableStatus);
        BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto> resultRespDto = new BizChangeRuleResultRespDto<ControlItemAreaRespDto, ControlItemCustomerRespDto, ControlItemRespDto>();
        List controlItemAreaEoList = Lists.newArrayList();
        List controlItemCustomerEoList = Lists.newArrayList();
        ControlItemRuleEo queryEo = new ControlItemRuleEo();
        queryEo.setId(ruleId);
        ControlItemRuleEo itemRuleEo = (ControlItemRuleEo)this.controlItemRuleDas.selectOne((BaseEo)queryEo);
        AssertUtils.notNull((Object)itemRuleEo, (String)"\u8be5\u89c4\u5219\u4e0d\u5b58\u5728\uff01");
        if (RuleEnableEnum.STOP.getValue().equals(itemRuleEo.getEnable())) {
            throw new BizException(ControlExceptionCode.ENABLE_UNALLOW.getCode(), ControlExceptionCode.ENABLE_UNALLOW.getMsg());
        }
        if (RuleEnableEnum.ENABLE.equals((Object)enableEnum)) {
            BizControlItemReqDto modifyReqDto = new BizControlItemReqDto();
            CubeBeanUtils.copyProperties((Object)modifyReqDto, (Object)itemRuleEo, (String[])new String[0]);
            if (RuleRangeTypeEnum.CUSTOMER.getType().equals(itemRuleEo.getRuleRangeType())) {
                ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
                controlItemCustomerEo.setRuleId(ruleId);
                controlItemCustomerEoList = this.controlItemCustomerDas.select((BaseEo)controlItemCustomerEo);
                ArrayList controlItemCustomerReqDtos = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)controlItemCustomerEoList, (Collection)controlItemCustomerReqDtos, ControlItemCustomerReqDto.class);
                modifyReqDto.setCustomerList((List)controlItemCustomerReqDtos);
            }
            if (RuleRangeTypeEnum.AREA.getType().equals(itemRuleEo.getRuleRangeType())) {
                ControlItemAreaEo controlItemAreaEo = new ControlItemAreaEo();
                controlItemAreaEo.setRuleId(ruleId);
                controlItemAreaEoList = this.controlItemAreaDas.select((BaseEo)controlItemAreaEo);
                List areaCodeList = controlItemAreaEoList.stream().map(c -> c.getAreaCode()).collect(Collectors.toList());
                ArrayList controlItemAreaReqDtoArrayList = Lists.newArrayList();
                DtoHelper.eoList2DtoList(controlItemAreaEoList, (Collection)controlItemAreaReqDtoArrayList, ControlItemAreaReqDto.class);
                ((ControlItemAreaReqDto)controlItemAreaReqDtoArrayList.get(0)).setAreaCodeList(areaCodeList);
                modifyReqDto.setAreaList((List)controlItemAreaReqDtoArrayList);
            }
            modifyReqDto.setOrgId(orgId);
            resultRespDto = this.verifyRule(modifyReqDto);
            if (!resultRespDto.getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_NOEXIT.getValue())) {
                return resultRespDto;
            }
        }
        itemRuleEo.setEnable(enableStatus);
        this.controlItemRuleDas.updateSelective((BaseEo)itemRuleEo);
        if (RuleRangeTypeEnum.CUSTOMER.getType().equals(itemRuleEo.getRuleRangeType())) {
            ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
            controlItemCustomerEo.setEnable(enableStatus);
            controlItemCustomerEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
            this.controlItemCustomerDas.updateSelectiveSqlFilter((BaseEo)controlItemCustomerEo);
            if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(itemRuleEo.getCalculateType())) {
                ArrayList controlItemBaseReqs = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)controlItemBaseReqs, (Collection)controlItemCustomerEoList, ControlItemBaseReq.class);
                this.countItemNum(true, controlItemBaseReqs);
            }
        }
        if (RuleRangeTypeEnum.AREA.getType().equals(itemRuleEo.getRuleRangeType())) {
            ControlItemAreaEo controlItemAreaEo = new ControlItemAreaEo();
            controlItemAreaEo.setEnable(enableStatus);
            controlItemAreaEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
            this.controlItemAreaDas.updateSelective((BaseEo)controlItemAreaEo);
            if (CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType().equals(itemRuleEo.getCalculateType())) {
                List collect1 = controlItemAreaEoList.stream().filter(c -> c.getAreaEnable().equals(RuleEnableEnum.ENABLE.getValue())).collect(Collectors.toList());
                ArrayList controlItemBaseReqs = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)controlItemBaseReqs, collect1, ControlItemBaseReq.class);
                this.countItemNum(false, controlItemBaseReqs);
            }
        }
        return resultRespDto;
    }

    @Override
    public ControlToCustomerRespDto<ControlItemRespDto> queryRuleByCustomer(CustomerControlBaseReqDto baseReqDto) {
        List itemIdList = baseReqDto.getItemIdList();
        Long customerId = baseReqDto.getCustomerId();
        List customerAreaCodeList = baseReqDto.getCustomerAreaCodeList();
        Long orgId = baseReqDto.getOrgId();
        AssertUtils.notEmpty((Collection)itemIdList, (String)"itemIdList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)customerId, (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)orgId, (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"item_id", (Object)itemIdList));
        ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
        controlItemCustomerEo.setSqlFilters(sqlFilters);
        controlItemCustomerEo.setCustomerId(customerId);
        controlItemCustomerEo.setEnable(RuleEnableEnum.ENABLE.getValue());
        List controlItemCustomerEos = this.controlItemCustomerDas.select((BaseEo)controlItemCustomerEo);
        List<Object> ruleIdList = Lists.newArrayList();
        ArrayList controlItemCustomerRespDtos = new ArrayList();
        ArrayList controlItemAreaRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)controlItemCustomerEos)) {
            ruleIdList.addAll(controlItemCustomerEos.stream().map(ControlItemCustomerEo::getRuleId).collect(Collectors.toList()));
            DtoHelper.eoList2DtoList((Collection)controlItemCustomerEos, controlItemCustomerRespDtos, ControlItemCustomerRespDto.class);
        }
        if (!CollectionUtils.isEmpty((Collection)customerAreaCodeList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.in((Object)"area_code", (Collection)customerAreaCodeList);
            queryWrapper.in((Object)"item_id", (Collection)itemIdList);
            queryWrapper.eq((Object)"area_enable", (Object)RuleEnableEnum.ENABLE.getValue());
            List controlItemAreaEos = this.controlItemAreaMapper.selectList((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)controlItemAreaEos)) {
                ruleIdList.addAll(controlItemAreaEos.stream().map(ControlItemAreaEo::getRuleId).collect(Collectors.toList()));
                DtoHelper.eoList2DtoList((Collection)controlItemAreaEos, controlItemAreaRespDtos, ControlItemAreaRespDto.class);
            }
        }
        if (CollectionUtils.isEmpty((Collection)ruleIdList)) {
            this.logger.info("\u672a\u5339\u914d\u5230\u6709\u6548\u53d7\u63a7\u5546\u54c1");
            return null;
        }
        List<ControlItemRuleEo> controlItemRules = this.getItemRuleEoByRuleIdList((List<Long>)(ruleIdList = ruleIdList.stream().distinct().collect(Collectors.toList())), customerId, orgId);
        if (Objects.isNull(controlItemRules)) {
            return null;
        }
        ArrayList controlItemRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList(controlItemRules, (Collection)controlItemRespDtos, ControlItemRespDto.class);
        Map<Long, List<ControlItemAreaRespDto>> ControlItemAreaRespDtoGroupByMap = controlItemAreaRespDtos.stream().collect(Collectors.groupingBy(ControlItemAreaRespDto::getRuleId));
        Map<Long, List<ControlItemCustomerRespDto>> controlItemCustomerRespDtoGroupByMap = controlItemCustomerRespDtos.stream().collect(Collectors.groupingBy(ControlItemCustomerRespDto::getRuleId));
        for (ControlItemRespDto controlItemRespDto : controlItemRespDtos) {
            controlItemRespDto.setAreaList(ControlItemAreaRespDtoGroupByMap.getOrDefault(controlItemRespDto.getId(), Lists.newArrayList()));
            controlItemRespDto.setCustomerList(controlItemCustomerRespDtoGroupByMap.getOrDefault(controlItemRespDto.getId(), Lists.newArrayList()));
        }
        return new ControlToCustomerRespDto((List)controlItemRespDtos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyBean(Long ruleId) {
        ControlItemRuleEo queryEo = new ControlItemRuleEo();
        queryEo.setId(ruleId);
        ControlItemRuleEo itemRuleEo = (ControlItemRuleEo)this.controlItemRuleDas.selectOne((BaseEo)queryEo);
        AssertUtils.notNull((Object)itemRuleEo, (String)"\u8be5\u89c4\u5219\u4e0d\u5b58\u5728\uff01");
        ControlItemRuleEo copyControlItemRuleEo = new ControlItemRuleEo();
        CubeBeanUtils.copyProperties((Object)copyControlItemRuleEo, (Object)itemRuleEo, (String[])new String[0]);
        copyControlItemRuleEo.setId(null);
        copyControlItemRuleEo.setEnable(RuleEnableEnum.DRAFT.getValue());
        copyControlItemRuleEo.setCreateTime(new Date());
        this.controlItemRuleDas.insert((BaseEo)copyControlItemRuleEo);
        String requestId = ServiceContext.getContext().getRequestId();
        ExecutorUtils.execute(() -> {
            MDC.put((String)"yes.req.requestId", (String)requestId);
            this.logger.info("\u5f02\u6b65\u5904\u7406\u5173\u8054\u5173\u7cfb");
            if (RuleRangeTypeEnum.CUSTOMER.getType().equals(itemRuleEo.getRuleRangeType())) {
                ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
                controlItemCustomerEo.setRuleId(ruleId);
                List controlItemCustomerEoList = this.controlItemCustomerDas.select((BaseEo)controlItemCustomerEo);
                ArrayList copyControlItemCustomerEoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)copyControlItemCustomerEoList, (Collection)controlItemCustomerEoList, ControlItemCustomerEo.class);
                copyControlItemCustomerEoList.forEach(c -> {
                    c.setRuleId(copyControlItemRuleEo.getId());
                    c.setPurchasedCount(Integer.valueOf(0));
                    c.setId(null);
                    c.setEnable(RuleEnableEnum.DRAFT.getValue());
                });
                this.controlItemCustomerDas.insertBatch((List)copyControlItemCustomerEoList);
            }
            if (RuleRangeTypeEnum.AREA.getType().equals(itemRuleEo.getRuleRangeType())) {
                ControlItemAreaEo controlItemAreaEo = new ControlItemAreaEo();
                controlItemAreaEo.setRuleId(ruleId);
                List controlItemAreaEoList = this.controlItemAreaDas.select((BaseEo)controlItemAreaEo);
                ArrayList copyControlItemAreaEoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)copyControlItemAreaEoList, (Collection)controlItemAreaEoList, ControlItemAreaEo.class);
                copyControlItemAreaEoList.forEach(c -> {
                    c.setRuleId(copyControlItemRuleEo.getId());
                    c.setPurchasedCount(Integer.valueOf(0));
                    c.setId(null);
                    c.setEnable(RuleEnableEnum.DRAFT.getValue());
                });
                this.controlItemAreaDas.insertBatch((List)copyControlItemAreaEoList);
            }
        });
    }

    private List<ControlItemRuleEo> getItemRuleEoByRuleIdList(List<Long> ruleIdList, Long customerId, Long orgId) {
        ArrayList<SqlFilter> ruleSqlFilterList = new ArrayList<SqlFilter>();
        ruleSqlFilterList.add(SqlFilter.in((String)"id", ruleIdList));
        ruleSqlFilterList.add(SqlFilter.eq((String)"enable", (Object)RuleEnableEnum.ENABLE.getValue()));
        ruleSqlFilterList.add(SqlFilter.le((String)"control_start_date", (Object)LocalDate.now().toString()));
        ruleSqlFilterList.add(SqlFilter.ge((String)"control_end_date", (Object)LocalDate.now().toString()));
        ruleSqlFilterList.add(SqlFilter.eq((String)"org_id", (Object)orgId));
        ControlItemRuleEo controlItemRuleEo = new ControlItemRuleEo();
        controlItemRuleEo.setSqlFilters(ruleSqlFilterList);
        List controlItemRuleEos = this.controlItemRuleDas.select((BaseEo)controlItemRuleEo);
        if (CollectionUtils.isEmpty((Collection)controlItemRuleEos)) {
            this.logger.info("\u672a\u67e5\u8be2\u6709\u6548\u7684\u5355\u54c1\u7ba1\u63a7\u89c4\u5219");
            return null;
        }
        this.logger.info("\u67e5\u8be2\u6709\u6548\u7684\u5355\u54c1\u7ba1\u63a7\u89c4\u5219:{}", (Object)JSON.toJSONString((Object)controlItemRuleEos));
        return controlItemRuleEos;
    }

    @Override
    public void countItemNum(Boolean isCustomer, List<ControlItemBaseReq> controlItemBaseReqs) {
        List countorderItemNumRespDtos;
        Map itemIdToCountMap;
        List countOrderItemNumReqDtos;
        this.logger.info("param:{}", (Object)JSON.toJSONString(controlItemBaseReqs));
        List<Object> controlItemAreaEos = new ArrayList();
        List<Object> controlItemCustomerEos = new ArrayList();
        Optional controlItemBaseReq = ((List)Optional.ofNullable(controlItemBaseReqs).orElse(new ArrayList())).stream().findFirst();
        if (null == isCustomer) {
            controlItemAreaEos = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.controlItemAreaMapper).eq(ControlItemAreaEo::getCalculateType, (Object)CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType())).eq(ControlItemAreaEo::getEnable, (Object)RuleEnableEnum.ENABLE.getValue())).list();
            controlItemCustomerEos = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.controlItemCustomerMapper).eq(ControlItemCustomerEo::getCalculateType, (Object)CalculateTypeEnum.AUTO_PURCHASE_LIMITS.getType())).eq(ControlItemCustomerEo::getEnable, (Object)RuleEnableEnum.ENABLE.getValue())).list();
        } else if (isCustomer.booleanValue()) {
            if (controlItemBaseReq.isPresent() && controlItemBaseReq.get() instanceof ControlItemCustomerEo) {
                controlItemCustomerEos = controlItemBaseReqs.stream().map(controlItemBase -> (ControlItemCustomerEo)controlItemBase).collect(Collectors.toList());
            }
        } else if (controlItemBaseReq.isPresent() && controlItemBaseReq.get() instanceof ControlItemAreaEo) {
            controlItemAreaEos = controlItemBaseReqs.stream().map(controlItemBase -> (ControlItemAreaEo)controlItemBase).collect(Collectors.toList());
        }
        this.logger.info("\u6307\u5b9a\u5ba2\u6237\u7684\u5355\u54c1\u7ba1\u63a7\u89c4\u5219: {}", (Object)JSON.toJSONString(controlItemCustomerEos));
        this.logger.info("\u6307\u5b9a\u533a\u57df\u7684\u5355\u54c1\u7ba1\u63a7\u89c4\u5219: {}", (Object)JSON.toJSONString(controlItemAreaEos));
        if (CollectionUtils.isNotEmpty(controlItemAreaEos)) {
            List<Long> areaRuleIds = controlItemAreaEos.stream().map(ControlItemAreaEo::getRuleId).collect(Collectors.toList());
            Map ruleIdToItemAreaMap = controlItemAreaEos.stream().filter(controlItemAreaEo -> RuleEnableEnum.ENABLE.getValue().equals(controlItemAreaEo.getAreaEnable())).collect(Collectors.toMap(ControlItemAreaEo::getRuleId, Function.identity(), (old, now) -> old));
            controlItemAreaEos = this.getControlItemRuleEos(areaRuleIds, ruleIdToItemAreaMap);
            countOrderItemNumReqDtos = controlItemAreaEos.stream().map(controlItemAreaEo -> {
                CountOrderItemNumReqDto countOrderItemNumReqDto = new CountOrderItemNumReqDto();
                BeanCopierUtils.copy((Object)controlItemAreaEo, (Object)countOrderItemNumReqDto);
                return this.buildCountOrderItemNumReqDto(countOrderItemNumReqDto);
            }).collect(Collectors.toList());
            itemIdToCountMap = countOrderItemNumReqDtos.stream().collect(Collectors.toMap(CountOrderItemNumReqDto::getItemId, Function.identity(), (old, now) -> old));
            this.logger.info("\u6307\u5b9a\u533a\u57df\u7edf\u8ba1\u8ba2\u5355\u6709\u6548\u5546\u54c1\u6570\u91cf\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString(countOrderItemNumReqDtos));
            countorderItemNumRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.controlReportQueryApi.countOrderItemNumByMonth(countOrderItemNumReqDtos));
            this.logger.info("\u6307\u5b9a\u533a\u57df\u7edf\u8ba1\u8ba2\u5355\u6709\u6548\u5546\u54c1\u6570\u91cf\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)countorderItemNumRespDtos));
            Map<Long, Integer> itemIdToLimitCountMap = this.getLimitCountMap(countorderItemNumRespDtos);
            controlItemAreaEos.forEach(controlItemAreaEo -> {
                BigDecimal limitCount = BigDecimal.ZERO;
                if (!itemIdToLimitCountMap.isEmpty() && itemIdToLimitCountMap.containsKey(controlItemAreaEo.getItemId())) {
                    limitCount = new BigDecimal((Integer)itemIdToLimitCountMap.get(controlItemAreaEo.getItemId())).setScale(2);
                }
                CountOrderItemNumReqDto countOrderItemNumReqDto = (CountOrderItemNumReqDto)itemIdToCountMap.get(controlItemAreaEo.getItemId());
                ControlItemAreaEo update = new ControlItemAreaEo();
                BigDecimal perentBigNum = new BigDecimal(countOrderItemNumReqDto.getPercent()).setScale(2);
                BigDecimal perentNum = perentBigNum.divide(new BigDecimal(100).setScale(2)).setScale(2);
                BigDecimal limitCountBigNum = limitCount.multiply(perentNum).setScale(2, 1);
                update.setLimitCount(Integer.valueOf(limitCountBigNum.intValue()));
                ((LambdaUpdateChainWrapper)new LambdaUpdateChainWrapper((BaseMapper)this.controlItemAreaMapper).eq(BaseEo::getId, (Object)controlItemAreaEo.getId())).update((Object)update);
            });
        }
        if (CollectionUtils.isNotEmpty(controlItemCustomerEos)) {
            List<Long> customerRuleIds = controlItemCustomerEos.stream().map(ControlItemCustomerEo::getRuleId).collect(Collectors.toList());
            Map customerRuleIdToMap = controlItemCustomerEos.stream().collect(Collectors.toMap(ControlItemCustomerEo::getRuleId, Function.identity(), (old, now) -> old));
            controlItemCustomerEos = this.getControlItemRuleEos(customerRuleIds, customerRuleIdToMap);
            countOrderItemNumReqDtos = controlItemCustomerEos.stream().map(controlItemCustomerEo -> {
                CountOrderItemNumReqDto countOrderItemNumReqDto = new CountOrderItemNumReqDto();
                BeanCopierUtils.copy((Object)controlItemCustomerEo, (Object)countOrderItemNumReqDto);
                return this.buildCountOrderItemNumReqDto(countOrderItemNumReqDto);
            }).collect(Collectors.toList());
            itemIdToCountMap = countOrderItemNumReqDtos.stream().collect(Collectors.toMap(CountOrderItemNumReqDto::getItemId, Function.identity(), (old, now) -> old));
            this.logger.info("\u6307\u5b9a\u5ba2\u6237\u7edf\u8ba1\u8ba2\u5355\u6709\u6548\u5546\u54c1\u6570\u91cf\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString(countOrderItemNumReqDtos));
            countorderItemNumRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.controlReportQueryApi.countOrderItemNumByCustomerId(countOrderItemNumReqDtos));
            this.logger.info("\u6307\u5b9a\u5ba2\u6237\u7edf\u8ba1\u8ba2\u5355\u6709\u6548\u5546\u54c1\u6570\u91cf\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)countorderItemNumRespDtos));
            Map<Long, Integer> LimitCountMap = this.getLimitCountMap(countorderItemNumRespDtos);
            controlItemCustomerEos.forEach(controlItemCustomerEo -> {
                BigDecimal limitCount = BigDecimal.ZERO;
                if (!LimitCountMap.isEmpty() && LimitCountMap.containsKey(controlItemCustomerEo.getItemId())) {
                    limitCount = new BigDecimal((Integer)LimitCountMap.get(controlItemCustomerEo.getItemId())).setScale(2);
                }
                CountOrderItemNumReqDto countOrderItemNumReqDto = (CountOrderItemNumReqDto)itemIdToCountMap.get(controlItemCustomerEo.getItemId());
                ControlItemCustomerEo update = new ControlItemCustomerEo();
                BigDecimal perentBigNum = new BigDecimal(countOrderItemNumReqDto.getPercent()).setScale(2);
                BigDecimal perentNum = perentBigNum.divide(new BigDecimal(100).setScale(2)).setScale(2);
                BigDecimal limitCountBigNum = limitCount.multiply(perentNum).setScale(2, 1);
                update.setLimitCount(Integer.valueOf(limitCountBigNum.intValue()));
                ((LambdaUpdateChainWrapper)new LambdaUpdateChainWrapper((BaseMapper)this.controlItemCustomerMapper).eq(BaseEo::getId, (Object)controlItemCustomerEo.getId())).update((Object)update);
            });
        }
    }

    @Override
    public List<ControlItemRuleEo> queryRuleRuleByEnable(Integer status, Date date) {
        ControlItemRuleEo controlItemRuleEo = new ControlItemRuleEo();
        controlItemRuleEo.setEnable(status);
        controlItemRuleEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.le((String)"control_end_date", (Object)date)}));
        return this.controlItemRuleDas.selectList((BaseEo)controlItemRuleEo);
    }

    @Override
    public void modifyRuleEnable(Long ruleId, Integer enable) {
        ControlItemRuleEo controlItemRuleEo = new ControlItemRuleEo();
        controlItemRuleEo.setId(ruleId);
        controlItemRuleEo.setEnable(enable);
        int ruleResult = this.controlItemRuleDas.updateSelective((BaseEo)controlItemRuleEo);
        if (ruleResult < 0) {
            throw ControlExceptionCode.MODIFY_FAIL.getException();
        }
        ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
        controlItemCustomerEo.setEnable(enable);
        controlItemCustomerEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        int customerResult = this.controlItemCustomerDas.updateSelectiveSqlFilter((BaseEo)controlItemCustomerEo);
        if (customerResult < 0) {
            throw ControlExceptionCode.MODIFY_FAIL.getException();
        }
        ControlItemAreaEo controlItemAreaEo = new ControlItemAreaEo();
        controlItemAreaEo.setEnable(enable);
        controlItemAreaEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        int areaResult = this.controlItemAreaDas.updateSelectiveSqlFilter((BaseEo)controlItemAreaEo);
        if (areaResult < 0) {
            throw ControlExceptionCode.MODIFY_FAIL.getException();
        }
    }

    private Map<Long, Integer> getLimitCountMap(List<CountorderItemNumRespDto> countorderItemNumRespDtos) {
        if (CollectionUtils.isEmpty(countorderItemNumRespDtos)) {
            return new HashMap<Long, Integer>();
        }
        return countorderItemNumRespDtos.stream().collect(Collectors.toMap(CountorderItemNumRespDto::getItemId, dto -> dto.getItemNum() == null ? 0 : dto.getItemNum(), (old, now) -> old));
    }

    private CountOrderItemNumReqDto buildCountOrderItemNumReqDto(CountOrderItemNumReqDto countOrderItemNumReqDto) {
        ControlItemLimitContentRespDto controlItemLimitContentRespDto = (ControlItemLimitContentRespDto)JSON.parseObject((String)countOrderItemNumReqDto.getLimitContent(), ControlItemLimitContentRespDto.class);
        SelectTimeRespDto selectTimeRespDto = this.getSelectTime(controlItemLimitContentRespDto.getMonth());
        countOrderItemNumReqDto.setStartTime(selectTimeRespDto.getStartTime());
        countOrderItemNumReqDto.setEndTime(selectTimeRespDto.getEndTime());
        countOrderItemNumReqDto.setPercent(Integer.valueOf(null == controlItemLimitContentRespDto.getPercent() ? 0 : controlItemLimitContentRespDto.getPercent()));
        return countOrderItemNumReqDto;
    }

    private <T> List<T> getControlItemRuleEos(List<Long> ruleIds, Map<Long, T> ruleIdToMap) {
        return ((List)Optional.ofNullable(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.controlItemRuleMapper).le(ControlItemRuleEo::getControlStartDate, (Object)new Date())).ge(ControlItemRuleEo::getControlEndDate, (Object)new Date())).in(BaseEo::getId, ruleIds)).list()).orElse(new ArrayList())).stream().map(controlItemRuleEo -> {
            if (ruleIds.contains(controlItemRuleEo.getId())) {
                return ruleIdToMap.get(controlItemRuleEo.getId());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private SelectTimeRespDto getSelectTime(Integer month) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5), 23, 59, 59);
        SelectTimeRespDto selectTimeRespDto = new SelectTimeRespDto();
        String endTime = DateUtil.getDateFormat((Calendar)calendar, (String)"yyyy-MM-dd HH:mm:ss");
        selectTimeRespDto.setEndTime(endTime);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, -month.intValue());
        calendar2.set(calendar2.get(1), calendar2.get(2), calendar2.getActualMinimum(5), 0, 0, 0);
        String startTime = DateUtil.getDateFormat((Calendar)calendar2, (String)"yyyy-MM-dd HH:mm:ss");
        selectTimeRespDto.setStartTime(startTime);
        return selectTimeRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOrderForItem(String orderNo) {
        if (StringUtils.isEmpty((CharSequence)orderNo)) {
            this.logger.info("\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            return;
        }
        List<ControlItemOrderRespDto> controlItemOrderRespDtos = this.controlItemOrderService.queryByTradeNo(orderNo);
        if (CollectionUtils.isEmpty(controlItemOrderRespDtos)) {
            this.logger.info("\u8ba2\u5355\u53f7[{}]\u5355\u54c1\u7d2f\u8ba1\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object)orderNo);
            return;
        }
        for (ControlItemOrderRespDto itemOrderRespDto : controlItemOrderRespDtos) {
            BigDecimal itemNum = itemOrderRespDto.getItemNum().negate();
            if (Objects.equals(itemOrderRespDto.getRuleRangeType(), "appoint")) {
                this.customerService.modifyPurchasedCount(itemNum.intValue(), itemOrderRespDto.getRuleItemId());
            }
            if (!Objects.equals(itemOrderRespDto.getRuleRangeType(), "area")) continue;
            this.areaService.modifyPurchasedCount(itemNum.intValue(), itemOrderRespDto.getRuleItemId());
        }
    }

    @Override
    public PageInfo<ControlItemAreaExtRespDto> queryCustomerItemPage(String filter, Integer pageNum, Integer pageSize) {
        ControlItemCustomerReqDto customerReqDto = (ControlItemCustomerReqDto)JSON.parseObject((String)filter, ControlItemCustomerReqDto.class);
        AssertUtils.notNull((Object)customerReqDto.getAreaCode(), (String)"\u5ba2\u6237\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)customerReqDto.getItemId(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        PageInfo dtoPageInfo = new PageInfo();
        CustomerAreaListReqDto areaListReqDto = new CustomerAreaListReqDto();
        areaListReqDto.setCode(customerReqDto.getAreaCode());
        List areaCodes = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.querySubCodeAll(areaListReqDto));
        List controlItemAreaExtRespDtoList = this.controlItemCustomerDas.queryCustomerItem(areaCodes, customerReqDto.getItemId());
        List areaCodeList = controlItemAreaExtRespDtoList.stream().map(dto -> dto.getAreaCode()).collect(Collectors.toList());
        Map areaMap = (Map)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAreaNameMapByCode(areaCodeList));
        if (CollectionUtils.isEmpty((Collection)controlItemAreaExtRespDtoList)) {
            return new PageInfo();
        }
        Map<String, List<ControlItemAreaExtRespDto>> customerMap = controlItemAreaExtRespDtoList.stream().collect(Collectors.groupingBy(ControlItemAreaExtRespDto::getCustomerCode));
        ArrayList list = Lists.newArrayList();
        ControlItemAreaExtRespDto respDto = null;
        for (List<ControlItemAreaExtRespDto> controlItemAreaExtRespDtos : customerMap.values()) {
            respDto = new ControlItemAreaExtRespDto();
            ControlItemAreaExtRespDto extRespDto = controlItemAreaExtRespDtos.get(0);
            respDto.setCustomerCode(extRespDto.getCustomerCode());
            respDto.setCustomerName(extRespDto.getCustomerName());
            respDto.setLimitCount(extRespDto.getLimitCount());
            respDto.setAreaCode(customerReqDto.getAreaCode());
            respDto.setAreaName(areaMap.getOrDefault(customerReqDto.getAreaCode(), ""));
            respDto.setSharePurchaseRestriction(extRespDto.getSharePurchaseRestriction());
            Integer purchasedCount = 0;
            for (ControlItemAreaExtRespDto dto2 : controlItemAreaExtRespDtos) {
                Integer count = dto2.getPurchasedCount();
                purchasedCount = purchasedCount + count;
            }
            respDto.setPurchasedCount(purchasedCount);
            list.add(respDto);
        }
        dtoPageInfo.setList((List)list);
        dtoPageInfo.setPageNum(pageNum.intValue());
        dtoPageInfo.setPageSize(pageSize.intValue());
        return dtoPageInfo;
    }
}

