/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlOrderAreaReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlOrderAreaService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlOrderAreaDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlOrderAreaEo;
import com.dtyunxi.tcbj.center.control.dao.vo.RuleQueryVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ControlOrderAreaServiceImpl
implements IControlOrderAreaService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlOrderAreaDas controlOrderAreaDas;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;

    @Override
    public Long addControlOrderArea(ControlOrderAreaReqDto addReqDto) {
        ControlOrderAreaEo controlOrderAreaEo = new ControlOrderAreaEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlOrderAreaEo);
        this.controlOrderAreaDas.insert((BaseEo)controlOrderAreaEo);
        return controlOrderAreaEo.getId();
    }

    @Override
    public void modifyControlOrderArea(ControlOrderAreaReqDto modifyReqDto) {
        ControlOrderAreaEo controlOrderAreaEo = new ControlOrderAreaEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)controlOrderAreaEo);
        this.controlOrderAreaDas.updateSelective((BaseEo)controlOrderAreaEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlOrderArea(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlOrderAreaDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ControlOrderAreaRespDto queryById(Long id) {
        ControlOrderAreaEo controlOrderAreaEo = (ControlOrderAreaEo)this.controlOrderAreaDas.selectByPrimaryKey(id);
        ControlOrderAreaRespDto controlOrderAreaRespDto = new ControlOrderAreaRespDto();
        DtoHelper.eo2Dto((BaseEo)controlOrderAreaEo, (BaseVo)controlOrderAreaRespDto);
        return controlOrderAreaRespDto;
    }

    @Override
    public PageInfo<ControlOrderAreaRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ControlOrderAreaReqDto controlOrderAreaReqDto = (ControlOrderAreaReqDto)JSON.parseObject((String)filter, ControlOrderAreaReqDto.class);
        ControlOrderAreaEo controlOrderAreaEo = new ControlOrderAreaEo();
        DtoHelper.dto2Eo((BaseVo)controlOrderAreaReqDto, (BaseEo)controlOrderAreaEo);
        PageInfo eoPageInfo = this.controlOrderAreaDas.selectPage((BaseEo)controlOrderAreaEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlOrderAreaRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void addControlAreaList(List<ControlOrderAreaReqDto> areaList) {
        if (CollectionUtils.isEmpty(areaList)) {
            throw ControlExceptionCode.AREA_EMPTY.getException();
        }
        if (areaList.get(0).getRuleId() == null) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011ruleId\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(areaList));
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ArrayList orderAreaEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderAreaEos, areaList, ControlOrderAreaEo.class);
        int result = this.controlOrderAreaDas.insertBatch((List)orderAreaEos);
        if (result < 0) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u6279\u91cf\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(areaList));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
    }

    @Override
    public void removeControlAreaByRuleId(Long ruleId) {
        if (ruleId == null) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011ruleId\u4e0d\u80fd\u4e3a\u7a7a");
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ControlOrderAreaEo areaEo = new ControlOrderAreaEo();
        areaEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        this.controlOrderAreaDas.delete((BaseEo)areaEo);
    }

    @Override
    public List<ControlOrderAreaRespDto> verifyRuleForArea(List<String> areaCodeList) {
        List areaCodes;
        Map areaNameMap;
        if (CollectionUtils.isEmpty(areaCodeList)) {
            return null;
        }
        ControlOrderAreaEo queryEo = new ControlOrderAreaEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"area_code", areaCodeList));
        sqlFilters.add(SqlFilter.eq((String)"enable", (Object)RuleEnableEnum.ENABLE.getValue()));
        queryEo.setSqlFilters((List)sqlFilters);
        List reAreaList = this.controlOrderAreaDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)reAreaList) && Objects.nonNull(areaNameMap = (Map)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAreaNameMapByCode(areaCodes = reAreaList.stream().map(ControlOrderAreaEo::getAreaCode).distinct().collect(Collectors.toList())))) && !areaNameMap.isEmpty()) {
            for (ControlOrderAreaEo eo : reAreaList) {
                if (!areaNameMap.containsKey(eo.getAreaCode())) continue;
                eo.setAreaName((String)areaNameMap.get(eo.getAreaCode()));
            }
        }
        ArrayList result = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)reAreaList, (Collection)result, ControlOrderAreaRespDto.class);
        return result;
    }

    @Override
    public List<ControlOrderAreaRespDto> queryAreaByRuleId(Long ruleId) {
        AssertUtils.notNull((Object)ruleId, (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ControlOrderAreaEo queryEo = new ControlOrderAreaEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.eq((String)"rule_id", (Object)ruleId));
        queryEo.setSqlFilters((List)filterList);
        List areaEoList = this.controlOrderAreaDas.select((BaseEo)queryEo);
        ArrayList areaRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)areaEoList, (Collection)areaRespDtoList, ControlOrderAreaRespDto.class);
        return areaRespDtoList;
    }

    @Override
    public List<ControlOrderAreaRespDto> queryAreaByAreaList(List<String> areaCodeList) {
        AssertUtils.notEmpty(areaCodeList, (String)"areaCode \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RuleQueryVo queryRuleVo = new RuleQueryVo();
        queryRuleVo.setAreaCodeList(areaCodeList);
        queryRuleVo.setEnable(RuleEnableEnum.ENABLE.getValue());
        queryRuleVo.setNowDate(new Date());
        List orderAreaEos = this.controlOrderAreaDas.queryOrderAreaList(queryRuleVo);
        ArrayList areaRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)orderAreaEos, (Collection)areaRespDtoList, ControlOrderAreaRespDto.class);
        return areaRespDtoList;
    }

    @Override
    public List<ControlOrderAreaRespDto> queryControlOrderAreaList(String filter) {
        ControlOrderAreaReqDto controlOrderAreaReqDto = (ControlOrderAreaReqDto)JSON.parseObject((String)filter, ControlOrderAreaReqDto.class);
        ControlOrderAreaEo controlOrderAreaEo = new ControlOrderAreaEo();
        DtoHelper.dto2Eo((BaseVo)controlOrderAreaReqDto, (BaseEo)controlOrderAreaEo);
        List select = this.controlOrderAreaDas.select((BaseEo)controlOrderAreaEo);
        ArrayList<ControlOrderAreaRespDto> list = new ArrayList<ControlOrderAreaRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, ControlOrderAreaRespDto.class);
        return list;
    }
}

