/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlOrderCustomerReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlOrderCustomerService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlOrderCustomerDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlOrderCustomerEo;
import com.dtyunxi.tcbj.center.control.dao.vo.RuleQueryVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ControlOrderCustomerServiceImpl
implements IControlOrderCustomerService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlOrderCustomerDas controlOrderCustomerDas;

    @Override
    public Long addControlOrderCustomer(ControlOrderCustomerReqDto addReqDto) {
        ControlOrderCustomerEo controlOrderCustomerEo = new ControlOrderCustomerEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlOrderCustomerEo);
        this.controlOrderCustomerDas.insert((BaseEo)controlOrderCustomerEo);
        return controlOrderCustomerEo.getId();
    }

    @Override
    public void modifyControlOrderCustomer(ControlOrderCustomerReqDto modifyReqDto) {
        ControlOrderCustomerEo controlOrderCustomerEo = new ControlOrderCustomerEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)controlOrderCustomerEo);
        this.controlOrderCustomerDas.updateSelective((BaseEo)controlOrderCustomerEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlOrderCustomer(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlOrderCustomerDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ControlOrderCustomerRespDto queryById(Long id) {
        ControlOrderCustomerEo controlOrderCustomerEo = (ControlOrderCustomerEo)this.controlOrderCustomerDas.selectByPrimaryKey(id);
        ControlOrderCustomerRespDto controlOrderCustomerRespDto = new ControlOrderCustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)controlOrderCustomerEo, (BaseVo)controlOrderCustomerRespDto);
        return controlOrderCustomerRespDto;
    }

    @Override
    public PageInfo<ControlOrderCustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ControlOrderCustomerReqDto controlOrderCustomerReqDto = (ControlOrderCustomerReqDto)JSON.parseObject((String)filter, ControlOrderCustomerReqDto.class);
        ControlOrderCustomerEo controlOrderCustomerEo = new ControlOrderCustomerEo();
        DtoHelper.dto2Eo((BaseVo)controlOrderCustomerReqDto, (BaseEo)controlOrderCustomerEo);
        PageInfo eoPageInfo = this.controlOrderCustomerDas.selectPage((BaseEo)controlOrderCustomerEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlOrderCustomerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void addOrderCustomers(List<ControlOrderCustomerReqDto> addReqDtoList) {
        if (CollectionUtils.isEmpty(addReqDtoList)) {
            throw ControlExceptionCode.CUSTOMER_EMPTY.getException();
        }
        if (addReqDtoList.get(0).getRuleId() == null) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011ruleId\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(addReqDtoList));
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ArrayList customerList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)customerList, addReqDtoList, ControlOrderCustomerEo.class);
        int result = this.controlOrderCustomerDas.insertBatch((List)customerList);
        if (result < 0) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u6279\u91cf\u65b0\u589e\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(addReqDtoList));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
    }

    @Override
    public void removeCustomerByRuleId(Long ruleId) {
        if (ruleId == null) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011ruleId\u4e0d\u80fd\u4e3a\u7a7a");
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ControlOrderCustomerEo pointEo = new ControlOrderCustomerEo();
        pointEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        this.controlOrderCustomerDas.delete((BaseEo)pointEo);
    }

    @Override
    public List<ControlOrderCustomerRespDto> verifyRuleForCustomer(List<Long> customerIdList) {
        if (CollectionUtils.isEmpty(customerIdList)) {
            return null;
        }
        ControlOrderCustomerEo queryEo = new ControlOrderCustomerEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"customer_id", customerIdList));
        sqlFilters.add(SqlFilter.eq((String)"enable", (Object)RuleEnableEnum.ENABLE.getValue()));
        queryEo.setSqlFilters((List)sqlFilters);
        List reCustomerList = this.controlOrderCustomerDas.select((BaseEo)queryEo);
        ArrayList result = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)reCustomerList, (Collection)result, ControlOrderCustomerRespDto.class);
        return result;
    }

    @Override
    public List<ControlOrderCustomerRespDto> queryCustomerByRuleId(Long ruleId) {
        AssertUtils.notNull((Object)ruleId, (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ControlOrderCustomerEo queryEo = new ControlOrderCustomerEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.eq((String)"rule_id", (Object)ruleId));
        queryEo.setSqlFilters((List)filterList);
        List controlOrderCustomerEoList = this.controlOrderCustomerDas.select((BaseEo)queryEo);
        ArrayList customerRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)controlOrderCustomerEoList, (Collection)customerRespDtoList, ControlOrderCustomerRespDto.class);
        return customerRespDtoList;
    }

    @Override
    public List<ControlOrderCustomerRespDto> queryByIds(List<Long> customerList) {
        AssertUtils.notEmpty(customerList, (String)"customerList\u4e0d\u80fd\u4e3a\u7a7a");
        ControlOrderCustomerEo queryEo = new ControlOrderCustomerEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"id", customerList));
        queryEo.setSqlFilters((List)filterList);
        List orderCustomerEos = this.controlOrderCustomerDas.select((BaseEo)queryEo);
        ArrayList customerRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)orderCustomerEos, (Collection)customerRespDtoList, ControlOrderCustomerRespDto.class);
        return customerRespDtoList;
    }

    @Override
    public List<ControlOrderCustomerRespDto> queryOrderCustomerByCustomerId(Long customerId) {
        AssertUtils.notNull((Object)customerId, (String)"customerId\u4e0d\u80fd\u4e3a\u7a7a");
        RuleQueryVo customerRuleVo = new RuleQueryVo();
        customerRuleVo.setCustomerId(customerId);
        customerRuleVo.setEnable(RuleEnableEnum.ENABLE.getValue());
        customerRuleVo.setNowDateStr(LocalDate.now().toString());
        List orderCustomerEos = this.controlOrderCustomerDas.queryOrderCustomerList(customerRuleVo);
        ArrayList customerRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)orderCustomerEos, (Collection)customerRespDtoList, ControlOrderCustomerRespDto.class);
        return customerRespDtoList;
    }
}

