/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.utils;

import com.dtyunxi.tcbj.center.control.api.dto.constant.OperationTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.TradeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRecordRespDto;
import com.dtyunxi.tcbj.center.control.biz.utils.TradeUtil;
import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmountFlowHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmountFlowHelper.class);

    public static TrControlItemAmountRecordRespDto getDefaultInfo(TradeTypeEnum typeEnum, Function<TrControlItemAmountRecordRespDto, TrControlItemAmountRecordRespDto> func) {
        Objects.requireNonNull(typeEnum);
        TrControlItemAmountRecordRespDto defaultInfo = AmountFlowHelper.getDefault(typeEnum);
        switch (typeEnum) {
            case AMOUNT_MONTH: 
            case AMOUNT_ADD: 
            case AMOUNT_MONTH_SETTLE: 
            case AMOUNT_ORDER_ROLLBACK: 
            case AMOUNT_SALESRETURN_ADD: {
                defaultInfo.setOperationType(OperationTypeEnum.OPERATIONTYPEENUM_IN.getType());
                break;
            }
            case AMOUNT_CUT: 
            case AMOUNT_ORDER_CUT: {
                defaultInfo.setOperationType(OperationTypeEnum.OPERATIONTYPEENUM_OUT.getType());
                break;
            }
            case AMOUNT_PERSON: {
                break;
            }
            default: {
                LOGGER.warn("getDefaultInfo\u4e2dtype={} \u8ba2\u5355\u7684\u7c7b\u578b\u4e0d\u660e\u786e\uff01\u8bf7\u68c0\u67e5com.dtyunxi.tcbj.center.control.api.dto.constant.TradeTypeEnum\u662f\u5426\u5b58\u5728\u8be5\u7c7b\u578b\uff01", (Object)typeEnum.getType());
            }
        }
        return func.apply(defaultInfo);
    }

    private static TrControlItemAmountRecordRespDto getDefault(TradeTypeEnum typeEnum) {
        TrControlItemAmountRecordRespDto itemAmountRecordRespDto = new TrControlItemAmountRecordRespDto();
        itemAmountRecordRespDto.setTradeTime(new Date());
        itemAmountRecordRespDto.setTradeType(typeEnum.getType());
        itemAmountRecordRespDto.setTradeNo(TradeUtil.generateOrderFlowNo(typeEnum.getType()));
        return itemAmountRecordRespDto;
    }
}

