/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlInventoryAreaReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlInventoryAreaService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlInventoryAreaDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlInventoryAreaEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ControlInventoryAreaServiceImpl
implements IControlInventoryAreaService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlInventoryAreaDas controlInventoryAreaDas;

    @Override
    public Long addControlInventoryArea(ControlInventoryAreaReqDto addReqDto) {
        ControlInventoryAreaEo controlInventoryAreaEo = new ControlInventoryAreaEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlInventoryAreaEo);
        this.controlInventoryAreaDas.insert((BaseEo)controlInventoryAreaEo);
        return controlInventoryAreaEo.getId();
    }

    @Override
    public void addControlAreaList(List<ControlInventoryAreaReqDto> areaList) {
        if (CollectionUtils.isEmpty(areaList)) {
            throw ControlExceptionCode.AREA_EMPTY.getException();
        }
        if (areaList.get(0).getRuleId() == null) {
            this.logger.error("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011ruleId\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(areaList));
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ArrayList inventoryAreaEos = Lists.newArrayList();
        DtoHelper.dtoList2EoList(areaList, (Collection)inventoryAreaEos, ControlInventoryAreaEo.class);
        int result = this.controlInventoryAreaDas.insertBatch((List)inventoryAreaEos);
        if (result < 0) {
            this.logger.error("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u6279\u91cf\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(areaList));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
    }

    @Override
    public void modifyControlInventoryArea(ControlInventoryAreaReqDto modifyReqDto) {
        ControlInventoryAreaEo controlInventoryAreaEo = new ControlInventoryAreaEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)controlInventoryAreaEo);
        this.controlInventoryAreaDas.updateSelective((BaseEo)controlInventoryAreaEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlInventoryArea(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlInventoryAreaDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ControlInventoryAreaRespDto queryById(Long id) {
        ControlInventoryAreaEo controlInventoryAreaEo = (ControlInventoryAreaEo)this.controlInventoryAreaDas.selectByPrimaryKey(id);
        ControlInventoryAreaRespDto controlInventoryAreaRespDto = new ControlInventoryAreaRespDto();
        DtoHelper.eo2Dto((BaseEo)controlInventoryAreaEo, (BaseVo)controlInventoryAreaRespDto);
        return controlInventoryAreaRespDto;
    }

    @Override
    public PageInfo<ControlInventoryAreaRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ControlInventoryAreaReqDto controlInventoryAreaReqDto = (ControlInventoryAreaReqDto)JSON.parseObject((String)filter, ControlInventoryAreaReqDto.class);
        ControlInventoryAreaEo controlInventoryAreaEo = new ControlInventoryAreaEo();
        DtoHelper.dto2Eo((BaseVo)controlInventoryAreaReqDto, (BaseEo)controlInventoryAreaEo);
        PageInfo eoPageInfo = this.controlInventoryAreaDas.selectPage((BaseEo)controlInventoryAreaEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlInventoryAreaRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void removeControlAreaByRuleId(Long ruleId) {
        if (ruleId == null) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011ruleId\u4e0d\u80fd\u4e3a\u7a7a");
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ControlInventoryAreaEo areaEo = new ControlInventoryAreaEo();
        areaEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        this.controlInventoryAreaDas.delete((BaseEo)areaEo);
    }

    @Override
    public List<ControlInventoryAreaRespDto> verifyRuleForArea(List<Long> ruleIdList) {
        if (CollectionUtils.isEmpty(ruleIdList)) {
            return null;
        }
        ControlInventoryAreaEo queryEo = new ControlInventoryAreaEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"rule_id", ruleIdList));
        sqlFilters.add(SqlFilter.eq((String)"enable", (Object)RuleEnableEnum.ENABLE.getValue()));
        queryEo.setSqlFilters((List)sqlFilters);
        List reAreaEoList = this.controlInventoryAreaDas.select((BaseEo)queryEo);
        ArrayList result = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)reAreaEoList, (Collection)result, ControlInventoryAreaRespDto.class);
        return result;
    }
}

