/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlInventoryCustomerReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlInventoryCustomerService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlInventoryCustomerDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlInventoryCustomerEo;
import com.dtyunxi.tcbj.center.control.dao.mapper.ControlInventoryCustomerMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ControlInventoryCustomerServiceImpl
implements IControlInventoryCustomerService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlInventoryCustomerDas controlInventoryCustomerDas;
    @Resource
    private ControlInventoryCustomerMapper controlInventoryCustomerMapper;

    @Override
    public Long addControlInventoryCustomer(ControlInventoryCustomerReqDto addReqDto) {
        ControlInventoryCustomerEo controlInventoryCustomerEo = new ControlInventoryCustomerEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlInventoryCustomerEo);
        this.controlInventoryCustomerDas.insert((BaseEo)controlInventoryCustomerEo);
        return controlInventoryCustomerEo.getId();
    }

    @Override
    public void addOrderCustomers(List<ControlInventoryCustomerReqDto> addReqDtoList) {
        if (CollectionUtils.isEmpty(addReqDtoList)) {
            throw ControlExceptionCode.CUSTOMER_EMPTY.getException();
        }
        if (addReqDtoList.get(0).getRuleId() == null) {
            this.logger.error("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011ruleId\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(addReqDtoList));
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ArrayList customerList = Lists.newArrayList();
        DtoHelper.dtoList2EoList(addReqDtoList, (Collection)customerList, ControlInventoryCustomerEo.class);
        int result = this.controlInventoryCustomerDas.insertBatch((List)customerList);
        if (result < 0) {
            this.logger.error("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u6279\u91cf\u65b0\u589e\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(addReqDtoList));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
    }

    @Override
    public void modifyControlInventoryCustomer(ControlInventoryCustomerReqDto modifyReqDto) {
        ControlInventoryCustomerEo controlInventoryCustomerEo = new ControlInventoryCustomerEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)controlInventoryCustomerEo);
        this.controlInventoryCustomerDas.updateSelective((BaseEo)controlInventoryCustomerEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlInventoryCustomer(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlInventoryCustomerDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ControlInventoryCustomerRespDto queryById(Long id) {
        ControlInventoryCustomerEo controlInventoryCustomerEo = (ControlInventoryCustomerEo)this.controlInventoryCustomerDas.selectByPrimaryKey(id);
        ControlInventoryCustomerRespDto controlInventoryCustomerRespDto = new ControlInventoryCustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)controlInventoryCustomerEo, (BaseVo)controlInventoryCustomerRespDto);
        return controlInventoryCustomerRespDto;
    }

    @Override
    public PageInfo<ControlInventoryCustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ControlInventoryCustomerReqDto controlInventoryCustomerReqDto = (ControlInventoryCustomerReqDto)JSON.parseObject((String)filter, ControlInventoryCustomerReqDto.class);
        ControlInventoryCustomerEo controlInventoryCustomerEo = new ControlInventoryCustomerEo();
        DtoHelper.dto2Eo((BaseVo)controlInventoryCustomerReqDto, (BaseEo)controlInventoryCustomerEo);
        PageInfo eoPageInfo = this.controlInventoryCustomerDas.selectPage((BaseEo)controlInventoryCustomerEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlInventoryCustomerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void removeCustomerByRuleId(Long ruleId) {
        if (ruleId == null) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011ruleId\u4e0d\u80fd\u4e3a\u7a7a");
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ControlInventoryCustomerEo pointEo = new ControlInventoryCustomerEo();
        pointEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        this.controlInventoryCustomerDas.delete((BaseEo)pointEo);
    }

    @Override
    public List<ControlInventoryCustomerRespDto> verifyRuleForCustomer(Collection<Long> ruleIdList, Long customerId) {
        if (CollectionUtils.isEmpty(ruleIdList)) {
            return null;
        }
        ControlInventoryCustomerEo queryEo = new ControlInventoryCustomerEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"rule_id", ruleIdList));
        sqlFilters.add(SqlFilter.eq((String)"enable", (Object)RuleEnableEnum.ENABLE.getValue()));
        if (Objects.nonNull(customerId)) {
            sqlFilters.add(SqlFilter.eq((String)"customer_id", (Object)customerId));
        }
        queryEo.setSqlFilters((List)sqlFilters);
        List inventoryCustomerEos = this.controlInventoryCustomerDas.select((BaseEo)queryEo);
        ArrayList result = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)inventoryCustomerEos, (Collection)result, ControlInventoryCustomerRespDto.class);
        return result;
    }

    @Override
    public List<ControlInventoryCustomerRespDto> queryByRuleId(Long ruleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)"0");
        queryWrapper.eq((Object)"rule_id", (Object)ruleId);
        List inventoryCustomerEos = this.controlInventoryCustomerMapper.selectList((Wrapper)queryWrapper);
        ControlInventoryCustomerRespDto controlInventoryCustomerRespDto = new ControlInventoryCustomerRespDto();
        ArrayList result = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)inventoryCustomerEos, (Collection)result, ControlInventoryCustomerRespDto.class);
        return result;
    }
}

