/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleRangeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlInventoryReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlInventoryAreaReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlInventoryCustomerReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlInventoryItemReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlInventoryReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BaseRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizChangeRuleResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlInventoryAreaService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlInventoryCustomerService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlInventoryItemService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlInventoryService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlInventoryAreaDas;
import com.dtyunxi.tcbj.center.control.dao.das.ControlInventoryCustomerDas;
import com.dtyunxi.tcbj.center.control.dao.das.ControlInventoryItemDas;
import com.dtyunxi.tcbj.center.control.dao.das.ControlInventoryRuleDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlInventoryAreaEo;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlInventoryCustomerEo;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlInventoryItemEo;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlInventoryRuleEo;
import com.dtyunxi.tcbj.center.control.dao.mapper.ControlInventoryItemMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ControlInventoryServiceImpl
implements IControlInventoryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlInventoryRuleDas controlInventoryRuleDas;
    @Resource
    private IControlInventoryCustomerService controlInventoryCustomerService;
    @Resource
    private IControlInventoryAreaService controlInventoryAreaService;
    @Resource
    private IControlInventoryItemService controlInventoryItemService;
    @Resource
    private ControlInventoryItemMapper controlInventoryItemMapper;
    @Resource
    private ControlInventoryItemDas controlInventoryItemDas;
    @Resource
    private ControlInventoryAreaDas controlInventoryAreaDas;
    @Resource
    private ControlInventoryCustomerDas controlInventoryCustomerDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizChangeRuleResultRespDto<ControlInventoryAreaRespDto, ControlInventoryCustomerRespDto, ControlInventoryRespDto> addControlInventory(BizControlInventoryReqDto addReqDto) {
        BizChangeRuleResultRespDto<ControlInventoryAreaRespDto, ControlInventoryCustomerRespDto, ControlInventoryRespDto> resultRespDto = new BizChangeRuleResultRespDto<ControlInventoryAreaRespDto, ControlInventoryCustomerRespDto, ControlInventoryRespDto>();
        if (RuleEnableEnum.ENABLE.getValue().equals(addReqDto.getEnable()) && (resultRespDto = this.verifyRule(addReqDto)).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            return resultRespDto;
        }
        ControlInventoryRuleEo inventoryRuleEo = new ControlInventoryRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inventoryRuleEo);
        this.controlInventoryRuleDas.insert((BaseEo)inventoryRuleEo);
        Long ruleId = inventoryRuleEo.getId();
        if (ruleId == null) {
            this.logger.error("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u6dfb\u52a0\u7ba1\u63a7\u89c4\u5219\u5931\u8d25\uff0c\u63d0\u4ea4\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getCustomerList())) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6307\u5b9a\u5ba2\u6237,\u5ba2\u6237\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto.getCustomerList()));
            addReqDto.getCustomerList().forEach(c -> {
                c.setRuleId(ruleId);
                c.setEnable(addReqDto.getEnable());
                c.setBlacklistStatus(YesOrNoEnum.NO.getCode());
            });
            this.controlInventoryCustomerService.addOrderCustomers(addReqDto.getCustomerList());
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getCustomerBlackList())) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u9ed1\u540d\u5355\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto.getCustomerBlackList()));
            addReqDto.getCustomerBlackList().forEach(c -> {
                c.setRuleId(ruleId);
                c.setEnable(addReqDto.getEnable());
                c.setBlacklistStatus(YesOrNoEnum.YES.getCode());
            });
            this.controlInventoryCustomerService.addOrderCustomers(addReqDto.getCustomerBlackList());
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getAreaList())) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6309\u5ba2\u6237\u533a\u57df,\u533a\u57df\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto.getAreaList()));
            ArrayList list = Lists.newArrayList();
            addReqDto.getAreaList().forEach(areaItem -> {
                ControlInventoryAreaReqDto controlInventoryAreaReqDto = new ControlInventoryAreaReqDto();
                controlInventoryAreaReqDto.setRuleId(ruleId);
                controlInventoryAreaReqDto.setEnable(addReqDto.getEnable());
                controlInventoryAreaReqDto.setAreaCode(areaItem);
                list.add(controlInventoryAreaReqDto);
            });
            this.controlInventoryAreaService.addControlAreaList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getItemList())) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u6dfb\u52a0\u5546\u54c1\u6570\u636e\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto.getItemList()));
            addReqDto.getItemList().forEach(item -> {
                item.setEnable(addReqDto.getEnable());
                item.setRuleId(ruleId);
            });
            this.controlInventoryItemService.addControlInventoryItems(addReqDto.getItemList());
        }
        return resultRespDto;
    }

    private BizChangeRuleResultRespDto<ControlInventoryAreaRespDto, ControlInventoryCustomerRespDto, ControlInventoryRespDto> verifyRule(BizControlInventoryReqDto addReqDto) {
        List<Long> ruleIdList;
        BizChangeRuleResultRespDto resultRespDto = new BizChangeRuleResultRespDto();
        if (CollectionUtils.isEmpty((Collection)addReqDto.getItemList())) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\uff08{}\uff09\u5f53\u524d\u89c4\u5219\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a", (Object)addReqDto.getRuleName());
            return resultRespDto;
        }
        List<ControlInventoryItemRespDto> inventoryRuleRespDtoList = this.controlInventoryItemService.queryVerifyItemList(addReqDto.getItemList());
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getCustomerList())) {
            List<Object> verifyCustomerRespDtos;
            ruleIdList = Optional.ofNullable(inventoryRuleRespDtoList).orElseGet(Collections::emptyList).stream().map(ControlInventoryItemRespDto::getRuleId).distinct().collect(Collectors.toList());
            if (!ObjectUtils.isEmpty((Object)addReqDto.getId())) {
                ruleIdList.remove(addReqDto.getId());
            }
            if (CollectionUtils.isNotEmpty(verifyCustomerRespDtos = this.controlInventoryCustomerService.verifyRuleForCustomer(ruleIdList, null)) && CollectionUtils.isNotEmpty(verifyCustomerRespDtos = verifyCustomerRespDtos.stream().filter(dto -> Objects.equals(dto.getBlacklistStatus(), YesOrNoEnum.NO.getCode())).collect(Collectors.toList()))) {
                List collect = addReqDto.getCustomerList().stream().map(c -> c.getCustomerId()).collect(Collectors.toList());
                List conflictCustomerList = verifyCustomerRespDtos.stream().filter(c -> collect.contains(c.getCustomerId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(conflictCustomerList)) {
                    List conflictRuleIdList = Optional.ofNullable(conflictCustomerList).orElseGet(Collections::emptyList).stream().map(ControlInventoryCustomerRespDto::getRuleId).distinct().collect(Collectors.toList());
                    ControlInventoryRuleEo queryEo = new ControlInventoryRuleEo();
                    queryEo.setOrgId(addReqDto.getOrgId());
                    queryEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", conflictRuleIdList)}));
                    List inventoryRuleEos = this.controlInventoryRuleDas.select((BaseEo)queryEo);
                    if (!ObjectUtils.isEmpty((Object)inventoryRuleEos)) {
                        resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                        this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u89c4\u5219\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u7684\u6307\u5b9a\u5ba2\u6237\uff0c\u91cd\u590d\u7684\u5ba2\u6237\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(verifyCustomerRespDtos));
                        ArrayList conflictInventoryRuleList = Lists.newArrayList();
                        DtoHelper.eoList2DtoList((Collection)inventoryRuleEos, (Collection)conflictInventoryRuleList, ControlInventoryRespDto.class);
                        resultRespDto.setCustomerList(conflictCustomerList);
                        resultRespDto.setConflictRuleList((List)conflictInventoryRuleList);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getAreaList())) {
            List conflictAreaList;
            List<ControlInventoryAreaRespDto> verifyAreaRespDtos;
            ruleIdList = Optional.ofNullable(inventoryRuleRespDtoList).orElseGet(Collections::emptyList).stream().map(ControlInventoryItemRespDto::getRuleId).distinct().collect(Collectors.toList());
            if (!ObjectUtils.isEmpty((Object)addReqDto.getId())) {
                ruleIdList.remove(addReqDto.getId());
            }
            if (CollectionUtils.isNotEmpty(verifyAreaRespDtos = this.controlInventoryAreaService.verifyRuleForArea(ruleIdList)) && CollectionUtils.isNotEmpty(conflictAreaList = verifyAreaRespDtos.stream().filter(c -> addReqDto.getAreaList().contains(c.getAreaCode())).collect(Collectors.toList()))) {
                List conflictRuleIdList = conflictAreaList.stream().map(ControlInventoryAreaRespDto::getRuleId).distinct().collect(Collectors.toList());
                ControlInventoryRuleEo queryEo = new ControlInventoryRuleEo();
                queryEo.setOrgId(addReqDto.getOrgId());
                queryEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", conflictRuleIdList)}));
                List inventoryRuleEos = this.controlInventoryRuleDas.select((BaseEo)queryEo);
                if (!ObjectUtils.isEmpty((Object)inventoryRuleEos)) {
                    resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                    this.logger.error("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u89c4\u5219\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u7684\u5ba2\u6237\u533a\u57df\uff0c\u91cd\u590d\u7684\u5ba2\u6237\u533a\u57df\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(verifyAreaRespDtos));
                    ArrayList conflictItemRuleList = Lists.newArrayList();
                    DtoHelper.eoList2DtoList((Collection)inventoryRuleEos, (Collection)conflictItemRuleList, ControlInventoryRespDto.class);
                    resultRespDto.setConflictRuleList((List)conflictItemRuleList);
                    resultRespDto.setAreaList(conflictAreaList);
                }
            }
        }
        if (addReqDto.getRuleRangeType().equals(RuleRangeTypeEnum.ALL.getType())) {
            ControlInventoryRuleEo queryEo = new ControlInventoryRuleEo();
            queryEo.setEnable(RuleEnableEnum.ENABLE.getValue());
            queryEo.setRuleRangeType(RuleRangeTypeEnum.ALL.getType());
            List collect = inventoryRuleRespDtoList.stream().map(c -> c.getRuleId()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty((Object)addReqDto.getId())) {
                collect.remove(addReqDto.getId());
            }
            queryEo.setOrgId(addReqDto.getOrgId());
            queryEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", collect)}));
            List inventoryRuleEos = this.controlInventoryRuleDas.select((BaseEo)queryEo);
            if (CollectionUtils.isNotEmpty((Collection)inventoryRuleEos)) {
                resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                ArrayList conflictItemRuleList = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)inventoryRuleEos, (Collection)conflictItemRuleList, ControlInventoryRespDto.class);
                resultRespDto.setConflictRuleList((List)conflictItemRuleList);
            }
        }
        return resultRespDto;
    }

    @Override
    public BizChangeRuleResultRespDto<ControlInventoryAreaRespDto, ControlInventoryCustomerRespDto, ControlInventoryRespDto> modifyControlInventory(BizControlInventoryReqDto modifyReqDto) {
        this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u4fee\u6539\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u89c4\u5219");
        BizChangeRuleResultRespDto<ControlInventoryAreaRespDto, ControlInventoryCustomerRespDto, ControlInventoryRespDto> resultRespDto = new BizChangeRuleResultRespDto<ControlInventoryAreaRespDto, ControlInventoryCustomerRespDto, ControlInventoryRespDto>();
        if (RuleEnableEnum.ENABLE.getValue().equals(modifyReqDto.getEnable()) && (resultRespDto = this.verifyRule(modifyReqDto)).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            return resultRespDto;
        }
        ControlInventoryRuleEo updateInventoryRuleEo = new ControlInventoryRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)updateInventoryRuleEo);
        this.controlInventoryRuleDas.updateSelective((BaseEo)updateInventoryRuleEo);
        Long ruleId = modifyReqDto.getId();
        this.controlInventoryCustomerService.removeCustomerByRuleId(ruleId);
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getCustomerList())) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u4fee\u6539\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6307\u5b9a\u5ba2\u6237,\u5ba2\u6237\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)modifyReqDto.getCustomerList());
            modifyReqDto.getCustomerList().forEach(c -> {
                c.setRuleId(ruleId);
                c.setEnable(modifyReqDto.getEnable());
                c.setBlacklistStatus(YesOrNoEnum.NO.getCode());
            });
            this.controlInventoryCustomerService.addOrderCustomers(modifyReqDto.getCustomerList());
        }
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getCustomerBlackList())) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u9ed1\u540d\u5355\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getCustomerBlackList()));
            modifyReqDto.getCustomerBlackList().forEach(c -> {
                c.setRuleId(ruleId);
                c.setEnable(modifyReqDto.getEnable());
                c.setBlacklistStatus(YesOrNoEnum.YES.getCode());
            });
            this.controlInventoryCustomerService.addOrderCustomers(modifyReqDto.getCustomerBlackList());
        }
        this.controlInventoryAreaService.removeControlAreaByRuleId(ruleId);
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getAreaList())) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6309\u5ba2\u6237\u533a\u57df,\u533a\u57df\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto.getAreaList()));
            ArrayList list = Lists.newArrayList();
            modifyReqDto.getAreaList().forEach(areaItem -> {
                ControlInventoryAreaReqDto controlInventoryAreaReqDto = new ControlInventoryAreaReqDto();
                controlInventoryAreaReqDto.setRuleId(ruleId);
                controlInventoryAreaReqDto.setEnable(modifyReqDto.getEnable());
                controlInventoryAreaReqDto.setAreaCode(areaItem);
                list.add(controlInventoryAreaReqDto);
            });
            this.controlInventoryAreaService.addControlAreaList(list);
        }
        this.controlInventoryItemService.removeControlItemByRuleId(ruleId);
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getItemList())) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u4e3a\uff1a{}", (Object)modifyReqDto.getItemList());
            modifyReqDto.getItemList().forEach(item -> {
                item.setRuleId(ruleId);
                item.setEnable(modifyReqDto.getEnable());
            });
            this.controlInventoryItemService.addControlInventoryItems(modifyReqDto.getItemList());
        }
        return resultRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlInventory(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlInventoryRuleDas.logicDeleteById(Long.valueOf(id));
            this.controlInventoryCustomerService.removeCustomerByRuleId(Long.valueOf(id));
            this.controlInventoryAreaService.removeControlAreaByRuleId(Long.valueOf(id));
            this.controlInventoryItemService.removeControlItemByRuleId(Long.valueOf(id));
        }
    }

    @Override
    public ControlInventoryRespDto queryById(Long id) {
        AssertUtils.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ControlInventoryRuleEo controlInventoryRuleEo = (ControlInventoryRuleEo)this.controlInventoryRuleDas.selectByPrimaryKey(id);
        if (ObjectUtils.isEmpty((Object)controlInventoryRuleEo)) {
            return null;
        }
        ControlInventoryRespDto controlInventoryRespDto = new ControlInventoryRespDto();
        DtoHelper.eo2Dto((BaseEo)controlInventoryRuleEo, (BaseVo)controlInventoryRespDto);
        if (controlInventoryRuleEo.getRuleRangeType().equals(RuleRangeTypeEnum.AREA.getType())) {
            List<ControlInventoryAreaRespDto> controlInventoryAreaRespDtoList = this.controlInventoryAreaService.verifyRuleForArea(Lists.newArrayList((Object[])new Long[]{controlInventoryRuleEo.getId()}));
            controlInventoryRespDto.setAreaList(controlInventoryAreaRespDtoList);
        }
        List<ControlInventoryCustomerRespDto> controlInventoryCustomerRespDtos = this.controlInventoryCustomerService.queryByRuleId(controlInventoryRuleEo.getId());
        controlInventoryRespDto.setCustomerList(controlInventoryCustomerRespDtos);
        List<ControlInventoryItemRespDto> controlInventoryItemRespDtos = this.controlInventoryItemService.queryByRuleIds(Lists.newArrayList((Object[])new Long[]{controlInventoryRuleEo.getId()}));
        controlInventoryRespDto.setItemList(controlInventoryItemRespDtos);
        return controlInventoryRespDto;
    }

    @Override
    public PageInfo<ControlInventoryRespDto> queryByPage(BizControlInventoryReqDto controlInventoryReqDto) {
        Integer pageNum = controlInventoryReqDto.getPageNum() == null ? 1 : controlInventoryReqDto.getPageNum();
        Integer pageSize = controlInventoryReqDto.getPageSize() == null ? 10 : controlInventoryReqDto.getPageSize();
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlInventoryReqDto.getItemKeyword()})) {
            List controlInventoryItemAndRuleId = this.controlInventoryItemMapper.getControlInventoryItemAndRuleId(controlInventoryReqDto.getItemKeyword(), controlInventoryReqDto.getItemKeyword());
            if (ObjectUtils.isEmpty((Object)controlInventoryItemAndRuleId)) {
                dtoPageInfo.setPageNum(pageNum.intValue());
                dtoPageInfo.setPageSize(pageSize.intValue());
                return dtoPageInfo;
            }
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)StringUtils.join((Iterable)controlInventoryItemAndRuleId, (String)",")));
        }
        if (controlInventoryReqDto.getEnable() != null) {
            RuleEnableEnum enableEnum = RuleEnableEnum.enumOf((Integer)controlInventoryReqDto.getEnable());
            sqlFilterList.add(SqlFilter.eq((String)"enable", (Object)enableEnum.getValue()));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlInventoryReqDto.getRuleName()})) {
            sqlFilterList.add(SqlFilter.like((String)"rule_name", (Object)("%" + controlInventoryReqDto.getRuleName() + "%")));
        }
        this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u3010\u5206\u9875\u67e5\u8be2\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u89c4\u5219\u5217\u8868\u3011\u67e5\u8be2\u7684\u6761\u4ef6\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sqlFilterList));
        ControlInventoryRuleEo controlInventoryRuleEo = new ControlInventoryRuleEo();
        controlInventoryRuleEo.setOrgId(controlInventoryReqDto.getOrgId());
        controlInventoryRuleEo.setSqlFilters((List)sqlFilterList);
        controlInventoryRuleEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.controlInventoryRuleDas.selectPage((BaseEo)controlInventoryRuleEo, pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlInventoryRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public BizChangeRuleResultRespDto setEnable(Long ruleId, Integer enableStatus, Long orgId) {
        AssertUtils.notNull((Object)ruleId, (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RuleEnableEnum enableEnum = RuleEnableEnum.enumOf((Integer)enableStatus);
        BizChangeRuleResultRespDto<ControlInventoryAreaRespDto, ControlInventoryCustomerRespDto, ControlInventoryRespDto> resultRespDto = new BizChangeRuleResultRespDto<ControlInventoryAreaRespDto, ControlInventoryCustomerRespDto, ControlInventoryRespDto>();
        ControlInventoryRuleEo queryEo = new ControlInventoryRuleEo();
        queryEo.setId(ruleId);
        ControlInventoryRuleEo inventoryRuleEo = (ControlInventoryRuleEo)this.controlInventoryRuleDas.selectOne((BaseEo)queryEo);
        AssertUtils.notNull((Object)inventoryRuleEo, (String)"\u8be5\u89c4\u5219\u4e0d\u5b58\u5728\uff01");
        if (RuleEnableEnum.ENABLE.equals((Object)enableEnum)) {
            ArrayList controlItemCustomerReqDtoList;
            List controlInventoryCustomerEoList;
            ControlInventoryCustomerEo controlInventoryCustomerEo;
            BizControlInventoryReqDto modifyReqDto = new BizControlInventoryReqDto();
            CubeBeanUtils.copyProperties((Object)modifyReqDto, (Object)inventoryRuleEo, (String[])new String[0]);
            if (RuleRangeTypeEnum.CUSTOMER.getType().equals(inventoryRuleEo.getRuleRangeType())) {
                controlInventoryCustomerEo = new ControlInventoryCustomerEo();
                controlInventoryCustomerEo.setRuleId(ruleId);
                controlInventoryCustomerEo.setBlacklistStatus(YesOrNoEnum.NO.getCode());
                controlInventoryCustomerEoList = this.controlInventoryCustomerDas.select((BaseEo)controlInventoryCustomerEo);
                controlItemCustomerReqDtoList = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)controlInventoryCustomerEoList, (Collection)controlItemCustomerReqDtoList, ControlInventoryCustomerReqDto.class);
                modifyReqDto.setCustomerList((List)controlItemCustomerReqDtoList);
            }
            if (RuleRangeTypeEnum.AREA.getType().equals(inventoryRuleEo.getRuleRangeType())) {
                ControlInventoryAreaEo controlInventoryAreaEo = new ControlInventoryAreaEo();
                controlInventoryAreaEo.setRuleId(ruleId);
                List controlInventoryAreaEoList = this.controlInventoryAreaDas.select((BaseEo)controlInventoryAreaEo);
                List areaCodeList = controlInventoryAreaEoList.stream().map(c -> c.getAreaCode()).collect(Collectors.toList());
                modifyReqDto.setAreaList(areaCodeList);
            }
            controlInventoryCustomerEo = new ControlInventoryCustomerEo();
            controlInventoryCustomerEo.setRuleId(ruleId);
            controlInventoryCustomerEo.setBlacklistStatus(YesOrNoEnum.YES.getCode());
            controlInventoryCustomerEoList = this.controlInventoryCustomerDas.select((BaseEo)controlInventoryCustomerEo);
            controlItemCustomerReqDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)controlInventoryCustomerEoList, (Collection)controlItemCustomerReqDtoList, ControlInventoryCustomerReqDto.class);
            modifyReqDto.setCustomerBlackList((List)controlItemCustomerReqDtoList);
            ControlInventoryItemEo controlInventoryItemEo = new ControlInventoryItemEo();
            controlInventoryItemEo.setRuleId(ruleId);
            List controlInventoryItemEoList = this.controlInventoryItemDas.select((BaseEo)controlInventoryItemEo);
            ArrayList controlInventoryItemReqDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)controlInventoryItemEoList, (Collection)controlInventoryItemReqDtoList, ControlInventoryItemReqDto.class);
            modifyReqDto.setItemList((List)controlInventoryItemReqDtoList);
            modifyReqDto.setOrgId(orgId);
            resultRespDto = this.verifyRule(modifyReqDto);
            if (resultRespDto.getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
                return resultRespDto;
            }
        }
        inventoryRuleEo.setEnable(enableStatus);
        this.controlInventoryRuleDas.updateSelective((BaseEo)inventoryRuleEo);
        if (RuleRangeTypeEnum.CUSTOMER.getType().equals(inventoryRuleEo.getRuleRangeType())) {
            ControlInventoryCustomerEo controlInventoryCustomerEo = new ControlInventoryCustomerEo();
            controlInventoryCustomerEo.setEnable(enableStatus);
            controlInventoryCustomerEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
            this.controlInventoryCustomerDas.updateSelectiveSqlFilter((BaseEo)controlInventoryCustomerEo);
        }
        if (RuleRangeTypeEnum.AREA.getType().equals(inventoryRuleEo.getRuleRangeType())) {
            ControlInventoryAreaEo controlInventoryAreaEo = new ControlInventoryAreaEo();
            controlInventoryAreaEo.setEnable(enableStatus);
            controlInventoryAreaEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
            this.controlInventoryAreaDas.updateSelective((BaseEo)controlInventoryAreaEo);
        }
        ControlInventoryItemEo controlInventoryItemEo = new ControlInventoryItemEo();
        controlInventoryItemEo.setEnable(enableStatus);
        controlInventoryItemEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        this.controlInventoryItemDas.updateSelective((BaseEo)controlInventoryItemEo);
        return resultRespDto;
    }

    @Override
    public List<ControlInventoryItemRespDto> queryRuleByCustomer(Long customerId, String customerAreaCode, List<Long> itemIdList) {
        return null;
    }

    @Override
    public List<ControlInventoryItemRespDto> queryRuleByCustomerNew(CustomerControlInventoryReqDto reqDto) {
        List<ControlInventoryAreaRespDto> controlAreaList;
        List itemIdList = reqDto.getItemIdList();
        Long customerId = reqDto.getCustomerId();
        List customerAreaCodeList = reqDto.getCustomerAreaCodeList();
        AssertUtils.notEmpty((Collection)itemIdList, (String)"itemIdList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)customerId, (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)reqDto.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<ControlInventoryItemRespDto> itemRespDtoList = this.controlInventoryItemService.queryInventoryItemByitemIds(itemIdList);
        if (CollectionUtils.isEmpty(itemRespDtoList)) {
            this.logger.info("\u8be5\u6279\u5546\u54c1\u4e0d\u5b58\u5728\u5b89\u5168\u5e93\u5b58\u914d\u7f6e");
            return Lists.newArrayList();
        }
        List<Long> ruleIdList = itemRespDtoList.stream().map(ControlInventoryItemRespDto::getRuleId).distinct().collect(Collectors.toList());
        this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u5546\u54c1\u4e2d\u5b58\u5728\u7684\u89c4\u5219id\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(ruleIdList));
        ControlInventoryRuleEo queryEo = new ControlInventoryRuleEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"id", ruleIdList));
        filterList.add(SqlFilter.eq((String)"org_id", (Object)reqDto.getOrgId()));
        filterList.add(SqlFilter.eq((String)"enable", (Object)YesOrNoEnum.YES.getCode()));
        queryEo.setSqlFilters((List)filterList);
        List inventoryRuleEoList = this.controlInventoryRuleDas.select((BaseEo)queryEo);
        if (CollectionUtils.isEmpty((Collection)inventoryRuleEoList)) {
            this.logger.info("\u8be5\u7ec4\u7ec7\u4e0b\u4e0d\u5b58\u5728\u542f\u7528\u7684\u5b89\u5168\u5e93\u5b58\u914d\u7f6e");
            return Lists.newArrayList();
        }
        this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u627e\u5230\u7b26\u5408\u7ec4\u7ec7id[{}]\u7684\u89c4\u5219\uff1a{}", (Object)reqDto.getOrgId(), JSON.toJSON((Object)inventoryRuleEoList));
        ruleIdList = inventoryRuleEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        List<Object> blcakIdRuleIdList = Lists.newArrayList();
        List<Object> customerRuleAllList = Lists.newArrayList();
        List<ControlInventoryCustomerRespDto> inventoryCustomeList = this.controlInventoryCustomerService.verifyRuleForCustomer(ruleIdList, customerId);
        if (CollectionUtils.isNotEmpty(inventoryCustomeList)) {
            List customerBlackList = inventoryCustomeList.stream().filter(dto -> Objects.equals(dto.getBlacklistStatus(), YesOrNoEnum.YES.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(customerBlackList)) {
                blcakIdRuleIdList = customerBlackList.stream().map(ControlInventoryCustomerRespDto::getRuleId).distinct().collect(Collectors.toList());
            }
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u9ed1\u540d\u5355\u89c4\u5219id\u4e3a:{}", (Object)JSON.toJSONString((Object)blcakIdRuleIdList));
            List customerList = inventoryCustomeList.stream().filter(dto -> Objects.equals(dto.getBlacklistStatus(), YesOrNoEnum.NO.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(customerList)) {
                customerRuleAllList = customerList.stream().map(ControlInventoryCustomerRespDto::getRuleId).distinct().collect(Collectors.toList());
                this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u5ba2\u6237\u7c7b\u578b\u4e3a\u6307\u5b9a\u5ba2\u6237\uff0c\u7b26\u5408\u5ba2\u6237\u7684\u6821\u9a8c\u89c4\u5219id\u4e3a\uff1a{}", (Object)JSON.toJSONString(customerRuleAllList));
                if (CollectionUtils.isEmpty(customerRuleAllList)) {
                    this.logger.info("\u8be5\u6279\u5546\u54c1\u5bf9\u5e94\u5ba2\u6237\u4e0d\u5b58\u5728\u5b89\u5168\u5e93\u5b58\u914d\u7f6e");
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)customerAreaCodeList) && CollectionUtils.isNotEmpty(controlAreaList = this.controlInventoryAreaService.verifyRuleForArea(ruleIdList))) {
            Map<Long, List<ControlInventoryAreaRespDto>> areaRuleMap = controlAreaList.stream().collect(Collectors.groupingBy(ControlInventoryAreaRespDto::getRuleId));
            ArrayList areaRuleAllList = Lists.newArrayList();
            for (Long areaRuleKey : areaRuleMap.keySet()) {
                List areaRuleList = areaRuleMap.get(areaRuleKey).stream().map(ControlInventoryAreaRespDto::getAreaCode).collect(Collectors.toList());
                List collect = areaRuleList.stream().filter(customerAreaCodeList::contains).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(collect) || blcakIdRuleIdList.contains(areaRuleKey)) continue;
                areaRuleAllList.add(areaRuleKey);
            }
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u5ba2\u6237\u7c7b\u578b\u4e3a\u6307\u5b9a\u5ba2\u6237\u533a\u57df\uff0c\u7b26\u5408\u5ba2\u6237\u7684\u6821\u9a8c\u89c4\u5219id\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)areaRuleAllList));
            if (CollectionUtils.isEmpty((Collection)areaRuleAllList)) {
                this.logger.info("\u8be5\u6279\u5546\u54c1\u5bf9\u5e94\u5ba2\u6237\u533a\u57df\u4e0d\u5b58\u5728\u5b89\u5168\u5e93\u5b58\u914d\u7f6e");
            } else {
                customerRuleAllList.addAll(areaRuleAllList);
            }
        }
        List allRuleId = inventoryRuleEoList.stream().filter(e -> Objects.equals(e.getRuleRangeType(), "all")).map(BaseEo::getId).collect(Collectors.toList());
        this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u5ba2\u6237\u7c7b\u578b\u4e3a\u5168\u90e8\uff0c\u7b26\u5408\u5ba2\u6237\u7684\u6821\u9a8c\u89c4\u5219id\u4e3a\uff1a{}", (Object)JSON.toJSONString(allRuleId));
        if (CollectionUtils.isNotEmpty(allRuleId)) {
            customerRuleAllList.addAll(allRuleId);
        }
        if (CollectionUtils.isEmpty((Collection)customerRuleAllList)) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u672a\u627e\u5230\u7b26\u5408\u7684\u89c4\u5219ID");
            return Lists.newArrayList();
        }
        List<Object> effectRuleItemList = Lists.newArrayList();
        for (ControlInventoryItemRespDto itemRespDto : itemRespDtoList) {
            if (CollectionUtils.isNotEmpty((Collection)blcakIdRuleIdList) && blcakIdRuleIdList.contains(itemRespDto.getRuleId()) || !customerRuleAllList.contains(itemRespDto.getRuleId())) continue;
            effectRuleItemList.add(itemRespDto);
        }
        if (CollectionUtils.isEmpty((Collection)effectRuleItemList)) {
            this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u8fc7\u6ee4\u9ed1\u540d\u5355\u540e\u672a\u627e\u5230\u7b26\u5408\u7684\u89c4\u5219ID");
            return Lists.newArrayList();
        }
        Map inventoryRuleEoMap = Optional.ofNullable(inventoryRuleEoList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        effectRuleItemList.forEach(item -> {
            ControlInventoryRuleEo inventoryRuleEo = (ControlInventoryRuleEo)inventoryRuleEoMap.get(item.getRuleId());
            item.setRuleName(inventoryRuleEo.getRuleName());
            item.setRuleRangeType(inventoryRuleEo.getRuleRangeType());
        });
        effectRuleItemList = effectRuleItemList.stream().sorted(Comparator.comparing(BaseRuleRespDto::getRuleSort)).collect(Collectors.toList());
        this.logger.info("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u6821\u9a8c\u3011\u5ba2\u6237({})\u7b26\u5408\u5b89\u5168\u6821\u9a8c\u89c4\u5219\u4e3a\uff1a{}", (Object)customerId, (Object)JSON.toJSONString((Object)effectRuleItemList));
        return effectRuleItemList;
    }
}

