/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlItemReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlItemAreaReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemAreaService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlItemAreaDas;
import com.dtyunxi.tcbj.center.control.dao.das.ControlItemRuleDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlItemAreaEo;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlItemRuleEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ControlItemAreaServiceImpl
implements IControlItemAreaService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlItemAreaDas controlItemAreaDas;
    @Resource
    private ControlItemRuleDas controlItemRuleDas;
    @Resource
    private IControlItemService controlItemService;

    @Override
    public Long addControlItemArea(ControlItemAreaReqDto addReqDto) {
        ControlItemAreaEo controlItemAreaEo = new ControlItemAreaEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlItemAreaEo);
        this.controlItemAreaDas.insert((BaseEo)controlItemAreaEo);
        return controlItemAreaEo.getId();
    }

    @Override
    public void addControlAreaList(List<ControlItemAreaReqDto> areaList) {
        if (CollectionUtils.isEmpty(areaList)) {
            throw ControlExceptionCode.AREA_EMPTY.getException();
        }
        if (areaList.get(0).getRuleId() == null) {
            this.logger.error("\u3010\u5355\u54c1\u7ba1\u63a7\u3011ruleId\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(areaList));
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ArrayList itemAreaEos = Lists.newArrayList();
        DtoHelper.dtoList2EoList(areaList, (Collection)itemAreaEos, ControlItemAreaEo.class);
        int result = this.controlItemAreaDas.insertBatch((List)itemAreaEos);
        if (result < 0) {
            this.logger.error("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u6279\u91cf\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(areaList));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
    }

    @Override
    public void modifyControlItemArea(ControlItemAreaReqDto modifyReqDto) {
        ControlItemAreaEo controlItemAreaEo = new ControlItemAreaEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)controlItemAreaEo);
        this.controlItemAreaDas.updateSelective((BaseEo)controlItemAreaEo);
    }

    @Override
    public int modifyPurchasedCount(Integer purchasedCount, Long id) {
        return this.controlItemAreaDas.updatePurchasedCount(purchasedCount, id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlItemArea(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlItemAreaDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ControlItemAreaRespDto queryById(Long id) {
        ControlItemAreaEo controlItemAreaEo = (ControlItemAreaEo)this.controlItemAreaDas.selectByPrimaryKey(id);
        ControlItemAreaRespDto controlItemAreaRespDto = new ControlItemAreaRespDto();
        DtoHelper.eo2Dto((BaseEo)controlItemAreaEo, (BaseVo)controlItemAreaRespDto);
        return controlItemAreaRespDto;
    }

    @Override
    public List<ControlItemAreaRespDto> queryByRuleId(Long ruleId) {
        ControlItemAreaEo controlItemAreaEo = new ControlItemAreaEo();
        controlItemAreaEo.setRuleId(ruleId);
        List select = this.controlItemAreaDas.select((BaseEo)controlItemAreaEo);
        ArrayList<ControlItemAreaRespDto> controlItemAreaRespDtoList = new ArrayList<ControlItemAreaRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, controlItemAreaRespDtoList, ControlItemAreaRespDto.class);
        return controlItemAreaRespDtoList;
    }

    @Override
    public PageInfo<ControlItemAreaRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ControlItemAreaReqDto controlItemAreaReqDto = (ControlItemAreaReqDto)JSON.parseObject((String)filter, ControlItemAreaReqDto.class);
        ControlItemAreaEo controlItemAreaEo = new ControlItemAreaEo();
        DtoHelper.dto2Eo((BaseVo)controlItemAreaReqDto, (BaseEo)controlItemAreaEo);
        PageInfo eoPageInfo = this.controlItemAreaDas.selectPage((BaseEo)controlItemAreaEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlItemAreaRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void removeControlAreaByRuleId(Long ruleId) {
        if (ruleId == null) {
            this.logger.error("\u3010\u5355\u54c1\u7ba1\u63a7\u3011ruleId\u4e0d\u80fd\u4e3a\u7a7a");
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ControlItemAreaEo areaEo = new ControlItemAreaEo();
        areaEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        this.controlItemAreaDas.delete((BaseEo)areaEo);
    }

    @Override
    public List<ControlItemAreaRespDto> verifyRuleForArea(BizControlItemReqDto addReqDto, Long rule_id) {
        List areaList = addReqDto.getAreaList();
        if (CollectionUtils.isEmpty((Collection)areaList)) {
            return null;
        }
        ArrayList areaCodeList = Lists.newArrayList();
        areaList.forEach(c -> areaCodeList.addAll(!ObjectUtils.isEmpty((Object)c.getAreaCodeList()) ? c.getAreaCodeList() : Lists.newArrayList()));
        List itemIdList = areaList.stream().map(ControlItemAreaReqDto::getItemId).distinct().collect(Collectors.toList());
        ControlItemAreaEo queryEo = new ControlItemAreaEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"area_code", (Object)areaCodeList));
        sqlFilters.add(SqlFilter.in((String)"item_id", itemIdList));
        if (Objects.nonNull(rule_id)) {
            sqlFilters.add(SqlFilter.ne((String)"rule_id", (Object)rule_id));
        }
        sqlFilters.add(SqlFilter.eq((String)"enable", (Object)RuleEnableEnum.ENABLE.getValue()));
        queryEo.setSqlFilters((List)sqlFilters);
        List reAreaList = this.controlItemAreaDas.select((BaseEo)queryEo);
        ArrayList result = Lists.newArrayList();
        Map<Object, Object> collect = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)reAreaList)) {
            List reRuleList = this.controlItemRuleDas.selectByIds(reAreaList.stream().distinct().map(ControlItemAreaEo::getRuleId).collect(Collectors.toList()));
            collect = reRuleList.stream().collect(Collectors.groupingBy(BaseEo::getId));
        }
        for (ControlItemAreaReqDto itemAreaReqDto : areaList) {
            for (ControlItemAreaEo itemAreaEo : reAreaList) {
                AssertUtils.notEmpty((String)itemAreaReqDto.getAreaCode(), (String)String.format("\u533a\u57df\u4fe1\u606f\uff1a%s,\u533a\u57dfcode\u4e0d\u80fd\u4e3a\u7a7a", JSON.toJSONString((Object)itemAreaReqDto)));
                AssertUtils.notNull((Object)itemAreaReqDto.getItemId(), (String)String.format("\u533a\u57df\u4fe1\u606f\uff1a%s,\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a", JSON.toJSONString((Object)itemAreaReqDto)));
                if (!itemAreaReqDto.getAreaCodeList().contains(itemAreaEo.getAreaCode()) || !itemAreaReqDto.getItemCode().equals(itemAreaEo.getItemCode())) continue;
                ControlItemRuleEo reEo = (ControlItemRuleEo)((List)collect.get(itemAreaEo.getRuleId())).get(0);
                if (addReqDto.getControlStartDate().compareTo(reEo.getControlEndDate()) > 0 || addReqDto.getControlEndDate().compareTo(reEo.getControlStartDate()) < 0) {
                    ControlItemAreaRespDto controlItemAreaRespDto = new ControlItemAreaRespDto();
                    DtoHelper.eo2Dto((BaseEo)itemAreaEo, (BaseVo)controlItemAreaRespDto);
                    result.add(controlItemAreaRespDto);
                    continue;
                }
                throw new BizException(ControlExceptionCode.ENABLE_UNALLOW.getCode(), "\u4e0e" + reEo.getRuleName() + "\u5728\u533a\u57df/\u5546\u54c1/\u65f6\u95f4\u4e0a\u6709\u4ea4\u53e0");
            }
        }
        return result;
    }

    @Override
    public List<ControlItemAreaRespDto> queryByItemIds(List<Long> itemIdList) {
        AssertUtils.notEmpty(itemIdList, (String)"itemList \u4e0d\u80fd\u4e3a\u7a7a");
        ControlItemAreaEo queryEo = new ControlItemAreaEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"item_id", itemIdList));
        queryEo.setSqlFilters((List)filterList);
        List itemAreaEos = this.controlItemAreaDas.select((BaseEo)queryEo);
        ArrayList areaRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemAreaEos, (Collection)areaRespDtoList, ControlItemAreaRespDto.class);
        return areaRespDtoList;
    }

    @Override
    public List<ControlItemAreaRespDto> queryList(ControlItemAreaReqDto controlItemAreaReqDto) {
        ControlItemAreaEo controlItemAreaEo = new ControlItemAreaEo();
        DtoHelper.dto2Eo((BaseVo)controlItemAreaReqDto, (BaseEo)controlItemAreaEo);
        List controlItemAreaEos = this.controlItemAreaDas.select((BaseEo)controlItemAreaEo);
        ArrayList<ControlItemAreaRespDto> controlItemAreaRespDtos = new ArrayList<ControlItemAreaRespDto>();
        DtoHelper.eoList2DtoList((Collection)controlItemAreaEos, controlItemAreaRespDtos, ControlItemAreaRespDto.class);
        return controlItemAreaRespDtos;
    }
}

