/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.AmountStatusEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountEnoughEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountIsAccumulateEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountSwitchEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountType;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountWay;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountWayEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftCalculateWay;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleRangeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizContolGiftReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlGiftResultReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizOrderItemReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerGiftAmountReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftConfigReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftRuleReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizChangeRuleResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizContolGiftRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.CustomerGiftAmountInfo;
import com.dtyunxi.tcbj.center.control.api.dto.response.GiftAmountItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftConfigRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.scheduleds.DisabledGiftScheduled;
import com.dtyunxi.tcbj.center.control.biz.scheduleds.biz.BizDisabledGift;
import com.dtyunxi.tcbj.center.control.biz.scheduleds.biz.BizDisabledRuleGift;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftAreaService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftBlacklistService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftConfigService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftCustomerService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftFreebieService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftItemService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftResultService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftRuleService;
import com.dtyunxi.tcbj.center.control.biz.utils.RedisCacheHelper;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftAreaDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftBlacklistDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftCustomerDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftFreebieDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftItemDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftResultDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftRuleDas;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftAreaEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftBlacklistEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftCustomerEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftFreebieEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftItemEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftResultEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftRuleEo;
import com.dtyunxi.tcbj.center.control.dao.mapper.TrControlGiftResultMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class TrControlGiftRuleServiceImpl
implements ITrControlGiftRuleService {
    private static Logger logger = LoggerFactory.getLogger(TrControlGiftRuleServiceImpl.class);
    private static final Integer IS_NEW = 1;
    private static final Integer SELECTED = 1;
    public static final Integer NOT_CONTAIN_GIFT = 0;
    private static final Integer IS_PRODUCT = 1;
    @Resource
    private TrControlGiftRuleDas trControlGiftRuleDas;
    @Resource
    private TrControlGiftAreaDas trControlGiftAreaDas;
    @Resource
    private TrControlGiftCustomerDas trControlGiftCustomerDas;
    @Resource
    private TrControlGiftItemDas trControlGiftItemDas;
    @Resource
    private TrControlGiftResultDas controlGiftResultDas;
    @Resource
    private TrControlGiftFreebieDas trControlGiftFreebieDas;
    @Resource
    private TrControlGiftBlacklistDas trControlGiftBlacklistDas;
    @Resource
    private ITrControlGiftAreaService trControlGiftAreaService;
    @Resource
    private ITrControlGiftBlacklistService trControlGiftBlacklistService;
    @Resource
    private ITrControlGiftCustomerService trControlGiftCustomerService;
    @Resource
    private ITrControlGiftFreebieService trControlGiftFreebieService;
    @Resource
    private ITrControlGiftItemService trControlGiftItemService;
    @Resource
    private TrControlGiftResultMapper controlGiftResultMapper;
    @Resource
    private ITrControlGiftConfigService trControlGiftConfigService;
    @Resource
    private RedisCacheHelper cacheHelper;
    @Resource
    private ITrControlGiftResultService giftResultService;
    @Resource
    private BizDisabledGift bizDisabledGift;
    @Resource
    private BizDisabledRuleGift bizDisabledRuleGift;
    @Resource
    private DisabledGiftScheduled disabledGiftScheduled;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizChangeRuleResultRespDto<TrControlGiftAreaRespDto, TrControlGiftCustomerRespDto, TrControlGiftRuleRespDto> addTrControlGiftRule(BizContolGiftReqDto addReqDto) {
        TrControlGiftConfigRespDto trControlGiftConfigRespDto;
        List giftAreaEos;
        int result;
        Long tasks;
        AssertUtils.notNull((Object)addReqDto.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        BizChangeRuleResultRespDto respDto = new BizChangeRuleResultRespDto();
        TrControlGiftRuleEo trControlGiftRuleEo = new TrControlGiftRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)trControlGiftRuleEo);
        AssertUtils.notNull((Object)trControlGiftRuleEo.getControlStartTime(), (String)"\u6267\u884c\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        trControlGiftRuleEo.setStatus(trControlGiftRuleEo.getControlEndTime().compareTo(new Date()) <= 0 ? AmountStatusEnum.USED.getType() : (trControlGiftRuleEo.getControlStartTime().compareTo(new Date()) <= 0 ? AmountStatusEnum.USING.getType() : AmountStatusEnum.USE.getType()));
        int results = this.trControlGiftRuleDas.insert((BaseEo)trControlGiftRuleEo);
        if (results < 0) {
            logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u89c4\u5219\u3011\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)trControlGiftRuleEo));
        }
        if (trControlGiftRuleEo.getStatus().equals(AmountStatusEnum.USE.getType())) {
            tasks = this.bizDisabledRuleGift.createTasks(trControlGiftRuleEo.getControlStartTime(), trControlGiftRuleEo.getId());
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u65b0\u589e\u3011\u5904\u7406\u89c4\u5219\u751f\u6548\u72b6\u6001\u8c03\u5ea6Id:{}", (Object)tasks);
        }
        if (!trControlGiftRuleEo.getStatus().equals(AmountStatusEnum.USED.getType())) {
            Long disableTasks = this.bizDisabledRuleGift.createTasks(trControlGiftRuleEo.getControlEndTime(), trControlGiftRuleEo.getId());
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u65b0\u589e\u3011\u5904\u7406\u89c4\u5219\u8fc7\u671f\u72b6\u6001\u8c03\u5ea6Id:{}", (Object)disableTasks);
        }
        if (trControlGiftRuleEo.getLoseTime().compareTo(DateUtil.getToday()) > 0) {
            tasks = this.bizDisabledGift.createTasks(trControlGiftRuleEo.getLoseTime(), trControlGiftRuleEo.getId());
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u65b0\u589e\u3011\u5904\u7406\u89c4\u5219\u8d60\u54c1\u989d\u5ea6\u8fc7\u671f\u8c03\u5ea6Id:{}", (Object)tasks);
        }
        if (addReqDto.getRuleRangeType().equals(RuleRangeTypeEnum.AREA.getType()) && (result = this.trControlGiftAreaDas.insertBatch(giftAreaEos = addReqDto.getAreaList().stream().map(c -> {
            TrControlGiftAreaEo trControlGiftAreaEo = new TrControlGiftAreaEo();
            trControlGiftAreaEo.setRuleId(trControlGiftRuleEo.getId());
            trControlGiftAreaEo.setAreaCode(c);
            return trControlGiftAreaEo;
        }).collect(Collectors.toList()))) < 0) {
            logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(giftAreaEos));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
        if (addReqDto.getRuleRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType())) {
            ArrayList giftCustomerEos = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)addReqDto.getCustomerList(), (Collection)giftCustomerEos, TrControlGiftCustomerEo.class);
            giftCustomerEos.forEach(c -> c.setRuleId(trControlGiftRuleEo.getId()));
            result = this.trControlGiftCustomerDas.insertBatch((List)giftCustomerEos);
            if (result < 0) {
                logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)giftCustomerEos));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        if (addReqDto.getItemRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType())) {
            ArrayList itemEoList = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)addReqDto.getItemList(), (Collection)itemEoList, TrControlGiftItemEo.class);
            itemEoList.forEach(c -> c.setRuleId(trControlGiftRuleEo.getId()));
            result = this.trControlGiftItemDas.insertBatch((List)itemEoList);
            if (result < 0) {
                logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)itemEoList));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        if (!ObjectUtils.isEmpty((Object)addReqDto.getGiftList())) {
            ArrayList giftFreebieEos = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)addReqDto.getGiftList(), (Collection)giftFreebieEos, TrControlGiftFreebieEo.class);
            giftFreebieEos.forEach(c -> c.setRuleId(trControlGiftRuleEo.getId()));
            result = this.trControlGiftFreebieDas.insertBatch((List)giftFreebieEos);
            if (result < 0) {
                logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u8d60\u54c1\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)giftFreebieEos));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        if (!ObjectUtils.isEmpty((Object)addReqDto.getBlackList())) {
            ArrayList giftBlacklistEos = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)addReqDto.getBlackList(), (Collection)giftBlacklistEos, TrControlGiftBlacklistEo.class);
            giftBlacklistEos.forEach(c -> c.setRuleId(trControlGiftRuleEo.getId()));
            result = this.trControlGiftBlacklistDas.insertBatch((List)giftBlacklistEos);
            if (result < 0) {
                logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u9ed1\u540d\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)giftBlacklistEos));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        if (ObjectUtils.isEmpty((Object)(trControlGiftConfigRespDto = this.trControlGiftConfigService.queryByOrgId(addReqDto.getOrgId())))) {
            TrControlGiftConfigReqDto trControlGiftConfigReqDto = new TrControlGiftConfigReqDto();
            trControlGiftConfigReqDto.setIsSwitchConfig(GiftAmountSwitchEnum.CLOSE.getType());
            trControlGiftConfigReqDto.setOrgId(addReqDto.getOrgId());
            this.trControlGiftConfigService.addTrControlGiftConfig(trControlGiftConfigReqDto);
        }
        return respDto;
    }

    @Override
    public BizChangeRuleResultRespDto<TrControlGiftAreaRespDto, TrControlGiftCustomerRespDto, TrControlGiftRuleRespDto> modifyTrControlGiftRule(BizContolGiftReqDto modifyReqDto) {
        int result;
        TrControlGiftResultEo trControlGiftResultEo;
        Long tasks;
        AssertUtils.notNull((Object)modifyReqDto.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        BizChangeRuleResultRespDto respDto = new BizChangeRuleResultRespDto();
        TrControlGiftRuleEo controlGiftRuleEos = (TrControlGiftRuleEo)this.trControlGiftRuleDas.selectByPrimaryKey(modifyReqDto.getId());
        if (!controlGiftRuleEos.getControlEndTime().equals(modifyReqDto.getControlEndTime())) {
            tasks = this.bizDisabledRuleGift.createTasks(modifyReqDto.getControlEndTime(), modifyReqDto.getId());
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u65b0\u589e\u4fee\u6539\u3011\u5904\u7406\u89c4\u5219\u8fc7\u671f\u72b6\u6001\u8c03\u5ea6Id:{}", (Object)tasks);
        }
        modifyReqDto.setStatus(modifyReqDto.getControlEndTime().compareTo(new Date()) <= 0 ? AmountStatusEnum.USED.getType() : (modifyReqDto.getControlStartTime().compareTo(new Date()) <= 0 ? AmountStatusEnum.USING.getType() : AmountStatusEnum.USE.getType()));
        if (modifyReqDto.getStatus().equals(AmountStatusEnum.USE.getType()) && !modifyReqDto.getControlStartTime().equals(controlGiftRuleEos.getControlStartTime())) {
            tasks = this.bizDisabledRuleGift.createTasks(modifyReqDto.getControlStartTime(), modifyReqDto.getId());
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u65b0\u589e\u3011\u5904\u7406\u89c4\u5219\u751f\u6548\u72b6\u6001\u8c03\u5ea6Id:{}", (Object)tasks);
        }
        if (!modifyReqDto.getStatus().equals(AmountStatusEnum.USED.getType()) && !modifyReqDto.getControlEndTime().equals(controlGiftRuleEos.getControlEndTime())) {
            Long disableTasks = this.bizDisabledRuleGift.createTasks(modifyReqDto.getControlEndTime(), modifyReqDto.getId());
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u65b0\u589e\u3011\u5904\u7406\u89c4\u5219\u8fc7\u671f\u72b6\u6001\u8c03\u5ea6Id:{}", (Object)disableTasks);
        }
        Date today = DateUtil.getToday();
        if (!controlGiftRuleEos.getValidTime().equals(modifyReqDto.getValidTime())) {
            trControlGiftResultEo = new TrControlGiftResultEo();
            trControlGiftResultEo.setValidTime(modifyReqDto.getValidTime());
            trControlGiftResultEo.setStatus(AmountStatusEnum.USING.getType());
            if (modifyReqDto.getValidTime().compareTo(today) > 0) {
                trControlGiftResultEo.setStatus(AmountStatusEnum.USE.getType());
            }
            trControlGiftResultEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)controlGiftRuleEos.getId())}));
            this.controlGiftResultDas.updateSelectiveSqlFilter((BaseEo)trControlGiftResultEo);
        }
        if (!controlGiftRuleEos.getLoseTime().equals(modifyReqDto.getLoseTime())) {
            if (modifyReqDto.getLoseTime().compareTo(today) > 0) {
                Long tasks2 = this.bizDisabledGift.createTasks(modifyReqDto.getLoseTime(), modifyReqDto.getId());
                logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u65b0\u589e\u3011\u5904\u7406\u89c4\u5219\u8d60\u54c1\u989d\u5ea6\u8fc7\u671f\u8c03\u5ea6Id:{}", (Object)tasks2);
            }
            if (modifyReqDto.getLoseTime().compareTo(today) <= 0) {
                this.disabledGiftScheduled.disabledGiftAmountScheduled(String.valueOf(modifyReqDto.getId()));
            }
            trControlGiftResultEo = new TrControlGiftResultEo();
            trControlGiftResultEo.setLoseTime(modifyReqDto.getLoseTime());
            trControlGiftResultEo.setStatus(AmountStatusEnum.USING.getType());
            if (modifyReqDto.getLoseTime().compareTo(today) < 0) {
                trControlGiftResultEo.setStatus(AmountStatusEnum.USED.getType());
            }
            trControlGiftResultEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)controlGiftRuleEos.getId())}));
            this.controlGiftResultDas.updateSelectiveSqlFilter((BaseEo)trControlGiftResultEo);
        }
        TrControlGiftRuleEo trControlGiftRuleEo = new TrControlGiftRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)trControlGiftRuleEo);
        this.trControlGiftRuleDas.updateSelective((BaseEo)trControlGiftRuleEo);
        if (modifyReqDto.getRuleRangeType().equals(RuleRangeTypeEnum.AREA.getType())) {
            this.trControlGiftAreaService.deleteControlGiftAreaByRuleId(trControlGiftRuleEo.getId());
            List giftAreaEos = modifyReqDto.getAreaList().stream().map(c -> {
                TrControlGiftAreaEo trControlGiftAreaEo = new TrControlGiftAreaEo();
                trControlGiftAreaEo.setRuleId(trControlGiftRuleEo.getId());
                trControlGiftAreaEo.setAreaCode(c);
                return trControlGiftAreaEo;
            }).collect(Collectors.toList());
            result = this.trControlGiftAreaDas.insertBatch(giftAreaEos);
            if (result < 0) {
                logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(giftAreaEos));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        if (modifyReqDto.getRuleRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType())) {
            this.trControlGiftCustomerService.deleteControlGiftCustomerByRuleId(trControlGiftRuleEo.getId());
            ArrayList giftCustomerEos = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)modifyReqDto.getCustomerList(), (Collection)giftCustomerEos, TrControlGiftCustomerEo.class);
            giftCustomerEos.forEach(c -> c.setRuleId(trControlGiftRuleEo.getId()));
            result = this.trControlGiftCustomerDas.insertBatch((List)giftCustomerEos);
            if (result < 0) {
                logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)giftCustomerEos));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        if (modifyReqDto.getItemRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType())) {
            this.trControlGiftItemService.deleteControlGiftItemByRuleId(trControlGiftRuleEo.getId());
            ArrayList itemEoList = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)modifyReqDto.getItemList(), (Collection)itemEoList, TrControlGiftItemEo.class);
            itemEoList.forEach(c -> c.setRuleId(trControlGiftRuleEo.getId()));
            result = this.trControlGiftItemDas.insertBatch((List)itemEoList);
            if (result < 0) {
                logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)itemEoList));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        this.trControlGiftFreebieService.deleteControlGiftFreebieByRuleId(trControlGiftRuleEo.getId());
        if (!ObjectUtils.isEmpty((Object)modifyReqDto.getGiftList())) {
            ArrayList giftFreebieEos = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)modifyReqDto.getGiftList(), (Collection)giftFreebieEos, TrControlGiftFreebieEo.class);
            giftFreebieEos.forEach(c -> c.setRuleId(trControlGiftRuleEo.getId()));
            result = this.trControlGiftFreebieDas.insertBatch((List)giftFreebieEos);
            if (result < 0) {
                logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u8d60\u54c1\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)giftFreebieEos));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        this.trControlGiftBlacklistService.deleteControlGiftBlacklistByRuleId(trControlGiftRuleEo.getId());
        if (!ObjectUtils.isEmpty((Object)modifyReqDto.getBlackList())) {
            ArrayList giftBlacklistEos = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)modifyReqDto.getBlackList(), (Collection)giftBlacklistEos, TrControlGiftBlacklistEo.class);
            giftBlacklistEos.forEach(c -> c.setRuleId(trControlGiftRuleEo.getId()));
            result = this.trControlGiftBlacklistDas.insertBatch((List)giftBlacklistEos);
            if (result < 0) {
                logger.error("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u6279\u91cf\u9ed1\u540d\u5355\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)giftBlacklistEos));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        return respDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTrControlGiftRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.trControlGiftRuleDas.logicDeleteById(Long.valueOf(id));
            this.trControlGiftAreaService.deleteControlGiftAreaByRuleId(Long.valueOf(id));
            this.trControlGiftCustomerService.deleteControlGiftCustomerByRuleId(Long.valueOf(id));
            this.trControlGiftItemService.deleteControlGiftItemByRuleId(Long.valueOf(id));
            this.trControlGiftFreebieService.deleteControlGiftFreebieByRuleId(Long.valueOf(id));
            this.trControlGiftBlacklistService.deleteControlGiftBlacklistByRuleId(Long.valueOf(id));
        }
    }

    @Override
    public BizContolGiftRespDto queryById(Long id) {
        if (ObjectUtils.isEmpty((Object)id)) {
            AssertUtils.notNull((Object)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        BizContolGiftRespDto bizContolGiftRespDto = new BizContolGiftRespDto();
        TrControlGiftRuleEo trControlGiftRuleEo = (TrControlGiftRuleEo)this.trControlGiftRuleDas.selectByPrimaryKey(id);
        if (ObjectUtils.isEmpty((Object)trControlGiftRuleEo)) {
            return null;
        }
        DtoHelper.eo2Dto((BaseEo)trControlGiftRuleEo, (BaseVo)bizContolGiftRespDto);
        if (bizContolGiftRespDto.getRuleRangeType().equals(RuleRangeTypeEnum.AREA.getType())) {
            List<TrControlGiftAreaRespDto> areaRespDtos = this.trControlGiftAreaService.queryGiftAreaRespDtoByRuleId(bizContolGiftRespDto.getId());
            List areaCodeList = Optional.ofNullable(areaRespDtos).orElse(Lists.newArrayList()).stream().map(c -> c.getAreaCode()).collect(Collectors.toList());
            bizContolGiftRespDto.setAreaList(areaCodeList);
        }
        if (bizContolGiftRespDto.getRuleRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType())) {
            List<TrControlGiftCustomerRespDto> giftCustomerRespDtos = this.trControlGiftCustomerService.queryGiftCustomerRespDtoByRuleId(bizContolGiftRespDto.getId());
            bizContolGiftRespDto.setCustomerList(giftCustomerRespDtos);
        }
        if (bizContolGiftRespDto.getItemRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType())) {
            List<TrControlGiftItemRespDto> giftItemRespDtos = this.trControlGiftItemService.queryGiftItemRespDtoByRuleId(bizContolGiftRespDto.getId());
            bizContolGiftRespDto.setItemList(giftItemRespDtos);
        }
        bizContolGiftRespDto.setGiftList(Optional.ofNullable(this.trControlGiftFreebieService.queryGiftFreebieRespDtoByRuleId(bizContolGiftRespDto.getId())).orElse(Lists.newArrayList()));
        bizContolGiftRespDto.setBlackList(Optional.ofNullable(this.trControlGiftBlacklistService.queryGiftBlacklistRespDtoByRuleId(bizContolGiftRespDto.getId())).orElse(Lists.newArrayList()));
        return bizContolGiftRespDto;
    }

    @Override
    public PageInfo<TrControlGiftRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List ruleIds;
        TrControlGiftRuleReqDto trControlGiftRuleReqDto = (TrControlGiftRuleReqDto)JSON.parseObject((String)filter, TrControlGiftRuleReqDto.class);
        TrControlGiftRuleEo trControlGiftRuleEo = new TrControlGiftRuleEo();
        DtoHelper.dto2Eo((BaseVo)trControlGiftRuleReqDto, (BaseEo)trControlGiftRuleEo, (String[])new String[]{"name"});
        AssertUtils.notNull((Object)trControlGiftRuleEo.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ArrayList sqlFilters = Lists.newArrayList();
        ArrayList ruleIdList = Lists.newArrayList();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{trControlGiftRuleReqDto.getGiftName()})) {
            TrControlGiftFreebieEo trControlGiftFreebieEo = new TrControlGiftFreebieEo();
            trControlGiftFreebieEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.like((String)"item_name", (Object)trControlGiftRuleReqDto.getGiftName())}));
            List giftFreebieEos = this.trControlGiftFreebieDas.select((BaseEo)trControlGiftFreebieEo);
            if (ObjectUtils.isEmpty((Object)giftFreebieEos)) {
                return null;
            }
            ruleIds = giftFreebieEos.stream().map(c -> c.getRuleId()).collect(Collectors.toList());
            ruleIdList.addAll(ruleIds);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{trControlGiftRuleReqDto.getItemName()})) {
            TrControlGiftItemEo trControlGiftItemEo = new TrControlGiftItemEo();
            trControlGiftItemEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.like((String)"item_name", (Object)trControlGiftRuleReqDto.getItemName())}));
            List controlGiftItemEos = this.trControlGiftItemDas.select((BaseEo)trControlGiftItemEo);
            if (ObjectUtils.isEmpty((Object)controlGiftItemEos)) {
                return null;
            }
            ruleIds = controlGiftItemEos.stream().map(c -> c.getRuleId()).collect(Collectors.toList());
            ruleIdList.addAll(ruleIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)ruleIdList)) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)ruleIdList));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftRuleReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)trControlGiftRuleReqDto.getName()));
        }
        if (!ObjectUtils.isEmpty((Object)trControlGiftRuleEo.getControlStartTime())) {
            trControlGiftRuleEo.setControlStartTime(null);
            sqlFilters.add(SqlFilter.ge((String)"control_start_time", (Object)trControlGiftRuleReqDto.getControlStartTime()));
        }
        if (!ObjectUtils.isEmpty((Object)trControlGiftRuleEo.getControlEndTime())) {
            trControlGiftRuleEo.setControlStartTime(null);
            sqlFilters.add(SqlFilter.ge((String)"control_end_time", (Object)trControlGiftRuleReqDto.getControlEndTime()));
        }
        trControlGiftRuleEo.setOrderByDesc("create_time");
        trControlGiftRuleEo.setSqlFilters((List)sqlFilters);
        PageInfo eoPageInfo = this.trControlGiftRuleDas.selectPage((BaseEo)trControlGiftRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TrControlGiftRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<TrControlGiftRuleEo> getControlGiftRuleByRuleIds(List<Long> ruleIds) {
        AssertUtils.notEmpty(ruleIds, (String)"\u89c4\u5219id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        return this.trControlGiftRuleDas.selectByIds(ruleIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyControlGiftRule(TrControlGiftRuleEo controlGiftRuleEo) {
        this.trControlGiftRuleDas.updateSelective((BaseEo)controlGiftRuleEo);
    }

    public BizChangeRuleResultRespDto<TrControlGiftAreaRespDto, TrControlGiftCustomerRespDto, TrControlGiftRuleRespDto> verifyRule(BizContolGiftReqDto modifyReqDto) {
        ArrayList controlGiftRuleRespDtos;
        List controlGiftRuleEoList;
        List controlGiftAreaEoList;
        BizChangeRuleResultRespDto respDto = new BizChangeRuleResultRespDto();
        List<Object> collect = Lists.newArrayList();
        List<Object> ruleIdList = Lists.newArrayList();
        if (modifyReqDto.getItemRangeType().equals(RuleRangeTypeEnum.ALL.getType())) {
            TrControlGiftRuleEo trControlGiftRuleEo = new TrControlGiftRuleEo();
            trControlGiftRuleEo.setItemRangeType(RuleRangeTypeEnum.ALL.getType());
            trControlGiftRuleEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"status", Arrays.asList(AmountStatusEnum.USING.getType(), AmountStatusEnum.USE.getType()))}));
            trControlGiftRuleEo.setOrgId(modifyReqDto.getOrgId());
            List imposeRuleList = this.trControlGiftRuleDas.select((BaseEo)trControlGiftRuleEo);
            collect = Optional.ofNullable(imposeRuleList).orElse(Lists.newArrayList()).stream().filter(c -> c.getControlEndTime().compareTo(modifyReqDto.getControlStartTime()) >= 0 && !c.getId().equals(modifyReqDto.getId())).collect(Collectors.toList());
            ruleIdList = ((List)Optional.ofNullable(collect).orElse(Lists.newArrayList())).stream().map(c -> c.getId()).collect(Collectors.toList());
        } else {
            TrControlGiftItemEo trControlGiftItemEo = new TrControlGiftItemEo();
            trControlGiftItemEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"item_code", Optional.ofNullable(modifyReqDto.getItemList()).orElse(Lists.newArrayList()).stream().map(c -> c.getItemCode()).collect(Collectors.toList()))}));
            trControlGiftItemEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"item_sku_code", Optional.ofNullable(modifyReqDto.getItemList()).orElse(Lists.newArrayList()).stream().map(c -> c.getItemSkuCode()).collect(Collectors.toList()))}));
            List itemEoList = this.trControlGiftItemDas.select((BaseEo)trControlGiftItemEo);
            List allRuleIdList = itemEoList.stream().filter(c -> !c.getRuleId().equals(modifyReqDto.getId())).map(c -> c.getRuleId()).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(allRuleIdList)) {
                collect = Optional.ofNullable(this.trControlGiftRuleDas.selectByIds(allRuleIdList)).orElse(Lists.newArrayList()).stream().filter(c -> c.getOrgId().equals(modifyReqDto.getOrgId())).collect(Collectors.toList());
                ruleIdList = collect.stream().map(c -> c.getId()).collect(Collectors.toList());
            }
        }
        if (ObjectUtils.isEmpty((Object)ruleIdList)) {
            return respDto;
        }
        if (modifyReqDto.getRuleRangeType().equals(RuleRangeTypeEnum.AREA.getType())) {
            TrControlGiftAreaEo trControlGiftAreaEo = new TrControlGiftAreaEo();
            trControlGiftAreaEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"rule_id", (Object)ruleIdList)}));
            controlGiftAreaEoList = this.trControlGiftAreaDas.select((BaseEo)trControlGiftAreaEo);
            List areaCodeList = controlGiftAreaEoList.stream().map(c -> c.getAreaCode()).collect(Collectors.toList());
            List verifyAreaCodeList = modifyReqDto.getAreaList().stream().filter(c -> areaCodeList.contains(c)).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(verifyAreaCodeList)) {
                respDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                ArrayList areaRespDtos = Lists.newArrayList();
                List controlGiftAreaEos = controlGiftAreaEoList.stream().filter(c -> verifyAreaCodeList.contains(c.getAreaCode())).collect(Collectors.toList());
                DtoHelper.eoList2DtoList(controlGiftAreaEos, (Collection)areaRespDtos, TrControlGiftAreaRespDto.class);
                respDto.setAreaList((List)areaRespDtos);
                List areaAndRuleId = controlGiftAreaEos.stream().map(c -> c.getRuleId()).collect(Collectors.toList());
                controlGiftRuleEoList = collect.stream().filter(c -> areaAndRuleId.contains(c.getId())).collect(Collectors.toList());
                controlGiftRuleRespDtos = Lists.newArrayList();
                DtoHelper.eoList2DtoList(controlGiftRuleEoList, (Collection)controlGiftRuleRespDtos, TrControlGiftRuleRespDto.class);
                respDto.setConflictRuleList((List)controlGiftRuleRespDtos);
            }
        }
        if (modifyReqDto.getRuleRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType())) {
            TrControlGiftCustomerEo trControlGiftCustomerEo = new TrControlGiftCustomerEo();
            trControlGiftCustomerEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"rule_id", (Object)ruleIdList)}));
            controlGiftAreaEoList = this.trControlGiftCustomerDas.select((BaseEo)trControlGiftCustomerEo);
            List customerCodeList = controlGiftAreaEoList.stream().map(c -> c.getCustomerCode()).collect(Collectors.toList());
            List verifyCustomerCodeList = modifyReqDto.getCustomerList().stream().filter(c -> customerCodeList.contains(c.getCustomerCode())).map(c -> c.getCustomerCode()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(verifyCustomerCodeList)) {
                respDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                ArrayList customerRespDtos = Lists.newArrayList();
                List controlGiftCustomerEos = controlGiftAreaEoList.stream().filter(c -> verifyCustomerCodeList.contains(c.getCustomerCode())).collect(Collectors.toList());
                DtoHelper.eoList2DtoList(controlGiftCustomerEos, (Collection)customerRespDtos, TrControlGiftCustomerRespDto.class);
                respDto.setCustomerList((List)customerRespDtos);
                List customerAndRuleId = controlGiftCustomerEos.stream().map(c -> c.getRuleId()).collect(Collectors.toList());
                controlGiftRuleEoList = collect.stream().filter(c -> customerAndRuleId.contains(c.getId())).collect(Collectors.toList());
                controlGiftRuleRespDtos = Lists.newArrayList();
                DtoHelper.eoList2DtoList(controlGiftRuleEoList, (Collection)controlGiftRuleRespDtos, TrControlGiftRuleRespDto.class);
                respDto.setConflictRuleList((List)controlGiftRuleRespDtos);
            }
        }
        if (modifyReqDto.getRuleRangeType().equals(RuleRangeTypeEnum.ALL.getType())) {
            List<Object> controlGiftRuleEoList2 = Lists.newArrayList();
            if (modifyReqDto.getItemRangeType().equals(RuleRangeTypeEnum.ALL.getType())) {
                controlGiftRuleEoList2 = Optional.ofNullable(collect).orElse(Lists.newArrayList()).stream().filter(c -> c.getRuleRangeType().equals(RuleRangeTypeEnum.ALL.getType())).collect(Collectors.toList());
            } else {
                TrControlGiftRuleEo trControlGiftRuleEo = new TrControlGiftRuleEo();
                trControlGiftRuleEo.setRuleRangeType(RuleRangeTypeEnum.ALL.getType());
                trControlGiftRuleEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", (Object)ruleIdList)}));
                controlGiftRuleEoList2 = this.trControlGiftRuleDas.select((BaseEo)trControlGiftRuleEo);
            }
            if (!ObjectUtils.isEmpty((Object)controlGiftRuleEoList2)) {
                respDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                ArrayList controlGiftRuleRespDtos2 = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)controlGiftRuleEoList2, (Collection)controlGiftRuleRespDtos2, TrControlGiftRuleRespDto.class);
                respDto.setConflictRuleList((List)controlGiftRuleRespDtos2);
            }
        }
        return respDto;
    }

    @Override
    public CustomerGiftAmountInfo queryAllRuleOfCutomerByOrder(CustomerGiftAmountReqDto reqDto) {
        AssertUtils.notBlank((String)reqDto.getCustomerCode(), (String)"customerCode\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty((Collection)reqDto.getGiftList())) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5ba2\u6237\u8d2d\u4e70\u7684\u5546\u54c1\u4e2d\u4e0d\u5305\u542b\u8d60\u54c1\uff0c\u65e0\u9700\u7ba1\u63a7");
            CustomerGiftAmountInfo customerGiftAmountInfo = new CustomerGiftAmountInfo();
            customerGiftAmountInfo.setContainGiftItem(NOT_CONTAIN_GIFT);
            return customerGiftAmountInfo;
        }
        List<GiftAmountItemRespDto> giftAmountsOfCustomer = this.queryCustomerAmount(reqDto);
        if (CollectionUtils.isEmpty(giftAmountsOfCustomer)) {
            return null;
        }
        CustomerGiftAmountInfo giftAmountsOfCustomerRespDto = this.deductCustomerAmountForOrder(reqDto, giftAmountsOfCustomer);
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5ba2\u6237\u5546\u54c1\u62b5\u6263\u65b9\u5f0f\uff1a{}", (Object)JSON.toJSONString((Object)giftAmountsOfCustomerRespDto));
        return giftAmountsOfCustomerRespDto;
    }

    @Override
    public PageInfo<GiftAmountItemRespDto> queryRulePageByCustomerCode(String customerCode, Integer status, Integer pageNo, Integer pageSize) {
        AssertUtils.notBlank((String)customerCode, (String)"customerCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AmountStatusEnum statusEnum = AmountStatusEnum.enumOf((Integer)status);
        ArrayList filterList = Lists.newArrayList();
        Date currentDate = new Date();
        switch (statusEnum) {
            case USE: {
                filterList.add(SqlFilter.ge((String)"valid_time", (Object)currentDate));
                break;
            }
            case USING: {
                filterList.add(SqlFilter.le((String)"valid_time", (Object)currentDate));
                filterList.add(SqlFilter.ge((String)"lose_time", (Object)currentDate));
                break;
            }
            case USED: {
                filterList.add(SqlFilter.le((String)"lose_time", (Object)currentDate));
                break;
            }
        }
        TrControlGiftResultEo queryEo = new TrControlGiftResultEo();
        queryEo.setCustomerCode(customerCode);
        queryEo.setSqlFilters((List)filterList);
        queryEo.setOrderByDesc("lose_time");
        PageInfo eoPageInfo = this.controlGiftResultDas.selectPage((BaseEo)queryEo, pageNo, pageSize);
        if (CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            dtoPageInfo.setList(new ArrayList());
            logger.info("\u3010\u4f1a\u5458\u4e2d\u5fc3\u8d60\u54c1\u67e5\u8be2\u3011\u5ba2\u6237(customerCode={})\u5173\u4e8e({})\u8d60\u54c1\u989d\u5ea6\u4e0d\u5b58\u5728\uff01", (Object)customerCode, (Object)statusEnum.getDesc());
            return dtoPageInfo;
        }
        List ruleIdList = eoPageInfo.getList().stream().map(TrControlGiftResultEo::getRuleId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryGiftFreebieWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryGiftFreebieWrapper.eq(BaseEo::getDr, (Object)0)).in(TrControlGiftFreebieEo::getRuleId, ruleIdList);
        List giftFreebieEos = this.trControlGiftFreebieDas.list((Wrapper)queryGiftFreebieWrapper);
        Map<Long, List<TrControlGiftFreebieEo>> listMap = giftFreebieEos.stream().collect(Collectors.groupingBy(TrControlGiftFreebieEo::getRuleId));
        logger.info("\u3010\u4f1a\u5458\u4e2d\u5fc3\u8d60\u54c1\u67e5\u8be2\u3011\u5ba2\u6237(customerCode={})\u5404\u4e2a\u89c4\u5219\u7684\u8d60\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)customerCode, (Object)JSON.toJSONString(listMap));
        List<GiftAmountItemRespDto> giftAmountItemRespDtos = eoPageInfo.getList().stream().map(item -> {
            GiftAmountItemRespDto giftAmountItemRespDto = new GiftAmountItemRespDto();
            giftAmountItemRespDto.setId(item.getId());
            giftAmountItemRespDto.setRuleId(item.getRuleId());
            giftAmountItemRespDto.setUsableAmount(item.getUsableAmount());
            giftAmountItemRespDto.setAmountType(item.getAmountType());
            giftAmountItemRespDto.setVaildTime(item.getValidTime());
            giftAmountItemRespDto.setLoseTime(item.getLoseTime());
            return giftAmountItemRespDto;
        }).collect(Collectors.toList());
        giftAmountItemRespDtos.forEach(giftAmountItemRespDto -> {
            List giftCodeList = Optional.ofNullable(listMap.get(giftAmountItemRespDto.getRuleId())).orElseGet(Collections::emptyList).stream().map(TrControlGiftFreebieEo::getItemCode).collect(Collectors.toList());
            giftAmountItemRespDto.setGiftList(giftCodeList);
        });
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        dtoPageInfo.setList(giftAmountItemRespDtos);
        return dtoPageInfo;
    }

    @Override
    public Map<String, Object> queryCountForRuleByCustomerCode(String customerCode) {
        String cacheKey = String.format("amoutCount:%s", customerCode);
        return this.cacheHelper.putCacheIfAbsent(cacheKey, Map.class, 60, () -> {
            Integer useCount = this.queryAmountOfCustomer(AmountStatusEnum.USE, customerCode);
            Integer usingCount = this.queryAmountOfCustomer(AmountStatusEnum.USING, customerCode);
            Integer usedCount = this.queryAmountOfCustomer(AmountStatusEnum.USED, customerCode);
            HashMap countMap = Maps.newHashMap();
            countMap.put(AmountStatusEnum.USE.getType() + "", useCount);
            countMap.put(AmountStatusEnum.USING.getType() + "", usingCount);
            countMap.put(AmountStatusEnum.USED.getType() + "", usedCount);
            return countMap;
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleGiftAmountForOrder(CustomerGiftAmountReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getOrgId(), (String)"orgId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notBlank((String)reqDto.getCustomerCode(), (String)"customerCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notBlank((String)reqDto.getCustomerName(), (String)"customerName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CustomerGiftAmountInfo cutomerByOrder = this.queryAllRuleOfCutomerByOrder(reqDto);
        List<GiftAmountItemRespDto> giftAmountItemRespDtos = this.addGiftAmountByOrderItems(reqDto);
        this.deductRuleAmountForCustomer(cutomerByOrder, reqDto);
        this.recoveryAndFreezeAmount(giftAmountItemRespDtos, cutomerByOrder, reqDto);
    }

    private void recoveryAndFreezeAmount(List<GiftAmountItemRespDto> giftAmountItemRespDtos, CustomerGiftAmountInfo cutomerByOrder, CustomerGiftAmountReqDto reqDto) {
        Map amountItemMap = Optional.ofNullable(cutomerByOrder.getCustomerAmountList()).orElseGet(Collections::emptyList).stream().filter(item -> Integer.valueOf(1).equals(item.getSelected())).collect(Collectors.toMap(GiftAmountItemRespDto::getRuleId, Function.identity()));
        Optional.ofNullable(giftAmountItemRespDtos).ifPresent(giftAmountItemList -> giftAmountItemList.forEach(item -> {
            GiftAmountItemRespDto amountItemRespDto = (GiftAmountItemRespDto)amountItemMap.get(item.getRuleId());
            BizControlGiftResultReqDto giftResultReqDto = new BizControlGiftResultReqDto(item.getRuleId(), reqDto.getCustomerCode(), reqDto.getCustomerName(), reqDto.getOrgId(), BigDecimal.ZERO, item.getAmountType(), reqDto.getOrderNo(), GiftAmountWayEnum.WAY_06.getType(), null);
            if (GiftAmountIsAccumulateEnum.UNACCUMULATE.getType().equals(item.getIsAccumulate())) {
                if (amountItemRespDto != null) {
                    BigDecimal recoveryAmount = item.getUsableAmount().subtract(amountItemRespDto.getDeductAmount());
                    logger.info("\u3010\u4e0b\u5355\u65b0\u589e\u8d60\u54c1\u989d\u5ea6\u3011\u89c4\u5219(id={})\u56de\u6536\u90e8\u5206\u989d\u5ea6\u4e3a\uff1a{}", (Object)item.getRuleId(), (Object)recoveryAmount);
                    giftResultReqDto.setChangeAmount(recoveryAmount);
                    giftResultReqDto.setChangeWay(GiftAmountWayEnum.WAY_06.getType());
                } else {
                    giftResultReqDto.setChangeAmount(item.getUsableAmount());
                    giftResultReqDto.setChangeWay(GiftAmountWayEnum.WAY_06.getType());
                    logger.info("\u3010\u4e0b\u5355\u65b0\u589e\u8d60\u54c1\u989d\u5ea6\u3011\u89c4\u5219(id={})\u56de\u6536\u5168\u90e8\u989d\u5ea6\u4e3a\uff1a{}", (Object)item.getRuleId(), (Object)item.getUsableAmount());
                }
            } else if (amountItemRespDto != null) {
                BigDecimal freezeAmount = item.getUsableAmount().subtract(amountItemRespDto.getDeductAmount());
                logger.info("\u3010\u4e0b\u5355\u65b0\u589e\u8d60\u54c1\u989d\u5ea6\u3011\u89c4\u5219(id={})\u51bb\u7ed3\u90e8\u5206\u989d\u5ea6\u4e3a\uff1a{}", (Object)item.getRuleId(), (Object)freezeAmount);
                giftResultReqDto.setChangeAmount(freezeAmount);
                giftResultReqDto.setChangeWay(GiftAmountWayEnum.WAY_11.getType());
            } else {
                logger.info("\u3010\u4e0b\u5355\u65b0\u589e\u8d60\u54c1\u989d\u5ea6\u3011\u89c4\u5219(id={})\u51bb\u7ed3\u5168\u90e8\u989d\u5ea6\u4e3a\uff1a{}", (Object)item.getRuleId(), (Object)item.getUsableAmount());
                giftResultReqDto.setChangeAmount(item.getUsableAmount());
                giftResultReqDto.setChangeWay(GiftAmountWayEnum.WAY_11.getType());
            }
            if (giftResultReqDto.getChangeAmount().compareTo(BigDecimal.ZERO) != 0) {
                this.giftResultService.modifyBillData(giftResultReqDto);
            }
        }));
    }

    private void deductRuleAmountForCustomer(CustomerGiftAmountInfo cutomerByOrder, CustomerGiftAmountReqDto reqDto) {
        if (CollectionUtils.isEmpty((Collection)reqDto.getGiftList())) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5ba2\u6237\u8d2d\u4e70\u7684\u5546\u54c1\u4e2d\u4e0d\u5305\u542b\u8d60\u54c1\uff0c\u65e0\u9700\u6263\u51cf\u8d60\u54c1\u989d\u5ea6\uff01");
            return;
        }
        if (GiftAmountEnoughEnum.NOT_ENOUGH.getStatus().equals(cutomerByOrder.getAmountEnough())) {
            logger.error("\u3010\u4e0b\u5355\u65b0\u589e\u8d60\u54c1\u989d\u5ea6\u3011\u5ba2\u6237\u7684\u8d60\u54c1\u989d\u5ea6\u4e0d\u8db3!");
            throw ControlExceptionCode.GIFT_AMOUNT_LESS_EXIT.getException();
        }
        List<GiftAmountItemRespDto> customerAmountList = cutomerByOrder.getCustomerAmountList().stream().filter(dto -> YesOrNoEnum.YES.getCode().equals(dto.getIsUsable())).collect(Collectors.toList());
        logger.info("\u3010\u4e0b\u5355\u65b0\u589e\u8d60\u54c1\u989d\u5ea6\u3011\u6263\u51cf\u5ba2\u6237\u989d\u5ea6\u65b9\u5f0f\u4e3a\uff1a{}", (Object)JSON.toJSONString(customerAmountList));
        customerAmountList.forEach(customerAmount -> {
            if (customerAmount.getDeductAmount() != null) {
                BizControlGiftResultReqDto giftResultReqDto = new BizControlGiftResultReqDto(customerAmount.getRuleId(), reqDto.getCustomerCode(), reqDto.getCustomerName(), reqDto.getOrgId(), customerAmount.getDeductAmount(), customerAmount.getAmountType(), reqDto.getOrderNo(), GiftAmountWayEnum.WAY_04.getType(), null);
                logger.info("\u3010\u4e0b\u5355\u65b0\u589e\u8d60\u54c1\u989d\u5ea6\u3011\u6263\u51cf\u5ba2\u6237\u989d\u5ea6\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)giftResultReqDto));
                if (giftResultReqDto.getChangeAmount().compareTo(BigDecimal.ZERO) != 0) {
                    this.giftResultService.modifyBillData(giftResultReqDto);
                }
            }
        });
    }

    private List<GiftAmountItemRespDto> addGiftAmountByOrderItems(CustomerGiftAmountReqDto reqDto) {
        List<GiftAmountItemRespDto> giftAmountItemForAllItems = this.calNewAmountByBuyItems(reqDto);
        if (CollectionUtils.isEmpty(giftAmountItemForAllItems)) {
            logger.info("\u3010\u4e0b\u5355\u65b0\u589e\u8d60\u54c1\u989d\u5ea6\u3011\u5ba2\u6237({})\u8d2d\u4e70\u7684\u5546\u54c1\u6ca1\u6709\u9002\u5408\u7684\u89c4\u5219\u65b0\u589e\u989d\u5ea6,\u8d2d\u4e70\u7684\u5546\u54c1\u4e3a\uff1a{}", (Object)reqDto.getCustomerCode(), (Object)JSON.toJSONString((Object)reqDto.getGiftList()));
            return null;
        }
        for (GiftAmountItemRespDto giftAmountItem : giftAmountItemForAllItems) {
            BizControlGiftResultReqDto giftResultReqDto = new BizControlGiftResultReqDto(giftAmountItem.getRuleId(), reqDto.getCustomerCode(), reqDto.getCustomerName(), reqDto.getOrgId(), giftAmountItem.getUsableAmount(), giftAmountItem.getAmountType(), reqDto.getOrderNo(), GiftAmountWayEnum.WAY_02.getType(), null);
            if (giftResultReqDto.getChangeAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            this.giftResultService.modifyBillData(giftResultReqDto);
        }
        return giftAmountItemForAllItems;
    }

    private Integer queryAmountOfCustomer(AmountStatusEnum statusEnum, String customerCode) {
        AssertUtils.notBlank((String)customerCode, (String)"customerCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Date currentDate = new Date();
        ArrayList filterList = Lists.newArrayList();
        switch (statusEnum) {
            case USE: {
                filterList.add(SqlFilter.ge((String)"valid_time", (Object)currentDate));
                break;
            }
            case USING: {
                filterList.add(SqlFilter.le((String)"valid_time", (Object)currentDate));
                filterList.add(SqlFilter.ge((String)"lose_time", (Object)currentDate));
                break;
            }
            case USED: {
                filterList.add(SqlFilter.le((String)"lose_time", (Object)currentDate));
                break;
            }
        }
        TrControlGiftResultEo queryEo = new TrControlGiftResultEo();
        queryEo.setCustomerCode(customerCode);
        queryEo.setSqlFilters((List)filterList);
        return this.controlGiftResultDas.count((BaseEo)queryEo);
    }

    private CustomerGiftAmountInfo deductCustomerAmountForOrder(CustomerGiftAmountReqDto reqDto, List<GiftAmountItemRespDto> giftAmountsOfCustomer) {
        if (CollectionUtils.isEmpty(giftAmountsOfCustomer)) {
            return null;
        }
        CustomerGiftAmountInfo customerGiftAmountInfo = new CustomerGiftAmountInfo();
        giftAmountsOfCustomer.sort(Comparator.comparing(GiftAmountItemRespDto::getIsAccumulate).thenComparing(GiftAmountItemRespDto::getAmountType).thenComparing(GiftAmountItemRespDto::getLoseTime));
        Date currentDate = DateUtil.getToday();
        ArrayList giftCodeListOfNotEnough = Lists.newArrayList();
        List reqGiftList = reqDto.getGiftList();
        for (GiftAmountItemRespDto giftAmountItemRespDto : giftAmountsOfCustomer) {
            giftAmountItemRespDto.setCurrentUsableAmount(giftAmountItemRespDto.getUsableAmount());
        }
        ArrayList list = Lists.newArrayList();
        for (BizOrderItemReqDto reqGiftItemReqDto : reqDto.getGiftList()) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u62b5\u6263\u8ba1\u7b97\u3011\u5f00\u59cb\u8ba1\u7b97\u8d60\u54c1\u7684\u62b5\u6263\uff1a{}", (Object)JSON.toJSONString((Object)reqGiftItemReqDto));
            reqGiftItemReqDto.setRemainGiftNum(this.setScaleUp2(reqGiftItemReqDto.getItemNum()));
            reqGiftItemReqDto.setRemainGiftAmount(this.setScaleUp2(this.setScaleUp2(reqGiftItemReqDto.getRemainGiftNum()).multiply(this.setScaleUp2(reqGiftItemReqDto.getOriginalPrice()))));
            for (GiftAmountItemRespDto giftAmountItemRespDto : giftAmountsOfCustomer) {
                List suitGiftCodeList = giftAmountItemRespDto.getGiftList();
                if (currentDate.compareTo(giftAmountItemRespDto.getVaildTime()) < 0 || currentDate.compareTo(giftAmountItemRespDto.getLoseTime()) > 0) {
                    logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u62b5\u6263\u8ba1\u7b97\u3011\u8be5\u989d\u5ea6\u5c1a\u672a\u751f\u6548\u6216\u8005\u5df2\u5931\u6548\uff1a{}", (Object)JSON.toJSONString((Object)giftAmountItemRespDto));
                    continue;
                }
                if (YesOrNoEnum.NO.getCode().equals(giftAmountItemRespDto.getIsUsable()) || !suitGiftCodeList.contains(reqGiftItemReqDto.getItemCode())) continue;
                if (reqGiftItemReqDto.getRemainGiftNum().compareTo(BigDecimal.ZERO) == 0) break;
                reqGiftItemReqDto.setMatch(Integer.valueOf(2));
                if (GiftAmountType.AMOUNT_NUM.getType().equals(giftAmountItemRespDto.getAmountType())) {
                    BigDecimal deductCount = giftAmountItemRespDto.getCurrentUsableAmount().compareTo(reqGiftItemReqDto.getRemainGiftNum()) >= 0 ? reqGiftItemReqDto.getRemainGiftNum() : giftAmountItemRespDto.getCurrentUsableAmount();
                    giftAmountItemRespDto.setCurrentUsableAmount(giftAmountItemRespDto.getCurrentUsableAmount().subtract(deductCount));
                    giftAmountItemRespDto.setDeductAmount(Optional.ofNullable(giftAmountItemRespDto.getDeductAmount()).orElse(BigDecimal.ZERO).add(deductCount));
                    giftAmountItemRespDto.setSelected(SELECTED);
                    BigDecimal remainGiftNum = this.setScaleUp2(this.setScaleUp2(reqGiftItemReqDto.getRemainGiftNum()));
                    deductCount = this.setScaleUp2(deductCount);
                    reqGiftItemReqDto.setRemainGiftNum(remainGiftNum.subtract(deductCount).setScale(2, 4));
                    BigDecimal remainGiftAmount = this.setScaleUp2(this.setScaleUp2(reqGiftItemReqDto.getRemainGiftNum()).multiply(this.setScaleUp2(reqGiftItemReqDto.getOriginalPrice())));
                    reqGiftItemReqDto.setRemainGiftAmount(remainGiftAmount);
                    logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u62b5\u6263\u8ba1\u7b97\u3011\u5f53\u524d\u8d60\u54c1(code={})\u8fdb\u884c\u6570\u91cf\u62b5\u6263,\u62b5\u6263\u6389\u7684\u6570\u91cf\u4e3a\uff1a{}\uff0c\u8fd8\u5269\u672a\u62b5\u6263\u6570\u4e3a\uff1a{}", new Object[]{reqGiftItemReqDto.getItemCode(), deductCount, this.setScaleUp2(reqGiftItemReqDto.getItemNum()).subtract(this.setScaleUp2(deductCount))});
                    continue;
                }
                BigDecimal giftAmount = reqGiftItemReqDto.getRemainGiftNum().multiply(reqGiftItemReqDto.getOriginalPrice());
                if (giftAmountItemRespDto.getCurrentUsableAmount().compareTo(giftAmount) >= 0) {
                    giftAmountItemRespDto.setDeductAmount(giftAmount);
                    giftAmountItemRespDto.setSelected(SELECTED);
                    reqGiftItemReqDto.setRemainGiftNum(BigDecimal.ZERO);
                    reqGiftItemReqDto.setRemainGiftAmount(BigDecimal.ZERO);
                    giftAmountItemRespDto.setCurrentUsableAmount(giftAmountItemRespDto.getCurrentUsableAmount().subtract(giftAmount));
                    logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u62b5\u6263\u8ba1\u7b97\u3011\u5f53\u524d\u8d60\u54c1(code={})\u8fdb\u884c\u91d1\u989d\u62b5\u6263,\u5168\u90e8\u62b5\u6263\u6389\u7684\u91d1\u989d\u4e3a\uff1a{}", (Object)reqGiftItemReqDto.getItemCode(), (Object)giftAmount);
                    break;
                }
                BigDecimal currentUsableAmount = giftAmountItemRespDto.getCurrentUsableAmount();
                giftAmountItemRespDto.setDeductAmount(Optional.ofNullable(giftAmountItemRespDto.getDeductAmount()).orElse(BigDecimal.ZERO).add(currentUsableAmount));
                giftAmountItemRespDto.setSelected(SELECTED);
                BigDecimal usableAmount = this.setScaleUp2(currentUsableAmount);
                BigDecimal originalPrice = this.setScaleUp2(reqGiftItemReqDto.getOriginalPrice());
                BigDecimal deductCount = usableAmount.divide(originalPrice, 2, 4);
                BigDecimal remainGiftNum = this.setScaleUp2(reqGiftItemReqDto.getRemainGiftNum());
                BigDecimal remainGiftNumNew = this.setScaleUp2(remainGiftNum.subtract(deductCount));
                reqGiftItemReqDto.setRemainGiftNum(remainGiftNumNew);
                BigDecimal remainGiftNumAmount = this.setScaleUp2(reqGiftItemReqDto.getRemainGiftNum());
                BigDecimal remainGiftAmount = this.setScaleUp2(remainGiftNumAmount.multiply(originalPrice));
                reqGiftItemReqDto.setRemainGiftAmount(remainGiftAmount);
                giftAmountItemRespDto.setCurrentUsableAmount(BigDecimal.ZERO);
                logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u62b5\u6263\u8ba1\u7b97\u3011\u5f53\u524d\u8d60\u54c1(code={})\u8fdb\u884c\u91d1\u989d\u62b5\u6263,\u62b5\u6263\u6389\u7684\u91d1\u989d\u4e3a\uff1a{},\u8fd8\u672a\u62b5\u6263\u7684\u91d1\u989d\u4e3a\uff1a{}\uff0c\u8f6c\u5316\u4e3a\u5bf9\u5e94\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{reqGiftItemReqDto.getItemCode(), giftAmountItemRespDto.getCurrentUsableAmount(), giftAmount.subtract(currentUsableAmount), reqGiftItemReqDto.getRemainGiftNum()});
            }
            if (!Objects.equals(2, reqGiftItemReqDto.getMatch()) || reqGiftItemReqDto.getRemainGiftNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            customerGiftAmountInfo.setAmountEnough(GiftAmountEnoughEnum.NOT_ENOUGH.getStatus());
            giftCodeListOfNotEnough.add(reqGiftItemReqDto.getItemCode());
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u62b5\u6263\u8ba1\u7b97\u3011\u5f53\u524d\u8ba2\u5355\u7684\u8d60\u54c1\u989d\u5ea6\u4e0d\u8db3,\u8d2d\u4e70\u7684\u8d60\u54c1\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto.getGiftList()));
        }
        customerGiftAmountInfo.setCustomerAmountList(giftAmountsOfCustomer);
        customerGiftAmountInfo.setGiftCodesOfAmountNotEnough((List)giftCodeListOfNotEnough);
        return customerGiftAmountInfo;
    }

    private BigDecimal setScaleUp2(BigDecimal num) {
        if (null == num) {
            return BigDecimal.ZERO;
        }
        return num.setScale(2, 4);
    }

    private List<GiftAmountItemRespDto> queryCustomerAmount(CustomerGiftAmountReqDto reqDto) {
        List<GiftAmountItemRespDto> giftAmountByItem = this.calNewGiftAmountByItemGift(reqDto);
        List<GiftAmountItemRespDto> giftAmountOfCustomer = this.queryCustomerRuleForGift(reqDto);
        ArrayList mergeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(giftAmountByItem)) {
            mergeList.addAll(giftAmountByItem);
        }
        if (CollectionUtils.isNotEmpty(giftAmountOfCustomer)) {
            mergeList.addAll(giftAmountOfCustomer);
        }
        if (CollectionUtils.isEmpty((Collection)mergeList)) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5f53\u524d\u5ba2\u6237(customerCode={})\u8d60\u54c1\u989d\u5ea6\u4e0d\u8db3\uff01", (Object)reqDto.getCustomerCode());
            return null;
        }
        List<GiftAmountItemRespDto> amountItemRespDtos = Optional.ofNullable(mergeList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(GiftAmountItemRespDto::getRuleId, Function.identity(), (v1, v2) -> {
            BigDecimal deductAmountOfV1 = Optional.ofNullable(v1.getDeductAmount()).orElse(BigDecimal.ZERO);
            BigDecimal deductAmountOfV2 = Optional.ofNullable(v2.getDeductAmount()).orElse(BigDecimal.ZERO);
            BigDecimal totalAmount = v1.getUsableAmount().add(v2.getUsableAmount());
            BigDecimal totalDeductAmount = deductAmountOfV1.add(deductAmountOfV2);
            Integer isNew = v1.getIsNew() > v2.getIsNew() ? v1.getIsNew() : v2.getIsNew();
            Integer selected = v1.getSelected() != null ? v1.getSelected() : v2.getSelected();
            Integer isUsable = v1.getIsUsable() > v2.getIsUsable() ? v1.getIsUsable() : v2.getIsUsable();
            Integer status = v1.getStatus() > v2.getStatus() ? v1.getStatus() : v2.getStatus();
            BigDecimal orderAmount = v1.getOrderAmount().add(v2.getOrderAmount());
            v1.setOrderAmount(orderAmount);
            BigDecimal oldTotalAmount = v1.getTotalAmount().add(v2.getTotalAmount());
            v1.setTotalAmount(oldTotalAmount);
            v1.setIsUsable(isUsable);
            v1.setUsableAmount(totalAmount);
            v1.setDeductAmount(totalDeductAmount);
            v1.setIsNew(isNew);
            v1.setSelected(selected);
            v1.setStatus(status);
            return v1;
        })).entrySet().stream().map(giftAmountItemEntry -> (GiftAmountItemRespDto)giftAmountItemEntry.getValue()).collect(Collectors.toList());
        List ruleIds = Optional.ofNullable(amountItemRespDtos).orElseGet(Collections::emptyList).stream().map(GiftAmountItemRespDto::getRuleId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(TrControlGiftFreebieEo::getRuleId, ruleIds)).eq(BaseEo::getDr, (Object)0);
        List ruleOfGift = this.trControlGiftFreebieDas.list((Wrapper)queryWrapper);
        Map<Long, List<TrControlGiftFreebieEo>> listGiftFreebieMap = Optional.ofNullable(ruleOfGift).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(TrControlGiftFreebieEo::getRuleId));
        amountItemRespDtos.forEach(item -> {
            List giftFreebieEos = (List)listGiftFreebieMap.get(item.getRuleId());
            if (CollectionUtils.isNotEmpty((Collection)giftFreebieEos)) {
                List giftCodeList = giftFreebieEos.stream().map(TrControlGiftFreebieEo::getItemCode).collect(Collectors.toList());
                item.setGiftList(giftCodeList);
            }
        });
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011[\u603b\u989d\u5ea6]\u5f53\u524d\u5ba2\u6237(customerCode={})\u53ef\u7528\u7684\u8d60\u54c1\u989d\u5ea6\u5217\u8868\u4e3a\uff1a{}", (Object)reqDto.getCustomerCode(), (Object)JSON.toJSONString(amountItemRespDtos));
        return amountItemRespDtos;
    }

    private List<GiftAmountItemRespDto> calNewGiftAmountByItemGift(CustomerGiftAmountReqDto reqDto) {
        if (CollectionUtils.isEmpty((Collection)reqDto.getItemList())) {
            return null;
        }
        List<GiftAmountItemRespDto> giftAmountItemForAllItems = this.calNewAmountByBuyItems(reqDto);
        if (CollectionUtils.isEmpty(giftAmountItemForAllItems)) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u672c\u6b21\u8d2d\u4e70\u7684\u5546\u54c1\u6ca1\u6709\u65b0\u589e\u989d\u5ea6\uff0c\u8d2d\u4e70\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto.getItemList()));
            return null;
        }
        List ruleIdList = giftAmountItemForAllItems.stream().map(GiftAmountItemRespDto::getRuleId).collect(Collectors.toList());
        List giftCodeList = reqDto.getGiftList().stream().map(BizOrderItemReqDto::getItemCode).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(TrControlGiftFreebieEo::getRuleId, ruleIdList)).in(TrControlGiftFreebieEo::getItemCode, giftCodeList)).eq(BaseEo::getDr, (Object)0);
        List ruleOfGift = this.trControlGiftFreebieDas.list((Wrapper)queryWrapper);
        List ruleIdOfGift = Optional.ofNullable(ruleOfGift).orElseGet(Collections::emptyList).stream().map(TrControlGiftFreebieEo::getRuleId).collect(Collectors.toList());
        Date today = DateUtil.getToday();
        for (GiftAmountItemRespDto item : giftAmountItemForAllItems) {
            if (ruleIdOfGift.contains(item.getRuleId())) {
                item.setIsUsable(YesOrNoEnum.YES.getCode());
            } else {
                item.setIsUsable(YesOrNoEnum.NO.getCode());
            }
            if (item.getVaildTime().compareTo(today) <= 0 && item.getLoseTime().compareTo(today) >= 0) {
                item.setStatus(YesOrNoEnum.YES.getCode());
                continue;
            }
            item.setIsUsable(YesOrNoEnum.NO.getCode());
        }
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011[\u672c\u5355\u65b0\u589e]\u5ba2\u6237({})\u672c\u5355\u65b0\u589e\u7684\u8d60\u54c1\u989d\u5ea6\u5217\u8868\u4e3a\uff1a{}", (Object)reqDto.getCustomerCode(), (Object)JSON.toJSONString(giftAmountItemForAllItems));
        return giftAmountItemForAllItems;
    }

    private List<GiftAmountItemRespDto> calNewAmountByBuyItems(CustomerGiftAmountReqDto reqDto) {
        Map<String, List<TrControlGiftRuleEo>> itemRuleMap = this.queryNewAmountForRule(reqDto);
        if (MapUtils.isEmpty(itemRuleMap)) {
            return null;
        }
        HashMap ruleAmountMap = Maps.newHashMap();
        itemRuleMap.forEach((itemCode, ruleList) -> {
            for (BizOrderItemReqDto itemReqDto : reqDto.getItemList()) {
                if (!Objects.equals(itemCode, itemReqDto.getItemCode())) continue;
                logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011[\u672c\u5355\u65b0\u589e]\u5546\u54c1itemCode={}\u547d\u4e2d\u7684\u89c4\u5219\u5217\u8868\u4e3a\uff1a{}", itemCode, (Object)JSON.toJSONString((Object)ruleList));
                logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011[\u672c\u5355\u65b0\u589e]\u5546\u54c1itemCode={}\u5bf9\u5e94\u7684\u8ba2\u5355\u5546\u54c1\u4e3a\uff1a{}", itemCode, (Object)JSON.toJSONString((Object)itemReqDto));
                ruleList.forEach(controlGiftRuleEo -> ruleAmountMap.compute(controlGiftRuleEo.getId(), (k, v) -> {
                    BigDecimal newAmount = this.calNewAmount(itemReqDto, (TrControlGiftRuleEo)controlGiftRuleEo);
                    if (v == null) {
                        GiftAmountItemRespDto giftAmountItemRespDto = new GiftAmountItemRespDto();
                        giftAmountItemRespDto.setIsNew(IS_NEW);
                        giftAmountItemRespDto.setRuleId(controlGiftRuleEo.getId());
                        giftAmountItemRespDto.setAmountType(controlGiftRuleEo.getAmountType());
                        giftAmountItemRespDto.setVaildTime(controlGiftRuleEo.getValidTime());
                        giftAmountItemRespDto.setLoseTime(controlGiftRuleEo.getLoseTime());
                        giftAmountItemRespDto.setIsAccumulate(controlGiftRuleEo.getIsAccumulate());
                        giftAmountItemRespDto.setUsableAmount(newAmount);
                        giftAmountItemRespDto.setOrderAmount(newAmount);
                        giftAmountItemRespDto.setTotalAmount(BigDecimal.ZERO);
                        return giftAmountItemRespDto;
                    }
                    v.setOrderAmount(Optional.ofNullable(v.getOrderAmount()).orElse(BigDecimal.ZERO).add(newAmount));
                    v.setUsableAmount(Optional.ofNullable(v.getUsableAmount()).orElse(BigDecimal.ZERO).add(newAmount));
                    return v;
                }));
            }
        });
        return ruleAmountMap.values().stream().collect(Collectors.toList());
    }

    private BigDecimal calNewAmount(BizOrderItemReqDto giftItem, TrControlGiftRuleEo controlGiftRuleEo) {
        BigDecimal scaleAmount = BigDecimal.ONE;
        if (GiftAmountWay.WAY_01.getType().equals(controlGiftRuleEo.getAmountWay())) {
            scaleAmount = controlGiftRuleEo.getAmountRatioSecond().divide(controlGiftRuleEo.getAmountRatioFirst(), 2, 4);
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u65b0\u589e\u989d\u5ea6\u8ba1\u7b97\u3011\u4f7f\u7528\u6309\u9002\u7528\u5546\u54c1\u914d\u6bd4\u65b9\u5f0f\u8ba1\u7b97\uff0cgiftCode={},ruleId={},\u914d\u6bd4\u7684\u6bd4\u4f8b\u4e3a\uff1a{}", new Object[]{giftItem.getItemCode(), controlGiftRuleEo.getId(), scaleAmount});
        } else {
            scaleAmount = controlGiftRuleEo.getAmountFormula().divide(BigDecimal.valueOf(100L), 2, 4);
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u65b0\u589e\u989d\u5ea6\u8ba1\u7b97\u3011\u4f7f\u7528\u6309\u9002\u7528\u5546\u54c1\u767e\u5206\u6bd4\u8ba1\u7b97\uff0cgiftCode={},ruleId={},\u6bd4\u4f8b\u4e3a\uff1a{}", new Object[]{giftItem.getItemCode(), controlGiftRuleEo.getId(), scaleAmount});
        }
        if (GiftAmountType.AMOUNT_MONEY.getType().equals(controlGiftRuleEo.getAmountType())) {
            if (GiftCalculateWay.WAY_01.getType().equals(controlGiftRuleEo.getMoneyWay())) {
                BigDecimal giveAmount = BigDecimal.ZERO;
                if (GiftAmountWay.WAY_01.getType().equals(controlGiftRuleEo.getAmountWay())) {
                    BigDecimal itemMaxAmount = giftItem.getOriginalPrice().multiply(giftItem.getItemNum()).multiply(controlGiftRuleEo.getAmountRatioSecond());
                    giveAmount = itemMaxAmount.divide(controlGiftRuleEo.getAmountRatioFirst(), 2, 4);
                } else {
                    giveAmount = giftItem.getOriginalPrice().multiply(giftItem.getItemNum()).multiply(scaleAmount).setScale(2);
                }
                logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u65b0\u589e\u989d\u5ea6\u8ba1\u7b97\u3011\u4f7f\u7528\u91d1\u989d\u8ba1\u7b97\u65b9\u5f0f\u5546\u54c1\u4f9b\u8d27\u4ef7\uff0c\u8d60\u9001\u7684\u989d\u5ea6\u4e3a\uff1a{}", (Object)giveAmount);
                return giveAmount;
            }
        } else {
            BigDecimal giveCount = BigDecimal.ZERO;
            if (GiftAmountWay.WAY_01.getType().equals(controlGiftRuleEo.getAmountWay())) {
                BigDecimal itemMaxNum = giftItem.getItemNum().multiply(controlGiftRuleEo.getAmountRatioSecond());
                giveCount = itemMaxNum.divide(controlGiftRuleEo.getAmountRatioFirst(), 2, 4);
            } else {
                giveCount = giftItem.getItemNum().multiply(scaleAmount);
            }
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u3010\u65b0\u589e\u989d\u5ea6\u8ba1\u7b97\u3011\u4f7f\u7528\u989d\u5ea6\u7c7b\u578b:\u6570\u91cf\uff0c\u8d60\u9001\u7684\u6570\u91cf\u4e3a\uff1a{}", (Object)giveCount);
            return giveCount;
        }
        return BigDecimal.ZERO;
    }

    private List<GiftAmountItemRespDto> queryCustomerRuleForGift(CustomerGiftAmountReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getGiftList(), (String)"giftList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notEmpty((String)reqDto.getCustomerCode(), (String)"customerCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryCustomerRuleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryCustomerRuleWrapper.eq(BaseEo::getDr, (Object)0)).eq(TrControlGiftResultEo::getCustomerCode, (Object)reqDto.getCustomerCode())).ne(TrControlGiftResultEo::getUsableAmount, (Object)0)).ge(true, TrControlGiftResultEo::getLoseTime, (Object)DateUtil.getToday());
        List customerAmountList = this.controlGiftResultDas.list((Wrapper)queryCustomerRuleWrapper);
        if (CollectionUtils.isEmpty((Collection)customerAmountList)) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5f53\u524d\u5ba2\u6237(customerCode={})\u6ca1\u6709\u53ef\u7528\u7684\u8d60\u54c1\u989d\u5ea6", (Object)reqDto.getCustomerCode());
            return null;
        }
        List ruleIdList = customerAmountList.stream().map(TrControlGiftResultEo::getRuleId).collect(Collectors.toList());
        List giftCodeList = reqDto.getGiftList().stream().map(BizOrderItemReqDto::getItemCode).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(TrControlGiftFreebieEo::getRuleId, ruleIdList)).eq(BaseEo::getDr, (Object)0);
        List ruleOfGift = this.trControlGiftFreebieDas.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)ruleOfGift)) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5f53\u524d\u5ba2\u6237(customerCode={})\u6ca1\u6709\u53ef\u7528\u7684\u8d60\u54c1\u989d\u5ea6", (Object)reqDto.getCustomerCode());
            return null;
        }
        List filterRuleId = ruleOfGift.stream().filter(item -> giftCodeList.contains(item.getItemCode())).map(TrControlGiftFreebieEo::getRuleId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterRuleId)) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5f53\u524d\u8d60\u54c1(itemCode={})\u6ca1\u6709\u5386\u53f2\u53ef\u7528\u7684\u8d60\u54c1\u989d\u5ea6", (Object)JSON.toJSONString(giftCodeList));
            return null;
        }
        Date currentDate = new Date();
        LambdaQueryWrapper queryRuleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryRuleWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, filterRuleId)).eq(TrControlGiftRuleEo::getIsAccumulate, (Object)1)).ge(true, TrControlGiftRuleEo::getLoseTime, (Object)DateUtil.getToday());
        List filterRuleList = this.trControlGiftRuleDas.list((Wrapper)queryRuleWrapper);
        Map giftRuleEoMap = filterRuleList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        ArrayList giftAmountItemRespDtos = Lists.newArrayList();
        Date today = DateUtil.getToday();
        for (TrControlGiftResultEo item2 : customerAmountList) {
            GiftAmountItemRespDto giftAmountItemRespDto = new GiftAmountItemRespDto();
            if (giftRuleEoMap.isEmpty() || !giftRuleEoMap.containsKey(item2.getRuleId())) continue;
            if (filterRuleId.contains(item2.getRuleId())) {
                giftAmountItemRespDto.setIsUsable(YesOrNoEnum.YES.getCode());
            } else {
                giftAmountItemRespDto.setIsUsable(YesOrNoEnum.NO.getCode());
            }
            giftAmountItemRespDto.setRuleId(item2.getRuleId());
            giftAmountItemRespDto.setAmountType(item2.getAmountType());
            giftAmountItemRespDto.setUsableAmount(item2.getUsableAmount());
            giftAmountItemRespDto.setTotalAmount(item2.getUsableAmount());
            giftAmountItemRespDto.setOrderAmount(BigDecimal.ZERO);
            giftAmountItemRespDto.setIsAccumulate(YesOrNoEnum.NO.getCode());
            TrControlGiftRuleEo giftRuleEo = (TrControlGiftRuleEo)giftRuleEoMap.get(item2.getRuleId());
            giftAmountItemRespDto.setIsAccumulate(giftRuleEo.getIsAccumulate());
            giftAmountItemRespDto.setVaildTime(giftRuleEo.getValidTime());
            giftAmountItemRespDto.setLoseTime(giftRuleEo.getLoseTime());
            if (giftRuleEo.getValidTime().compareTo(today) <= 0 && item2.getLoseTime().compareTo(today) >= 0) {
                giftAmountItemRespDto.setStatus(YesOrNoEnum.YES.getCode());
            } else {
                giftAmountItemRespDto.setIsUsable(YesOrNoEnum.NO.getCode());
            }
            giftAmountItemRespDtos.add(giftAmountItemRespDto);
        }
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011[\u5df2\u6709\u989d\u5ea6]\u5f53\u524d\u5ba2\u6237(customerCode={})\u7684\u5df2\u5b58\u5728\u7684\u8d60\u54c1\u989d\u5ea6\u5217\u8868\u4e3a\uff1a{}", (Object)reqDto.getCustomerCode(), (Object)JSON.toJSONString((Object)giftAmountItemRespDtos));
        return giftAmountItemRespDtos;
    }

    private Map<String, List<TrControlGiftRuleEo>> queryNewAmountForRule(CustomerGiftAmountReqDto reqDto) {
        if (CollectionUtils.isEmpty((Collection)reqDto.getItemList())) {
            return null;
        }
        Date currentDate = new Date();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(TrControlGiftRuleEo::getOrgId, (Object)reqDto.getOrgId())).eq(TrControlGiftRuleEo::getItemRangeType, (Object)RuleRangeTypeEnum.ALL.getType())).le(TrControlGiftRuleEo::getControlStartTime, (Object)currentDate)).ge(TrControlGiftRuleEo::getControlEndTime, (Object)currentDate)).ge(true, TrControlGiftRuleEo::getLoseTime, (Object)DateUtil.getToday());
        List giftRuleOfAll = this.trControlGiftRuleDas.list((Wrapper)queryWrapper);
        logger.error("\u9002\u7528\u5546\u54c1\uff1a\u5168\u90e8\u5546\u54c1\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)giftRuleOfAll));
        List<Object> giftRuleEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)giftRuleOfAll)) {
            giftRuleEos.addAll(giftRuleOfAll);
        }
        List buyItemCodeList = Optional.ofNullable(reqDto.getItemList()).orElseGet(Collections::emptyList).stream().map(BizOrderItemReqDto::getItemCode).collect(Collectors.toList());
        LambdaQueryWrapper itemQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)itemQueryWrapper.eq(BaseEo::getDr, (Object)0)).in(TrControlGiftItemEo::getItemCode, buyItemCodeList);
        List itemList = this.trControlGiftItemDas.list((Wrapper)itemQueryWrapper);
        List ruleIdOfItem = Optional.ofNullable(itemList).orElseGet(Collections::emptyList).stream().map(TrControlGiftItemEo::getRuleId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ruleIdOfItem)) {
            LambdaQueryWrapper queryRuleWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryRuleWrapper.eq(BaseEo::getDr, (Object)0)).eq(TrControlGiftRuleEo::getItemRangeType, (Object)RuleRangeTypeEnum.CUSTOMER.getType())).eq(TrControlGiftRuleEo::getOrgId, (Object)reqDto.getOrgId())).in(BaseEo::getId, ruleIdOfItem)).le(TrControlGiftRuleEo::getControlStartTime, (Object)currentDate)).ge(TrControlGiftRuleEo::getControlEndTime, (Object)currentDate)).ge(true, TrControlGiftRuleEo::getLoseTime, (Object)DateUtil.getToday());
            List giftRuleOfItem = this.trControlGiftRuleDas.list((Wrapper)queryRuleWrapper);
            logger.error("\u9002\u7528\u5546\u54c1\uff1a\u7b26\u5408\u6307\u5b9a\u5546\u54c1\u7684\u7ba1\u63a7\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)giftRuleOfItem));
            if (CollectionUtils.isNotEmpty((Collection)giftRuleOfItem)) {
                giftRuleEos.addAll(giftRuleOfItem);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)giftRuleEos)) {
            LambdaQueryWrapper queryBlacklisWrapper = new LambdaQueryWrapper();
            List ruleIdList = giftRuleEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryBlacklisWrapper.in(TrControlGiftBlacklistEo::getRuleId, ruleIdList)).eq(BaseEo::getDr, (Object)0)).eq(TrControlGiftBlacklistEo::getCustomerCode, (Object)reqDto.getCustomerCode());
            List blacklistEos = this.trControlGiftBlacklistDas.list((Wrapper)queryBlacklisWrapper);
            List ruleIdOfBlacklist = Optional.ofNullable(blacklistEos).orElseGet(Collections::emptyList).stream().map(TrControlGiftBlacklistEo::getRuleId).collect(Collectors.toList());
            giftRuleEos = giftRuleEos.stream().filter(giftRule -> !ruleIdOfBlacklist.contains(giftRule.getId())).collect(Collectors.toList());
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u7ecf\u8fc7\u9ed1\u540d\u5355\u7684\u8fc7\u6ee4\u540e\uff0c\u5269\u4f59\u7b26\u5408\u7684\u89c4\u5219\u6709\uff1a{}", (Object)JSON.toJSONString((Object)giftRuleEos));
        }
        if (CollectionUtils.isEmpty((Collection)giftRuleEos)) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5ba2\u6237(customerCode={})\u6ca1\u6709\u7b26\u5408\u7684\u89c4\u5219", (Object)reqDto.getCustomerCode());
            return null;
        }
        List ruleIds = giftRuleEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        LambdaQueryWrapper customerQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)customerQueryWrapper.eq(BaseEo::getDr, (Object)0)).in(TrControlGiftCustomerEo::getRuleId, ruleIds)).eq(TrControlGiftCustomerEo::getCustomerCode, (Object)reqDto.getCustomerCode());
        List customerList = this.trControlGiftCustomerDas.list((Wrapper)customerQueryWrapper);
        List ruleIdOfCustomer = Optional.ofNullable(customerList).orElseGet(Collections::emptyList).stream().map(TrControlGiftCustomerEo::getRuleId).collect(Collectors.toList());
        List<Object> ruleIdOfArea = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getAreaCodeList())) {
            LambdaQueryWrapper areaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)areaQueryWrapper.eq(BaseEo::getDr, (Object)0)).in(TrControlGiftAreaEo::getRuleId, ruleIds)).in(TrControlGiftAreaEo::getAreaCode, (Collection)reqDto.getAreaCodeList());
            List areaList = this.trControlGiftAreaDas.list((Wrapper)areaQueryWrapper);
            ruleIdOfArea = Optional.ofNullable(areaList).orElseGet(Collections::emptyList).stream().map(TrControlGiftAreaEo::getRuleId).collect(Collectors.toList());
        }
        ArrayList finalRuleIdOfArea = ruleIdOfArea;
        List resultList = Optional.ofNullable(giftRuleEos).orElseGet(Collections::emptyList).stream().filter(item -> RuleRangeTypeEnum.ALL.getType().equals(item.getRuleRangeType()) || RuleRangeTypeEnum.CUSTOMER.getType().equals(item.getRuleRangeType()) && ruleIdOfCustomer.contains(item.getId()) || RuleRangeTypeEnum.AREA.getType().equals(item.getRuleRangeType()) && finalRuleIdOfArea.contains(item.getId())).collect(Collectors.toList());
        Map ruleEoMap = resultList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u67e5\u8be2\u672c\u5355\u4e0b\u5355\u7684\u5546\u54c1\u5bf9\u5e94\u65b0\u589e\u7684\u7ba1\u63a7\u989d\u5ea6\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(resultList));
        List resultRuleIds = resultList.stream().map(BaseEo::getId).collect(Collectors.toList());
        List ruleOfAllForValid = Optional.ofNullable(giftRuleOfAll).orElseGet(Collections::emptyList).stream().filter(item -> resultRuleIds.contains(item.getId())).collect(Collectors.toList());
        Map<String, List<TrControlGiftItemEo>> listItemRuleMap = itemList.stream().filter(item -> resultRuleIds.contains(item.getRuleId())).collect(Collectors.groupingBy(TrControlGiftItemEo::getItemCode));
        List validItemCodeOfAll = Optional.ofNullable(reqDto.getItemList()).orElseGet(Collections::emptyList).stream().filter(item -> IS_PRODUCT.equals(item.getSubType())).map(BizOrderItemReqDto::getItemCode).collect(Collectors.toList());
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u6ee1\u8db3\u5168\u90e8\u7c7b\u578b\u7684\u5546\u54c1code\u4e3a\uff1a{}", (Object)JSON.toJSONString(validItemCodeOfAll));
        HashMap resultListMap = Maps.newHashMap();
        for (BizOrderItemReqDto item2 : reqDto.getItemList()) {
            List hitRuleList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(ruleOfAllForValid) && validItemCodeOfAll.contains(item2.getItemCode())) {
                logger.info("\u547d\u4e2d\u5168\u90e8\u5546\u54c1\u4e14\u6709\u6548\u89c4\u5219itemCode={}", (Object)item2.getItemCode());
                hitRuleList.addAll(ruleOfAllForValid);
            }
            if (!listItemRuleMap.isEmpty() && listItemRuleMap.containsKey(item2.getItemCode())) {
                logger.info("\u547d\u4e2d\u6307\u5b9a\u5546\u54c1\u4e14\u6709\u6548\u89c4\u5219itemCode={}", (Object)item2.getItemCode());
                List<TrControlGiftItemEo> assignRuleList = listItemRuleMap.get(item2.getItemCode());
                List ruleEoByItemList = assignRuleList.stream().map(dto -> (TrControlGiftRuleEo)ruleEoMap.get(dto.getRuleId())).collect(Collectors.toList());
                hitRuleList.addAll(ruleEoByItemList);
            }
            if (CollectionUtils.isEmpty((Collection)hitRuleList)) continue;
            hitRuleList = hitRuleList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TrControlGiftRuleEo>(Comparator.comparing(BaseEo::getId))), ArrayList::new));
            resultListMap.put(item2.getItemCode(), hitRuleList);
        }
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u83b7\u53d6\u8d2d\u4e70\u5546\u54c1\u547d\u4e2d\u89c4\u5219\u7684map\u6620\u5c04\uff1a{}", (Object)JSON.toJSONString((Object)resultListMap));
        return resultListMap;
    }
}

