/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.utils;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class RedisCacheHelper {
    @Resource
    private ICacheService cacheService;

    public <T> T putCacheIfAbsent(String key, Class<T> clz, Supplier<T> supplier) {
        return this.putCacheIfAbsent(key, clz, 0, supplier);
    }

    public <T> T putCacheIfAbsent(String key, Class<T> clz, int seconds, Supplier<T> supplier) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(clz);
        Object cache = this.cacheService.getCache(key, clz);
        if (cache != null) {
            return (T)cache;
        }
        T object = supplier.get();
        this.cacheService.setCache(key, object, seconds);
        return object;
    }
}

