/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountEnoughEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountSwitchEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountType;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizOrderItemReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerGiftAmountReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizOrderItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.CustomerGiftAmountInfo;
import com.dtyunxi.tcbj.center.control.api.dto.response.CustomerGiftAmountRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.GiftAmountItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftConfigRespDto;
import com.dtyunxi.tcbj.center.control.api.query.IControlOptQueryApi;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftConfigService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftRuleService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class ControlOptQueryApiImpl
implements IControlOptQueryApi {
    private static final Integer CONTAIN_GIFT = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlOptQueryApiImpl.class);
    private static final int DEFAULT_MAX_CONCURRENT = Runtime.getRuntime().availableProcessors() * 2;
    private static final Integer ENOUGH = 1;
    private static final Integer NOT_ENOUGH = 2;
    private static final long DEFAULT_KEEP_ALIVE = 60L;
    private static final int DEFAULT_SIZE = 500;
    private static ExecutorService executor;
    private static BlockingQueue<Runnable> executeQueue;
    private static final String THREAD_POOL_NAME = "ExternalConvertProcessPool-%d";
    private static final ThreadFactory FACTORY;
    private static final Integer SELECTED;
    @Resource
    private ITrControlGiftRuleService controlGiftRuleService;
    @Resource
    private ITrControlGiftConfigService giftConfigService;

    private static void shutDownThreadPool(ExecutorService executor) {
        LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5173\u95ed\u7ebf\u7a0b\u6c60");
        executor.shutdown();
        try {
            if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                LOGGER.warn("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5ef6\u8fdf60s\u5f3a\u5236\u4e2d\u65ad\u8fdb\u7a0b");
                if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    LOGGER.warn("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u7ebf\u7a0b\u6c60\u65e0\u6cd5\u5173\u95ed");
                }
            }
        }
        catch (InterruptedException ie) {
            executor.shutdownNow();
            LOGGER.warn("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5f53\u524d\u670d\u52a1\u5668\u7ebf\u7a0b\u5728\u5c1d\u8bd5\u505c\u6b62\u5de5\u4f5c\u7ebf\u7a0b\u65f6\u88ab\u4e2d\u65ad");
            Thread.currentThread().interrupt();
        }
    }

    public RestResponse<CustomerGiftAmountRespDto> queryCustomerAmountForOrder(CustomerGiftAmountReqDto reqDto) {
        TrControlGiftConfigRespDto giftConfigRespDto = this.giftConfigService.queryByOrgId(reqDto.getOrgId());
        if (giftConfigRespDto == null || giftConfigRespDto != null && GiftAmountSwitchEnum.CLOSE.getType().equals(giftConfigRespDto.getIsSwitchConfig())) {
            LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5f53\u524d\u5ba2\u6237\u6240\u5c5e\u7684\u7ec4\u7ec7(orgId={})\u672a\u5f00\u542f\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u89c4\u5219\uff01", (Object)reqDto.getOrgId());
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)reqDto.getGiftList())) {
            LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5f53\u524d\u5ba2\u6237(customerCode={})\u6ca1\u6709\u8d2d\u4e70\u8d60\u54c1\uff0c\u65e0\u9700\u8fdb\u884c\u7ba1\u63a7", (Object)reqDto.getCustomerCode());
            return null;
        }
        LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5f53\u524d\u5ba2\u6237(customerCode={})\u8fdb\u5165\u7ba1\u63a7\u67e5\u8be2", (Object)reqDto.getCustomerCode());
        CustomerGiftAmountRespDto customerGiftAmountRespDto = new CustomerGiftAmountRespDto();
        CustomerGiftAmountInfo customerGiftAmountInfo = this.controlGiftRuleService.queryAllRuleOfCutomerByOrder(reqDto);
        if (customerGiftAmountInfo == null) {
            LOGGER.info("[\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2]\u5f53\u524d\u5ba2\u6237(customerCode={})\u8d60\u54c1\u989d\u5ea6\u5217\u8868\u4e3a\u7a7a", (Object)reqDto.getCustomerCode());
            return null;
        }
        if (CONTAIN_GIFT.equals(customerGiftAmountInfo.getContainGiftItem()) && CollectionUtils.isEmpty((Collection)customerGiftAmountInfo.getCustomerAmountList())) {
            LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5ba2\u6237({})\u8d2d\u4e70\u8d60\u54c1({})\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u8d60\u54c1\u989d\u5ea6\uff01", (Object)reqDto.getCustomerCode(), (Object)JSON.toJSONString((Object)reqDto.getGiftList()));
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalCount = BigDecimal.ZERO;
            for (BizOrderItemReqDto giftDto : reqDto.getGiftList()) {
                BigDecimal itemTotalAmount = giftDto.getItemNum().multiply(giftDto.getOriginalPrice());
                totalAmount = totalAmount.add(itemTotalAmount);
                totalCount = totalCount.add(giftDto.getItemNum());
            }
            List giftList = reqDto.getGiftList();
            ArrayList giftRespDtos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)giftRespDtos, (Collection)giftList, BizOrderItemRespDto.class);
            customerGiftAmountRespDto.setGiftsOfNotEnough((List)giftRespDtos);
            customerGiftAmountRespDto.setAmountEnough(GiftAmountEnoughEnum.NOT_ENOUGH.getStatus());
            customerGiftAmountRespDto.setCustomerCode(reqDto.getCustomerCode());
            customerGiftAmountRespDto.setGiftTotalAmount(totalAmount.setScale(2));
            customerGiftAmountRespDto.setGiftTotalNum(totalCount.setScale(2));
            customerGiftAmountRespDto.setDeductGiftAmount(BigDecimal.ZERO);
            customerGiftAmountRespDto.setDeductGiftNum(BigDecimal.ZERO);
            customerGiftAmountRespDto.setRemainGiftAmount(totalAmount.setScale(2));
            customerGiftAmountRespDto.setRemainGiftNum(totalCount.setScale(2));
            return new RestResponse((Object)customerGiftAmountRespDto);
        }
        this.builderResponseData(reqDto, customerGiftAmountRespDto, customerGiftAmountInfo);
        return new RestResponse((Object)customerGiftAmountRespDto);
    }

    private void builderResponseData(CustomerGiftAmountReqDto reqDto, CustomerGiftAmountRespDto customerGiftAmountRespDto, CustomerGiftAmountInfo customerGiftAmountInfo) {
        LOGGER.info("builderResponseData==>customerGiftAmountInfo:{}", (Object)JSON.toJSONString((Object)customerGiftAmountInfo));
        ArrayList orgGiftItemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orgGiftItemList, (Collection)reqDto.getGiftList(), BizOrderItemRespDto.class);
        ArrayList validAmountList = Lists.newArrayList();
        ArrayList unusableAmountList = Lists.newArrayList();
        Date currentDate = DateUtil.getToday();
        List allRuleAmountList = customerGiftAmountInfo.getCustomerAmountList();
        allRuleAmountList.forEach(ruleAmount -> {
            if (YesOrNoEnum.YES.getCode().equals(ruleAmount.getIsUsable())) {
                validAmountList.add(ruleAmount);
            } else {
                unusableAmountList.add(ruleAmount);
            }
        });
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalCount = BigDecimal.ZERO;
        BigDecimal remainGiftAmount = BigDecimal.ZERO;
        BigDecimal remainGiftNum = BigDecimal.ZERO;
        ArrayList controlGiftItems = Lists.newArrayList();
        for (BizOrderItemReqDto giftDto : reqDto.getGiftList()) {
            if (!Objects.equals(giftDto.getMatch(), 2)) continue;
            giftDto.setEnoughStatus(customerGiftAmountInfo.getGiftCodesOfAmountNotEnough().contains(giftDto.getItemCode()) ? NOT_ENOUGH : ENOUGH);
            controlGiftItems.add(giftDto);
            BigDecimal itemTotalAmount = giftDto.getItemNum().multiply(giftDto.getOriginalPrice());
            totalAmount = totalAmount.add(itemTotalAmount);
            totalCount = totalCount.add(giftDto.getItemNum());
            remainGiftAmount = remainGiftAmount.add(giftDto.getRemainGiftAmount());
            remainGiftNum = remainGiftNum.add(giftDto.getRemainGiftNum());
        }
        BigDecimal reduceAmount = Optional.ofNullable(validAmountList).orElseGet(Collections::emptyList).stream().filter(item -> GiftAmountType.AMOUNT_MONEY.getType().equals(item.getAmountType())).filter(item -> SELECTED.equals(item.getSelected())).map(GiftAmountItemRespDto::getDeductAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reduceCount = Optional.ofNullable(validAmountList).orElseGet(Collections::emptyList).stream().filter(item -> GiftAmountType.AMOUNT_NUM.getType().equals(item.getAmountType())).filter(item -> SELECTED.equals(item.getSelected())).map(GiftAmountItemRespDto::getDeductAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        List giftsOfNotEnough = orgGiftItemList.stream().filter(item -> customerGiftAmountInfo.getGiftCodesOfAmountNotEnough().contains(item.getItemCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(giftsOfNotEnough)) {
            LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u989d\u5ea6\u4e0d\u8db3\u7684\u8d60\u54c1\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(giftsOfNotEnough));
        }
        LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u8d60\u54c1\u603b\u4ef7:{}\uff0c\u603b\u6570\u91cf:{};\n\u989d\u5ea6\u53ef\u6263\u51cf(\u91d1\u989d):{}\uff0c\u989d\u5ea6\u53ef\u6263\u51cf(\u6570\u91cf):{};\n\u8d60\u54c1\u5269\u4f59\u4ef7\u683c:{},\u8d60\u54c1\u5269\u4f59\u6570\u91cf:{}", new Object[]{totalAmount, totalCount, reduceAmount, reduceCount, remainGiftAmount, remainGiftNum});
        customerGiftAmountRespDto.setGiftsOfNotEnough(giftsOfNotEnough);
        customerGiftAmountRespDto.setCustomerCode(reqDto.getCustomerCode());
        customerGiftAmountRespDto.setGiftTotalAmount(totalAmount.setScale(2, 4));
        customerGiftAmountRespDto.setGiftTotalNum(totalCount.setScale(2, 4));
        customerGiftAmountRespDto.setDeductGiftAmount(reduceAmount.setScale(2, 4));
        customerGiftAmountRespDto.setDeductGiftNum(reduceCount.setScale(2, 4));
        customerGiftAmountRespDto.setRemainGiftAmount(remainGiftAmount);
        customerGiftAmountRespDto.setRemainGiftNum(remainGiftNum);
        customerGiftAmountRespDto.setAmountEnough(customerGiftAmountInfo.getAmountEnough());
        customerGiftAmountRespDto.setValidAmountList((List)validAmountList);
        customerGiftAmountRespDto.setUnusableAmountList((List)unusableAmountList);
        customerGiftAmountRespDto.setControlGiftItems((List)controlGiftItems);
    }

    public RestResponse<List<CustomerGiftAmountRespDto>> queryCustomersAmountForOrder(List<CustomerGiftAmountReqDto> reqDtos) {
        LOGGER.info("queryCustomersAmountForOrder==>{}", (Object)JSON.toJSONString(reqDtos));
        if (CollectionUtils.isEmpty(reqDtos)) {
            LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u63d0\u4ea4\u7684\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        Map mdcContextMap = MDC.getCopyOfContextMap();
        ArrayList futureList = Lists.newArrayList();
        reqDtos.forEach(reqDto -> {
            CompletableFuture<CustomerGiftAmountRespDto> future = CompletableFuture.supplyAsync(() -> {
                try {
                    if (null != mdcContextMap) {
                        MDC.setContextMap((Map)mdcContextMap);
                    } else {
                        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
                    }
                    RestResponse<CustomerGiftAmountRespDto> respDtoRestResponse = this.queryCustomerAmountForOrder((CustomerGiftAmountReqDto)reqDto);
                    LOGGER.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011[{}]\u67e5\u8be2\u5230\u5ba2\u6237\u7684\u989d\u5ea6\u4fe1\u606f\u4e3a\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSON.toJSONString(respDtoRestResponse));
                    CustomerGiftAmountRespDto customerGiftAmountRespDto = (CustomerGiftAmountRespDto)RestResponseHelper.extractData(respDtoRestResponse);
                    return customerGiftAmountRespDto;
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u67e5\u8be2\u5ba2\u6237(customerCode=%s)\u7684\u8d60\u54c1\u989d\u5ea6\u5f02\u5e38\uff1a", reqDto.getCustomerCode()), (Throwable)e);
                    throw e;
                }
            }, executor);
            futureList.add(future);
        });
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()]));
        ArrayList resultList = Lists.newArrayList();
        for (CompletableFuture future : futureList) {
            try {
                CustomerGiftAmountRespDto customerGiftAmountRespDto = (CustomerGiftAmountRespDto)future.get(30L, TimeUnit.SECONDS);
                if (customerGiftAmountRespDto == null) continue;
                resultList.add(customerGiftAmountRespDto);
            }
            catch (Exception e) {
                LOGGER.error("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5f02\u6b65\u7ebf\u7a0b\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return new RestResponse((Object)resultList);
    }

    static {
        executeQueue = new ArrayBlockingQueue<Runnable>(500);
        FACTORY = new BasicThreadFactory.Builder().namingPattern(THREAD_POOL_NAME).daemon(true).build();
        SELECTED = 1;
        try {
            executor = new ThreadPoolExecutor(DEFAULT_MAX_CONCURRENT, DEFAULT_MAX_CONCURRENT * 2, 60L, TimeUnit.SECONDS, executeQueue, FACTORY);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ControlOptQueryApiImpl.shutDownThreadPool(executor)));
        }
        catch (Exception e) {
            LOGGER.error("AsyncProcessor init error.", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

