/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.scheduleds;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.tcbj.center.control.api.dto.constant.AmountStatusEnum;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftRuleService;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftRuleEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component(value="disabledGiftRuleScheduled")
@Scope(value="prototype")
public class DisabledGiftRuleScheduled
extends SingleTupleScheduleEvent {
    private final Logger logger = LoggerFactory.getLogger(DisabledGiftRuleScheduled.class);
    @Resource
    private ITrControlGiftRuleService controlGiftRuleService;

    public void before(TaskMsg taskMsg) {
        this.logger.info("\u5f00\u59cb\u6267\u884c\u8d60\u54c1\u989d\u5ea6\u89c4\u5219\u72b6\u6001\u5904\u7406---");
    }

    public boolean execute(TaskMsg taskMsg) {
        List controlGiftRuleEos;
        String content = taskMsg.getContent();
        this.logger.info("\u3010\u8c03\u5ea6\u4efb\u52a1\u3011\u6267\u884c\u53c2\u6570\uff1a{}", (Object)content);
        Date date = new Date();
        List<TrControlGiftRuleEo> controlGiftRuleAndDisabled = this.controlGiftRuleService.getControlGiftRuleByRuleIds(Lists.newArrayList((Object[])new Long[]{Long.valueOf(content)}));
        List setGiftRuleList = controlGiftRuleAndDisabled.stream().filter(c -> c.getStatus().equals(AmountStatusEnum.USE.getType())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(setGiftRuleList)) {
            TrControlGiftRuleEo controlGiftRuleEo = (TrControlGiftRuleEo)setGiftRuleList.stream().findFirst().get();
            AssertUtils.notNull((Object)controlGiftRuleEo.getControlStartTime(), (String)"\u5f00\u59cb\u6267\u884c\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            controlGiftRuleEo.setStatus(controlGiftRuleEo.getControlStartTime().compareTo(date) == 1 ? AmountStatusEnum.USE.getType() : AmountStatusEnum.USING.getType());
            this.logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u89c4\u5219\u72b6\u6001\u5904\u7406\u3011\u5f53\u524d\u9700\u8981\u5904\u7406\u6570\u636e:{}", (Object)JSON.toJSONString(setGiftRuleList));
            this.controlGiftRuleService.modifyControlGiftRule(controlGiftRuleEo);
        }
        if (!ObjectUtils.isEmpty(controlGiftRuleEos = controlGiftRuleAndDisabled.stream().filter(c -> c.getControlEndTime().compareTo(date) <= 0).collect(Collectors.toList()))) {
            TrControlGiftRuleEo controlGiftRuleEo = (TrControlGiftRuleEo)controlGiftRuleEos.stream().findFirst().get();
            AssertUtils.notNull((Object)controlGiftRuleEo.getControlEndTime(), (String)"\u6267\u884c\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            controlGiftRuleEo.setStatus(controlGiftRuleEo.getControlEndTime().compareTo(date) == 1 ? AmountStatusEnum.USING.getType() : AmountStatusEnum.USED.getType());
            this.logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u89c4\u5219\u72b6\u6001\u5904\u7406\u3011\u5f53\u524d\u9700\u8981\u5904\u7406\u6570\u636e:{}", (Object)JSON.toJSONString(controlGiftRuleEos));
            this.controlGiftRuleService.modifyControlGiftRule(controlGiftRuleEo);
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

