/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlInventoryItemReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryItemRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlInventoryItemService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlInventoryItemDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlInventoryItemEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ControlInventoryItemServiceImpl
implements IControlInventoryItemService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlInventoryItemDas controlInventoryItemDas;

    @Override
    public Long addControlInventoryItem(ControlInventoryItemReqDto addReqDto) {
        ControlInventoryItemEo controlInventoryItemEo = new ControlInventoryItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlInventoryItemEo);
        this.controlInventoryItemDas.insert((BaseEo)controlInventoryItemEo);
        return controlInventoryItemEo.getId();
    }

    @Override
    public void modifyControlInventoryItem(ControlInventoryItemReqDto modifyReqDto) {
        ControlInventoryItemEo controlInventoryItemEo = new ControlInventoryItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)controlInventoryItemEo);
        this.controlInventoryItemDas.updateSelective((BaseEo)controlInventoryItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlInventoryItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlInventoryItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ControlInventoryItemRespDto queryById(Long id) {
        ControlInventoryItemEo controlInventoryItemEo = (ControlInventoryItemEo)this.controlInventoryItemDas.selectByPrimaryKey(id);
        ControlInventoryItemRespDto controlInventoryItemRespDto = new ControlInventoryItemRespDto();
        DtoHelper.eo2Dto((BaseEo)controlInventoryItemEo, (BaseVo)controlInventoryItemRespDto);
        return controlInventoryItemRespDto;
    }

    @Override
    public PageInfo<ControlInventoryItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ControlInventoryItemReqDto controlInventoryItemReqDto = (ControlInventoryItemReqDto)JSON.parseObject((String)filter, ControlInventoryItemReqDto.class);
        ControlInventoryItemEo controlInventoryItemEo = new ControlInventoryItemEo();
        DtoHelper.dto2Eo((BaseVo)controlInventoryItemReqDto, (BaseEo)controlInventoryItemEo);
        PageInfo eoPageInfo = this.controlInventoryItemDas.selectPage((BaseEo)controlInventoryItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlInventoryItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void addControlInventoryItems(List<ControlInventoryItemReqDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            throw ControlExceptionCode.ITEM_NOT_EXIT.getException();
        }
        if (itemList.get(0).getRuleId() == null) {
            this.logger.error("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011ruleId\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(itemList));
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ArrayList inventoryAreaEos = Lists.newArrayList();
        DtoHelper.dtoList2EoList(itemList, (Collection)inventoryAreaEos, ControlInventoryItemEo.class);
        int result = this.controlInventoryItemDas.insertBatch((List)inventoryAreaEos);
        if (result < 0) {
            this.logger.error("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011\u6279\u91cf\u6dfb\u52a0\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(itemList));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
    }

    @Override
    public List<ControlInventoryItemRespDto> queryVerifyItemList(List<ControlInventoryItemReqDto> itemList) {
        AssertUtils.notEmpty(itemList, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List itemIdList = itemList.stream().map(ControlInventoryItemReqDto::getItemId).distinct().collect(Collectors.toList());
        ControlInventoryItemEo queryEo = new ControlInventoryItemEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"item_id", itemIdList));
        filterList.add(SqlFilter.eq((String)"enable", (Object)RuleEnableEnum.ENABLE.getValue()));
        queryEo.setSqlFilters((List)filterList);
        List inventoryItemEos = this.controlInventoryItemDas.select((BaseEo)queryEo);
        ArrayList inventoryItemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)inventoryItemEos, (Collection)inventoryItemRespDtoList, ControlInventoryItemRespDto.class);
        return inventoryItemRespDtoList;
    }

    @Override
    public void removeControlItemByRuleId(Long ruleId) {
        if (ruleId == null) {
            this.logger.error("\u3010\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\u3011ruleId\u4e0d\u80fd\u4e3a\u7a7a");
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ControlInventoryItemEo removeEo = new ControlInventoryItemEo();
        removeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        this.controlInventoryItemDas.delete((BaseEo)removeEo);
    }

    @Override
    public List<ControlInventoryItemRespDto> queryByItemIds(List<Long> itemIdList) {
        AssertUtils.notEmpty(itemIdList, (String)"itemList \u4e0d\u80fd\u4e3a\u7a7a");
        ControlInventoryItemEo queryEo = new ControlInventoryItemEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"item_id", itemIdList));
        queryEo.setSqlFilters((List)filterList);
        List itemCustomerEos = this.controlInventoryItemDas.select((BaseEo)queryEo);
        ArrayList itemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemCustomerEos, (Collection)itemRespDtoList, ControlInventoryItemRespDto.class);
        return itemRespDtoList;
    }

    @Override
    public List<ControlInventoryItemRespDto> queryByRuleIds(List<Long> ruleId) {
        AssertUtils.notEmpty(ruleId, (String)"itemList \u4e0d\u80fd\u4e3a\u7a7a");
        ControlInventoryItemEo queryEo = new ControlInventoryItemEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"rule_id", ruleId));
        queryEo.setSqlFilters((List)filterList);
        List itemCustomerEos = this.controlInventoryItemDas.select((BaseEo)queryEo);
        ArrayList itemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemCustomerEos, (Collection)itemRespDtoList, ControlInventoryItemRespDto.class);
        return itemRespDtoList;
    }

    @Override
    public List<ControlInventoryItemRespDto> queryInventoryItemByitemIds(List<Long> itemIdList) {
        AssertUtils.notEmpty(itemIdList, (String)"itemIdList\u4e0d\u80fd\u4e3a\u7a7a");
        ControlInventoryItemEo queryEo = new ControlInventoryItemEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"item_id", itemIdList));
        filterList.add(SqlFilter.eq((String)"enable", (Object)RuleEnableEnum.ENABLE.getValue()));
        queryEo.setSqlFilters((List)filterList);
        List itemCustomerEos = this.controlInventoryItemDas.select((BaseEo)queryEo);
        ArrayList itemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemCustomerEos, (Collection)itemRespDtoList, ControlInventoryItemRespDto.class);
        return itemRespDtoList;
    }
}

