/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlItemOrderReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemOrderRespDto;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemOrderService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlItemOrderDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlItemOrderEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ControlItemOrderServiceImpl
implements IControlItemOrderService {
    @Resource
    private ControlItemOrderDas controlItemOrderDas;

    @Override
    public Long addControlItemOrder(ControlItemOrderReqDto addReqDto) {
        ControlItemOrderEo controlItemOrderEo = new ControlItemOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlItemOrderEo);
        this.controlItemOrderDas.insert((BaseEo)controlItemOrderEo);
        return controlItemOrderEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addControlItemOrderBatch(List<ControlItemOrderReqDto> addReqDtoList) {
        ArrayList controlItemOrderEoList = Lists.newArrayList();
        DtoHelper.dtoList2EoList(addReqDtoList, (Collection)controlItemOrderEoList, ControlItemOrderEo.class);
        this.controlItemOrderDas.insertBatch((List)controlItemOrderEoList);
    }

    @Override
    public void modifyControlItemOrder(ControlItemOrderReqDto modifyReqDto) {
        ControlItemOrderEo controlItemOrderEo = new ControlItemOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)controlItemOrderEo);
        this.controlItemOrderDas.updateSelective((BaseEo)controlItemOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlItemOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlItemOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ControlItemOrderRespDto queryById(Long id) {
        ControlItemOrderEo controlItemOrderEo = (ControlItemOrderEo)this.controlItemOrderDas.selectByPrimaryKey(id);
        ControlItemOrderRespDto controlItemOrderRespDto = new ControlItemOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)controlItemOrderEo, (BaseVo)controlItemOrderRespDto);
        return controlItemOrderRespDto;
    }

    @Override
    public PageInfo<ControlItemOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ControlItemOrderReqDto controlItemOrderReqDto = (ControlItemOrderReqDto)JSON.parseObject((String)filter, ControlItemOrderReqDto.class);
        ControlItemOrderEo controlItemOrderEo = new ControlItemOrderEo();
        DtoHelper.dto2Eo((BaseVo)controlItemOrderReqDto, (BaseEo)controlItemOrderEo);
        PageInfo eoPageInfo = this.controlItemOrderDas.selectPage((BaseEo)controlItemOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlItemOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ControlItemOrderRespDto> queryByTradeNo(String tradeNo) {
        if (StringUtils.isEmpty((CharSequence)tradeNo)) {
            return Lists.newArrayList();
        }
        ControlItemOrderEo queryEo = new ControlItemOrderEo();
        queryEo.setTradeNo(tradeNo);
        queryEo.setDr(0);
        List itemOrderEos = this.controlItemOrderDas.select((BaseEo)queryEo);
        if (CollectionUtil.isEmpty((Collection)itemOrderEos)) {
            return Lists.newArrayList();
        }
        ArrayList<ControlItemOrderRespDto> dtoList = new ArrayList<ControlItemOrderRespDto>();
        DtoHelper.eoList2DtoList((Collection)itemOrderEos, dtoList, ControlItemOrderRespDto.class);
        return dtoList;
    }
}

