/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.IControlOptApi;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountEnoughEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountSwitchEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OrderAmountCalculateTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.TradeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.AmountControlReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerGiftAmountReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizItemAmountRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.CustomerGiftAmountInfo;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftConfigRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemAmountOptVo;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftConfigService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftResultService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftRuleService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlItemAmountRecordService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlItemAmountRuleService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IControlOptApiImpl
implements IControlOptApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final Integer CONTAIN_GIFT = 1;
    @Resource
    private ITrControlItemAmountRuleService itemAmountRuleService;
    @Resource
    private ITrControlItemAmountRecordService itemAmountRecordService;
    @Resource
    private ITrControlGiftConfigService controlGiftConfigService;
    @Resource
    private ITrControlGiftRuleService controlGiftRuleService;
    @Resource
    private ITrControlGiftResultService giftResultService;
    @Autowired
    private ITrControlItemAmountRuleService controlItemAmountRuleService;
    @Resource
    private IControlItemService controlItemService;

    public RestResponse<Void> checkAmountControl(AmountControlReqDto reqDto) {
        BigDecimal buyAmount;
        boolean overLimitAmount;
        this.logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        BizItemAmountRuleRespDto itemAmountRuleRespDto = this.itemAmountRuleService.queryRuleByCustomer(reqDto.getCustomerCode(), reqDto.getOrgId());
        if (itemAmountRuleRespDto == null) {
            this.logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5ba2\u6237(customerCode={})\u4e0d\u5b58\u5728\u7ba1\u63a7\u89c4\u5219\uff01", (Object)reqDto.getCustomerCode());
            return RestResponse.VOID;
        }
        if (OrderAmountCalculateTypeEnum.SUPPLY_AMOUNT.getType().equals(itemAmountRuleRespDto.getOrderDeductionWay())) {
            overLimitAmount = reqDto.getSupplyAmount().compareTo(itemAmountRuleRespDto.getSurplusAmount()) > 0;
            buyAmount = reqDto.getSupplyAmount();
            if (overLimitAmount) {
                this.logger.warn("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5ba2\u6237\u7684\u5269\u4f59\u989d\u5ea6\u4e0d\u8db3\uff0c\u8d2d\u4e70\u7684\u989d\u5ea6\u4e3a\uff1a{}\uff0c\u5269\u4f59\u7684\u989d\u5ea6\u4e3a\uff1a{}", (Object)reqDto.getSupplyAmount(), (Object)itemAmountRuleRespDto.getSurplusAmount());
                String message = String.format("\u5546\u5bb6\u7ed9\u60a8\u672c\u6708\u5206\u914d\u7684\u8ba2\u8d27\u989d\u5ea6\u4ec5\u5269%s\u5143\uff0c\u5e94\u4ed8\u91d1\u989d%s\u5143", itemAmountRuleRespDto.getSurplusAmount(), reqDto.getSupplyAmount());
                throw new BizException(ControlExceptionCode.AMOUNT_NOT_ENOUGH.getCode(), message);
            }
        } else {
            overLimitAmount = reqDto.getPaymentAmount().compareTo(itemAmountRuleRespDto.getSurplusAmount()) > 0;
            buyAmount = reqDto.getPaymentAmount();
            if (overLimitAmount) {
                this.logger.warn("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5ba2\u6237\u7684\u5269\u4f59\u989d\u5ea6\u4e0d\u8db3\uff0c\u8d2d\u4e70\u7684\u989d\u5ea6\u4e3a\uff1a{}\uff0c\u5269\u4f59\u7684\u989d\u5ea6\u4e3a\uff1a{}", (Object)reqDto.getPaymentAmount(), (Object)itemAmountRuleRespDto.getSurplusAmount());
                String message = String.format("\u5546\u5bb6\u7ed9\u60a8\u672c\u6708\u5206\u914d\u7684\u8ba2\u8d27\u989d\u5ea6\u4ec5\u5269%s\u5143\uff0c\u5e94\u4ed8\u91d1\u989d%s\u5143", itemAmountRuleRespDto.getSurplusAmount(), reqDto.getPaymentAmount());
                throw new BizException(ControlExceptionCode.AMOUNT_NOT_ENOUGH.getCode(), message);
            }
        }
        ItemAmountOptVo itemAmountOptVo = new ItemAmountOptVo();
        itemAmountOptVo.setAmount(buyAmount);
        itemAmountOptVo.setBusinessId(reqDto.getOrderNo());
        itemAmountOptVo.setCustomerCode(reqDto.getCustomerCode());
        itemAmountOptVo.setCustomerName(reqDto.getCustomerName());
        itemAmountOptVo.setId(itemAmountRuleRespDto.getId());
        itemAmountOptVo.setOrgId(reqDto.getOrgId());
        itemAmountOptVo.setAmountTime(DateUtil.parseDate((String)itemAmountRuleRespDto.getAmountTime(), (String)"yyyy-MM-dd"));
        itemAmountOptVo.setTypeEnum(TradeTypeEnum.AMOUNT_ORDER_CUT);
        this.itemAmountRuleService.handleAmount(itemAmountOptVo);
        this.logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5ba2\u6237(customerCode={},customerName={})\u7684\u8ba2\u5355(orderNo={})\u53d7\u5230\u7ba1\u63a7\uff0c\u7ba1\u63a7\u6821\u9a8c\u901a\u8fc7\uff01", new Object[]{reqDto.getCustomerCode(), reqDto.getCustomerName(), reqDto.getOrderNo()});
        return RestResponse.VOID;
    }

    public RestResponse<Void> cancelOrderOfControl(AmountControlReqDto reqDto) {
        this.logger.info("\u3010\u53d6\u6d88\u8ba2\u5355\u3011[\u7ba1\u63a7]\u8ba2\u5355\u53f7\uff1a({}) \u53d6\u6d88\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)reqDto.getOrderNo(), (Object)JSON.toJSONString((Object)reqDto));
        this.returnOrCancelOrder(reqDto, TradeTypeEnum.AMOUNT_ORDER_ROLLBACK);
        this.giftResultService.cancelOrderForGift(reqDto.getOrderNo(), reqDto.getCustomerCode());
        this.controlItemService.cancelOrderForItem(reqDto.getOrderNo());
        return RestResponse.VOID;
    }

    public RestResponse<Void> returnProductOfControl(AmountControlReqDto reqDto) {
        this.logger.info("\u3010\u9000\u8d27\u3011[\u7ba1\u63a7]\u8ba2\u5355\u53f7\uff1a({}) \u53d1\u8d77\u9000\u8d27\u64cd\u4f5c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)reqDto.getOrderNo(), (Object)JSON.toJSONString((Object)reqDto));
        this.returnOrCancelOrder(reqDto, TradeTypeEnum.AMOUNT_SALESRETURN_ADD);
        this.giftResultService.returnProductForGift(reqDto.getOrderNo());
        return RestResponse.VOID;
    }

    public RestResponse<Void> returnProductOfControlExt(AmountControlReqDto reqDto) {
        this.logger.info("\u3010\u9000\u8d27\u3011[\u7ba1\u63a7]\u8ba2\u5355\u53f7\uff1a({}) \u53d1\u8d77\u9000\u8d27\u64cd\u4f5c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)reqDto.getOrderNo(), (Object)JSON.toJSONString((Object)reqDto));
        this.returnOrCancelOrderExt(reqDto, TradeTypeEnum.AMOUNT_SALESRETURN_ADD);
        return RestResponse.VOID;
    }

    private void returnOrCancelOrderExt(AmountControlReqDto reqDto, TradeTypeEnum tradeTypeEnum) {
        this.verifyParam(reqDto);
        TrControlItemAmountRuleRespDto ruleRespDto = this.controlItemAmountRuleService.queryEffectiveRuleByCustomerCode(reqDto.getCustomerCode());
        if (ruleRespDto == null) {
            this.logger.info("\u751f\u6548\u4e2d\u7684\u8ba2\u8d27\u989d\u5ea6\u8d26\u6237\u4e3a\u7a7a");
            return;
        }
        ItemAmountOptVo itemAmountOptVo = new ItemAmountOptVo();
        itemAmountOptVo.setAmount(reqDto.getReturnAmount());
        itemAmountOptVo.setBusinessId(reqDto.getReturnNo());
        itemAmountOptVo.setCustomerCode(reqDto.getCustomerCode());
        itemAmountOptVo.setCustomerName(ruleRespDto.getCustomerName());
        itemAmountOptVo.setId(ruleRespDto.getId());
        itemAmountOptVo.setOrgId(ruleRespDto.getOrgId());
        itemAmountOptVo.setAmountTime(new Date());
        itemAmountOptVo.setTypeEnum(tradeTypeEnum);
        this.itemAmountRuleService.handleAmount(itemAmountOptVo);
        this.logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5ba2\u6237(customerCode={},customerName={})\u7684\u8ba2\u5355(orderNo={})\u53d6\u6d88\u8ba2\u5355\u6210\u529f\uff01", new Object[]{reqDto.getCustomerCode(), ruleRespDto.getCustomerName(), reqDto.getReturnNo()});
    }

    private void verifyParam(AmountControlReqDto reqDto) {
        AssertUtils.notBlank((String)reqDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((reqDto.getReturnAmount() != null && reqDto.getReturnAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u9000\u56de\u8ba2\u8d27\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
    }

    public RestResponse<Void> checkGiftAmountControl(CustomerGiftAmountReqDto reqDto) {
        TrControlGiftConfigRespDto controlGiftConfigRespDto = this.controlGiftConfigService.queryByOrgId(reqDto.getOrgId());
        if (controlGiftConfigRespDto == null || GiftAmountSwitchEnum.CLOSE.getType().equals(controlGiftConfigRespDto.getIsSwitchConfig())) {
            this.logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u7ba1\u63a7\u3011\u5ba2\u6237(customerCode={})\u4e0d\u5b58\u5728\u7ba1\u63a7\u89c4\u5219\uff01", (Object)reqDto.getCustomerCode());
            return RestResponse.VOID;
        }
        CustomerGiftAmountReqDto preAmountReqDto = new CustomerGiftAmountReqDto();
        CubeBeanUtils.copyProperties((Object)preAmountReqDto, (Object)reqDto, (String[])new String[0]);
        CustomerGiftAmountInfo customerGiftAmountInfo = this.controlGiftRuleService.queryAllRuleOfCutomerByOrder(preAmountReqDto);
        if (customerGiftAmountInfo == null) {
            this.logger.info("[\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2]\u5f53\u524d\u5ba2\u6237(customerCode={})\u8d60\u54c1\u989d\u5ea6\u5217\u8868\u4e3a\u7a7a", (Object)reqDto.getCustomerCode());
            return RestResponse.VOID;
        }
        if (CONTAIN_GIFT.equals(customerGiftAmountInfo.getContainGiftItem()) && CollectionUtils.isEmpty((Collection)customerGiftAmountInfo.getCustomerAmountList())) {
            this.logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5ba2\u6237({})\u8d2d\u4e70\u8d60\u54c1({})\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u8d60\u54c1\u989d\u5ea6\uff01", (Object)reqDto.getCustomerCode(), (Object)JSON.toJSONString((Object)reqDto.getGiftList()));
            throw ControlExceptionCode.GIFT_AMOUNT_LESS_EXIT.getException();
        }
        if (GiftAmountEnoughEnum.NOT_ENOUGH.getStatus().equals(customerGiftAmountInfo.getAmountEnough())) {
            this.logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u67e5\u8be2\u3011\u5ba2\u6237({})\u8d60\u54c1\u4f59\u989d\u4e0d\u8db3\uff01\u8d2d\u4e70\u7684\u8d60\u54c1\u5217\u8868\u4e3a\uff1a{},\u53ef\u7528\u4e8e\u8d2d\u4e70\u7684\u989d\u5ea6\u5217\u8868\u4e3a\uff1a{}", new Object[]{reqDto.getCustomerCode(), JSON.toJSONString((Object)reqDto.getGiftList()), JSON.toJSONString((Object)customerGiftAmountInfo.getCustomerAmountList())});
            throw ControlExceptionCode.GIFT_AMOUNT_LESS_EXIT.getException();
        }
        this.controlGiftRuleService.handleGiftAmountForOrder(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> unfreezeAmountForGift(String orderNo) {
        this.giftResultService.unfreezeAmountForGift(orderNo);
        return RestResponse.VOID;
    }

    private RestResponse<Void> returnOrCancelOrder(AmountControlReqDto reqDto, TradeTypeEnum tradeTypeEnum) {
        AssertUtils.notEmpty((String)reqDto.getOrderNo(), (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TrControlItemAmountRecordRespDto itemAmountRecordRespDto = this.itemAmountRecordService.queryRecordByOrderNo(reqDto.getOrderNo());
        if (itemAmountRecordRespDto == null) {
            this.logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u8ba2\u5355\u53f7\u4e3a\uff1a{}\u6ca1\u6709\u88ab\u7ba1\u63a7\uff0c\u672a\u5b58\u5728\u7ba1\u63a7\u8bb0\u5f55", (Object)reqDto.getOrderNo());
            return RestResponse.VOID;
        }
        ItemAmountOptVo itemAmountOptVo = new ItemAmountOptVo();
        itemAmountOptVo.setAmount(itemAmountRecordRespDto.getTradeAmount());
        itemAmountOptVo.setBusinessId(reqDto.getOrderNo());
        itemAmountOptVo.setCustomerCode(itemAmountRecordRespDto.getCustomerCode());
        itemAmountOptVo.setCustomerName(itemAmountRecordRespDto.getCustomerName());
        itemAmountOptVo.setId(itemAmountRecordRespDto.getBillId());
        itemAmountOptVo.setOrgId(itemAmountRecordRespDto.getOrgId());
        itemAmountOptVo.setAmountTime(itemAmountRecordRespDto.getAmountTime());
        itemAmountOptVo.setTypeEnum(tradeTypeEnum);
        this.itemAmountRuleService.handleAmount(itemAmountOptVo);
        this.logger.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u5ba2\u6237(customerCode={},customerName={})\u7684\u8ba2\u5355(orderNo={})\u53d6\u6d88\u8ba2\u5355\u6210\u529f\uff01", new Object[]{itemAmountRecordRespDto.getCustomerCode(), itemAmountRecordRespDto.getCustomerName(), reqDto.getOrderNo()});
        return RestResponse.VOID;
    }
}

