/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.scheduleds;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ControlItemScheduled {
    private static final Logger logger = LoggerFactory.getLogger(ControlItemScheduled.class);
    private static final String CONTROL_ITEM_LOCK_KEY = "CONTROL_ITEM_LOCK_KEY";
    @Resource
    private IControlItemService controlItemService;
    @Resource
    private ICacheService cacheService;

    @Scheduled(cron="0 0 0 1 1/1 ? ")
    public void autoCountControlItem() {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1-autoCountControlItem");
        Boolean lockFlag = this.cacheService.setIfAbsent(CONTROL_ITEM_LOCK_KEY, (Object)1, 120);
        if (lockFlag.booleanValue()) {
            logger.info("\u3010\u7ba1\u63a7\u81ea\u52a8\u9650\u8d2d\u6570\u91cf\u7edf\u8ba1\u3011\u5b9a\u65f6\u5668\u542f\u52a8");
            try {
                this.controlItemService.countItemNum(null, null);
            }
            catch (Exception e) {
                logger.error("\u3010\u7ba1\u63a7\u81ea\u52a8\u9650\u8d2d\u6570\u91cf\u7edf\u8ba1\u3011\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.cacheService.delCache(CONTROL_ITEM_LOCK_KEY);
            }
        }
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-autoCountControlItem");
    }
}

