/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.scheduleds;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.control.api.dto.constant.AmountStatusEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftResultReqDto;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftResultService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftRuleService;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftResultEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftRuleEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="disabledGiftScheduled")
@Scope(value="prototype")
public class DisabledGiftScheduled
extends SingleTupleScheduleEvent {
    private final Logger logger = LoggerFactory.getLogger(DisabledGiftScheduled.class);
    @Resource
    private ITrControlGiftResultService controlGiftResultService;
    @Resource
    private ITrControlGiftRuleService controlGiftRuleService;

    public void disabledGiftAmountScheduled(String ruleId) {
        Date date = new Date();
        this.logger.info("\u3010\u4efb\u52a1\u8c03\u5ea6\u3011\u5f00\u59cb\u6267\u884c\u5904\u7406\u5931\u6548\u8d60\u54c1\u989d\u5ea6\u6263\u51cf\u65f6\u95f4 {}", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)date));
        List<TrControlGiftRuleEo> controlGiftRuleAndDisabled = this.controlGiftRuleService.getControlGiftRuleByRuleIds(Lists.newArrayList((Object[])new Long[]{Long.valueOf(ruleId)}));
        List loseGiftAmountList = controlGiftRuleAndDisabled.stream().filter(c -> c.getLoseTime().compareTo(date) <= 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(loseGiftAmountList)) {
            List<TrControlGiftResultEo> controlGiftResultEos = this.controlGiftResultService.getControlGiftResultListByRuleId(Lists.newArrayList((Object[])new Long[]{Long.valueOf(ruleId)}));
            controlGiftResultEos.forEach(c -> {
                c.setStatus(AmountStatusEnum.USED.getType());
                TrControlGiftResultReqDto controlGiftResultReqDto = new TrControlGiftResultReqDto();
                DtoHelper.eo2Dto((BaseEo)c, (BaseVo)controlGiftResultReqDto);
                this.controlGiftResultService.modifyTrControlGiftResult(controlGiftResultReqDto);
            });
        }
        this.logger.info("\u3010\u4efb\u52a1\u8c03\u5ea6\u3011\u7ed3\u675f\u6267\u884c\u5904\u7406\u5931\u6548\u8d60\u54c1\u989d\u5ea6\u6263\u51cf\u65f6\u95f4 {}", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)date));
    }

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            this.disabledGiftAmountScheduled(taskMsg.getContent());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

