/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.scheduleds.biz;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.connector.comm.constant.Constants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class BizGrantadvanceGift {
    private final Logger logger = LoggerFactory.getLogger(BizGrantadvanceGift.class);
    @Resource
    private ITaskApi iTaskApi;
    @Value(value="${scheduler.client.gift.grant.appBizCode}")
    private String grantAppBizCode;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;

    public Long createTasks(Date date, Long grantId) {
        TaskAndBizCreateReqDto task = new TaskAndBizCreateReqDto();
        task.setBizName("\u5904\u7406\u8d60\u54c1\u9884\u652f\u989d\u5ea6\u53d1\u653e");
        task.setAppCode(this.appCode);
        task.setBizCode(this.grantAppBizCode);
        task.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ss mm HH dd MM ? yyyy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        task.setScheduleExpression(simpleDateFormat.format(date));
        task.setShardType("SINGLE");
        task.setTenantId(Constants.CONNECTOR_TENANT_ID);
        task.setTaskName("\u5904\u7406\u8d60\u54c1\u9884\u652f\u989d\u5ea6\u53d1\u653e_" + System.currentTimeMillis());
        task.setParams(ObjectUtils.isEmpty((Object)grantId) ? null : grantId.toString());
        task.setTaskCode(String.valueOf(System.currentTimeMillis()));
        this.logger.info("\u3010\u4efb\u52a1\u8c03\u5ea6\u3011\u5f00\u59cb\u521b\u5efa\u5904\u9884\u652f\u53d1\u653e\u8d60\u54c1\u8ba2\u8d27\u989d\u5ea6\uff1a{}", (Object)JSON.toJSONString((Object)task));
        try {
            RestResponse restResponse = this.iTaskApi.addWithBiz(task);
            if (null != restResponse && String.valueOf(0).equals(restResponse.getResultCode())) {
                RequestDto requestDto = new RequestDto();
                requestDto.setInstanceId(Constants.CONNECTOR_INSTANCE_ID);
                requestDto.setTenantId(Constants.CONNECTOR_TENANT_ID);
                this.iTaskApi.enableById((Long)restResponse.getData(), ObjectHelper.bean2Json((Object)requestDto));
            }
            return (Long)restResponse.getData();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

