/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlItemReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlItemCustomerReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlItemOrderReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemCustomerService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemOrderService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlItemService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlItemCustomerDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlItemCustomerEo;
import com.dtyunxi.tcbj.center.control.dao.vo.ControlItemCustomerVo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ControlItemCustomerServiceImpl
implements IControlItemCustomerService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlItemCustomerDas controlItemCustomerDas;
    @Resource
    private IControlItemService controlItemService;
    @Resource
    private IControlItemOrderService controlItemOrderService;

    @Override
    public Long addControlItemCustomer(ControlItemCustomerReqDto addReqDto) {
        ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlItemCustomerEo);
        this.controlItemCustomerDas.insert((BaseEo)controlItemCustomerEo);
        return controlItemCustomerEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int insertBatch(List<ControlItemCustomerReqDto> controlItemCustomerReqDtos) {
        ArrayList addReqDtoList = Lists.newArrayList();
        for (ControlItemCustomerReqDto customerReqDto : controlItemCustomerReqDtos) {
            customerReqDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
            ControlItemOrderReqDto addDto = new ControlItemOrderReqDto();
            addDto.setItemNum(new BigDecimal(customerReqDto.getPurchasedCount()));
            addDto.setRuleItemId(customerReqDto.getId());
            addDto.setTradeNo(customerReqDto.getTradeNo());
            addDto.setRuleRangeType("appoint");
            addReqDtoList.add(addDto);
        }
        ArrayList controlItemCustomerEos = new ArrayList();
        DtoHelper.dtoList2EoList(controlItemCustomerReqDtos, controlItemCustomerEos, ControlItemCustomerEo.class);
        int count = this.controlItemCustomerDas.insertBatch(controlItemCustomerEos);
        this.controlItemOrderService.addControlItemOrderBatch(addReqDtoList);
        return count;
    }

    @Override
    public void addOrderCustomers(List<ControlItemCustomerReqDto> addReqDtoList) {
        if (CollectionUtils.isEmpty(addReqDtoList)) {
            throw ControlExceptionCode.CUSTOMER_EMPTY.getException();
        }
        if (addReqDtoList.get(0).getRuleId() == null) {
            this.logger.error("\u3010\u5355\u54c1\u7ba1\u63a7\u3011ruleId\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(addReqDtoList));
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ArrayList customerList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)customerList, addReqDtoList, ControlItemCustomerEo.class);
        int result = this.controlItemCustomerDas.insertBatch((List)customerList);
        if (result < 0) {
            this.logger.error("\u3010\u5355\u54c1\u7ba1\u63a7\u3011\u6279\u91cf\u65b0\u589e\u5ba2\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString(addReqDtoList));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
    }

    @Override
    public void modifyControlItemCustomer(ControlItemCustomerReqDto modifyReqDto) {
        ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)controlItemCustomerEo);
        this.controlItemCustomerDas.updateSelective((BaseEo)controlItemCustomerEo);
    }

    @Override
    public int modifyPurchasedCount(Integer purchasedCount, Long id) {
        return this.controlItemCustomerDas.updatePurchasedCount(purchasedCount, id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlItemCustomer(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlItemCustomerDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ControlItemCustomerRespDto queryById(Long id) {
        ControlItemCustomerEo controlItemCustomerEo = (ControlItemCustomerEo)this.controlItemCustomerDas.selectByPrimaryKey(id);
        ControlItemCustomerRespDto controlItemCustomerRespDto = new ControlItemCustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)controlItemCustomerEo, (BaseVo)controlItemCustomerRespDto);
        return controlItemCustomerRespDto;
    }

    @Override
    public List<ControlItemCustomerRespDto> queryByRuleId(Long ruleId) {
        ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
        controlItemCustomerEo.setRuleId(ruleId);
        List ControlItemCustomerEoList = this.controlItemCustomerDas.select((BaseEo)controlItemCustomerEo);
        ArrayList<ControlItemCustomerRespDto> controlItemCustomerRespDtoList = new ArrayList<ControlItemCustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)ControlItemCustomerEoList, controlItemCustomerRespDtoList, ControlItemCustomerRespDto.class);
        return controlItemCustomerRespDtoList;
    }

    @Override
    public PageInfo<ControlItemCustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ControlItemCustomerReqDto controlItemCustomerReqDto = (ControlItemCustomerReqDto)JSON.parseObject((String)filter, ControlItemCustomerReqDto.class);
        ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
        DtoHelper.dto2Eo((BaseVo)controlItemCustomerReqDto, (BaseEo)controlItemCustomerEo);
        PageInfo eoPageInfo = this.controlItemCustomerDas.selectPage((BaseEo)controlItemCustomerEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlItemCustomerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void removeCustomerByRuleId(Long ruleId) {
        if (ruleId == null) {
            this.logger.error("\u3010\u5355\u54c1\u7ba1\u63a7\u3011ruleId\u4e0d\u80fd\u4e3a\u7a7a");
            throw ControlExceptionCode.RULE_ID_NOT_EXIT.getException();
        }
        ControlItemCustomerEo pointEo = new ControlItemCustomerEo();
        pointEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        this.controlItemCustomerDas.delete((BaseEo)pointEo);
    }

    @Override
    public List<ControlItemCustomerRespDto> verifyRuleForCustomer(BizControlItemReqDto reqDto) {
        List customerList = reqDto.getCustomerList();
        if (CollectionUtils.isEmpty((Collection)customerList)) {
            return null;
        }
        List customerIdList = customerList.stream().map(ControlItemCustomerReqDto::getCustomerId).distinct().collect(Collectors.toList());
        List itemIdList = customerList.stream().map(ControlItemCustomerReqDto::getItemId).distinct().collect(Collectors.toList());
        ControlItemCustomerVo vo = new ControlItemCustomerVo();
        vo.setEnable(RuleEnableEnum.ENABLE.getValue());
        vo.setCustomerIdList(customerIdList);
        vo.setItemIdList(itemIdList);
        vo.setControlStartDate(reqDto.getControlStartDate());
        List reCustomerList = this.controlItemCustomerDas.selectByCondition(vo);
        Map<Object, List<ControlItemCustomerEo>> existRecustomerGroup = reCustomerList.stream().collect(Collectors.groupingBy(e -> this.buildKey(e.getCustomerId(), e.getItemCode())));
        ArrayList result = Lists.newArrayList();
        for (ControlItemCustomerReqDto itemCustomerReqDto : customerList) {
            List<ControlItemCustomerEo> controlItemCustomerEos = existRecustomerGroup.get(this.buildKey(itemCustomerReqDto.getCustomerId(), itemCustomerReqDto.getItemCode()));
            if (!CollectionUtils.isNotEmpty(controlItemCustomerEos)) continue;
            for (ControlItemCustomerEo itemCustomerEo : controlItemCustomerEos) {
                AssertUtils.notNull((Object)itemCustomerReqDto.getCustomerId(), (String)String.format("\u5ba2\u6237\u4fe1\u606f\uff1a%s,\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a", JSON.toJSONString((Object)itemCustomerReqDto)));
                AssertUtils.notNull((Object)itemCustomerReqDto.getItemId(), (String)String.format("\u5ba2\u6237\u4fe1\u606f\uff1a%s,\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a", JSON.toJSONString((Object)itemCustomerReqDto)));
                if (!itemCustomerReqDto.getCustomerId().equals(itemCustomerEo.getCustomerId()) || !itemCustomerReqDto.getItemCode().equals(itemCustomerEo.getItemCode())) continue;
                ControlItemCustomerRespDto itemCustomerRespDto = new ControlItemCustomerRespDto();
                itemCustomerRespDto.setId(itemCustomerEo.getId());
                itemCustomerRespDto.setCustomerId(itemCustomerEo.getCustomerId());
                itemCustomerRespDto.setCustomerName(itemCustomerEo.getCustomerName());
                itemCustomerRespDto.setItemCode(itemCustomerEo.getItemCode());
                itemCustomerRespDto.setRuleId(itemCustomerEo.getRuleId());
                result.add(itemCustomerRespDto);
            }
        }
        return result;
    }

    private String buildKey(Long customerId, String itemCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(customerId).append('_').append(itemCode);
        return sb.toString();
    }

    @Override
    public List<ControlItemCustomerRespDto> queryByCustomerIds(List<ControlItemCustomerReqDto> customerList) {
        AssertUtils.notEmpty(customerList, (String)"customerList\u4e0d\u80fd\u4e3a\u7a7a");
        ControlItemCustomerEo queryEo = new ControlItemCustomerEo();
        ArrayList filterList = Lists.newArrayList();
        List collect = customerList.stream().map(c -> c.getCustomerId()).collect(Collectors.toList());
        filterList.add(SqlFilter.in((String)"customer_id", collect));
        queryEo.setSqlFilters((List)filterList);
        List itemCustomerEos = this.controlItemCustomerDas.select((BaseEo)queryEo);
        ArrayList customerRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemCustomerEos, (Collection)customerRespDtoList, ControlItemCustomerRespDto.class);
        return customerRespDtoList;
    }

    @Override
    public List<ControlItemCustomerRespDto> queryByItemIds(List<Long> itemList) {
        AssertUtils.notEmpty(itemList, (String)"itemList \u4e0d\u80fd\u4e3a\u7a7a");
        ControlItemCustomerEo queryEo = new ControlItemCustomerEo();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.in((String)"item_id", itemList));
        queryEo.setSqlFilters((List)filterList);
        List itemCustomerEos = this.controlItemCustomerDas.select((BaseEo)queryEo);
        ArrayList customerRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemCustomerEos, (Collection)customerRespDtoList, ControlItemCustomerRespDto.class);
        return customerRespDtoList;
    }

    @Override
    public List<ControlItemCustomerRespDto> queryList(ControlItemCustomerReqDto controlItemCustomerReqDto) {
        ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
        DtoHelper.dto2Eo((BaseVo)controlItemCustomerReqDto, (BaseEo)controlItemCustomerEo);
        List controlItemCustomerEos = this.controlItemCustomerDas.select((BaseEo)controlItemCustomerEo);
        ArrayList<ControlItemCustomerRespDto> controlItemCustomerRespDtos = new ArrayList<ControlItemCustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)controlItemCustomerEos, controlItemCustomerRespDtos, ControlItemCustomerRespDto.class);
        return controlItemCustomerRespDtos;
    }

    @Override
    public List<ControlItemCustomerRespDto> queryItemCustomerByAreaAndItemIds(String areaCode, List<Long> itemIds, Long ruleId) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"area_code", (Object)areaCode));
        sqlFilters.add(SqlFilter.in((String)"item_id", itemIds));
        sqlFilters.add(SqlFilter.eq((String)"enable_area", (Object)RuleEnableEnum.ENABLE.getValue()));
        sqlFilters.add(SqlFilter.eq((String)"rule_id", (Object)ruleId));
        ControlItemCustomerEo controlItemCustomerEo = new ControlItemCustomerEo();
        controlItemCustomerEo.setSqlFilters(sqlFilters);
        List controlItemCustomerEos = this.controlItemCustomerDas.select((BaseEo)controlItemCustomerEo);
        ArrayList<ControlItemCustomerRespDto> controlItemCustomerRespDtos = new ArrayList<ControlItemCustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)controlItemCustomerEos, controlItemCustomerRespDtos, ControlItemCustomerRespDto.class);
        return controlItemCustomerRespDtos;
    }
}

