/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleEnableEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleRangeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlOrderReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlOrderAreaReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlOrderCustomerReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlBaseReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizChangeRuleResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizControlOrderRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderRespDto;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.IControlOrderAreaService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlOrderCustomerService;
import com.dtyunxi.tcbj.center.control.biz.service.IControlOrderService;
import com.dtyunxi.tcbj.center.control.dao.das.ControlOrderAreaDas;
import com.dtyunxi.tcbj.center.control.dao.das.ControlOrderCustomerDas;
import com.dtyunxi.tcbj.center.control.dao.das.ControlOrderRuleDas;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlOrderAreaEo;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlOrderCustomerEo;
import com.dtyunxi.tcbj.center.control.dao.eo.ControlOrderRuleEo;
import com.dtyunxi.tcbj.center.control.dao.mapper.ControlOrderCustomerMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ControlOrderServiceImpl
implements IControlOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ControlOrderRuleDas controlOrderRuleDas;
    @Resource
    private IControlOrderCustomerService orderCustomerService;
    @Resource
    private ControlOrderCustomerDas controlOrderCustomerDas;
    @Resource
    private ControlOrderCustomerMapper controlOrderCustomerMapper;
    @Resource
    private IControlOrderAreaService orderAreaService;
    @Resource
    private ControlOrderAreaDas controlOrderAreaDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizChangeRuleResultRespDto<ControlOrderAreaRespDto, ControlOrderCustomerRespDto, ControlOrderRespDto> addControlOrder(BizControlOrderReqDto addReqDto) {
        BizChangeRuleResultRespDto<ControlOrderAreaRespDto, ControlOrderCustomerRespDto, ControlOrderRespDto> resultRespDto = new BizChangeRuleResultRespDto<ControlOrderAreaRespDto, ControlOrderCustomerRespDto, ControlOrderRespDto>();
        if (RuleEnableEnum.ENABLE.getValue().equals(addReqDto.getEnable()) && (resultRespDto = this.verifyRule(addReqDto)).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            return resultRespDto;
        }
        ControlOrderRuleEo controlOrderRuleEo = new ControlOrderRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)controlOrderRuleEo);
        this.controlOrderRuleDas.insert((BaseEo)controlOrderRuleEo);
        Long ruleId = controlOrderRuleEo.getId();
        if (ruleId == null) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u6dfb\u52a0\u7ba1\u63a7\u89c4\u5219\u5931\u8d25\uff0c\u63d0\u4ea4\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getCustomerList())) {
            this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6307\u5b9a\u5ba2\u6237,\u5ba2\u6237\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)addReqDto.getCustomerList());
            addReqDto.getCustomerList().stream().forEach(c -> {
                c.setRuleId(ruleId);
                c.setEnable(addReqDto.getEnable());
            });
            this.orderCustomerService.addOrderCustomers(addReqDto.getCustomerList());
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getAreaList())) {
            this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6309\u5ba2\u6237\u533a\u57df,\u533a\u57df\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)addReqDto.getAreaList());
            ArrayList areaList = Lists.newArrayList();
            addReqDto.getAreaList().forEach(areaCode -> {
                ControlOrderAreaReqDto controlOrderAreaReqDto = new ControlOrderAreaReqDto();
                controlOrderAreaReqDto.setRuleId(ruleId);
                controlOrderAreaReqDto.setEnable(addReqDto.getEnable());
                controlOrderAreaReqDto.setAreaCode(areaCode);
                areaList.add(controlOrderAreaReqDto);
            });
            this.orderAreaService.addControlAreaList(areaList);
        }
        return resultRespDto;
    }

    private BizChangeRuleResultRespDto<ControlOrderAreaRespDto, ControlOrderCustomerRespDto, ControlOrderRespDto> verifyRule(BizControlOrderReqDto addReqDto) {
        List<ControlOrderAreaRespDto> verifyAreaRespDtos;
        List<Long> CustomerIdcollect;
        List<ControlOrderCustomerRespDto> verifyCustomerRespDtos;
        BizChangeRuleResultRespDto resultRespDto = new BizChangeRuleResultRespDto();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getCustomerList()) && CollectionUtils.isNotEmpty(verifyCustomerRespDtos = this.orderCustomerService.verifyRuleForCustomer(CustomerIdcollect = addReqDto.getCustomerList().stream().map(c -> c.getCustomerId()).collect(Collectors.toList())))) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u89c4\u5219\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u7684\u6307\u5b9a\u5ba2\u6237\uff0c\u91cd\u590d\u7684\u5ba2\u6237\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(verifyCustomerRespDtos));
            List ruleIdLis = verifyCustomerRespDtos.stream().map(ControlOrderCustomerRespDto::getRuleId).distinct().collect(Collectors.toList());
            ControlOrderRuleEo queryEo = new ControlOrderRuleEo();
            if (!ObjectUtils.isEmpty((Object)addReqDto.getId())) {
                ruleIdLis.remove(addReqDto.getId());
            }
            queryEo.setOrgId(addReqDto.getOrgId());
            queryEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", ruleIdLis)}));
            ArrayList orderRuleList = ObjectUtils.isEmpty(ruleIdLis) ? Lists.newArrayList() : this.controlOrderRuleDas.select((BaseEo)queryEo);
            List orderRuleEos = Optional.ofNullable(orderRuleList).orElseGet(Collections::emptyList).stream().filter(rule -> rule.getControlEndDate().compareTo(addReqDto.getControlStartDate()) >= 0).collect(Collectors.toList());
            ArrayList conflictOrderRuleList = Lists.newArrayList();
            DtoHelper.eoList2DtoList(orderRuleEos, (Collection)conflictOrderRuleList, ControlOrderRespDto.class);
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u76f8\u4e92\u51b2\u7a81\u7684\u8ba2\u5355\u7ba1\u63a7\u89c4\u5219\u6709\uff1a{}", (Object)JSON.toJSONString((Object)conflictOrderRuleList));
            if (CollectionUtils.isNotEmpty(orderRuleEos)) {
                resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                List conflictRuleIdList = orderRuleEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                List conflictCustomerList = verifyCustomerRespDtos.stream().filter(verifyCustomer -> conflictRuleIdList.contains(verifyCustomer.getRuleId())).collect(Collectors.toList());
                resultRespDto.setConflictRuleList((List)conflictOrderRuleList);
                resultRespDto.setCustomerList(conflictCustomerList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getAreaList()) && CollectionUtils.isNotEmpty(verifyAreaRespDtos = this.orderAreaService.verifyRuleForArea(addReqDto.getAreaList()))) {
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u89c4\u5219\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5b58\u5728\u91cd\u590d\u7684\u5ba2\u6237\u533a\u57df\uff0c\u91cd\u590d\u7684\u5ba2\u6237\u533a\u57df\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(verifyAreaRespDtos));
            List ruleIdLis = verifyAreaRespDtos.stream().map(ControlOrderAreaRespDto::getRuleId).distinct().collect(Collectors.toList());
            ControlOrderRuleEo queryEo = new ControlOrderRuleEo();
            if (!ObjectUtils.isEmpty((Object)addReqDto.getId())) {
                ruleIdLis.remove(addReqDto.getId());
            }
            queryEo.setOrgId(addReqDto.getOrgId());
            queryEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"id", ruleIdLis)}));
            ArrayList orderRuleList = ObjectUtils.isEmpty(ruleIdLis) ? Lists.newArrayList() : this.controlOrderRuleDas.select((BaseEo)queryEo);
            List orderRuleEos = Optional.ofNullable(orderRuleList).orElseGet(Collections::emptyList).stream().filter(rule -> rule.getControlEndDate().compareTo(addReqDto.getControlStartDate()) >= 0).collect(Collectors.toList());
            ArrayList conflictOrderRuleList = Lists.newArrayList();
            DtoHelper.eoList2DtoList(orderRuleEos, (Collection)conflictOrderRuleList, ControlOrderRespDto.class);
            this.logger.error("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u76f8\u4e92\u51b2\u7a81\u7684\u8ba2\u5355\u7ba1\u63a7\u89c4\u5219\u6709\uff1a{}", (Object)JSON.toJSONString((Object)conflictOrderRuleList));
            if (CollectionUtils.isNotEmpty(orderRuleEos)) {
                resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                List conflictRuleIdList = orderRuleEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                List conflictAreaList = verifyAreaRespDtos.stream().filter(verifyArea -> conflictRuleIdList.contains(verifyArea.getRuleId())).collect(Collectors.toList());
                resultRespDto.setConflictRuleList((List)conflictOrderRuleList);
                resultRespDto.setAreaList(conflictAreaList);
            }
        }
        if (addReqDto.getRuleRangeType().equals(RuleRangeTypeEnum.ALL.getType())) {
            List orderRuleList;
            List orderRuleEos;
            ControlOrderRuleEo queryEo = new ControlOrderRuleEo();
            queryEo.setEnable(RuleEnableEnum.ENABLE.getValue());
            queryEo.setRuleRangeType(RuleRangeTypeEnum.ALL.getType());
            queryEo.setOrgId(addReqDto.getOrgId());
            if (!ObjectUtils.isEmpty((Object)addReqDto.getId())) {
                queryEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.ne((String)"id", (Object)addReqDto.getId())}));
            }
            if (CollectionUtils.isNotEmpty(orderRuleEos = Optional.ofNullable(orderRuleList = this.controlOrderRuleDas.select((BaseEo)queryEo)).orElseGet(Collections::emptyList).stream().filter(rule -> rule.getControlEndDate().compareTo(addReqDto.getControlStartDate()) >= 0).collect(Collectors.toList()))) {
                resultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                ArrayList conflictOrderRuleList = Lists.newArrayList();
                DtoHelper.eoList2DtoList(orderRuleEos, (Collection)conflictOrderRuleList, ControlOrderRespDto.class);
                resultRespDto.setConflictRuleList((List)conflictOrderRuleList);
            }
        }
        return resultRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizChangeRuleResultRespDto<ControlOrderAreaRespDto, ControlOrderCustomerRespDto, ControlOrderRespDto> modifyControlOrder(BizControlOrderReqDto modifyReqDto) {
        this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u4fee\u6539\u8ba2\u5355\u7ba1\u63a7\u89c4\u5219");
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"\u8ba2\u5355\u7ba1\u63a7\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        BizChangeRuleResultRespDto<ControlOrderAreaRespDto, ControlOrderCustomerRespDto, ControlOrderRespDto> resultRespDto = new BizChangeRuleResultRespDto<ControlOrderAreaRespDto, ControlOrderCustomerRespDto, ControlOrderRespDto>();
        if (RuleEnableEnum.ENABLE.getValue().equals(modifyReqDto.getEnable()) && (resultRespDto = this.verifyRule(modifyReqDto)).getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            return resultRespDto;
        }
        ControlOrderRuleEo updateOrderRuleEo = new ControlOrderRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)updateOrderRuleEo);
        this.controlOrderRuleDas.updateSelective((BaseEo)updateOrderRuleEo);
        Long ruleId = modifyReqDto.getId();
        this.orderCustomerService.removeCustomerByRuleId(ruleId);
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getCustomerList())) {
            this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u4fee\u6539\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6307\u5b9a\u5ba2\u6237,\u5ba2\u6237\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)modifyReqDto.getCustomerList());
            modifyReqDto.getCustomerList().stream().forEach(c -> {
                c.setRuleId(ruleId);
                c.setEnable(modifyReqDto.getEnable());
            });
            this.orderCustomerService.addOrderCustomers(modifyReqDto.getCustomerList());
        }
        this.orderAreaService.removeControlAreaByRuleId(ruleId);
        if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getAreaList())) {
            this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u4fee\u6539\u5173\u8054\u5ba2\u6237\u7c7b\u578b\u4e3a\u6309\u5ba2\u6237\u533a\u57df,\u533a\u57df\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)modifyReqDto.getAreaList());
            ArrayList areaList = Lists.newArrayList();
            modifyReqDto.getAreaList().forEach(areaCode -> {
                ControlOrderAreaReqDto controlOrderAreaReqDto = new ControlOrderAreaReqDto();
                controlOrderAreaReqDto.setRuleId(ruleId);
                controlOrderAreaReqDto.setEnable(modifyReqDto.getEnable());
                controlOrderAreaReqDto.setAreaCode(areaCode);
                areaList.add(controlOrderAreaReqDto);
            });
            this.orderAreaService.addControlAreaList(areaList);
        }
        return resultRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeControlOrder(String ids, Long OrgId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.controlOrderRuleDas.logicDeleteById(Long.valueOf(id));
            this.orderCustomerService.removeCustomerByRuleId(Long.valueOf(id));
            this.orderAreaService.removeControlAreaByRuleId(Long.valueOf(id));
        }
    }

    @Override
    public BizControlOrderRespDto queryById(Long id) {
        AssertUtils.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ControlOrderRuleEo controlOrderRuleEo = (ControlOrderRuleEo)this.controlOrderRuleDas.selectByPrimaryKey(id);
        if (ObjectUtils.isEmpty((Object)controlOrderRuleEo)) {
            return null;
        }
        BizControlOrderRespDto controlOrderRuleRespDto = new BizControlOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)controlOrderRuleEo, (BaseVo)controlOrderRuleRespDto);
        if (controlOrderRuleRespDto.getRuleRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType())) {
            controlOrderRuleRespDto.setCustomerList(this.orderCustomerService.queryCustomerByRuleId(controlOrderRuleRespDto.getId()));
        }
        if (controlOrderRuleRespDto.getRuleRangeType().equals(RuleRangeTypeEnum.AREA.getType())) {
            controlOrderRuleRespDto.setAreaList(this.orderAreaService.queryAreaByRuleId(controlOrderRuleRespDto.getId()));
        }
        return controlOrderRuleRespDto;
    }

    @Override
    public PageInfo<ControlOrderRespDto> queryByPage(String filter, Long orgId, Integer pageNum, Integer pageSize) {
        BizControlOrderReqDto controlOrderReqDto = (BizControlOrderReqDto)JSON.parseObject((String)filter, BizControlOrderReqDto.class);
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)controlOrderReqDto)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlOrderReqDto.getCustomerKeyword()})) {
                List controlOrderCustomerByCustomerAndRuleId = this.controlOrderCustomerMapper.getControlOrderCustomerByCustomerAndRuleId(controlOrderReqDto.getCustomerKeyword(), controlOrderReqDto.getCustomerKeyword());
                if (ObjectUtils.isEmpty((Object)controlOrderCustomerByCustomerAndRuleId)) {
                    dtoPageInfo.setPageNum(pageNum.intValue());
                    dtoPageInfo.setPageSize(pageSize.intValue());
                    return dtoPageInfo;
                }
                sqlFilterList.add(SqlFilter.in((String)"id", (Object)controlOrderCustomerByCustomerAndRuleId));
            }
            if (null != controlOrderReqDto.getEnable()) {
                RuleEnableEnum enableEnum = RuleEnableEnum.enumOf((Integer)controlOrderReqDto.getEnable());
                sqlFilterList.add(SqlFilter.eq((String)"enable", (Object)enableEnum.getValue()));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{controlOrderReqDto.getRuleName()})) {
                sqlFilterList.add(SqlFilter.like((String)"rule_name", (Object)controlOrderReqDto.getRuleName()));
            }
            if (StringUtils.isNotBlank((CharSequence)controlOrderReqDto.getRuleRangeType())) {
                RuleRangeTypeEnum ruleRangeTypeEnum = RuleRangeTypeEnum.enumOf((String)controlOrderReqDto.getRuleRangeType());
                sqlFilterList.add(SqlFilter.eq((String)"rule_range_type", (Object)ruleRangeTypeEnum.getType()));
            }
        }
        this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u3010\u5206\u9875\u67e5\u8be2\u8ba2\u5355\u7ba1\u63a7\u89c4\u5219\u5217\u8868\u3011\u67e5\u8be2\u7684\u6761\u4ef6\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sqlFilterList));
        ControlOrderRuleEo controlOrderRuleEo = new ControlOrderRuleEo();
        controlOrderRuleEo.setOrgId(orgId);
        controlOrderRuleEo.setSqlFilters((List)sqlFilterList);
        controlOrderRuleEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.controlOrderRuleDas.selectPage((BaseEo)controlOrderRuleEo, pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ControlOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public BizChangeRuleResultRespDto setEnable(Long ruleId, Integer enableStatus, Long orgId) {
        AssertUtils.notNull((Object)ruleId, (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        RuleEnableEnum enableEnum = RuleEnableEnum.enumOf((Integer)enableStatus);
        BizChangeRuleResultRespDto<ControlOrderAreaRespDto, ControlOrderCustomerRespDto, ControlOrderRespDto> resultRespDto = new BizChangeRuleResultRespDto<ControlOrderAreaRespDto, ControlOrderCustomerRespDto, ControlOrderRespDto>();
        ControlOrderRuleEo queryEo = new ControlOrderRuleEo();
        queryEo.setId(ruleId);
        ControlOrderRuleEo orderRuleEo = (ControlOrderRuleEo)this.controlOrderRuleDas.selectOne((BaseEo)queryEo);
        AssertUtils.notNull((Object)orderRuleEo, (String)"\u8be5\u89c4\u5219\u4e0d\u5b58\u5728\uff01");
        if (RuleEnableEnum.ENABLE.equals((Object)enableEnum)) {
            BizControlOrderReqDto modifyReqDto = new BizControlOrderReqDto();
            CubeBeanUtils.copyProperties((Object)modifyReqDto, (Object)orderRuleEo, (String[])new String[0]);
            if (RuleRangeTypeEnum.CUSTOMER.getType().equals(orderRuleEo.getRuleRangeType())) {
                ControlOrderCustomerEo controlOrderCustomerEo = new ControlOrderCustomerEo();
                controlOrderCustomerEo.setRuleId(ruleId);
                List controlOrderCustomerEoList = this.controlOrderCustomerDas.select((BaseEo)controlOrderCustomerEo);
                ArrayList controlOrderCustomerReqDtoList = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)controlOrderCustomerEoList, (Collection)controlOrderCustomerReqDtoList, ControlOrderCustomerReqDto.class);
                modifyReqDto.setCustomerList((List)controlOrderCustomerReqDtoList);
            }
            if (RuleRangeTypeEnum.AREA.getType().equals(orderRuleEo.getRuleRangeType())) {
                ControlOrderAreaEo controlOrderAreaEo = new ControlOrderAreaEo();
                controlOrderAreaEo.setRuleId(ruleId);
                List controlOrderAreaEoList = this.controlOrderAreaDas.select((BaseEo)controlOrderAreaEo);
                modifyReqDto.setAreaList(controlOrderAreaEoList.stream().map(c -> c.getAreaCode()).collect(Collectors.toList()));
            }
            modifyReqDto.setOrgId(orgId);
            resultRespDto = this.verifyRule(modifyReqDto);
            if (resultRespDto.getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
                return resultRespDto;
            }
        }
        orderRuleEo.setEnable(enableStatus);
        this.controlOrderRuleDas.updateSelective((BaseEo)orderRuleEo);
        if (RuleRangeTypeEnum.CUSTOMER.getType().equals(orderRuleEo.getRuleRangeType())) {
            ControlOrderCustomerEo controlOrderCustomerEo = new ControlOrderCustomerEo();
            controlOrderCustomerEo.setEnable(enableStatus);
            controlOrderCustomerEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
            this.controlOrderCustomerDas.updateSelectiveSqlFilter((BaseEo)controlOrderCustomerEo);
        }
        if (RuleRangeTypeEnum.AREA.getType().equals(orderRuleEo.getRuleRangeType())) {
            ControlOrderAreaEo controlOrderAreaEo = new ControlOrderAreaEo();
            controlOrderAreaEo.setEnable(enableStatus);
            controlOrderAreaEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
            this.controlOrderAreaDas.updateSelective((BaseEo)controlOrderAreaEo);
        }
        return resultRespDto;
    }

    @Override
    public ControlOrderRespDto queryRuleByCustomer(CustomerControlBaseReqDto baseReqDto) {
        ControlOrderRuleEo queryEo;
        List<ControlOrderAreaRespDto> areaRespDtoList;
        Long customerId = baseReqDto.getCustomerId();
        List customerAreaCodeList = baseReqDto.getCustomerAreaCodeList();
        AssertUtils.notNull((Object)customerId, (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)baseReqDto.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<ControlOrderCustomerRespDto> customerRespDtoList = this.orderCustomerService.queryOrderCustomerByCustomerId(customerId);
        Long ruleId = null;
        if (CollectionUtils.isNotEmpty(customerRespDtoList)) {
            if (customerRespDtoList.size() > 0) {
                this.logger.warn("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u3010\u4f7f\u7528\u6307\u5b9a\u5ba2\u6237\u89c4\u5219\u3011\u5f53\u524d\u7684\u7ba1\u63a7\u89c4\u5219\u8bbe\u7f6e\u53ef\u80fd\u6709\u95ee\u9898\uff0c\u7ba1\u63a7\u7684\u89c4\u5219\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(customerRespDtoList));
            }
            this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u5f53\u524d\u5ba2\u6237(customerId={})\u4f7f\u7528\u7684\u662f\u6307\u5b9a\u5ba2\u6237\u89c4\u5219", (Object)customerId);
            ControlOrderCustomerRespDto customerRespDto = customerRespDtoList.get(0);
            ruleId = customerRespDto.getRuleId();
        } else if (CollectionUtils.isNotEmpty((Collection)customerAreaCodeList) && CollectionUtils.isNotEmpty(areaRespDtoList = this.orderAreaService.queryAreaByAreaList(customerAreaCodeList))) {
            if (areaRespDtoList.size() > 0) {
                this.logger.warn("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u3010\u4f7f\u7528\u6307\u5b9a\u5ba2\u6237\u533a\u57df\u89c4\u5219\u3011\u5f53\u524d\u7684\u7ba1\u63a7\u89c4\u5219\u8bbe\u7f6e\u53ef\u80fd\u6709\u95ee\u9898\uff0c\u7ba1\u63a7\u7684\u89c4\u5219\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(areaRespDtoList));
            }
            this.logger.info("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u5f53\u524d\u5ba2\u6237(customerId={})\u4f7f\u7528\u7684\u662f\u6307\u5b9a\u5ba2\u6237\u533a\u57df\u89c4\u5219", (Object)customerId);
            ruleId = areaRespDtoList.get(0).getRuleId();
        }
        if (ruleId != null) {
            queryEo = new ControlOrderRuleEo();
            queryEo.setId(ruleId);
            ControlOrderRuleEo controlOrderRuleEo = (ControlOrderRuleEo)this.controlOrderRuleDas.selectOne((BaseEo)queryEo);
            AssertUtils.notNull((Object)controlOrderRuleEo, (String)String.format("(id=%s)\u7ba1\u63a7\u89c4\u5219\u4e0d\u5b58\u5728\uff01", ruleId));
            BizControlOrderRespDto orderRespDt = new BizControlOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)controlOrderRuleEo, (BaseVo)orderRespDt);
            return orderRespDt;
        }
        queryEo = new ControlOrderRuleEo();
        Date nowDate = new Date();
        ArrayList filterList = Lists.newArrayList();
        filterList.add(SqlFilter.eq((String)"enable", (Object)RuleEnableEnum.ENABLE.getValue()));
        filterList.add(SqlFilter.eq((String)"rule_range_type", (Object)RuleRangeTypeEnum.ALL.getType()));
        filterList.add(SqlFilter.ge((String)"control_end_date", (Object)nowDate));
        filterList.add(SqlFilter.le((String)"control_start_date", (Object)nowDate));
        filterList.add(SqlFilter.eq((String)"org_id", (Object)baseReqDto.getOrgId()));
        queryEo.setSqlFilters((List)filterList);
        List ruleEoList = this.controlOrderRuleDas.select((BaseEo)queryEo);
        if (ruleEoList.size() > 0) {
            this.logger.warn("\u3010\u8ba2\u5355\u7ba1\u63a7\u3011\u3010\u4f7f\u7528\u5168\u90e8\u89c4\u5219\u3011\u5f53\u524d\u7684\u7ba1\u63a7\u89c4\u5219\u8bbe\u7f6e\u53ef\u80fd\u6709\u95ee\u9898\uff0c\u7ba1\u63a7\u7684\u89c4\u5219\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)ruleEoList));
        }
        if (CollectionUtils.isNotEmpty((Collection)ruleEoList)) {
            ControlOrderRuleEo controlOrderRuleEo = (ControlOrderRuleEo)ruleEoList.get(0);
            BizControlOrderRespDto orderRespDto = new BizControlOrderRespDto();
            DtoHelper.eo2Dto((BaseEo)controlOrderRuleEo, (BaseVo)orderRespDto);
            return orderRespDto;
        }
        return null;
    }

    @Override
    public List<ControlOrderRuleEo> queryRuleRuleByEnable(Integer status, Date date) {
        ControlOrderRuleEo controlOrderRuleEo = new ControlOrderRuleEo();
        controlOrderRuleEo.setEnable(status);
        controlOrderRuleEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.le((String)"control_end_date", (Object)date)}));
        return this.controlOrderRuleDas.selectList((BaseEo)controlOrderRuleEo);
    }

    @Override
    public void modifyRuleEnable(Long ruleId, Integer enable) {
        ControlOrderRuleEo controlOrderRuleEo = new ControlOrderRuleEo();
        controlOrderRuleEo.setId(ruleId);
        controlOrderRuleEo.setEnable(enable);
        int ruleResult = this.controlOrderRuleDas.updateSelective((BaseEo)controlOrderRuleEo);
        if (ruleResult < 0) {
            throw ControlExceptionCode.MODIFY_FAIL.getException();
        }
        ControlOrderCustomerEo controlOrderCustomerEo = new ControlOrderCustomerEo();
        controlOrderCustomerEo.setEnable(enable);
        controlOrderCustomerEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        int customerResult = this.controlOrderCustomerDas.updateSelectiveSqlFilter((BaseEo)controlOrderCustomerEo);
        if (customerResult < 0) {
            throw ControlExceptionCode.MODIFY_FAIL.getException();
        }
        ControlOrderAreaEo controlOrderAreaEo = new ControlOrderAreaEo();
        controlOrderAreaEo.setEnable(enable);
        controlOrderAreaEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"rule_id", (Object)ruleId)}));
        int areaResult = this.controlOrderAreaDas.updateSelectiveSqlFilter((BaseEo)controlOrderAreaEo);
        if (areaResult < 0) {
            throw ControlExceptionCode.MODIFY_FAIL.getException();
        }
    }
}

