/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountGrantIsReturnEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountGrantStatus;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountGrantTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountType;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountWayEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.ImportItemAmountReason;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleRangeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlGiftResultReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizImportDataReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftGrantRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizContolGiftRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizControlGiftGrantRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizImportRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftGrantRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftGrantRecordExportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftGrantRecordImportVo;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.biz.scheduleds.biz.BizGrantBackGift;
import com.dtyunxi.tcbj.center.control.biz.scheduleds.biz.BizGrantadvanceGift;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftGrantRecordService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftResultService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftRuleService;
import com.dtyunxi.tcbj.center.control.biz.service.impl.TrControlGiftResultServiceImpl;
import com.dtyunxi.tcbj.center.control.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftGrantRecordDas;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftGrantRecordEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrControlGiftGrantRecordServiceImpl
implements ITrControlGiftGrantRecordService {
    private static Logger logger = LoggerFactory.getLogger(TrControlGiftResultServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private TrControlGiftGrantRecordDas trControlGiftGrantRecordDas;
    @Resource
    private ITrControlGiftRuleService controlGiftRuleService;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private ITrControlGiftResultService trControlGiftResultService;
    @Resource
    private BizGrantBackGift bizGrantBackGift;
    @Resource
    private BizGrantadvanceGift bizGrantadvanceGift;
    @Resource
    private ITaskApi iTaskApi;
    @Resource
    private TrControlGiftGrantRecordServiceImpl controlGiftGrantRecordService;

    @Override
    public BizControlGiftGrantRespDto addTrControlGiftGrantRecord(TrControlGiftGrantRecordReqDto addReqDto) {
        Long tasks;
        BizControlGiftGrantRespDto bizControlGiftGrantRespDto = this.verifyGrantAmount(addReqDto);
        if (bizControlGiftGrantRespDto.getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            return bizControlGiftGrantRespDto;
        }
        TrControlGiftGrantRecordEo trControlGiftGrantRecordEo = new TrControlGiftGrantRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)trControlGiftGrantRecordEo);
        trControlGiftGrantRecordEo.setGrantNo(TradeUtil.generateGiftGrantNo(trControlGiftGrantRecordEo.getAmountType()));
        trControlGiftGrantRecordEo.setAdvanceTime(new Date());
        this.valuationGiftGrantStatus(trControlGiftGrantRecordEo);
        if (GiftAmountGrantTypeEnum.TIMING.getType().equals(trControlGiftGrantRecordEo.getGrantType())) {
            tasks = this.bizGrantadvanceGift.createTasks(trControlGiftGrantRecordEo.getGrantTime(), trControlGiftGrantRecordEo.getId());
            trControlGiftGrantRecordEo.setSchedulerGrantId(tasks);
            logger.info("\u3010\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u3011\u53d1\u653e\u5173\u8054\u8c03\u5ea6\u4efb\u52a1id\uff1a{}", (Object)tasks);
        } else {
            BizControlGiftResultReqDto bizControlGiftResultReqDto = new BizControlGiftResultReqDto(trControlGiftGrantRecordEo.getRuleId(), trControlGiftGrantRecordEo.getCustomerCode(), trControlGiftGrantRecordEo.getCustomerName(), trControlGiftGrantRecordEo.getOrgId(), trControlGiftGrantRecordEo.getAdvanceAmount(), trControlGiftGrantRecordEo.getAmountType(), trControlGiftGrantRecordEo.getGrantNo(), GiftAmountWayEnum.WAY_08.getType(), null);
            this.trControlGiftResultService.modifyBillData(bizControlGiftResultReqDto);
            trControlGiftGrantRecordEo.setGrantTime(new Date());
        }
        if (GiftAmountGrantIsReturnEnum.NEED.getType().equals(trControlGiftGrantRecordEo.getIsReturn())) {
            tasks = this.bizGrantBackGift.createTasks(trControlGiftGrantRecordEo.getReturnTime(), trControlGiftGrantRecordEo.getId());
            trControlGiftGrantRecordEo.setSchedulerBackId(tasks);
            logger.info("\u3010\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u3011\u56de\u6536\u5173\u8054\u8c03\u5ea6\u4efb\u52a1id\uff1a{}", (Object)tasks);
        }
        this.trControlGiftGrantRecordDas.insert((BaseEo)trControlGiftGrantRecordEo);
        return bizControlGiftGrantRespDto;
    }

    public BizControlGiftGrantRespDto verifyGrantAmount(TrControlGiftGrantRecordReqDto addReqDto) {
        logger.info("\u3010\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u3011\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u6821\u9a8c\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        BizControlGiftGrantRespDto bizControlGiftGrantRespDto = new BizControlGiftGrantRespDto();
        BizContolGiftRespDto bizContolGiftRespDto = this.controlGiftRuleService.queryById(addReqDto.getRuleId());
        logger.info("\u3010\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u3011\u5f53\u524d\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u89c4\u5219\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)bizContolGiftRespDto));
        String customerCode = addReqDto.getCustomerCode();
        if (!CollectionUtils.isEmpty((Collection)bizContolGiftRespDto.getBlackList()) && bizContolGiftRespDto.getBlackList().stream().filter(c -> c.getCustomerCode().equals(customerCode)).count() > 0L) {
            bizControlGiftGrantRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
            bizControlGiftGrantRespDto.setBlackList(bizContolGiftRespDto.getBlackList());
        }
        if (bizContolGiftRespDto.getRuleRangeType().equals(RuleRangeTypeEnum.CUSTOMER.getType()) && !CollectionUtils.isEmpty((Collection)bizContolGiftRespDto.getCustomerList()) && bizContolGiftRespDto.getCustomerList().stream().filter(c -> c.getCustomerCode().equals(customerCode)).count() <= 0L) {
            bizControlGiftGrantRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
            bizControlGiftGrantRespDto.setCustomerList(bizContolGiftRespDto.getCustomerList());
        }
        if (bizContolGiftRespDto.getRuleRangeType().equals(RuleRangeTypeEnum.AREA.getType()) && !CollectionUtils.isEmpty((Collection)bizContolGiftRespDto.getAreaList())) {
            CustomerRespDto customerRespDto = (CustomerRespDto)this.iCustomerQueryApi.queryByCode(customerCode).getData();
            AssertUtils.notNull((Object)customerRespDto, (String)"\u5f53\u524d\u63d0\u4ea4\u5ba2\u6237\u4e0d\u5b58\u5728\uff01\uff01");
            CustomerRespDto data = (CustomerRespDto)this.iCustomerQueryApi.queryById(customerRespDto.getId()).getData();
            AssertUtils.notEmpty((Collection)data.getRegionCodeList(), (String)"\u5f53\u524d\u5ba2\u6237\u6682\u65e0\u6240\u5c5e\u533a\u57df\uff01\uff01");
            String areaCode = (String)data.getRegionCodeList().stream().findFirst().get();
            if (!bizContolGiftRespDto.getAreaList().contains(areaCode)) {
                bizControlGiftGrantRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                bizControlGiftGrantRespDto.setAreaCodeList(bizContolGiftRespDto.getAreaList());
            }
        }
        return bizControlGiftGrantRespDto;
    }

    public void valuationGiftGrantStatus(TrControlGiftGrantRecordEo trControlGiftGrantRecordEo) {
        if (GiftAmountGrantTypeEnum.TIMING.getType().equals(trControlGiftGrantRecordEo.getGrantType())) {
            trControlGiftGrantRecordEo.setStatus(GiftAmountGrantStatus.PENDING_SEND.getType());
        }
        if (GiftAmountGrantIsReturnEnum.NEED.getType().equals(trControlGiftGrantRecordEo.getIsReturn())) {
            trControlGiftGrantRecordEo.setStatus(ObjectUtils.isEmpty((Object)trControlGiftGrantRecordEo.getStatus()) ? GiftAmountGrantStatus.PENDING_RETURN.getType() : trControlGiftGrantRecordEo.getStatus());
        } else {
            trControlGiftGrantRecordEo.setStatus(ObjectUtils.isEmpty((Object)trControlGiftGrantRecordEo.getStatus()) ? GiftAmountGrantStatus.NOT_NEED.getType() : trControlGiftGrantRecordEo.getStatus());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyTrControlGiftGrantRecord(TrControlGiftGrantRecordReqDto modifyReqDto) {
        TrControlGiftGrantRecordEo trControlGiftGrantRecordEo = new TrControlGiftGrantRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)trControlGiftGrantRecordEo);
        this.trControlGiftGrantRecordDas.updateSelective((BaseEo)trControlGiftGrantRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTrControlGiftGrantRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            TrControlGiftGrantRecordEo controlGiftGrantRecordEo = (TrControlGiftGrantRecordEo)this.trControlGiftGrantRecordDas.selectByPrimaryKey(Long.valueOf(id));
            if (controlGiftGrantRecordEo.getGrantTime().compareTo(new Date()) <= 0) continue;
            this.trControlGiftGrantRecordDas.logicDeleteById(Long.valueOf(id));
            if (!ObjectUtils.isEmpty((Object)controlGiftGrantRecordEo.getSchedulerGrantId())) {
                RestResponse voidRestResponse = this.iTaskApi.disableById(controlGiftGrantRecordEo.getSchedulerGrantId(), "");
                logger.info("\u3010\u5220\u9664\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u3011\u505c\u7528\u8c03\u5ea6\u4efb\u52a1\uff0c\u8c03\u5ea6\u4e2d\u5fc3\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)voidRestResponse));
            }
            if (ObjectUtils.isEmpty((Object)controlGiftGrantRecordEo.getSchedulerBackId())) continue;
            RestResponse voidRestResponse1 = this.iTaskApi.disableById(controlGiftGrantRecordEo.getSchedulerBackId(), "");
            logger.info("\u3010\u5220\u9664\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u3011\u505c\u7528\u8c03\u5ea6\u4efb\u52a1\uff0c\u8c03\u5ea6\u4e2d\u5fc3\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)voidRestResponse1));
        }
    }

    @Override
    public TrControlGiftGrantRecordRespDto queryById(Long id) {
        TrControlGiftGrantRecordEo trControlGiftGrantRecordEo = (TrControlGiftGrantRecordEo)this.trControlGiftGrantRecordDas.selectByPrimaryKey(id);
        TrControlGiftGrantRecordRespDto trControlGiftGrantRecordRespDto = new TrControlGiftGrantRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)trControlGiftGrantRecordEo, (BaseVo)trControlGiftGrantRecordRespDto);
        return trControlGiftGrantRecordRespDto;
    }

    @Override
    public PageInfo<TrControlGiftGrantRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TrControlGiftGrantRecordReqDto trControlGiftGrantRecordReqDto = (TrControlGiftGrantRecordReqDto)JSON.parseObject((String)filter, TrControlGiftGrantRecordReqDto.class);
        TrControlGiftGrantRecordEo trControlGiftGrantRecordEo = new TrControlGiftGrantRecordEo();
        DtoHelper.dto2Eo((BaseVo)trControlGiftGrantRecordReqDto, (BaseEo)trControlGiftGrantRecordEo, (String[])new String[]{"customerCode", "customerName", "grantNo"});
        AssertUtils.notNull((Object)trControlGiftGrantRecordEo.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ArrayList sqlFilters = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)trControlGiftGrantRecordReqDto.getAdvanceStartTime())) {
            sqlFilters.add(SqlFilter.ge((String)"advance_time", (Object)trControlGiftGrantRecordReqDto.getAdvanceStartTime()));
        }
        if (!ObjectUtils.isEmpty((Object)trControlGiftGrantRecordReqDto.getAdvanceEndTime())) {
            sqlFilters.add(SqlFilter.le((String)"advance_time", (Object)trControlGiftGrantRecordReqDto.getAdvanceEndTime()));
        }
        if (!ObjectUtils.isEmpty((Object)trControlGiftGrantRecordReqDto.getGrantStartTime())) {
            sqlFilters.add(SqlFilter.ge((String)"grant_time", (Object)trControlGiftGrantRecordReqDto.getGrantStartTime()));
        }
        if (!ObjectUtils.isEmpty((Object)trControlGiftGrantRecordReqDto.getGrantEndTime())) {
            sqlFilters.add(SqlFilter.le((String)"grant_time", (Object)trControlGiftGrantRecordReqDto.getGrantEndTime()));
        }
        if (!ObjectUtils.isEmpty((Object)trControlGiftGrantRecordReqDto.getReturnStartTime())) {
            sqlFilters.add(SqlFilter.ge((String)"return_time", (Object)trControlGiftGrantRecordReqDto.getReturnStartTime()));
        }
        if (!ObjectUtils.isEmpty((Object)trControlGiftGrantRecordReqDto.getReturnEndTime())) {
            sqlFilters.add(SqlFilter.le((String)"return_time", (Object)trControlGiftGrantRecordReqDto.getReturnEndTime()));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftGrantRecordReqDto.getCustomerCode())) {
            sqlFilters.add(SqlFilter.like((String)"customer_code", (Object)trControlGiftGrantRecordReqDto.getCustomerCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftGrantRecordReqDto.getCustomerName())) {
            sqlFilters.add(SqlFilter.like((String)"customer_name", (Object)trControlGiftGrantRecordReqDto.getCustomerName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftGrantRecordReqDto.getGrantNo())) {
            sqlFilters.add(SqlFilter.like((String)"grant_no", (Object)trControlGiftGrantRecordReqDto.getGrantNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftGrantRecordReqDto.getRuleIdLike())) {
            sqlFilters.add(SqlFilter.like((String)"rule_id", (Object)trControlGiftGrantRecordReqDto.getRuleIdLike()));
        }
        trControlGiftGrantRecordEo.setSqlFilters((List)sqlFilters);
        trControlGiftGrantRecordEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.trControlGiftGrantRecordDas.selectPage((BaseEo)trControlGiftGrantRecordEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TrControlGiftGrantRecordRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<GiftGrantRecordExportVo> exportGiftGrantRecord(Long orgId) {
        TrControlGiftGrantRecordEo controlGiftGrantRecordEo = new TrControlGiftGrantRecordEo();
        controlGiftGrantRecordEo.setOrgId(orgId);
        List controlGiftGrantRecordEos = this.trControlGiftGrantRecordDas.select((BaseEo)controlGiftGrantRecordEo);
        if (CollectionUtils.isEmpty((Collection)controlGiftGrantRecordEos)) {
            return null;
        }
        ArrayList giftGrantRecordExportVos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)controlGiftGrantRecordEos, (Collection)giftGrantRecordExportVos, GiftGrantRecordExportVo.class);
        Map<String, List<TrControlGiftGrantRecordEo>> collect = controlGiftGrantRecordEos.stream().collect(Collectors.groupingBy(c -> c.getGrantNo()));
        giftGrantRecordExportVos.forEach(c -> {
            List orDefault = collect.getOrDefault(c.getGrantNo(), Lists.newArrayList());
            TrControlGiftGrantRecordEo giftResultEo = (TrControlGiftGrantRecordEo)orDefault.stream().findFirst().get();
            c.setAmountType(GiftAmountType.enumOf((Integer)giftResultEo.getAmountType()).getDesc());
            c.setIsReturn(GiftAmountGrantIsReturnEnum.enumOf((Integer)giftResultEo.getIsReturn()).getDesc());
            c.setStatus(GiftAmountGrantStatus.enumOf((Integer)giftResultEo.getStatus()).getDesc());
        });
        return giftGrantRecordExportVos;
    }

    @Override
    public BizImportRespDto importGiftGrantRecord(BizImportDataReqDto<GiftGrantRecordImportVo> bizImportDataReqDto) {
        try {
            List importVoList = bizImportDataReqDto.getExcelImportResult();
            this.authImportData(importVoList, bizImportDataReqDto.getOrgId(), bizImportDataReqDto.getTenantId());
            List<GiftGrantRecordImportVo> itemAmountVoList = importVoList.stream().filter(c -> ObjectUtils.isEmpty((Object)c.getReason())).collect(Collectors.toList());
            List exportVoList = importVoList.stream().filter(c -> !ObjectUtils.isEmpty((Object)c.getReason())).collect(Collectors.toList());
            Integer importFailTotal = exportVoList.size();
            Integer importSuccessTotal = itemAmountVoList.size();
            Integer total = importVoList.size();
            logger.info("\u3010\u5bfc\u5165\u5269\u4f59\u989d\u5ea6\u3011\u603b\u5bfc\u5165\u6570\u636e{}\u6761\uff0c\u5408\u6cd5\u6570\u636e{}\u6761\uff0c\u4e0d\u5408\u6cd5\u6570\u636e{}\u6761", new Object[]{total, importSuccessTotal, importFailTotal});
            if (!ObjectUtils.isEmpty(itemAmountVoList)) {
                itemAmountVoList.forEach(c -> {
                    GiftAmountType giftAmountType = Arrays.stream(GiftAmountType.values()).filter(k -> k.getType().equals(c.getAmountType())).findFirst().get();
                    TrControlGiftGrantRecordEo controlGiftGrantRecordEo = new TrControlGiftGrantRecordEo(TradeUtil.generateGiftGrantNo(giftAmountType.getType()), new Date(), c.getRuleId(), c.getRuleName(), new BigDecimal(c.getGrantAmount()).setScale(2, 4), c.getAmountType(), c.getGrantTime(), c.getIsReturn(), c.getIsReturn().equals(GiftAmountGrantIsReturnEnum.NOT_NEED.getType()) ? null : c.getReturnTime(), c.getIsReturn().equals(GiftAmountGrantIsReturnEnum.NOT_NEED.getType()) ? GiftAmountGrantStatus.NOT_NEED.getType() : GiftAmountGrantStatus.PENDING_SEND.getType(), c.getCustomerCode(), c.getCustomerName(), GiftAmountGrantTypeEnum.TIMING.getType(), bizImportDataReqDto.getOrgId());
                    this.controlGiftGrantRecordService.schedulerGrantAmount(controlGiftGrantRecordEo, bizImportDataReqDto.getImportId());
                });
            }
            String url = "";
            if (!CollectionUtils.isEmpty(exportVoList)) {
                String excelName = "cube/\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u5bfc\u5165\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                try {
                    url = EasyPoiExportUtil.getExportUrl(exportVoList, GiftGrantRecordImportVo.class, (String)null, (String)excelName, (String)"xls");
                    logger.info("\u3010\u5bfc\u5165\u8d60\u54c1\u9884\u652f\u989d\u5ea6\u3011\u5931\u8d25\u6587\u4ef6url : {}", (Object)url);
                }
                catch (Exception var15) {
                    logger.error("\u5bfc\u5165\u9884\u652f\u8d60\u54c1\u989d\u5ea6-\u9519\u8bef:{}", (Object)var15.toString());
                    var15.printStackTrace();
                }
            }
            return new BizImportRespDto(total, importSuccessTotal, importFailTotal, url);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void schedulerGrantAmount(TrControlGiftGrantRecordEo controlGiftGrantRecordEo, Long importId) {
        Long tasks;
        int results = this.trControlGiftGrantRecordDas.insert((BaseEo)controlGiftGrantRecordEo);
        if (results < 0) {
            logger.error("\u3010\u5bfc\u5165\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u3011\u63d2\u5165\u5931\u8d25 \uff1a{}", (Object)JSON.toJSONString((Object)controlGiftGrantRecordEo));
        }
        if (GiftAmountGrantTypeEnum.TIMING.getType().equals(controlGiftGrantRecordEo.getGrantType())) {
            controlGiftGrantRecordEo.setStatus(GiftAmountGrantStatus.PENDING_SEND.getType());
            tasks = this.bizGrantadvanceGift.createTasks(controlGiftGrantRecordEo.getGrantTime(), controlGiftGrantRecordEo.getId());
            controlGiftGrantRecordEo.setSchedulerGrantId(tasks);
            logger.info("\u3010\u5bfc\u5165\u9884\u652f\u989d\u5ea6\u3011\u5b9a\u65f6\u53d1\u653e\u8c03\u5ea6id:{}", (Object)tasks);
        } else {
            BizControlGiftResultReqDto bizControlGiftResultReqDto = new BizControlGiftResultReqDto(controlGiftGrantRecordEo.getRuleId(), controlGiftGrantRecordEo.getCustomerCode(), controlGiftGrantRecordEo.getCustomerName(), controlGiftGrantRecordEo.getOrgId(), controlGiftGrantRecordEo.getAdvanceAmount(), controlGiftGrantRecordEo.getAmountType(), controlGiftGrantRecordEo.getGrantNo(), GiftAmountWayEnum.WAY_08.getType(), importId);
            this.trControlGiftResultService.modifyBillData(bizControlGiftResultReqDto);
        }
        if (GiftAmountGrantIsReturnEnum.NEED.getType().equals(controlGiftGrantRecordEo.getIsReturn())) {
            tasks = this.bizGrantBackGift.createTasks(controlGiftGrantRecordEo.getReturnTime(), controlGiftGrantRecordEo.getId());
            logger.info("\u3010\u5bfc\u5165\u9884\u652f\u989d\u5ea6\u3011\u5f52\u8fd8\u8c03\u5ea6id:{}", (Object)tasks);
            controlGiftGrantRecordEo.setSchedulerBackId(tasks);
            controlGiftGrantRecordEo.setStatus(ObjectUtils.isEmpty((Object)controlGiftGrantRecordEo.getStatus()) ? GiftAmountGrantStatus.PENDING_RETURN.getType() : controlGiftGrantRecordEo.getStatus());
        } else {
            controlGiftGrantRecordEo.setStatus(ObjectUtils.isEmpty((Object)controlGiftGrantRecordEo.getStatus()) ? GiftAmountGrantStatus.NOT_NEED.getType() : controlGiftGrantRecordEo.getStatus());
        }
        int modifyResult = this.trControlGiftGrantRecordDas.updateSelective((BaseEo)controlGiftGrantRecordEo);
        if (modifyResult < 0) {
            logger.error("\u3010\u5bfc\u5165\u9884\u652f\u8d60\u54c1\u989d\u5ea6\u3011\u66f4\u65b0\u5931\u8d25 \uff1a{}", (Object)JSON.toJSONString((Object)controlGiftGrantRecordEo));
        }
    }

    @Override
    public List<TrControlGiftGrantRecordEo> getControlGiftGrantRecordAndPendingSend(Date grantTime, Integer status) {
        AssertUtils.notNull((Object)grantTime, (String)"\u53d1\u653e\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtils.notNull((Object)status, (String)"\u72b6\u6001\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        TrControlGiftGrantRecordEo controlGiftGrantRecordEo = new TrControlGiftGrantRecordEo();
        controlGiftGrantRecordEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.le((String)"grant_time", (Object)grantTime)}));
        controlGiftGrantRecordEo.setStatus(status);
        return this.trControlGiftGrantRecordDas.select((BaseEo)controlGiftGrantRecordEo);
    }

    @Override
    public List<TrControlGiftGrantRecordEo> getControlGiftGrantRecordAndReturn(Date returnTime, Integer status) {
        AssertUtils.notNull((Object)returnTime, (String)"\u5f52\u8fd8\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtils.notNull((Object)status, (String)"\u72b6\u6001\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        TrControlGiftGrantRecordEo controlGiftGrantRecordEo = new TrControlGiftGrantRecordEo();
        controlGiftGrantRecordEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.le((String)"return_time", (Object)returnTime)}));
        controlGiftGrantRecordEo.setStatus(status);
        return this.trControlGiftGrantRecordDas.select((BaseEo)controlGiftGrantRecordEo);
    }

    public List<GiftGrantRecordImportVo> authImportData(List<GiftGrantRecordImportVo> list, Long orgId, Long tenantId) {
        for (GiftGrantRecordImportVo c : list) {
            block21: {
                block20: {
                    block19: {
                        try {
                            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{c.getCustomerCode()})) {
                                logger.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_01.getDesc());
                                c.setReason(ImportItemAmountReason.ERROR_01.getDesc());
                                continue;
                            }
                            CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
                            customerSearchReqDto.setTenantId(tenantId);
                            customerSearchReqDto.setCode(c.getCustomerCode());
                            customerSearchReqDto.setMerchantId(orgId);
                            RestResponse pageInfoRestResponse = this.iCustomerQueryApi.queryByPageOnPost(customerSearchReqDto, Integer.valueOf(1), Integer.valueOf(1));
                            PageInfo customerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
                            logger.info("\u3010\u5bfc\u5165\u9884\u652f\u989d\u5ea6\u3011\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)pageInfoRestResponse));
                            AssertUtils.notEmpty((Collection)customerRespDtoPageInfo.getList(), (String)"\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38");
                            CustomerRespDto data = (CustomerRespDto)customerRespDtoPageInfo.getList().stream().findFirst().get();
                            AssertUtils.notNull((Object)data, (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38");
                            AssertUtils.isTrue((boolean)data.getMerchantId().equals(orgId), (String)"\u5f53\u524d\u5ba2\u6237\u975e\u5f53\u524d\u7ec4\u7ec7");
                            c.setCustomerName(StringUtils.defaultString((String)data.getName(), (String)""));
                        }
                        catch (Exception e) {
                            logger.info("\u3010\u5bfc\u5165\u9884\u652f\u989d\u5ea6\u5f02\u5e38\u3011\u7528\u6237code\u89e3\u6790\u5f02\u5e38");
                            c.setReason(ImportItemAmountReason.ERROR_01.getDesc());
                            continue;
                        }
                        try {
                            BizContolGiftRespDto bizContolGiftRespDto = this.controlGiftRuleService.queryById(c.getRuleId());
                            if (ObjectUtils.isEmpty((Object)bizContolGiftRespDto)) {
                                c.setReason(ImportItemAmountReason.ERROR_11.getDesc());
                                continue;
                            }
                            c.setRuleName(bizContolGiftRespDto.getName());
                            c.setAmountType(bizContolGiftRespDto.getAmountType());
                        }
                        catch (Exception e) {
                            logger.info("\u3010\u5bfc\u5165\u9884\u652f\u989d\u5ea6\u5f02\u5e38\u3011\u8d60\u54c1\u989d\u5ea6\u89c4\u5219\u7f16\u53f7\u89e3\u6790\u5f02\u5e38");
                            c.setReason(ImportItemAmountReason.ERROR_11.getDesc());
                            continue;
                        }
                        try {
                            if (c.getGrantTime().compareTo(new Date()) != 1) {
                                c.setReason(ImportItemAmountReason.ERROR_13.getDesc());
                            }
                            break block19;
                        }
                        catch (Exception e) {
                            c.setReason(ImportItemAmountReason.ERROR_18.getDesc());
                        }
                        continue;
                    }
                    long count = Arrays.stream(GiftAmountGrantIsReturnEnum.values()).filter(k -> k.getType().equals(c.getIsReturn())).count();
                    if (count == 0L) {
                        c.setReason(ImportItemAmountReason.ERROR_14.getDesc());
                        continue;
                    }
                    if (!GiftAmountGrantIsReturnEnum.NOT_NEED.getType().equals(c.getIsReturn())) {
                        try {
                            if (c.getReturnTime().compareTo(new Date()) != 1) {
                                c.setReason(ImportItemAmountReason.ERROR_16.getDesc());
                                continue;
                            }
                            if (c.getReturnTime().compareTo(c.getGrantTime()) != 1) {
                                c.setReason(ImportItemAmountReason.ERROR_17.getDesc());
                            }
                            break block20;
                        }
                        catch (Exception e) {
                            c.setReason(ImportItemAmountReason.ERROR_15.getDesc());
                        }
                        continue;
                    }
                }
                try {
                    BigDecimal amount = new BigDecimal(c.getGrantAmount());
                    if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                        c.setReason(ImportItemAmountReason.ERROR_21.getDesc());
                    }
                    break block21;
                }
                catch (NumberFormatException e) {
                    c.setReason(ImportItemAmountReason.ERROR_08.getDesc());
                }
                continue;
            }
            TrControlGiftGrantRecordReqDto controlGiftGrantRecordReqDto = new TrControlGiftGrantRecordReqDto();
            controlGiftGrantRecordReqDto.setRuleId(c.getRuleId());
            controlGiftGrantRecordReqDto.setCustomerCode(c.getCustomerCode());
            BizControlGiftGrantRespDto bizControlGiftGrantRespDto = this.verifyGrantAmount(controlGiftGrantRecordReqDto);
            if (!bizControlGiftGrantRespDto.getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) continue;
            c.setReason(ImportItemAmountReason.ERROR_20.getDesc());
        }
        return list;
    }
}

