/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountType;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountWayEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OperationTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.TimeRangeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.TradeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizRecordQueryReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftRecordExportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.TimeRangeVo;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftRecordService;
import com.dtyunxi.tcbj.center.control.biz.utils.RedisCacheHelper;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftRecordDas;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftRecordEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class TrControlGiftRecordServiceImpl
implements ITrControlGiftRecordService {
    private static Logger logger = LoggerFactory.getLogger(TrControlGiftRecordServiceImpl.class);
    @Resource
    private TrControlGiftRecordDas trControlGiftRecordDas;
    @Resource
    private RedisCacheHelper cacheHelper;

    @Override
    public int addTrControlGiftRecord(TrControlGiftRecordReqDto addReqDto) {
        TrControlGiftRecordEo trControlGiftRecordEo = new TrControlGiftRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)trControlGiftRecordEo);
        return this.trControlGiftRecordDas.insert((BaseEo)trControlGiftRecordEo);
    }

    @Override
    public void modifyTrControlGiftRecord(TrControlGiftRecordReqDto modifyReqDto) {
        TrControlGiftRecordEo trControlGiftRecordEo = new TrControlGiftRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)trControlGiftRecordEo);
        this.trControlGiftRecordDas.updateSelective((BaseEo)trControlGiftRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTrControlGiftRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.trControlGiftRecordDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public TrControlGiftRecordRespDto queryById(Long id) {
        TrControlGiftRecordEo trControlGiftRecordEo = (TrControlGiftRecordEo)this.trControlGiftRecordDas.selectByPrimaryKey(id);
        TrControlGiftRecordRespDto trControlGiftRecordRespDto = new TrControlGiftRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)trControlGiftRecordEo, (BaseVo)trControlGiftRecordRespDto);
        return trControlGiftRecordRespDto;
    }

    @Override
    public PageInfo<TrControlGiftRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u6d41\u6c34\u3011\u6d41\u6c34\u67e5\u8be2\uff1a{}", (Object)filter);
        TrControlGiftRecordReqDto trControlGiftRecordReqDto = (TrControlGiftRecordReqDto)JSON.parseObject((String)filter, TrControlGiftRecordReqDto.class);
        AssertUtils.notNull((Object)trControlGiftRecordReqDto.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        TrControlGiftRecordEo trControlGiftRecordEo = new TrControlGiftRecordEo();
        DtoHelper.dto2Eo((BaseVo)trControlGiftRecordReqDto, (BaseEo)trControlGiftRecordEo, (String[])new String[]{"customerCode", "customerName", "tradeNo", "businessNo"});
        ArrayList sqlFilters = Lists.newArrayList();
        if (!ObjectUtils.isEmpty((Object)trControlGiftRecordReqDto.getTradeStartTime())) {
            sqlFilters.add(SqlFilter.ge((String)"trade_time", (Object)trControlGiftRecordReqDto.getTradeStartTime()));
        }
        if (!ObjectUtils.isEmpty((Object)trControlGiftRecordReqDto.getTradeEndTime())) {
            sqlFilters.add(SqlFilter.le((String)"trade_time", (Object)trControlGiftRecordReqDto.getTradeEndTime()));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftRecordReqDto.getCustomerCode())) {
            sqlFilters.add(SqlFilter.like((String)"customer_code", (Object)trControlGiftRecordReqDto.getCustomerCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftRecordReqDto.getCustomerName())) {
            sqlFilters.add(SqlFilter.like((String)"customer_name", (Object)trControlGiftRecordReqDto.getCustomerName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftRecordReqDto.getTradeNo())) {
            sqlFilters.add(SqlFilter.like((String)"trade_no", (Object)trControlGiftRecordReqDto.getTradeNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftRecordReqDto.getBusinessNo())) {
            sqlFilters.add(SqlFilter.like((String)"business_no", (Object)trControlGiftRecordReqDto.getBusinessNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)trControlGiftRecordReqDto.getRuleIdLike())) {
            sqlFilters.add(SqlFilter.like((String)"rule_id", (Object)trControlGiftRecordReqDto.getRuleIdLike()));
        }
        trControlGiftRecordEo.setSqlFilters((List)sqlFilters);
        trControlGiftRecordEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.trControlGiftRecordDas.selectPage((BaseEo)trControlGiftRecordEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TrControlGiftRecordRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<GiftRecordExportVo> exportGiftRecord(Long orgId, Long ruleId, String customerCode) {
        List controlGiftRecordEos;
        TrControlGiftRecordEo controlGiftRecordEo = new TrControlGiftRecordEo();
        controlGiftRecordEo.setOrgId(orgId);
        if (!ObjectUtils.isEmpty((Object)ruleId)) {
            controlGiftRecordEo.setRuleId(ruleId);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{customerCode})) {
            controlGiftRecordEo.setCustomerCode(customerCode);
        }
        if (CollectionUtils.isEmpty((Collection)(controlGiftRecordEos = this.trControlGiftRecordDas.select((BaseEo)controlGiftRecordEo)))) {
            return null;
        }
        ArrayList giftRecordExportVos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)controlGiftRecordEos, (Collection)giftRecordExportVos, GiftRecordExportVo.class);
        Map<String, List<TrControlGiftRecordEo>> collect = controlGiftRecordEos.stream().collect(Collectors.groupingBy(c -> c.getBusinessNo()));
        giftRecordExportVos.forEach(c -> {
            List recordEos = collect.getOrDefault(c.getBusinessNo(), Lists.newArrayList());
            TrControlGiftRecordEo trControlGiftRecordEo = (TrControlGiftRecordEo)recordEos.stream().findFirst().get();
            c.setAmountType(GiftAmountType.enumOf((Integer)trControlGiftRecordEo.getAmountType()).getDesc());
            c.setTradeType(TradeTypeEnum.enumOf((Integer)trControlGiftRecordEo.getTradeType()).getDesc());
            c.setIncomeType(OperationTypeEnum.enumOf((Integer)trControlGiftRecordEo.getIncomeType()).getDesc());
        });
        return giftRecordExportVos;
    }

    @Override
    public PageInfo<TrControlGiftRecordRespDto> queryPageByRule(BizRecordQueryReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getRuleId(), (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        GiftAmountWayEnum amountWayEnum = GiftAmountWayEnum.enumOf((Integer)reqDto.getAmountWay());
        TimeRangeEnum timeRangeEnum = TimeRangeEnum.enumOf((Integer)reqDto.getDateType());
        TimeRangeVo timeRangeVo = timeRangeEnum.calTimeRange(reqDto.getStartTime(), reqDto.getEndTime());
        TrControlGiftRecordEo queryEo = new TrControlGiftRecordEo();
        if (Objects.nonNull(reqDto.getRuleId())) {
            queryEo.setRuleId(reqDto.getRuleId());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCustomerCode())) {
            queryEo.setCustomerCode(reqDto.getCustomerCode());
        }
        if (Objects.nonNull(reqDto.getOrgId())) {
            queryEo.setOrgId(reqDto.getOrgId());
        }
        if (!GiftAmountWayEnum.ALL.equals((Object)amountWayEnum)) {
            queryEo.setTradeType(amountWayEnum.getType());
        }
        if (!TimeRangeEnum.ALL.equals((Object)timeRangeEnum)) {
            ArrayList filterList = Lists.newArrayList();
            filterList.add(SqlFilter.ge((String)"create_time", (Object)timeRangeVo.getStartTime()));
            filterList.add(SqlFilter.le((String)"create_time", (Object)timeRangeVo.getEndTime()));
            queryEo.setSqlFilters((List)filterList);
        }
        queryEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.trControlGiftRecordDas.selectPage((BaseEo)queryEo, reqDto.getPageNo(), reqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TrControlGiftRecordRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Map<String, Object> queryInOutAmountForRule(BizRecordQueryReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getRuleId(), (String)"ruleId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        GiftAmountWayEnum amountWayEnum = GiftAmountWayEnum.enumOf((Integer)reqDto.getAmountWay());
        TimeRangeEnum timeRangeEnum = TimeRangeEnum.enumOf((Integer)reqDto.getDateType());
        TimeRangeVo timeRangeVo = timeRangeEnum.calTimeRange(reqDto.getStartTime(), reqDto.getEndTime());
        String cacheKey = String.format("%s:%s:%s:%s", reqDto.getRuleId(), amountWayEnum.getType(), timeRangeVo.getStartTime(), timeRangeVo.getEndTime());
        Map countCacheMap = this.cacheHelper.putCacheIfAbsent(cacheKey, Map.class, 60, () -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            if (!GiftAmountWayEnum.ALL.equals((Object)amountWayEnum)) {
                queryWrapper.lambda().eq(TrControlGiftRecordEo::getTradeType, (Object)amountWayEnum.getType());
            }
            if (!TimeRangeEnum.ALL.equals((Object)timeRangeEnum)) {
                ((LambdaQueryWrapper)queryWrapper.lambda().ge(BaseEo::getCreateTime, (Object)timeRangeVo.getStartTime())).le(BaseEo::getCreateTime, (Object)timeRangeVo.getEndTime());
            }
            queryWrapper.lambda().eq(TrControlGiftRecordEo::getRuleId, (Object)reqDto.getRuleId());
            queryWrapper.select(new String[]{"income_type as 'incomeType',IFNULL(sum(trade_amount),0) as 'tradeAmount'"}).groupBy((Object)"income_type");
            List giftRecordEos = this.trControlGiftRecordDas.list((Wrapper)queryWrapper);
            HashMap<String, BigDecimal> countMap = new HashMap<String, BigDecimal>(2);
            if (CollectionUtils.isNotEmpty((Collection)giftRecordEos)) {
                for (int i = 0; i < giftRecordEos.size(); ++i) {
                    TrControlGiftRecordEo giftRecordEo = (TrControlGiftRecordEo)giftRecordEos.get(i);
                    countMap.put(giftRecordEo.getIncomeType() + "", giftRecordEo.getTradeAmount());
                }
            }
            return countMap;
        });
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("0", countCacheMap.computeIfAbsent("0", v -> 0));
        resultMap.put("1", countCacheMap.computeIfAbsent("1", v -> 0));
        return resultMap;
    }
}

