/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.dto.constant.AmountStatusEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountResultEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountType;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftAmountWayEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftFreezeReason;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftFreezeStatus;
import com.dtyunxi.tcbj.center.control.api.dto.constant.GiftFreezeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.ImportItemAmountReason;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OperationTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlGiftResultReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizImportDataReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftFreezeRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlGiftResultReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizGiftAmountResultMoneyRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizGiftAmountResultNumRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizImportRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftFreebieRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftFreezeRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlGiftResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftAmountResultExportVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.GiftAmountResultImportVo;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftFreebieService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftFreezeRecordService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftRecordService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftResultService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlGiftRuleService;
import com.dtyunxi.tcbj.center.control.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftFreezeRecordDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftRecordDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftResultDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlGiftRuleDas;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftFreezeRecordEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftRecordEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftResultEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlGiftRuleEo;
import com.dtyunxi.tcbj.center.control.dao.mapper.TrControlGiftResultMapper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class TrControlGiftResultServiceImpl
implements ITrControlGiftResultService {
    private static Logger logger = LoggerFactory.getLogger(TrControlGiftResultServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private TrControlGiftResultDas trControlGiftResultDas;
    @Resource
    private TrControlGiftRecordDas giftRecordDas;
    @Resource
    private TrControlGiftFreezeRecordDas freezeRecordDas;
    @Resource
    private TrControlGiftResultMapper trControlGiftResultMapper;
    @Resource
    private ITrControlGiftResultService trControlGiftResultService;
    @Resource
    private ITrControlGiftFreezeRecordService controlGiftFreezeRecordService;
    @Resource
    private ITrControlGiftRuleService controlGiftRuleService;
    @Resource
    private TrControlGiftRuleDas trControlGiftRuleDas;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private ITrControlGiftRecordService controlGiftRecordService;
    @Resource
    private ITrControlGiftFreebieService giftFreebieService;

    @Override
    public Long addTrControlGiftResult(TrControlGiftResultReqDto addReqDto) {
        TrControlGiftResultEo trControlGiftResultEo = new TrControlGiftResultEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)trControlGiftResultEo);
        this.trControlGiftResultDas.insert((BaseEo)trControlGiftResultEo);
        return trControlGiftResultEo.getId();
    }

    @Override
    public void modifyTrControlGiftResult(TrControlGiftResultReqDto modifyReqDto) {
        TrControlGiftResultEo trControlGiftResultEo = new TrControlGiftResultEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)trControlGiftResultEo);
        this.trControlGiftResultDas.updateSelective((BaseEo)trControlGiftResultEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTrControlGiftResult(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.trControlGiftResultDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public TrControlGiftResultRespDto queryById(Long id) {
        TrControlGiftResultEo trControlGiftResultEo = (TrControlGiftResultEo)this.trControlGiftResultDas.selectByPrimaryKey(id);
        TrControlGiftResultRespDto trControlGiftResultRespDto = new TrControlGiftResultRespDto();
        DtoHelper.eo2Dto((BaseEo)trControlGiftResultEo, (BaseVo)trControlGiftResultRespDto);
        Long ruleId = trControlGiftResultRespDto.getRuleId();
        List<TrControlGiftFreebieRespDto> freebieRespDtos = this.giftFreebieService.queryGiftFreebieRespDtoByRuleId(ruleId);
        Optional.ofNullable(freebieRespDtos).ifPresent(freebieRespDtoList -> {
            List giftCodeList = freebieRespDtoList.stream().map(TrControlGiftFreebieRespDto::getItemCode).collect(Collectors.toList());
            trControlGiftResultRespDto.setGiftCodeList(giftCodeList);
        });
        return trControlGiftResultRespDto;
    }

    @Override
    public PageInfo<TrControlGiftResultRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo dtoPageInfo = new PageInfo();
        TrControlGiftResultReqDto trControlGiftResultReqDto = (TrControlGiftResultReqDto)JSON.parseObject((String)filter, TrControlGiftResultReqDto.class);
        AssertUtils.notNull((Object)trControlGiftResultReqDto.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (trControlGiftResultReqDto.getType().equals(GiftAmountResultEnum.WAY_01.getType())) {
            TrControlGiftResultEo trControlGiftResultEo = new TrControlGiftResultEo();
            ArrayList sqlFilters = Lists.newArrayList();
            if (Objects.nonNull(trControlGiftResultReqDto.getOrgId())) {
                sqlFilters.add(SqlFilter.eq((String)"org_id", (Object)trControlGiftResultReqDto.getOrgId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)trControlGiftResultReqDto.getCustomerCode())) {
                sqlFilters.add(SqlFilter.like((String)"customer_code", (Object)trControlGiftResultReqDto.getCustomerCode()));
            }
            if (StringUtils.isNotEmpty((CharSequence)trControlGiftResultReqDto.getCustomerName())) {
                sqlFilters.add(SqlFilter.like((String)"customer_name", (Object)trControlGiftResultReqDto.getCustomerName()));
            }
            if (Objects.nonNull(trControlGiftResultReqDto.getAmountType())) {
                sqlFilters.add(SqlFilter.eq((String)"amount_type", (Object)trControlGiftResultReqDto.getAmountType()));
            }
            if (Objects.nonNull(trControlGiftResultReqDto.getStatus())) {
                sqlFilters.add(SqlFilter.eq((String)"status", (Object)trControlGiftResultReqDto.getStatus()));
            }
            if (StringUtils.isNotEmpty((CharSequence)trControlGiftResultReqDto.getRuleIdLike())) {
                sqlFilters.add(SqlFilter.like((String)"rule_id", (Object)trControlGiftResultReqDto.getRuleIdLike()));
            }
            if (CollectionUtils.isNotEmpty((Collection)sqlFilters)) {
                trControlGiftResultEo.setSqlFilters((List)sqlFilters);
            }
            trControlGiftResultEo.setOrderByDesc("create_time");
            PageInfo eoPageInfo = this.trControlGiftResultDas.selectPage((BaseEo)trControlGiftResultEo, pageNum, pageSize);
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TrControlGiftResultRespDto.class);
            dtoPageInfo.setList(dtoList);
        } else {
            int count = this.trControlGiftResultMapper.countPage(trControlGiftResultReqDto.getCustomerCode(), trControlGiftResultReqDto.getCustomerName(), trControlGiftResultReqDto.getAmountType(), trControlGiftResultReqDto.getRuleIdLike(), trControlGiftResultReqDto.getStatus(), trControlGiftResultReqDto.getOrgId());
            List trControlGiftResultEos = this.trControlGiftResultMapper.queryByPage(trControlGiftResultReqDto.getCustomerCode(), trControlGiftResultReqDto.getCustomerName(), trControlGiftResultReqDto.getAmountType(), trControlGiftResultReqDto.getRuleIdLike(), trControlGiftResultReqDto.getStatus(), trControlGiftResultReqDto.getOrgId(), Integer.valueOf(pageSize * (pageNum - 1)), Integer.valueOf(pageSize * 2));
            ArrayList dtoList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)trControlGiftResultEos)) {
                Map<String, List<TrControlGiftResultEo>> collect = trControlGiftResultEos.stream().collect(Collectors.groupingBy(TrControlGiftResultEo::getCustomerCode));
                collect.forEach((k, v) -> {
                    Map<Integer, List<TrControlGiftResultEo>> giftResultList = v.stream().filter(dto -> Objects.nonNull(dto.getAmountType())).collect(Collectors.groupingBy(TrControlGiftResultEo::getAmountType));
                    TrControlGiftResultEo giftResultEo_money = giftResultList.getOrDefault(GiftAmountType.AMOUNT_MONEY.getType(), Lists.newArrayList()).stream().findFirst().orElse(new TrControlGiftResultEo(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                    TrControlGiftResultEo giftResultEo_num = giftResultList.getOrDefault(GiftAmountType.AMOUNT_NUM.getType(), Lists.newArrayList()).stream().findFirst().orElse(new TrControlGiftResultEo(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
                    BizGiftAmountResultMoneyRespDto moneyRespDto = new BizGiftAmountResultMoneyRespDto(giftResultEo_money.getRemainAmount(), giftResultEo_money.getFreezeAmount(), giftResultEo_money.getUsedAmount(), giftResultEo_money.getUsableAmount());
                    BizGiftAmountResultNumRespDto numRespDto = new BizGiftAmountResultNumRespDto(giftResultEo_num.getRemainAmount(), giftResultEo_num.getFreezeAmount(), giftResultEo_num.getUsedAmount(), giftResultEo_num.getUsableAmount());
                    TrControlGiftResultRespDto giftResultRespDto = new TrControlGiftResultRespDto();
                    DtoHelper.eo2Dto((BaseEo)(ObjectUtils.isEmpty((Object)giftResultEo_money.getCustomerCode()) ? giftResultEo_num : giftResultEo_money), (BaseVo)giftResultRespDto);
                    giftResultRespDto.setAmountMoneyAll(moneyRespDto);
                    giftResultRespDto.setAmountNumAll(numRespDto);
                    dtoList.add(giftResultRespDto);
                });
            }
            dtoPageInfo.setList(dtoList);
            dtoPageInfo.setTotal((long)count);
            dtoPageInfo.setPageNum(pageNum.intValue());
            dtoPageInfo.setPageSize(pageSize.intValue());
            dtoPageInfo.setSize(dtoList.size());
        }
        return dtoPageInfo;
    }

    public BizControlGiftResultReqDto dealChangeWay(BizControlGiftResultReqDto giftResultReqDto) {
        ArrayList addList = Lists.newArrayList((Object[])new Integer[]{GiftAmountWayEnum.WAY_01.getType(), GiftAmountWayEnum.WAY_02.getType(), GiftAmountWayEnum.WAY_05.getType(), GiftAmountWayEnum.WAY_08.getType()});
        ArrayList cutList = Lists.newArrayList((Object[])new Integer[]{GiftAmountWayEnum.WAY_03.getType(), GiftAmountWayEnum.WAY_04.getType(), GiftAmountWayEnum.WAY_06.getType(), GiftAmountWayEnum.WAY_07.getType(), GiftAmountWayEnum.WAY_09.getType()});
        if (cutList.contains(giftResultReqDto.getChangeWay())) {
            giftResultReqDto.setChangeAmount(giftResultReqDto.getChangeAmount().negate());
        }
        giftResultReqDto.setChangeAmount(giftResultReqDto.getChangeAmount().setScale(2, 4));
        return giftResultReqDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBillData(BizControlGiftResultReqDto giftResultReqDto) {
        giftResultReqDto = this.dealChangeWay(giftResultReqDto);
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u3011\u8d60\u54c1\u989d\u5ea6\u8d26\u6237\u53d8\u66f4\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)giftResultReqDto));
        int result = 0;
        TrControlGiftResultRespDto giftResultRespDto = this.queryGiftResultByRuleIdAndCustomer(giftResultReqDto.getRuleId(), giftResultReqDto.getCustomerCode());
        logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u3011\u8d60\u54c1\u989d\u5ea6\u8d26\u6237\u53d8\u66f4\u8d26\u6237\uff1a{}", (Object)JSON.toJSONString((Object)giftResultRespDto));
        if (ObjectUtils.isEmpty((Object)giftResultRespDto)) {
            this.addGiftResultBill(giftResultReqDto);
        }
        GiftAmountWayEnum giftAmountWayEnum = GiftAmountWayEnum.enumOf((Integer)giftResultReqDto.getChangeWay());
        switch (giftAmountWayEnum) {
            case WAY_04: {
                if (ObjectUtils.isEmpty((Object)giftResultRespDto) || giftResultRespDto.getUsableAmount().compareTo(giftResultReqDto.getChangeAmount()) == -1) {
                    throw new BizException(ControlExceptionCode.GIFT_AMOUNT_AMPLE_FAIL.getCode(), ControlExceptionCode.GIFT_AMOUNT_AMPLE_FAIL.getMsg());
                }
            }
            case WAY_05: {
                result = this.trControlGiftResultMapper.updateGiftAmountByFields(null, giftResultReqDto.getChangeAmount().toString(), giftResultReqDto.getChangeAmount().toString(), giftResultReqDto.getChangeAmount().negate().toString(), giftResultReqDto.getRuleId(), giftResultReqDto.getCustomerCode());
                if (result >= 0) break;
                logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u64cd\u4f5c\u3011\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)giftResultReqDto));
                throw new BizException(ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getCode(), ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getMsg());
            }
            case WAY_03: {
                LambdaQueryWrapper queryFreezeWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryFreezeWrapper.eq(TrControlGiftFreezeRecordEo::getBusinessNo, (Object)giftResultReqDto.getOrderNo())).eq(BaseEo::getDr, (Object)0)).eq(TrControlGiftFreezeRecordEo::getRuleId, (Object)giftResultReqDto.getRuleId());
                List recordEos = this.freezeRecordDas.list((Wrapper)queryFreezeWrapper);
                logger.info("\u3010\u53d6\u6d88\u8ba2\u5355\u8ba1\u7b97\u53ef\u9000\u8d60\u54c1\u989d\u5ea6\u3011\u8be5\u8ba2\u5355({})\u7684\u51bb\u7ed3\u989d\u5ea6\u6d41\u6c34\u4e3a\uff1a{}", (Object)giftResultReqDto.getOrderNo(), (Object)JSON.toJSONString((Object)recordEos));
                if (CollectionUtils.isNotEmpty((Collection)recordEos)) {
                    for (TrControlGiftFreezeRecordEo giftFreezeRecordEo : recordEos) {
                        this.trControlGiftResultMapper.updateGiftAmountByFields(giftFreezeRecordEo.getFreezeAmount().negate().toString(), null, giftFreezeRecordEo.getFreezeAmount().negate().toString(), null, giftFreezeRecordEo.getRuleId(), giftFreezeRecordEo.getCustomerCode());
                        TrControlGiftFreezeRecordEo updateEo = new TrControlGiftFreezeRecordEo();
                        updateEo.setStatus(GiftFreezeStatus.FREEZED.getType());
                        updateEo.setUnfreezeTime(new Date());
                        AssertUtils.notNull((Object)giftFreezeRecordEo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        updateEo.setId(giftFreezeRecordEo.getId());
                        this.freezeRecordDas.updateSelective((BaseEo)updateEo);
                    }
                }
                BigDecimal reduce = recordEos.stream().map(c -> c.getFreezeAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal subtract = giftResultReqDto.getChangeAmount().add(reduce);
                if (subtract.equals(BigDecimal.ZERO) || (result = this.trControlGiftResultMapper.updateGiftAmountByFields(null, subtract.toString(), subtract.toString(), null, giftResultReqDto.getRuleId(), giftResultReqDto.getCustomerCode())) >= 0) break;
                logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u64cd\u4f5c\u3011\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)giftResultReqDto));
                throw new BizException(ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getCode(), ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getMsg());
            }
            case WAY_02: 
            case WAY_06: 
            case WAY_07: 
            case WAY_08: 
            case WAY_09: 
            case WAY_10: {
                result = this.trControlGiftResultMapper.updateGiftAmountByFields(null, giftResultReqDto.getChangeAmount().toString(), giftResultReqDto.getChangeAmount().toString(), null, giftResultReqDto.getRuleId(), giftResultReqDto.getCustomerCode());
                if (result >= 0) break;
                logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u64cd\u4f5c\u3011\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)giftResultReqDto));
                throw new BizException(ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getCode(), ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getMsg());
            }
            case WAY_01: {
                result = this.trControlGiftResultMapper.updateGiftAmountByFields(giftResultReqDto.getChangeAmount().negate().toString(), giftResultReqDto.getChangeAmount().toString(), null, null, giftResultReqDto.getRuleId(), giftResultReqDto.getCustomerCode());
                if (result < 0) {
                    logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u64cd\u4f5c\u3011\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)giftResultReqDto));
                    throw new BizException(ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getCode(), ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getMsg());
                }
                TrControlGiftFreezeRecordRespDto controlGiftFreezeRecordRespDto = this.controlGiftFreezeRecordService.queryGiftFreezeRecordByCustomer(giftResultReqDto.getOrderNo(), giftResultReqDto.getCustomerCode(), giftResultReqDto.getRuleId());
                AssertUtils.notNull((Object)controlGiftFreezeRecordRespDto, (String)"\u5f53\u524d\u51bb\u7ed3\u989d\u5ea6\u8bb0\u5f55\u4e0d\u5b58\u5728");
                TrControlGiftFreezeRecordReqDto controlGiftFreezeRecordReqDto = new TrControlGiftFreezeRecordReqDto();
                CubeBeanUtils.copyProperties((Object)controlGiftFreezeRecordReqDto, (Object)controlGiftFreezeRecordRespDto, (String[])new String[0]);
                controlGiftFreezeRecordReqDto.setStatus(GiftFreezeStatus.FREEZED.getType());
                controlGiftFreezeRecordReqDto.setUnfreezeTime(new Date());
                logger.info("\u3010\u51bb\u7ed3\u989d\u5ea6\u3011\u66f4\u65b0\u6d41\u6c34:{}", (Object)JSON.toJSONString((Object)controlGiftFreezeRecordReqDto));
                this.controlGiftFreezeRecordService.modifyTrControlGiftFreezeRecord(controlGiftFreezeRecordReqDto);
                break;
            }
            case WAY_11: {
                if (giftResultReqDto.getChangeAmount().compareTo(BigDecimal.ZERO) != 1) break;
                result = this.trControlGiftResultMapper.updateGiftAmountByFields(giftResultReqDto.getChangeAmount().toString(), giftResultReqDto.getChangeAmount().negate().toString(), null, null, giftResultReqDto.getRuleId(), giftResultReqDto.getCustomerCode());
                if (result < 0) {
                    logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u64cd\u4f5c\u3011\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)giftResultReqDto));
                    throw new BizException(ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getCode(), ControlExceptionCode.GIFT_AMOUNT_CHANGE_EXCEPTION.getMsg());
                }
                TrControlGiftFreezeRecordReqDto giftFreezeRecordReqDto = new TrControlGiftFreezeRecordReqDto(giftResultReqDto.getCustomerCode(), giftResultReqDto.getCustomerName(), new Date(), giftResultReqDto.getChangeAmount(), giftResultReqDto.getRuleId(), giftResultReqDto.getAmountType(), GiftFreezeTypeEnum.ORDER_GIFTFREEZE.getType(), null, GiftFreezeStatus.FREEZING.getType(), GiftFreezeReason.REASON_01.getDesc(), giftResultReqDto.getOrderNo(), giftResultReqDto.getOrgId());
                logger.info("\u3010\u51bb\u7ed3\u989d\u5ea6\u3011\u63d2\u5165\u6d41\u6c34:{}", (Object)JSON.toJSONString((Object)giftFreezeRecordReqDto));
                this.controlGiftFreezeRecordService.addTrControlGiftFreezeRecord(giftFreezeRecordReqDto);
                break;
            }
            default: {
                logger.error("\u3010\u989d\u5ea6\u64cd\u4f5c\u3011\u6682\u65e0\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b");
                return;
            }
        }
        if (!Lists.newArrayList((Object[])new Integer[]{GiftAmountWayEnum.WAY_01.getType(), GiftAmountWayEnum.WAY_11.getType()}).contains(giftResultReqDto.getChangeWay())) {
            TrControlGiftResultRespDto realTimeGiftResultRespDto = this.queryGiftResultByRuleIdAndCustomer(giftResultReqDto.getRuleId(), giftResultReqDto.getCustomerCode());
            TrControlGiftRecordReqDto controlGiftRecordReqDto = new TrControlGiftRecordReqDto(giftResultReqDto.getCustomerCode(), giftResultReqDto.getCustomerName(), TradeUtil.generateGiftItemFlowNo(giftResultReqDto.getChangeWay()), new Date(), giftResultReqDto.getRuleId(), giftResultReqDto.getAmountType(), giftResultReqDto.getChangeWay(), giftResultReqDto.getChangeAmount(), giftResultReqDto.getChangeAmount().compareTo(BigDecimal.ZERO) == -1 ? OperationTypeEnum.OPERATIONTYPEENUM_OUT.getType() : OperationTypeEnum.OPERATIONTYPEENUM_IN.getType(), realTimeGiftResultRespDto.getRemainAmount(), giftResultReqDto.getOrderNo(), giftResultReqDto.getImportId(), giftResultReqDto.getOrgId());
            result = this.controlGiftRecordService.addTrControlGiftRecord(controlGiftRecordReqDto);
            if (result < 0) {
                logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u6d41\u6c34\u3011\u63d2\u5165\u6d41\u6c34\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)controlGiftRecordReqDto));
                throw new BizException(ControlExceptionCode.CREATE_GIFT_FLOW_FAIL.getCode(), ControlExceptionCode.CREATE_GIFT_FLOW_FAIL.getMsg());
            }
        }
    }

    public void addGiftResultBill(BizControlGiftResultReqDto giftResultReqDto) {
        TrControlGiftRuleEo controlGiftRuleEo = (TrControlGiftRuleEo)this.trControlGiftRuleDas.selectByPrimaryKey(giftResultReqDto.getRuleId());
        Date date = DateUtil.parseDate((String)DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)new Date()), (String)"yyyy-MM-dd");
        Integer status = controlGiftRuleEo.getLoseTime().compareTo(date) == -1 ? AmountStatusEnum.USED.getType() : AmountStatusEnum.USING.getType();
        TrControlGiftResultEo controlGiftResultEo = new TrControlGiftResultEo(giftResultReqDto.getCustomerCode(), giftResultReqDto.getCustomerName(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, giftResultReqDto.getRuleId(), giftResultReqDto.getAmountType(), controlGiftRuleEo.getValidTime(), controlGiftRuleEo.getLoseTime(), status, giftResultReqDto.getOrgId());
        int result = this.trControlGiftResultDas.insert((BaseEo)controlGiftResultEo);
        if (result < 0) {
            logger.info("\u3010\u8d60\u54c1\u989d\u5ea6\u6d41\u6c34\u3011\u63d2\u5165\u6d41\u6c34\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)controlGiftResultEo));
            throw new BizException(ControlExceptionCode.CREATE_GIFT_RULE_ERROR.getCode(), ControlExceptionCode.CREATE_GIFT_RULE_ERROR.getMsg());
        }
    }

    @Override
    public List<GiftAmountResultExportVo> exportGiftResult(Long orgId) {
        TrControlGiftResultEo trControlGiftResultEo = new TrControlGiftResultEo();
        trControlGiftResultEo.setOrgId(orgId);
        List controlGiftResultEos = this.trControlGiftResultDas.select((BaseEo)trControlGiftResultEo);
        if (CollectionUtils.isEmpty((Collection)controlGiftResultEos)) {
            return null;
        }
        ArrayList giftAmountResultVos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)controlGiftResultEos, (Collection)giftAmountResultVos, GiftAmountResultExportVo.class);
        Map<String, List<TrControlGiftResultEo>> collect = controlGiftResultEos.stream().collect(Collectors.groupingBy(c -> c.getRuleId() + c.getCustomerCode()));
        giftAmountResultVos.forEach(c -> {
            List orDefault = collect.getOrDefault(c.getRuleId() + c.getCustomerCode(), Lists.newArrayList());
            TrControlGiftResultEo giftResultEo = (TrControlGiftResultEo)orDefault.stream().findFirst().get();
            c.setAmountType(GiftAmountType.enumOf((Integer)giftResultEo.getAmountType()).getDesc());
            c.setStatus(AmountStatusEnum.enumOf((Integer)giftResultEo.getStatus()).getDesc());
        });
        return giftAmountResultVos;
    }

    @Override
    public BizImportRespDto importGiftResult(BizImportDataReqDto<GiftAmountResultImportVo> bizImportDataReqDto) {
        try {
            List importVoList = bizImportDataReqDto.getExcelImportResult();
            this.authImportData(importVoList, bizImportDataReqDto.getOrgId(), bizImportDataReqDto.getTenantId());
            List<GiftAmountResultImportVo> itemAmountVoList = importVoList.stream().filter(c -> ObjectUtils.isEmpty((Object)c.getReason())).collect(Collectors.toList());
            List exportVoList = importVoList.stream().filter(c -> !ObjectUtils.isEmpty((Object)c.getReason())).collect(Collectors.toList());
            Integer importFailTotal = exportVoList.size();
            Integer importSuccessTotal = itemAmountVoList.size();
            Integer total = importVoList.size();
            logger.info("\u3010\u5bfc\u5165\u5269\u4f59\u989d\u5ea6\u3011\u603b\u5bfc\u5165\u6570\u636e{}\u6761\uff0c\u5408\u6cd5\u6570\u636e{}\u6761\uff0c\u4e0d\u5408\u6cd5\u6570\u636e{}\u6761", new Object[]{total, importSuccessTotal, importFailTotal});
            if (!ObjectUtils.isEmpty(itemAmountVoList)) {
                itemAmountVoList.forEach(c -> {
                    BizControlGiftResultReqDto bizControlGiftResultReqDto = new BizControlGiftResultReqDto(c.getRuleId(), c.getCustomerCode(), c.getCustomerName(), bizImportDataReqDto.getOrgId(), new BigDecimal(c.getAmount()), c.getAmountType(), "", GiftAmountWayEnum.WAY_10.getType(), bizImportDataReqDto.getImportId());
                    this.trControlGiftResultService.modifyBillData(bizControlGiftResultReqDto);
                });
            }
            String url = "";
            if (!CollectionUtils.isEmpty(exportVoList)) {
                String excelName = "cube/\u8d60\u54c1\u989d\u5ea6\u5bfc\u5165\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                try {
                    url = EasyPoiExportUtil.getExportUrl(exportVoList, GiftAmountResultImportVo.class, (String)null, (String)excelName, (String)"xls");
                    logger.info("\u3010\u5bfc\u5165\u8d60\u54c1\u989d\u5ea6\u3011\u5931\u8d25\u6587\u4ef6url : {}", (Object)url);
                }
                catch (Exception var15) {
                    logger.error("\u5bfc\u51fa\u8d60\u54c1\u989d\u5ea6-\u9519\u8bef:{}", (Object)var15.toString());
                    var15.printStackTrace();
                }
            }
            return new BizImportRespDto(total, importSuccessTotal, importFailTotal, url);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
    }

    @Override
    public List<TrControlGiftResultEo> getControlGiftResultListByRuleId(List<Long> ruleId) {
        AssertUtils.notEmpty(ruleId, (String)"\u89c4\u5219id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        TrControlGiftResultEo trControlGiftResultEo = new TrControlGiftResultEo();
        trControlGiftResultEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"rule_id", ruleId)}));
        List controlGiftResultEos = this.trControlGiftResultDas.select((BaseEo)trControlGiftResultEo);
        return controlGiftResultEos;
    }

    public List<GiftAmountResultImportVo> authImportData(List<GiftAmountResultImportVo> importVoList, Long orgId, Long tenantId) {
        for (GiftAmountResultImportVo c : importVoList) {
            Object pageInfoRestResponse;
            try {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{c.getCustomerCode()})) {
                    logger.error("\u3010\u5bfc\u5165\u8d60\u54c1\u989d\u5ea6\u989d\u5ea6\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_01.getDesc());
                    c.setReason(ImportItemAmountReason.ERROR_01.getDesc());
                    continue;
                }
                CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
                customerSearchReqDto.setTenantId(tenantId);
                customerSearchReqDto.setCode(c.getCustomerCode());
                customerSearchReqDto.setMerchantId(orgId);
                pageInfoRestResponse = this.iCustomerQueryApi.queryByPageOnPost(customerSearchReqDto, Integer.valueOf(1), Integer.valueOf(1));
                PageInfo customerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
                logger.info("\u3010\u5bfc\u5165\u8d60\u54c1\u989d\u5ea6\u989d\u5ea6\u3011\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)pageInfoRestResponse));
                AssertUtils.notEmpty((Collection)customerRespDtoPageInfo.getList(), (String)"\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38");
                CustomerRespDto data = (CustomerRespDto)customerRespDtoPageInfo.getList().stream().findFirst().get();
                AssertUtils.notNull((Object)data, (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38");
                AssertUtils.isTrue((boolean)data.getMerchantId().equals(orgId), (String)"\u5f53\u524d\u5ba2\u6237\u975e\u5f53\u524d\u7ec4\u7ec7");
                c.setCustomerName(StringUtils.defaultString((String)data.getName(), (String)""));
            }
            catch (Exception e) {
                logger.info("\u3010\u5bfc\u5165\u8d60\u54c1\u989d\u5ea6\u989d\u5ea6\u5f02\u5e38\u3011\u7528\u6237code\u89e3\u6790\u5f02\u5e38");
                c.setReason(ImportItemAmountReason.ERROR_01.getDesc());
                continue;
            }
            TrControlGiftRuleEo trControlGiftRuleEo = (TrControlGiftRuleEo)this.trControlGiftRuleDas.selectByPrimaryKey(c.getRuleId());
            if (ObjectUtils.isEmpty((Object)trControlGiftRuleEo)) {
                c.setReason(ImportItemAmountReason.ERROR_11.getDesc());
                continue;
            }
            c.setAmountType(trControlGiftRuleEo.getAmountType());
            try {
                pageInfoRestResponse = new BigDecimal(c.getAmount());
            }
            catch (NumberFormatException e) {
                c.setReason(ImportItemAmountReason.ERROR_08.getDesc());
            }
        }
        return importVoList;
    }

    @Override
    public List<TrControlGiftResultRespDto> queryListByCustomer(List<String> customerCodeList) {
        AssertUtils.notEmpty(customerCodeList, (String)"customerCodeList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List controlGiftResultEos = this.trControlGiftResultMapper.queryListByCustomer(customerCodeList);
        Map<String, List<TrControlGiftResultEo>> customerGiftMap = Optional.ofNullable(controlGiftResultEos).orElseGet(Collections::emptyList).stream().collect(Collectors.groupingBy(TrControlGiftResultEo::getCustomerCode));
        ArrayList<TrControlGiftResultRespDto> dtoList = new ArrayList<TrControlGiftResultRespDto>();
        customerGiftMap.forEach((k, v) -> {
            Map<Integer, List<TrControlGiftResultEo>> giftResultList = v.stream().collect(Collectors.groupingBy(TrControlGiftResultEo::getAmountType));
            TrControlGiftResultEo giftResultEo_money = giftResultList.getOrDefault(GiftAmountType.AMOUNT_MONEY.getType(), Lists.newArrayList()).stream().findFirst().orElse(new TrControlGiftResultEo(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
            TrControlGiftResultEo giftResultEo_num = giftResultList.getOrDefault(GiftAmountType.AMOUNT_NUM.getType(), Lists.newArrayList()).stream().findFirst().orElse(new TrControlGiftResultEo(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
            BizGiftAmountResultMoneyRespDto moneyRespDto = new BizGiftAmountResultMoneyRespDto(giftResultEo_money.getRemainAmount(), giftResultEo_money.getFreezeAmount(), giftResultEo_money.getUsedAmount(), giftResultEo_money.getUsableAmount());
            BizGiftAmountResultNumRespDto numRespDto = new BizGiftAmountResultNumRespDto(giftResultEo_num.getRemainAmount(), giftResultEo_num.getFreezeAmount(), giftResultEo_num.getUsedAmount(), giftResultEo_num.getUsableAmount());
            TrControlGiftResultRespDto giftResultRespDto = new TrControlGiftResultRespDto();
            DtoHelper.eo2Dto((BaseEo)(ObjectUtils.isEmpty((Object)giftResultEo_money.getCustomerCode()) ? giftResultEo_num : giftResultEo_money), (BaseVo)giftResultRespDto);
            giftResultRespDto.setAmountMoneyAll(moneyRespDto);
            giftResultRespDto.setAmountNumAll(numRespDto);
            dtoList.add(giftResultRespDto);
        });
        return dtoList;
    }

    @Override
    public TrControlGiftResultRespDto queryGiftResultByRuleIdAndCustomer(Long ruleId, String customerCode) {
        TrControlGiftResultEo trControlGiftResultEo = new TrControlGiftResultEo();
        trControlGiftResultEo.setRuleId(ruleId);
        trControlGiftResultEo.setCustomerCode(customerCode);
        TrControlGiftResultEo giftResultEo = (TrControlGiftResultEo)this.trControlGiftResultDas.selectOne((BaseEo)trControlGiftResultEo);
        if (ObjectUtils.isEmpty((Object)giftResultEo)) {
            return null;
        }
        TrControlGiftResultRespDto controlGiftResultRespDto = new TrControlGiftResultRespDto();
        DtoHelper.eo2Dto((BaseEo)giftResultEo, (BaseVo)controlGiftResultRespDto);
        return controlGiftResultRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOrderForGift(String orderNo, String customerCode) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notBlank((String)customerCode, (String)"customerCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(TrControlGiftRecordEo::getBusinessNo, (Object)orderNo)).eq(BaseEo::getDr, (Object)0);
        List giftRecordEos = this.giftRecordDas.list((Wrapper)queryWrapper);
        logger.info("\u3010\u53d6\u6d88\u8ba2\u5355\u8ba1\u7b97\u53ef\u9000\u8d60\u54c1\u989d\u5ea6\u3011\u672c\u6b21\u8ba2\u5355\uff08{}\uff09\u7684\u76f8\u5173\u6d41\u6c34\u4e3a\uff1a{}", (Object)orderNo, (Object)JSON.toJSONString((Object)giftRecordEos));
        if (CollectionUtils.isEmpty((Collection)giftRecordEos)) {
            logger.info("\u3010\u53d6\u6d88\u8ba2\u5355\u8ba1\u7b97\u53ef\u9000\u8d60\u54c1\u989d\u5ea6\u3011\u672c\u6b21\u8ba2\u5355\uff08{}\uff09\u6ca1\u6709\u67e5\u5230\u6d41\u6c34\u8bb0\u5f55\uff01", (Object)orderNo);
            return;
        }
        giftRecordEos.forEach(v -> {
            Integer changeWay = v.getIncomeType().equals(OperationTypeEnum.OPERATIONTYPEENUM_OUT.getType()) ? GiftAmountWayEnum.WAY_05.getType() : GiftAmountWayEnum.WAY_03.getType();
            BizControlGiftResultReqDto bizControlGiftResultReqDto = new BizControlGiftResultReqDto(v.getRuleId(), v.getCustomerCode(), v.getCustomerName(), v.getOrgId(), v.getIncomeType().equals(OperationTypeEnum.OPERATIONTYPEENUM_OUT.getType()) ? v.getTradeAmount().negate() : v.getTradeAmount(), v.getAmountType(), orderNo, changeWay, null);
            this.trControlGiftResultService.modifyBillData(bizControlGiftResultReqDto);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnProductForGift(String orderNo) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(TrControlGiftRecordEo::getBusinessNo, (Object)orderNo)).eq(BaseEo::getDr, (Object)0);
        List giftRecordEos = this.giftRecordDas.list((Wrapper)queryWrapper);
        logger.info("\u3010\u53d6\u6d88\u8ba2\u5355\u8ba1\u7b97\u53ef\u9000\u8d60\u54c1\u989d\u5ea6\u3011\u672c\u6b21\u8ba2\u5355\uff08{}\uff09\u7684\u76f8\u5173\u6d41\u6c34\u4e3a\uff1a{}", (Object)orderNo, (Object)JSON.toJSONString((Object)giftRecordEos));
        if (CollectionUtils.isEmpty((Collection)giftRecordEos)) {
            logger.info("\u3010\u53d6\u6d88\u8ba2\u5355\u8ba1\u7b97\u53ef\u9000\u8d60\u54c1\u989d\u5ea6\u3011\u672c\u6b21\u8ba2\u5355\uff08{}\uff09\u6ca1\u6709\u67e5\u5230\u6d41\u6c34\u8bb0\u5f55\uff01", (Object)orderNo);
            return;
        }
        HashMap ruleDeductAmountMap = Maps.newHashMap();
        for (TrControlGiftRecordEo giftRecordEo : giftRecordEos) {
            BigDecimal tradeAmount = giftRecordEo.getTradeAmount();
            ruleDeductAmountMap.compute(giftRecordEo.getRuleId(), (k, deductAmount) -> {
                if (deductAmount == null) {
                    deductAmount = BigDecimal.ZERO;
                }
                if (OperationTypeEnum.OPERATIONTYPEENUM_OUT.getType().equals(giftRecordEo.getIncomeType())) {
                    deductAmount.subtract(tradeAmount);
                } else {
                    deductAmount.add(tradeAmount);
                }
                return deductAmount;
            });
        }
        logger.info("\u3010\u53d6\u6d88\u8ba2\u5355\u8ba1\u7b97\u53ef\u9000\u8d60\u54c1\u989d\u5ea6\u3011\u672c\u6b21\u8ba2\u5355\u6263\u51cf\u989d\u5ea6(\u6b63\u6570\u4e3a\u6536\u5165\uff0c\u8d1f\u6570\u4e3a\u652f\u51fa)\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)ruleDeductAmountMap));
        Map recordEoMap = giftRecordEos.stream().collect(Collectors.toMap(TrControlGiftRecordEo::getRuleId, Function.identity(), (v1, v2) -> v2));
        ruleDeductAmountMap.forEach((ruleId, deductAmount) -> {
            TrControlGiftRecordEo giftRecordEo = (TrControlGiftRecordEo)recordEoMap.get(ruleId);
            BizControlGiftResultReqDto bizControlGiftResultReqDto = new BizControlGiftResultReqDto(ruleId, giftRecordEo.getCustomerCode(), giftRecordEo.getCustomerName(), giftRecordEo.getOrgId(), deductAmount.negate(), giftRecordEo.getAmountType(), orderNo, GiftAmountWayEnum.WAY_07.getType(), null);
            this.trControlGiftResultService.modifyBillData(bizControlGiftResultReqDto);
        });
        LambdaQueryWrapper queryFreezeWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryFreezeWrapper.eq(TrControlGiftFreezeRecordEo::getBusinessNo, (Object)orderNo)).eq(BaseEo::getDr, (Object)0);
        List recordEos = this.freezeRecordDas.list((Wrapper)queryFreezeWrapper);
        logger.info("\u3010\u53d6\u6d88\u8ba2\u5355\u8ba1\u7b97\u53ef\u9000\u8d60\u54c1\u989d\u5ea6\u3011\u8be5\u8ba2\u5355({})\u7684\u51bb\u7ed3\u989d\u5ea6\u6d41\u6c34\u4e3a\uff1a{}", (Object)orderNo, (Object)JSON.toJSONString((Object)recordEos));
        if (CollectionUtils.isNotEmpty((Collection)recordEos)) {
            for (TrControlGiftFreezeRecordEo giftFreezeRecordEo : recordEos) {
                this.trControlGiftResultMapper.updateGiftAmountByFields(giftFreezeRecordEo.getFreezeAmount().negate().toString(), null, null, null, giftFreezeRecordEo.getRuleId(), giftFreezeRecordEo.getCustomerCode());
                TrControlGiftFreezeRecordEo updateEo = new TrControlGiftFreezeRecordEo();
                updateEo.setStatus(GiftFreezeStatus.FREEZED.getType());
                AssertUtils.notNull((Object)giftFreezeRecordEo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                updateEo.setId(giftFreezeRecordEo.getId());
                this.freezeRecordDas.updateSelective((BaseEo)updateEo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unfreezeAmountForGift(String orderNo) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryFreezeWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryFreezeWrapper.eq(TrControlGiftFreezeRecordEo::getBusinessNo, (Object)orderNo)).eq(BaseEo::getDr, (Object)0);
        List recordEos = this.freezeRecordDas.list((Wrapper)queryFreezeWrapper);
        Optional.ofNullable(recordEos).ifPresent(recordEoList -> recordEoList.forEach(item -> {
            BizControlGiftResultReqDto bizControlGiftResultReqDto = new BizControlGiftResultReqDto(item.getRuleId(), item.getCustomerCode(), item.getCustomerName(), item.getOrgId(), item.getFreezeAmount(), item.getAmountType(), orderNo, GiftAmountWayEnum.WAY_01.getType(), null);
            this.trControlGiftResultService.modifyBillData(bizControlGiftResultReqDto);
        }));
    }
}

